#ifndef	imaptoken_h
#define	imaptoken_h

/*
** Copyright 1998 - 1999 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	<stdio.h>
#include	<stdlib.h>
#include	<time.h>

static const char imaptoken_h_rcsid[]="$Id: imaptoken.h,v 1.5 2001/10/01 23:06:33 mrsam Exp $";

struct imaptoken {
	short	tokentype;
	unsigned long tokennum;
	char *tokenbuf;
	size_t	tokenbuf_size;
	} ;

#define	IT_ATOM			0
#define	IT_NUMBER		1
#define	IT_QUOTED_STRING	2
#define	IT_LITERAL_STRING_START	3
#define	IT_LPAREN		4
#define	IT_RPAREN		5
#define	IT_NIL			6
#define	IT_ERROR		7
#define	IT_EOL			8
#define	IT_LBRACKET		9
#define	IT_RBRACKET		10

struct imaptoken *nexttoken(void);
struct imaptoken *currenttoken(void);
struct imaptoken *nexttoken_nouc(void);
struct imaptoken *nexttoken_noparseliteral(void);
struct imaptoken *nexttoken_okbracket(void);

int ismsgset(struct imaptoken *);
	/* See if this token is a syntactically valid message set */
void read_timeout(time_t);
void read_eol();
void unread(int);

void read_string(char **, unsigned long *, unsigned long);

/* Flags */

struct imapflags {
	char	seen;
	char	answered;
	char	deleted;
	char	flagged;
	char	drafts;
	char	recent;
	} ;

/* ATOMS have the following maximum length */

#define	IT_MAX_ATOM_SIZE	16384

char *my_strdup(const char *s);

#endif
