# cpushare client plugin
# Copyright (C) 2007  Andrea Arcangeli <andrea@cpushare.com>
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation;
# only version 2.1 of the License.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

try:
	from twisted.application.service import IServiceMaker
except ImportError:
	pass
else:
	from zope.interface import implements

	from twisted.python.usage import Options
	from twisted.plugin import IPlugin

	# local
	from cpushare import client, tap

	class service_class(object):
		implements(IServiceMaker, IPlugin)
		tapname = 'cpushare'
		description = 'CPUShare Client'
		options = tap.Options

		def makeService(self, options):
			return client.make_service(options)

	service = service_class()
