#!/bin/sh

VERSION=0.9.10

mkdir -p CriticalMass.app/Contents/MacOS
mkdir -p CriticalMass.app/Contents/Resources
mkdir -p CriticalMass.app/Contents/Frameworks

cp game/Info.plist CriticalMass.app/Contents/

cp game/critter CriticalMass.app/Contents/MacOS

cp game/resource.dat CriticalMass.app/Contents/Resources
cp game/critter.icns CriticalMass.app/Contents/Resources
cp data/music/lg-criti.xm CriticalMass.app/Contents/Resources

cp /usr/local/lib/libpng.3.dylib CriticalMass.app/Contents/Frameworks
cp /usr/local/lib/libSDL-1.2.0.dylib CriticalMass.app/Contents/Frameworks
cp /usr/local/lib/libSDL_image-1.2.0.dylib CriticalMass.app/Contents/Frameworks
cp /usr/local/lib/libSDL_mixer-1.2.0.dylib CriticalMass.app/Contents/Frameworks

install_name_tool -change /usr/local/lib/libpng.3.dylib @executable_path/../Frameworks/libpng.3.dylib CriticalMass.app/Contents/MacOS/critter
install_name_tool -change /usr/local/lib/libSDL-1.2.0.dylib @executable_path/../Frameworks/libSDL-1.2.0.dylib CriticalMass.app/Contents/MacOS/critter
install_name_tool -change /usr/local/lib/libSDL_image-1.2.0.dylib @executable_path/../Frameworks/libSDL_image-1.2.0.dylib CriticalMass.app/Contents/MacOS/critter
install_name_tool -change /usr/local/lib/libSDL_mixer-1.2.0.dylib @executable_path/../Frameworks/libSDL_mixer-1.2.0.dylib CriticalMass.app/Contents/MacOS/critter

rm -rf critter-$VERSION.dmg

mkdir critter-$VERSION
mv CriticalMass.app critter-$VERSION
cp Readme.html critter-$VERSION
cp COPYING critter-$VERSION

hdiutil create -ov -srcfolder critter-$VERSION -format UDZO critter-$VERSION.dmg

rm -rf critter-$VERSION
