#!/bin/sh
# This file contains some 'visual tests' for ctioga to make sure that when
# I add some features to ctioga, I don't break everything existing.
# As such, it also stands as a 'feature list' for ctioga.

. ./test_style.sh


# A series of tests on insets
ctioga -N -t 'Inset (with title)' 'x**2' --inset .5,.5:.4 \
    -t 'Title inset' 'cos(x)'

ctioga -N -t 'Inset (new specification)' 'x**2' --inset '0.4,0.4;0.7,0.6' \
    -t 'Title inset' 'cos(x)'

ctioga -N -t 'Chained insets, first take' 'x**2' \
    --inset '0.4,0.4;0.7,0.6' --rescale 0.6 \
    -t 'Title inset' 'cos(x)' --xaxis bottom --yaxis left \
    --next-inset '0.4,0.6;0.2,0.7' -x 'Second inset $x$' 'sin(x)'

ctioga -N --no-axes -t 'Chained insets, second take'  \
    --inset '0.4,0.4;0.7,0.6' --rescale 0.6 \
    -t 'Title inset' 'cos(x)' --xaxis bottom --yaxis left \
    --next-inset '0.4,0.8;0.2,0.6' -x 'Second inset $x$' 'sin(x)' \
    --next-inset '0.2,0.2;0.4,0.4' -x "Nothing interesting" -t 'Third inset' 'x**3'

ctioga -N --no-axes -t 'Chained subplots'  \
    --subplot '0.4,0.4;0.7,0.6' --padding 0pt --rescale 0.6 \
    -t 'Title subplot' 'cos(x)' --xaxis bottom --yaxis left \
    --next-subplot '0.4,0.8;0.2,0.6' -x 'Second subplot $x$' 'sin(x)' \
    --next-subplot '0.2,0.2;0.4,0.4' -x "Nothing interesting" -t 'Third subplot' 'x**3'

ctioga -N --no-axes -t 'X geometry-like inset specification'  \
    --inset '0.3x0.3+0.7+0.6' --padding 0pt --rescale 0.6 \
    -t '0.3x0.3+0.7+0.6' 'cos(x)' \
    --next-inset '0.3x0.3-0.7-0.6' -t '0.3x0.3-0.7-0.6' 'cos(x)'

ctioga -N --no-axes -t 'Chained insets with second axes'  \
    --inset '0.3x0.3+0.7+0.6' --padding 0pt --rescale 0.6 \
    -t '0.3x0.3+0.7+0.6' 'cos(x)' --y2 'x**2' --end \
    --next-inset '0.3x0.3-0.7-0.6' -t '0.3x0.3-0.7-0.6' 'cos(x)'
