/* lyparserfuncs.c
 * utility functions invoked by the
 * mudela parser */

/* For Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 2000, 2001 Matthew Hiller */

#include "chordops.h"
#include "datastructures.h"
#include "lyparserfuncs.h"
#include "objops.h"
#include "processstaffname.h"
#include "utils.h"

void
setstaffname (struct scoreinfo *si, gchar * str)
{
  staff *curstaffstruct = si->currentstaff->data;

  g_string_assign (curstaffstruct->lily_name, str);
  set_denemo_name (curstaffstruct->lily_name, curstaffstruct->denemo_name);
  g_free (str);
}

gint cleftypefromname (gchar * str)
{
  gint ret;

  if (g_strcasecmp (str, "treble") == 0)
    ret = TREBLE;
  else if (g_strcasecmp (str, "bass") == 0)
    ret = BASS;
  else if (g_strcasecmp (str, "alto") == 0)
    ret = ALTO;
  else if (g_strcasecmp (str, "\"g_8\"") == 0)
    ret = G_8;
  else if (g_strcasecmp (str, "tenor") == 0)
    ret = TENOR;
  else if (g_strcasecmp (str, "soprano") == 0)
    ret = SOPRANO;
  g_free (str);
  return ret;
}

void
setclef (struct scoreinfo *si, gchar * str)
{
  ((staff *) si->currentstaff->data)->sclef = cleftypefromname (str);
}

void
setkey (struct scoreinfo *si, struct twoints t)
{
  staff *curstaffstruct = si->currentstaff->data;

  if (t.b)
    {				/* Minor key  */
      curstaffstruct->skey = t.a - 3;
      curstaffstruct->skey_isminor = TRUE;
    }
  else
    {
      curstaffstruct->skey = t.a;
      curstaffstruct->skey_isminor = FALSE;
    }
  initkeyaccs (curstaffstruct->skeyaccs, curstaffstruct->skey);
}

void
settime (struct scoreinfo *si, struct twoints t)
{
  staff *curstaffstruct = si->currentstaff->data;

  curstaffstruct->stime1 = t.a;
  curstaffstruct->stime2 = t.b;
}

struct twoints
twointer (gint a, gint b)
{
  struct twoints ret;

  ret.a = a;
  ret.b = b;
  return ret;
}

/* This is basically the inverse to determinekey in
 * exportmudela.c */

gint keynametonumber (gchar * str)
{
  if (g_strcasecmp (str, "ces") == 0)
    return -7;
  else if (g_strcasecmp (str, "ges") == 0)
    return -6;
  else if (g_strcasecmp (str, "des") == 0)
    return -5;
  else if (g_strcasecmp (str, "aes") == 0)
    return -4;
  else if (g_strcasecmp (str, "ees") == 0)
    return -3;
  else if (g_strcasecmp (str, "bes") == 0)
    return -2;
  else if (g_strcasecmp (str, "f") == 0)
    return -1;
  else if (g_strcasecmp (str, "c") == 0)
    return 0;
  else if (g_strcasecmp (str, "g") == 0)
    return 1;
  else if (g_strcasecmp (str, "d") == 0)
    return 2;
  else if (g_strcasecmp (str, "a") == 0)
    return 3;
  else if (g_strcasecmp (str, "e") == 0)
    return 4;
  else if (g_strcasecmp (str, "b") == 0)
    return 5;
  else if (g_strcasecmp (str, "fis") == 0)
    return 6;
  else if (g_strcasecmp (str, "cis") == 0)
    return 7;
  else if (g_strcasecmp (str, "gis") == 0)
    return 8;
  else if (g_strcasecmp (str, "dis") == 0)
    return 9;
  else if (g_strcasecmp (str, "ais") == 0)
    return 10;
  else
    return 0;			/* Defaults to c minor/major */
  g_free (str);
}

gint mutointernalduration (gint muduration)
{
  gint ret = 0;

  while (muduration > 1)
    {
      ret++;
      muduration >>= 1;
    }
  return ret;
}

gint pitchtomid_c_offset (gchar name, gint octave)
{
  return 7 * (octave - 1) + (name - 'a' + 5) % 7;
}

void
addtonewrapper (mudelaobject * curmudelaobj, gchar tonetype,
		gint enshift, gint octave, struct twoints duration,
		gint dclef)
{
  gint mid_c_offset = pitchtomid_c_offset (tonetype, octave);

  if (tonetype != 'r')
    addtone (curmudelaobj, mid_c_offset, enshift, dclef);
  curmudelaobj->u.chordval.baseduration = duration.a;
  curmudelaobj->u.chordval.numdots = duration.b;
  set_basic_numticks (curmudelaobj);
}

void
set_tone_option (mudelaobject * curmudelaobj, gchar * option)
{

  if (!strcmp (option, "fermata"))
    curmudelaobj->u.chordval.has_fermata_p = TRUE;
  else if (!strcmp (option, "trill"))
    curmudelaobj->u.chordval.has_trill_p = TRUE;
  else if (!strcmp (option, "turn"))
    curmudelaobj->u.chordval.has_turn_p = TRUE;
  else if (!strcmp (option, "mordent"))
    curmudelaobj->u.chordval.has_mordent_p = TRUE;
  else if (!strcmp (option, "accent"))
    curmudelaobj->u.chordval.is_accented_p = TRUE;
  else if (!strcmp (option, "staccato"))
    curmudelaobj->u.chordval.has_stacatto_p = TRUE;
  else if (!strcmp (option, "staccatissimo"))
    curmudelaobj->u.chordval.has_staccatissimo_p = TRUE;
  else if (!strcmp (option, "tenuto"))
    curmudelaobj->u.chordval.has_tenuto_p = TRUE;
}
