/* tomeasuredialog.c
 * creates a dialog box asking the user if he wants to jump to a
 * particular measure

 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999, 2000, 2001 Matthew Hiller */

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include "calculatepositions.h"
#include "commandfuncs.h"
#include "contexts.h"
#include "datastructures.h"
#include "draw.h"
#include "moveviewport.h"
#include "staffops.h"
#include "utils.h"

struct callbackdata
{
  struct scoreinfo *si;
  GtkWidget *textentry;
};

static void
set_measurenum (GtkWidget * widget, gpointer data)
{
  struct callbackdata *cbdata = data;
  gint dest = atoi (gtk_entry_get_text (GTK_ENTRY (cbdata->textentry)));

  set_currentmeasurenum (cbdata->si, dest);
}

void
tomeasurenum (gpointer callback_data, guint callback_action,
	      GtkWidget * widget)
{
  struct scoreinfo *si = callback_data;
  GtkWidget *dialog;
  GtkWidget *label;
  GtkWidget *textentry;
  GtkWidget *okbutton;
  GtkWidget *cancelbutton;
  static GString *entrycontent = NULL;
  static struct callbackdata cbdata;

  if (!entrycontent)
    {
      entrycontent = g_string_new (NULL);
    }

  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), "Jump to measure");

  label = gtk_label_new ("Enter measure you'd like to jump to:");
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		      label, TRUE, TRUE, 0);
  gtk_widget_show (label);

  textentry = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		      textentry, TRUE, TRUE, 0);
  gtk_widget_show (textentry);

  okbutton = gtk_button_new_with_label ("OK");
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      okbutton, TRUE, TRUE, 0);
  cbdata.textentry = textentry;
  cbdata.si = si;

  processenter (textentry, set_measurenum, cbdata, dialog);
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      GTK_SIGNAL_FUNC (set_measurenum), &cbdata);
  gtk_signal_connect_object (GTK_OBJECT (okbutton), "clicked",
			     gtk_widget_destroy, GTK_OBJECT (dialog));
  gtk_widget_show (okbutton);

  cancelbutton = gtk_button_new_with_label ("Cancel");
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      cancelbutton, TRUE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (cancelbutton), "clicked",
			     gtk_widget_destroy, GTK_OBJECT (dialog));
  gtk_widget_show (cancelbutton);

  g_string_sprintf (entrycontent, "%d", si->currentmeasurenum);
  gtk_entry_set_text (GTK_ENTRY (textentry), entrycontent->str);
  gtk_widget_grab_focus (textentry);
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  gtk_widget_show (dialog);
}
