/* keyval_names.c - this file is part of DeSmuME
 *
 * Copyright (C) 2007 Damien Nozay (damdoum)
 * Author: damdoum at users.sourceforge.net
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "globals.h"
/* see <gdk/gdkkeysyms.h> */

char * unknown="(unknown)";
char * KEYVAL_NAMES[0x10000];

char * KEYNAME(int k) {
	char * s = unknown;
	s = KEYVAL_NAMES[k & 0xFFFF];
	return s;
}

void KEYVAL(int k, char * name) {
	if (KEYVAL_NAMES[k] == unknown)
	KEYVAL_NAMES[k] = name;
}

void inline init_keyvals() {
	int i;	
	for (i=0; i<0x10000; i++) 
		KEYVAL_NAMES[i]=unknown;

	KEYVAL ( 0x0020 , "space" );  
	KEYVAL ( 0x0021 , "exclam" );  
	KEYVAL ( 0x0022 , "quotedbl" );  
	KEYVAL ( 0x0023 , "numbersign" );  
	KEYVAL ( 0x0024 , "dollar" );  
	KEYVAL ( 0x0025 , "percent" );  
	KEYVAL ( 0x0026 , "ampersand" );  
	KEYVAL ( 0x0027 , "apostrophe" );  
	KEYVAL ( 0x0027 , "quoteright" );  
	KEYVAL ( 0x0028 , "parenleft" );  
	KEYVAL ( 0x0029 , "parenright" );  
	KEYVAL ( 0x002a , "asterisk" );  
	KEYVAL ( 0x002b , "plus" );  
	KEYVAL ( 0x002c , "comma" );  
	KEYVAL ( 0x002d , "minus" );  
	KEYVAL ( 0x002e , "period" );  
	KEYVAL ( 0x002f , "slash" );  
	KEYVAL ( 0x0030 , "0" );  
	KEYVAL ( 0x0031 , "1" );  
	KEYVAL ( 0x0032 , "2" );  
	KEYVAL ( 0x0033 , "3" );  
	KEYVAL ( 0x0034 , "4" );  
	KEYVAL ( 0x0035 , "5" );  
	KEYVAL ( 0x0036 , "6" );  
	KEYVAL ( 0x0037 , "7" );  
	KEYVAL ( 0x0038 , "8" );  
	KEYVAL ( 0x0039 , "9" );  
	KEYVAL ( 0x003a , "colon" );  
	KEYVAL ( 0x003b , "semicolon" );  
	KEYVAL ( 0x003c , "less" );  
	KEYVAL ( 0x003d , "equal" );  
	KEYVAL ( 0x003e , "greater" );  
	KEYVAL ( 0x003f , "question" );  
	KEYVAL ( 0x0040 , "at" );  
	KEYVAL ( 0x0041 , "A" );  
	KEYVAL ( 0x0042 , "B" );  
	KEYVAL ( 0x0043 , "C" );  
	KEYVAL ( 0x0044 , "D" );  
	KEYVAL ( 0x0045 , "E" );  
	KEYVAL ( 0x0046 , "F" );  
	KEYVAL ( 0x0047 , "G" );  
	KEYVAL ( 0x0048 , "H" );  
	KEYVAL ( 0x0049 , "I" );  
	KEYVAL ( 0x004a , "J" );  
	KEYVAL ( 0x004b , "K" );  
	KEYVAL ( 0x004c , "L" );  
	KEYVAL ( 0x004d , "M" );  
	KEYVAL ( 0x004e , "N" );  
	KEYVAL ( 0x004f , "O" );  
	KEYVAL ( 0x0050 , "P" );  
	KEYVAL ( 0x0051 , "Q" );  
	KEYVAL ( 0x0052 , "R" );  
	KEYVAL ( 0x0053 , "S" );  
	KEYVAL ( 0x0054 , "T" );  
	KEYVAL ( 0x0055 , "U" );  
	KEYVAL ( 0x0056 , "V" );  
	KEYVAL ( 0x0057 , "W" );  
	KEYVAL ( 0x0058 , "X" );  
	KEYVAL ( 0x0059 , "Y" );  
	KEYVAL ( 0x005a , "Z" );  
	KEYVAL ( 0x005b , "bracketleft" );  
	KEYVAL ( 0x005c , "backslash" );  
	KEYVAL ( 0x005d , "bracketright" );  
	KEYVAL ( 0x005e , "asciicircum" );  
	KEYVAL ( 0x005f , "underscore" );  
	KEYVAL ( 0x0060 , "grave" );  
	KEYVAL ( 0x0060 , "quoteleft" );  
	KEYVAL ( 0x0061 , "a" );  
	KEYVAL ( 0x0062 , "b" );  
	KEYVAL ( 0x0063 , "c" );  
	KEYVAL ( 0x0064 , "d" );  
	KEYVAL ( 0x0065 , "e" );  
	KEYVAL ( 0x0066 , "f" );  
	KEYVAL ( 0x0067 , "g" );  
	KEYVAL ( 0x0068 , "h" );  
	KEYVAL ( 0x0069 , "i" );  
	KEYVAL ( 0x006a , "j" );  
	KEYVAL ( 0x006b , "k" );  
	KEYVAL ( 0x006c , "l" );  
	KEYVAL ( 0x006d , "m" );  
	KEYVAL ( 0x006e , "n" );  
	KEYVAL ( 0x006f , "o" );  
	KEYVAL ( 0x0070 , "p" );  
	KEYVAL ( 0x0071 , "q" );  
	KEYVAL ( 0x0072 , "r" );  
	KEYVAL ( 0x0073 , "s" );  
	KEYVAL ( 0x0074 , "t" );  
	KEYVAL ( 0x0075 , "u" );  
	KEYVAL ( 0x0076 , "v" );  
	KEYVAL ( 0x0077 , "w" );  
	KEYVAL ( 0x0078 , "x" );  
	KEYVAL ( 0x0079 , "y" );  
	KEYVAL ( 0x007a , "z" );  
	KEYVAL ( 0x007b , "braceleft" );  
	KEYVAL ( 0x007c , "bar" );  
	KEYVAL ( 0x007d , "braceright" );  
	KEYVAL ( 0x007e , "asciitilde" );  
	KEYVAL ( 0x00a0 , "nobreakspace" );  
	KEYVAL ( 0x00a1 , "exclamdown" );  
	KEYVAL ( 0x00a2 , "cent" );  
	KEYVAL ( 0x00a3 , "sterling" );  
	KEYVAL ( 0x00a4 , "currency" );  
	KEYVAL ( 0x00a5 , "yen" );  
	KEYVAL ( 0x00a6 , "brokenbar" );  
	KEYVAL ( 0x00a7 , "section" );  
	KEYVAL ( 0x00a8 , "diaeresis" );  
	KEYVAL ( 0x00a9 , "copyright" );  
	KEYVAL ( 0x00aa , "ordfeminine" );  
	KEYVAL ( 0x00ab , "guillemotleft" );  
	KEYVAL ( 0x00ac , "notsign" );  
	KEYVAL ( 0x00ad , "hyphen" );  
	KEYVAL ( 0x00ae , "registered" );  
	KEYVAL ( 0x00af , "macron" );  
	KEYVAL ( 0x00b0 , "degree" );  
	KEYVAL ( 0x00b1 , "plusminus" );  
	KEYVAL ( 0x00b2 , "twosuperior" );  
	KEYVAL ( 0x00b3 , "threesuperior" );  
	KEYVAL ( 0x00b4 , "acute" );  
	KEYVAL ( 0x00b5 , "mu" );  
	KEYVAL ( 0x00b6 , "paragraph" );  
	KEYVAL ( 0x00b7 , "periodcentered" );  
	KEYVAL ( 0x00b8 , "cedilla" );  
	KEYVAL ( 0x00b9 , "onesuperior" );  
	KEYVAL ( 0x00ba , "masculine" );  
	KEYVAL ( 0x00bb , "guillemotright" );  
	KEYVAL ( 0x00bc , "onequarter" );  
	KEYVAL ( 0x00bd , "onehalf" );  
	KEYVAL ( 0x00be , "threequarters" );  
	KEYVAL ( 0x00bf , "questiondown" );  
	KEYVAL ( 0x00c0 , "Agrave" );  
	KEYVAL ( 0x00c1 , "Aacute" );  
	KEYVAL ( 0x00c2 , "Acircumflex" );  
	KEYVAL ( 0x00c3 , "Atilde" );  
	KEYVAL ( 0x00c4 , "Adiaeresis" );  
	KEYVAL ( 0x00c5 , "Aring" );  
	KEYVAL ( 0x00c6 , "AE" );  
	KEYVAL ( 0x00c7 , "Ccedilla" );  
	KEYVAL ( 0x00c8 , "Egrave" );  
	KEYVAL ( 0x00c9 , "Eacute" );  
	KEYVAL ( 0x00ca , "Ecircumflex" );  
	KEYVAL ( 0x00cb , "Ediaeresis" );  
	KEYVAL ( 0x00cc , "Igrave" );  
	KEYVAL ( 0x00cd , "Iacute" );  
	KEYVAL ( 0x00ce , "Icircumflex" );  
	KEYVAL ( 0x00cf , "Idiaeresis" );  
	KEYVAL ( 0x00d0 , "ETH" );  
	KEYVAL ( 0x00d0 , "Eth" );  
	KEYVAL ( 0x00d1 , "Ntilde" );  
	KEYVAL ( 0x00d2 , "Ograve" );  
	KEYVAL ( 0x00d3 , "Oacute" );  
	KEYVAL ( 0x00d4 , "Ocircumflex" );  
	KEYVAL ( 0x00d5 , "Otilde" );  
	KEYVAL ( 0x00d6 , "Odiaeresis" );  
	KEYVAL ( 0x00d7 , "multiply" );  
	KEYVAL ( 0x00d8 , "Ooblique" );  
	KEYVAL ( 0x00d9 , "Ugrave" );  
	KEYVAL ( 0x00da , "Uacute" );  
	KEYVAL ( 0x00db , "Ucircumflex" );  
	KEYVAL ( 0x00dc , "Udiaeresis" );  
	KEYVAL ( 0x00dd , "Yacute" );  
	KEYVAL ( 0x00de , "THORN" );  
	KEYVAL ( 0x00de , "Thorn" );  
	KEYVAL ( 0x00df , "ssharp" );  
	KEYVAL ( 0x00e0 , "agrave" );  
	KEYVAL ( 0x00e1 , "aacute" );  
	KEYVAL ( 0x00e2 , "acircumflex" );  
	KEYVAL ( 0x00e3 , "atilde" );  
	KEYVAL ( 0x00e4 , "adiaeresis" );  
	KEYVAL ( 0x00e5 , "aring" );  
	KEYVAL ( 0x00e6 , "ae" );  
	KEYVAL ( 0x00e7 , "ccedilla" );  
	KEYVAL ( 0x00e8 , "egrave" );  
	KEYVAL ( 0x00e9 , "eacute" );  
	KEYVAL ( 0x00ea , "ecircumflex" );  
	KEYVAL ( 0x00eb , "ediaeresis" );  
	KEYVAL ( 0x00ec , "igrave" );  
	KEYVAL ( 0x00ed , "iacute" );  
	KEYVAL ( 0x00ee , "icircumflex" );  
	KEYVAL ( 0x00ef , "idiaeresis" );  
	KEYVAL ( 0x00f0 , "eth" );  
	KEYVAL ( 0x00f1 , "ntilde" );  
	KEYVAL ( 0x00f2 , "ograve" );  
	KEYVAL ( 0x00f3 , "oacute" );  
	KEYVAL ( 0x00f4 , "ocircumflex" );  
	KEYVAL ( 0x00f5 , "otilde" );  
	KEYVAL ( 0x00f6 , "odiaeresis" );  
	KEYVAL ( 0x00f7 , "division" );  
	KEYVAL ( 0x00f8 , "oslash" );  
	KEYVAL ( 0x00f9 , "ugrave" );  
	KEYVAL ( 0x00fa , "uacute" );  
	KEYVAL ( 0x00fb , "ucircumflex" );  
	KEYVAL ( 0x00fc , "udiaeresis" );  
	KEYVAL ( 0x00fd , "yacute" );  
	KEYVAL ( 0x00fe , "thorn" );  
	KEYVAL ( 0x00ff , "ydiaeresis" );  
	KEYVAL ( 0x01a1 , "Aogonek" );  
	KEYVAL ( 0x01a2 , "breve" );  
	KEYVAL ( 0x01a3 , "Lstroke" );  
	KEYVAL ( 0x01a5 , "Lcaron" );  
	KEYVAL ( 0x01a6 , "Sacute" );  
	KEYVAL ( 0x01a9 , "Scaron" );  
	KEYVAL ( 0x01aa , "Scedilla" );  
	KEYVAL ( 0x01ab , "Tcaron" );  
	KEYVAL ( 0x01ac , "Zacute" );  
	KEYVAL ( 0x01ae , "Zcaron" );  
	KEYVAL ( 0x01af , "Zabovedot" );  
	KEYVAL ( 0x01b1 , "aogonek" );  
	KEYVAL ( 0x01b2 , "ogonek" );  
	KEYVAL ( 0x01b3 , "lstroke" );  
	KEYVAL ( 0x01b5 , "lcaron" );  
	KEYVAL ( 0x01b6 , "sacute" );  
	KEYVAL ( 0x01b7 , "caron" );  
	KEYVAL ( 0x01b9 , "scaron" );  
	KEYVAL ( 0x01ba , "scedilla" );  
	KEYVAL ( 0x01bb , "tcaron" );  
	KEYVAL ( 0x01bc , "zacute" );  
	KEYVAL ( 0x01bd , "doubleacute" );  
	KEYVAL ( 0x01be , "zcaron" );  
	KEYVAL ( 0x01bf , "zabovedot" );  
	KEYVAL ( 0x01c0 , "Racute" );  
	KEYVAL ( 0x01c3 , "Abreve" );  
	KEYVAL ( 0x01c5 , "Lacute" );  
	KEYVAL ( 0x01c6 , "Cacute" );  
	KEYVAL ( 0x01c8 , "Ccaron" );  
	KEYVAL ( 0x01ca , "Eogonek" );  
	KEYVAL ( 0x01cc , "Ecaron" );  
	KEYVAL ( 0x01cf , "Dcaron" );  
	KEYVAL ( 0x01d0 , "Dstroke" );  
	KEYVAL ( 0x01d1 , "Nacute" );  
	KEYVAL ( 0x01d2 , "Ncaron" );  
	KEYVAL ( 0x01d5 , "Odoubleacute" );  
	KEYVAL ( 0x01d8 , "Rcaron" );  
	KEYVAL ( 0x01d9 , "Uring" );  
	KEYVAL ( 0x01db , "Udoubleacute" );  
	KEYVAL ( 0x01de , "Tcedilla" );  
	KEYVAL ( 0x01e0 , "racute" );  
	KEYVAL ( 0x01e3 , "abreve" );  
	KEYVAL ( 0x01e5 , "lacute" );  
	KEYVAL ( 0x01e6 , "cacute" );  
	KEYVAL ( 0x01e8 , "ccaron" );  
	KEYVAL ( 0x01ea , "eogonek" );  
	KEYVAL ( 0x01ec , "ecaron" );  
	KEYVAL ( 0x01ef , "dcaron" );  
	KEYVAL ( 0x01f0 , "dstroke" );  
	KEYVAL ( 0x01f1 , "nacute" );  
	KEYVAL ( 0x01f2 , "ncaron" );  
	KEYVAL ( 0x01f5 , "odoubleacute" );  
	KEYVAL ( 0x01f8 , "rcaron" );  
	KEYVAL ( 0x01f9 , "uring" );  
	KEYVAL ( 0x01fb , "udoubleacute" );  
	KEYVAL ( 0x01fe , "tcedilla" );  
	KEYVAL ( 0x01ff , "abovedot" );  
	KEYVAL ( 0x02a1 , "Hstroke" );  
	KEYVAL ( 0x02a6 , "Hcircumflex" );  
	KEYVAL ( 0x02a9 , "Iabovedot" );  
	KEYVAL ( 0x02ab , "Gbreve" );  
	KEYVAL ( 0x02ac , "Jcircumflex" );  
	KEYVAL ( 0x02b1 , "hstroke" );  
	KEYVAL ( 0x02b6 , "hcircumflex" );  
	KEYVAL ( 0x02b9 , "idotless" );  
	KEYVAL ( 0x02bb , "gbreve" );  
	KEYVAL ( 0x02bc , "jcircumflex" );  
	KEYVAL ( 0x02c5 , "Cabovedot" );  
	KEYVAL ( 0x02c6 , "Ccircumflex" );  
	KEYVAL ( 0x02d5 , "Gabovedot" );  
	KEYVAL ( 0x02d8 , "Gcircumflex" );  
	KEYVAL ( 0x02dd , "Ubreve" );  
	KEYVAL ( 0x02de , "Scircumflex" );  
	KEYVAL ( 0x02e5 , "cabovedot" );  
	KEYVAL ( 0x02e6 , "ccircumflex" );  
	KEYVAL ( 0x02f5 , "gabovedot" );  
	KEYVAL ( 0x02f8 , "gcircumflex" );  
	KEYVAL ( 0x02fd , "ubreve" );  
	KEYVAL ( 0x02fe , "scircumflex" );  
	KEYVAL ( 0x03a2 , "kappa" );  
	KEYVAL ( 0x03a2 , "kra" );  
	KEYVAL ( 0x03a3 , "Rcedilla" );  
	KEYVAL ( 0x03a5 , "Itilde" );  
	KEYVAL ( 0x03a6 , "Lcedilla" );  
	KEYVAL ( 0x03aa , "Emacron" );  
	KEYVAL ( 0x03ab , "Gcedilla" );  
	KEYVAL ( 0x03ac , "Tslash" );  
	KEYVAL ( 0x03b3 , "rcedilla" );  
	KEYVAL ( 0x03b5 , "itilde" );  
	KEYVAL ( 0x03b6 , "lcedilla" );  
	KEYVAL ( 0x03ba , "emacron" );  
	KEYVAL ( 0x03bb , "gcedilla" );  
	KEYVAL ( 0x03bc , "tslash" );  
	KEYVAL ( 0x03bd , "ENG" );  
	KEYVAL ( 0x03bf , "eng" );  
	KEYVAL ( 0x03c0 , "Amacron" );  
	KEYVAL ( 0x03c7 , "Iogonek" );  
	KEYVAL ( 0x03cc , "Eabovedot" );  
	KEYVAL ( 0x03cf , "Imacron" );  
	KEYVAL ( 0x03d1 , "Ncedilla" );  
	KEYVAL ( 0x03d2 , "Omacron" );  
	KEYVAL ( 0x03d3 , "Kcedilla" );  
	KEYVAL ( 0x03d9 , "Uogonek" );  
	KEYVAL ( 0x03dd , "Utilde" );  
	KEYVAL ( 0x03de , "Umacron" );  
	KEYVAL ( 0x03e0 , "amacron" );  
	KEYVAL ( 0x03e7 , "iogonek" );  
	KEYVAL ( 0x03ec , "eabovedot" );  
	KEYVAL ( 0x03ef , "imacron" );  
	KEYVAL ( 0x03f1 , "ncedilla" );  
	KEYVAL ( 0x03f2 , "omacron" );  
	KEYVAL ( 0x03f3 , "kcedilla" );  
	KEYVAL ( 0x03f9 , "uogonek" );  
	KEYVAL ( 0x03fd , "utilde" );  
	KEYVAL ( 0x03fe , "umacron" );  
	KEYVAL ( 0x047e , "overline" );  
	KEYVAL ( 0x04a1 , "kana_fullstop" );  
	KEYVAL ( 0x04a2 , "kana_openingbracket" );  
	KEYVAL ( 0x04a3 , "kana_closingbracket" );  
	KEYVAL ( 0x04a4 , "kana_comma" );  
	KEYVAL ( 0x04a5 , "kana_conjunctive" );  
	KEYVAL ( 0x04a5 , "kana_middledot" );  
	KEYVAL ( 0x04a6 , "kana_WO" );  
	KEYVAL ( 0x04a7 , "kana_a" );  
	KEYVAL ( 0x04a8 , "kana_i" );  
	KEYVAL ( 0x04a9 , "kana_u" );  
	KEYVAL ( 0x04aa , "kana_e" );  
	KEYVAL ( 0x04ab , "kana_o" );  
	KEYVAL ( 0x04ac , "kana_ya" );  
	KEYVAL ( 0x04ad , "kana_yu" );  
	KEYVAL ( 0x04ae , "kana_yo" );  
	KEYVAL ( 0x04af , "kana_tsu" );  
	KEYVAL ( 0x04af , "kana_tu" );  
	KEYVAL ( 0x04b0 , "prolongedsound" );  
	KEYVAL ( 0x04b1 , "kana_A" );  
	KEYVAL ( 0x04b2 , "kana_I" );  
	KEYVAL ( 0x04b3 , "kana_U" );  
	KEYVAL ( 0x04b4 , "kana_E" );  
	KEYVAL ( 0x04b5 , "kana_O" );  
	KEYVAL ( 0x04b6 , "kana_KA" );  
	KEYVAL ( 0x04b7 , "kana_KI" );  
	KEYVAL ( 0x04b8 , "kana_KU" );  
	KEYVAL ( 0x04b9 , "kana_KE" );  
	KEYVAL ( 0x04ba , "kana_KO" );  
	KEYVAL ( 0x04bb , "kana_SA" );  
	KEYVAL ( 0x04bc , "kana_SHI" );  
	KEYVAL ( 0x04bd , "kana_SU" );  
	KEYVAL ( 0x04be , "kana_SE" );  
	KEYVAL ( 0x04bf , "kana_SO" );  
	KEYVAL ( 0x04c0 , "kana_TA" );  
	KEYVAL ( 0x04c1 , "kana_CHI" );  
	KEYVAL ( 0x04c1 , "kana_TI" );  
	KEYVAL ( 0x04c2 , "kana_TSU" );  
	KEYVAL ( 0x04c2 , "kana_TU" );  
	KEYVAL ( 0x04c3 , "kana_TE" );  
	KEYVAL ( 0x04c4 , "kana_TO" );  
	KEYVAL ( 0x04c5 , "kana_NA" );  
	KEYVAL ( 0x04c6 , "kana_NI" );  
	KEYVAL ( 0x04c7 , "kana_NU" );  
	KEYVAL ( 0x04c8 , "kana_NE" );  
	KEYVAL ( 0x04c9 , "kana_NO" );  
	KEYVAL ( 0x04ca , "kana_HA" );  
	KEYVAL ( 0x04cb , "kana_HI" );  
	KEYVAL ( 0x04cc , "kana_FU" );  
	KEYVAL ( 0x04cc , "kana_HU" );  
	KEYVAL ( 0x04cd , "kana_HE" );  
	KEYVAL ( 0x04ce , "kana_HO" );  
	KEYVAL ( 0x04cf , "kana_MA" );  
	KEYVAL ( 0x04d0 , "kana_MI" );  
	KEYVAL ( 0x04d1 , "kana_MU" );  
	KEYVAL ( 0x04d2 , "kana_ME" );  
	KEYVAL ( 0x04d3 , "kana_MO" );  
	KEYVAL ( 0x04d4 , "kana_YA" );  
	KEYVAL ( 0x04d5 , "kana_YU" );  
	KEYVAL ( 0x04d6 , "kana_YO" );  
	KEYVAL ( 0x04d7 , "kana_RA" );  
	KEYVAL ( 0x04d8 , "kana_RI" );  
	KEYVAL ( 0x04d9 , "kana_RU" );  
	KEYVAL ( 0x04da , "kana_RE" );  
	KEYVAL ( 0x04db , "kana_RO" );  
	KEYVAL ( 0x04dc , "kana_WA" );  
	KEYVAL ( 0x04dd , "kana_N" );  
	KEYVAL ( 0x04de , "voicedsound" );  
	KEYVAL ( 0x04df , "semivoicedsound" );  
	KEYVAL ( 0x05ac , "Arabic_comma" );  
	KEYVAL ( 0x05bb , "Arabic_semicolon" );  
	KEYVAL ( 0x05bf , "Arabic_question_mark" );  
	KEYVAL ( 0x05c1 , "Arabic_hamza" );  
	KEYVAL ( 0x05c2 , "Arabic_maddaonalef" );  
	KEYVAL ( 0x05c3 , "Arabic_hamzaonalef" );  
	KEYVAL ( 0x05c4 , "Arabic_hamzaonwaw" );  
	KEYVAL ( 0x05c5 , "Arabic_hamzaunderalef" );  
	KEYVAL ( 0x05c6 , "Arabic_hamzaonyeh" );  
	KEYVAL ( 0x05c7 , "Arabic_alef" );  
	KEYVAL ( 0x05c8 , "Arabic_beh" );  
	KEYVAL ( 0x05c9 , "Arabic_tehmarbuta" );  
	KEYVAL ( 0x05ca , "Arabic_teh" );  
	KEYVAL ( 0x05cb , "Arabic_theh" );  
	KEYVAL ( 0x05cc , "Arabic_jeem" );  
	KEYVAL ( 0x05cd , "Arabic_hah" );  
	KEYVAL ( 0x05ce , "Arabic_khah" );  
	KEYVAL ( 0x05cf , "Arabic_dal" );  
	KEYVAL ( 0x05d0 , "Arabic_thal" );  
	KEYVAL ( 0x05d1 , "Arabic_ra" );  
	KEYVAL ( 0x05d2 , "Arabic_zain" );  
	KEYVAL ( 0x05d3 , "Arabic_seen" );  
	KEYVAL ( 0x05d4 , "Arabic_sheen" );  
	KEYVAL ( 0x05d5 , "Arabic_sad" );  
	KEYVAL ( 0x05d6 , "Arabic_dad" );  
	KEYVAL ( 0x05d7 , "Arabic_tah" );  
	KEYVAL ( 0x05d8 , "Arabic_zah" );  
	KEYVAL ( 0x05d9 , "Arabic_ain" );  
	KEYVAL ( 0x05da , "Arabic_ghain" );  
	KEYVAL ( 0x05e0 , "Arabic_tatweel" );  
	KEYVAL ( 0x05e1 , "Arabic_feh" );  
	KEYVAL ( 0x05e2 , "Arabic_qaf" );  
	KEYVAL ( 0x05e3 , "Arabic_kaf" );  
	KEYVAL ( 0x05e4 , "Arabic_lam" );  
	KEYVAL ( 0x05e5 , "Arabic_meem" );  
	KEYVAL ( 0x05e6 , "Arabic_noon" );  
	KEYVAL ( 0x05e7 , "Arabic_ha" );  
	KEYVAL ( 0x05e7 , "Arabic_heh" );  
	KEYVAL ( 0x05e8 , "Arabic_waw" );  
	KEYVAL ( 0x05e9 , "Arabic_alefmaksura" );  
	KEYVAL ( 0x05ea , "Arabic_yeh" );  
	KEYVAL ( 0x05eb , "Arabic_fathatan" );  
	KEYVAL ( 0x05ec , "Arabic_dammatan" );  
	KEYVAL ( 0x05ed , "Arabic_kasratan" );  
	KEYVAL ( 0x05ee , "Arabic_fatha" );  
	KEYVAL ( 0x05ef , "Arabic_damma" );  
	KEYVAL ( 0x05f0 , "Arabic_kasra" );  
	KEYVAL ( 0x05f1 , "Arabic_shadda" );  
	KEYVAL ( 0x05f2 , "Arabic_sukun" );  
	KEYVAL ( 0x06a1 , "Serbian_dje" );  
	KEYVAL ( 0x06a2 , "Macedonia_gje" );  
	KEYVAL ( 0x06a3 , "Cyrillic_io" );  
	KEYVAL ( 0x06a4 , "Ukrainian_ie" );  
	KEYVAL ( 0x06a4 , "Ukranian_je" );  
	KEYVAL ( 0x06a5 , "Macedonia_dse" );  
	KEYVAL ( 0x06a6 , "Ukrainian_i" );  
	KEYVAL ( 0x06a6 , "Ukranian_i" );  
	KEYVAL ( 0x06a7 , "Ukrainian_yi" );  
	KEYVAL ( 0x06a7 , "Ukranian_yi" );  
	KEYVAL ( 0x06a8 , "Cyrillic_je" );  
	KEYVAL ( 0x06a8 , "Serbian_je" );  
	KEYVAL ( 0x06a9 , "Cyrillic_lje" );  
	KEYVAL ( 0x06a9 , "Serbian_lje" );  
	KEYVAL ( 0x06aa , "Cyrillic_nje" );  
	KEYVAL ( 0x06aa , "Serbian_nje" );  
	KEYVAL ( 0x06ab , "Serbian_tshe" );  
	KEYVAL ( 0x06ac , "Macedonia_kje" );  
	KEYVAL ( 0x06ad , "Ukrainian_ghe_with_upturn" );  
	KEYVAL ( 0x06ae , "Byelorussian_shortu" );  
	KEYVAL ( 0x06af , "Cyrillic_dzhe" );  
	KEYVAL ( 0x06af , "Serbian_dze" );  
	KEYVAL ( 0x06b0 , "numerosign" );  
	KEYVAL ( 0x06b1 , "Serbian_DJE" );  
	KEYVAL ( 0x06b2 , "Macedonia_GJE" );  
	KEYVAL ( 0x06b3 , "Cyrillic_IO" );  
	KEYVAL ( 0x06b4 , "Ukrainian_IE" );  
	KEYVAL ( 0x06b4 , "Ukranian_JE" );  
	KEYVAL ( 0x06b5 , "Macedonia_DSE" );  
	KEYVAL ( 0x06b6 , "Ukrainian_I" );  
	KEYVAL ( 0x06b6 , "Ukranian_I" );  
	KEYVAL ( 0x06b7 , "Ukrainian_YI" );  
	KEYVAL ( 0x06b7 , "Ukranian_YI" );  
	KEYVAL ( 0x06b8 , "Cyrillic_JE" );  
	KEYVAL ( 0x06b8 , "Serbian_JE" );  
	KEYVAL ( 0x06b9 , "Cyrillic_LJE" );  
	KEYVAL ( 0x06b9 , "Serbian_LJE" );  
	KEYVAL ( 0x06ba , "Cyrillic_NJE" );  
	KEYVAL ( 0x06ba , "Serbian_NJE" );  
	KEYVAL ( 0x06bb , "Serbian_TSHE" );  
	KEYVAL ( 0x06bc , "Macedonia_KJE" );  
	KEYVAL ( 0x06bd , "Ukrainian_GHE_WITH_UPTURN" );  
	KEYVAL ( 0x06be , "Byelorussian_SHORTU" );  
	KEYVAL ( 0x06bf , "Cyrillic_DZHE" );  
	KEYVAL ( 0x06bf , "Serbian_DZE" );  
	KEYVAL ( 0x06c0 , "Cyrillic_yu" );  
	KEYVAL ( 0x06c1 , "Cyrillic_a" );  
	KEYVAL ( 0x06c2 , "Cyrillic_be" );  
	KEYVAL ( 0x06c3 , "Cyrillic_tse" );  
	KEYVAL ( 0x06c4 , "Cyrillic_de" );  
	KEYVAL ( 0x06c5 , "Cyrillic_ie" );  
	KEYVAL ( 0x06c6 , "Cyrillic_ef" );  
	KEYVAL ( 0x06c7 , "Cyrillic_ghe" );  
	KEYVAL ( 0x06c8 , "Cyrillic_ha" );  
	KEYVAL ( 0x06c9 , "Cyrillic_i" );  
	KEYVAL ( 0x06ca , "Cyrillic_shorti" );  
	KEYVAL ( 0x06cb , "Cyrillic_ka" );  
	KEYVAL ( 0x06cc , "Cyrillic_el" );  
	KEYVAL ( 0x06cd , "Cyrillic_em" );  
	KEYVAL ( 0x06ce , "Cyrillic_en" );  
	KEYVAL ( 0x06cf , "Cyrillic_o" );  
	KEYVAL ( 0x06d0 , "Cyrillic_pe" );  
	KEYVAL ( 0x06d1 , "Cyrillic_ya" );  
	KEYVAL ( 0x06d2 , "Cyrillic_er" );  
	KEYVAL ( 0x06d3 , "Cyrillic_es" );  
	KEYVAL ( 0x06d4 , "Cyrillic_te" );  
	KEYVAL ( 0x06d5 , "Cyrillic_u" );  
	KEYVAL ( 0x06d6 , "Cyrillic_zhe" );  
	KEYVAL ( 0x06d7 , "Cyrillic_ve" );  
	KEYVAL ( 0x06d8 , "Cyrillic_softsign" );  
	KEYVAL ( 0x06d9 , "Cyrillic_yeru" );  
	KEYVAL ( 0x06da , "Cyrillic_ze" );  
	KEYVAL ( 0x06db , "Cyrillic_sha" );  
	KEYVAL ( 0x06dc , "Cyrillic_e" );  
	KEYVAL ( 0x06dd , "Cyrillic_shcha" );  
	KEYVAL ( 0x06de , "Cyrillic_che" );  
	KEYVAL ( 0x06df , "Cyrillic_hardsign" );  
	KEYVAL ( 0x06e0 , "Cyrillic_YU" );  
	KEYVAL ( 0x06e1 , "Cyrillic_A" );  
	KEYVAL ( 0x06e2 , "Cyrillic_BE" );  
	KEYVAL ( 0x06e3 , "Cyrillic_TSE" );  
	KEYVAL ( 0x06e4 , "Cyrillic_DE" );  
	KEYVAL ( 0x06e5 , "Cyrillic_IE" );  
	KEYVAL ( 0x06e6 , "Cyrillic_EF" );  
	KEYVAL ( 0x06e7 , "Cyrillic_GHE" );  
	KEYVAL ( 0x06e8 , "Cyrillic_HA" );  
	KEYVAL ( 0x06e9 , "Cyrillic_I" );  
	KEYVAL ( 0x06ea , "Cyrillic_SHORTI" );  
	KEYVAL ( 0x06eb , "Cyrillic_KA" );  
	KEYVAL ( 0x06ec , "Cyrillic_EL" );  
	KEYVAL ( 0x06ed , "Cyrillic_EM" );  
	KEYVAL ( 0x06ee , "Cyrillic_EN" );  
	KEYVAL ( 0x06ef , "Cyrillic_O" );  
	KEYVAL ( 0x06f0 , "Cyrillic_PE" );  
	KEYVAL ( 0x06f1 , "Cyrillic_YA" );  
	KEYVAL ( 0x06f2 , "Cyrillic_ER" );  
	KEYVAL ( 0x06f3 , "Cyrillic_ES" );  
	KEYVAL ( 0x06f4 , "Cyrillic_TE" );  
	KEYVAL ( 0x06f5 , "Cyrillic_U" );  
	KEYVAL ( 0x06f6 , "Cyrillic_ZHE" );  
	KEYVAL ( 0x06f7 , "Cyrillic_VE" );  
	KEYVAL ( 0x06f8 , "Cyrillic_SOFTSIGN" );  
	KEYVAL ( 0x06f9 , "Cyrillic_YERU" );  
	KEYVAL ( 0x06fa , "Cyrillic_ZE" );  
	KEYVAL ( 0x06fb , "Cyrillic_SHA" );  
	KEYVAL ( 0x06fc , "Cyrillic_E" );  
	KEYVAL ( 0x06fd , "Cyrillic_SHCHA" );  
	KEYVAL ( 0x06fe , "Cyrillic_CHE" );  
	KEYVAL ( 0x06ff , "Cyrillic_HARDSIGN" );  
	KEYVAL ( 0x07a1 , "Greek_ALPHAaccent" );  
	KEYVAL ( 0x07a2 , "Greek_EPSILONaccent" );  
	KEYVAL ( 0x07a3 , "Greek_ETAaccent" );  
	KEYVAL ( 0x07a4 , "Greek_IOTAaccent" );  
	KEYVAL ( 0x07a5 , "Greek_IOTAdieresis" );  
	KEYVAL ( 0x07a7 , "Greek_OMICRONaccent" );  
	KEYVAL ( 0x07a8 , "Greek_UPSILONaccent" );  
	KEYVAL ( 0x07a9 , "Greek_UPSILONdieresis" );  
	KEYVAL ( 0x07ab , "Greek_OMEGAaccent" );  
	KEYVAL ( 0x07ae , "Greek_accentdieresis" );  
	KEYVAL ( 0x07af , "Greek_horizbar" );  
	KEYVAL ( 0x07b1 , "Greek_alphaaccent" );  
	KEYVAL ( 0x07b2 , "Greek_epsilonaccent" );  
	KEYVAL ( 0x07b3 , "Greek_etaaccent" );  
	KEYVAL ( 0x07b4 , "Greek_iotaaccent" );  
	KEYVAL ( 0x07b5 , "Greek_iotadieresis" );  
	KEYVAL ( 0x07b6 , "Greek_iotaaccentdieresis" );  
	KEYVAL ( 0x07b7 , "Greek_omicronaccent" );  
	KEYVAL ( 0x07b8 , "Greek_upsilonaccent" );  
	KEYVAL ( 0x07b9 , "Greek_upsilondieresis" );  
	KEYVAL ( 0x07ba , "Greek_upsilonaccentdieresis" );  
	KEYVAL ( 0x07bb , "Greek_omegaaccent" );  
	KEYVAL ( 0x07c1 , "Greek_ALPHA" );  
	KEYVAL ( 0x07c2 , "Greek_BETA" );  
	KEYVAL ( 0x07c3 , "Greek_GAMMA" );  
	KEYVAL ( 0x07c4 , "Greek_DELTA" );  
	KEYVAL ( 0x07c5 , "Greek_EPSILON" );  
	KEYVAL ( 0x07c6 , "Greek_ZETA" );  
	KEYVAL ( 0x07c7 , "Greek_ETA" );  
	KEYVAL ( 0x07c8 , "Greek_THETA" );  
	KEYVAL ( 0x07c9 , "Greek_IOTA" );  
	KEYVAL ( 0x07ca , "Greek_KAPPA" );  
	KEYVAL ( 0x07cb , "Greek_LAMBDA" );  
	KEYVAL ( 0x07cb , "Greek_LAMDA" );  
	KEYVAL ( 0x07cc , "Greek_MU" );  
	KEYVAL ( 0x07cd , "Greek_NU" );  
	KEYVAL ( 0x07ce , "Greek_XI" );  
	KEYVAL ( 0x07cf , "Greek_OMICRON" );  
	KEYVAL ( 0x07d0 , "Greek_PI" );  
	KEYVAL ( 0x07d1 , "Greek_RHO" );  
	KEYVAL ( 0x07d2 , "Greek_SIGMA" );  
	KEYVAL ( 0x07d4 , "Greek_TAU" );  
	KEYVAL ( 0x07d5 , "Greek_UPSILON" );  
	KEYVAL ( 0x07d6 , "Greek_PHI" );  
	KEYVAL ( 0x07d7 , "Greek_CHI" );  
	KEYVAL ( 0x07d8 , "Greek_PSI" );  
	KEYVAL ( 0x07d9 , "Greek_OMEGA" );  
	KEYVAL ( 0x07e1 , "Greek_alpha" );  
	KEYVAL ( 0x07e2 , "Greek_beta" );  
	KEYVAL ( 0x07e3 , "Greek_gamma" );  
	KEYVAL ( 0x07e4 , "Greek_delta" );  
	KEYVAL ( 0x07e5 , "Greek_epsilon" );  
	KEYVAL ( 0x07e6 , "Greek_zeta" );  
	KEYVAL ( 0x07e7 , "Greek_eta" );  
	KEYVAL ( 0x07e8 , "Greek_theta" );  
	KEYVAL ( 0x07e9 , "Greek_iota" );  
	KEYVAL ( 0x07ea , "Greek_kappa" );  
	KEYVAL ( 0x07eb , "Greek_lambda" );  
	KEYVAL ( 0x07eb , "Greek_lamda" );  
	KEYVAL ( 0x07ec , "Greek_mu" );  
	KEYVAL ( 0x07ed , "Greek_nu" );  
	KEYVAL ( 0x07ee , "Greek_xi" );  
	KEYVAL ( 0x07ef , "Greek_omicron" );  
	KEYVAL ( 0x07f0 , "Greek_pi" );  
	KEYVAL ( 0x07f1 , "Greek_rho" );  
	KEYVAL ( 0x07f2 , "Greek_sigma" );  
	KEYVAL ( 0x07f3 , "Greek_finalsmallsigma" );  
	KEYVAL ( 0x07f4 , "Greek_tau" );  
	KEYVAL ( 0x07f5 , "Greek_upsilon" );  
	KEYVAL ( 0x07f6 , "Greek_phi" );  
	KEYVAL ( 0x07f7 , "Greek_chi" );  
	KEYVAL ( 0x07f8 , "Greek_psi" );  
	KEYVAL ( 0x07f9 , "Greek_omega" );  
	KEYVAL ( 0x08a1 , "leftradical" );  
	KEYVAL ( 0x08a2 , "topleftradical" );  
	KEYVAL ( 0x08a3 , "horizconnector" );  
	KEYVAL ( 0x08a4 , "topintegral" );  
	KEYVAL ( 0x08a5 , "botintegral" );  
	KEYVAL ( 0x08a6 , "vertconnector" );  
	KEYVAL ( 0x08a7 , "topleftsqbracket" );  
	KEYVAL ( 0x08a8 , "botleftsqbracket" );  
	KEYVAL ( 0x08a9 , "toprightsqbracket" );  
	KEYVAL ( 0x08aa , "botrightsqbracket" );  
	KEYVAL ( 0x08ab , "topleftparens" );  
	KEYVAL ( 0x08ac , "botleftparens" );  
	KEYVAL ( 0x08ad , "toprightparens" );  
	KEYVAL ( 0x08ae , "botrightparens" );  
	KEYVAL ( 0x08af , "leftmiddlecurlybrace" );  
	KEYVAL ( 0x08b0 , "rightmiddlecurlybrace" );  
	KEYVAL ( 0x08b1 , "topleftsummation" );  
	KEYVAL ( 0x08b2 , "botleftsummation" );  
	KEYVAL ( 0x08b3 , "topvertsummationconnector" );  
	KEYVAL ( 0x08b4 , "botvertsummationconnector" );  
	KEYVAL ( 0x08b5 , "toprightsummation" );  
	KEYVAL ( 0x08b6 , "botrightsummation" );  
	KEYVAL ( 0x08b7 , "rightmiddlesummation" );  
	KEYVAL ( 0x08bc , "lessthanequal" );  
	KEYVAL ( 0x08bd , "notequal" );  
	KEYVAL ( 0x08be , "greaterthanequal" );  
	KEYVAL ( 0x08bf , "integral" );  
	KEYVAL ( 0x08c0 , "therefore" );  
	KEYVAL ( 0x08c1 , "variation" );  
	KEYVAL ( 0x08c2 , "infinity" );  
	KEYVAL ( 0x08c5 , "nabla" );  
	KEYVAL ( 0x08c8 , "approximate" );  
	KEYVAL ( 0x08c9 , "similarequal" );  
	KEYVAL ( 0x08cd , "ifonlyif" );  
	KEYVAL ( 0x08ce , "implies" );  
	KEYVAL ( 0x08cf , "identical" );  
	KEYVAL ( 0x08d6 , "radical" );  
	KEYVAL ( 0x08da , "includedin" );  
	KEYVAL ( 0x08db , "includes" );  
	KEYVAL ( 0x08dc , "intersection" );  
	KEYVAL ( 0x08dd , "union" );  
	KEYVAL ( 0x08de , "logicaland" );  
	KEYVAL ( 0x08df , "logicalor" );  
	KEYVAL ( 0x08ef , "partialderivative" );  
	KEYVAL ( 0x08f6 , "function" );  
	KEYVAL ( 0x08fb , "leftarrow" );  
	KEYVAL ( 0x08fc , "uparrow" );  
	KEYVAL ( 0x08fd , "rightarrow" );  
	KEYVAL ( 0x08fe , "downarrow" );  
	KEYVAL ( 0x09df , "blank" );  
	KEYVAL ( 0x09e0 , "soliddiamond" );  
	KEYVAL ( 0x09e1 , "checkerboard" );  
	KEYVAL ( 0x09e2 , "ht" );  
	KEYVAL ( 0x09e3 , "ff" );  
	KEYVAL ( 0x09e4 , "cr" );  
	KEYVAL ( 0x09e5 , "lf" );  
	KEYVAL ( 0x09e8 , "nl" );  
	KEYVAL ( 0x09e9 , "vt" );  
	KEYVAL ( 0x09ea , "lowrightcorner" );  
	KEYVAL ( 0x09eb , "uprightcorner" );  
	KEYVAL ( 0x09ec , "upleftcorner" );  
	KEYVAL ( 0x09ed , "lowleftcorner" );  
	KEYVAL ( 0x09ee , "crossinglines" );  
	KEYVAL ( 0x09ef , "horizlinescan1" );  
	KEYVAL ( 0x09f0 , "horizlinescan3" );  
	KEYVAL ( 0x09f1 , "horizlinescan5" );  
	KEYVAL ( 0x09f2 , "horizlinescan7" );  
	KEYVAL ( 0x09f3 , "horizlinescan9" );  
	KEYVAL ( 0x09f4 , "leftt" );  
	KEYVAL ( 0x09f5 , "rightt" );  
	KEYVAL ( 0x09f6 , "bott" );  
	KEYVAL ( 0x09f7 , "topt" );  
	KEYVAL ( 0x09f8 , "vertbar" );  
	KEYVAL ( 0x0aa1 , "emspace" );  
	KEYVAL ( 0x0aa2 , "enspace" );  
	KEYVAL ( 0x0aa3 , "em3space" );  
	KEYVAL ( 0x0aa4 , "em4space" );  
	KEYVAL ( 0x0aa5 , "digitspace" );  
	KEYVAL ( 0x0aa6 , "punctspace" );  
	KEYVAL ( 0x0aa7 , "thinspace" );  
	KEYVAL ( 0x0aa8 , "hairspace" );  
	KEYVAL ( 0x0aa9 , "emdash" );  
	KEYVAL ( 0x0aaa , "endash" );  
	KEYVAL ( 0x0aac , "signifblank" );  
	KEYVAL ( 0x0aae , "ellipsis" );  
	KEYVAL ( 0x0aaf , "doubbaselinedot" );  
	KEYVAL ( 0x0ab0 , "onethird" );  
	KEYVAL ( 0x0ab1 , "twothirds" );  
	KEYVAL ( 0x0ab2 , "onefifth" );  
	KEYVAL ( 0x0ab3 , "twofifths" );  
	KEYVAL ( 0x0ab4 , "threefifths" );  
	KEYVAL ( 0x0ab5 , "fourfifths" );  
	KEYVAL ( 0x0ab6 , "onesixth" );  
	KEYVAL ( 0x0ab7 , "fivesixths" );  
	KEYVAL ( 0x0ab8 , "careof" );  
	KEYVAL ( 0x0abb , "figdash" );  
	KEYVAL ( 0x0abc , "leftanglebracket" );  
	KEYVAL ( 0x0abd , "decimalpoint" );  
	KEYVAL ( 0x0abe , "rightanglebracket" );  
	KEYVAL ( 0x0abf , "marker" );  
	KEYVAL ( 0x0ac3 , "oneeighth" );  
	KEYVAL ( 0x0ac4 , "threeeighths" );  
	KEYVAL ( 0x0ac5 , "fiveeighths" );  
	KEYVAL ( 0x0ac6 , "seveneighths" );  
	KEYVAL ( 0x0ac9 , "trademark" );  
	KEYVAL ( 0x0aca , "signaturemark" );  
	KEYVAL ( 0x0acb , "trademarkincircle" );  
	KEYVAL ( 0x0acc , "leftopentriangle" );  
	KEYVAL ( 0x0acd , "rightopentriangle" );  
	KEYVAL ( 0x0ace , "emopencircle" );  
	KEYVAL ( 0x0acf , "emopenrectangle" );  
	KEYVAL ( 0x0ad0 , "leftsinglequotemark" );  
	KEYVAL ( 0x0ad1 , "rightsinglequotemark" );  
	KEYVAL ( 0x0ad2 , "leftdoublequotemark" );  
	KEYVAL ( 0x0ad3 , "rightdoublequotemark" );  
	KEYVAL ( 0x0ad4 , "prescription" );  
	KEYVAL ( 0x0ad6 , "minutes" );  
	KEYVAL ( 0x0ad7 , "seconds" );  
	KEYVAL ( 0x0ad9 , "latincross" );  
	KEYVAL ( 0x0ada , "hexagram" );  
	KEYVAL ( 0x0adb , "filledrectbullet" );  
	KEYVAL ( 0x0adc , "filledlefttribullet" );  
	KEYVAL ( 0x0add , "filledrighttribullet" );  
	KEYVAL ( 0x0ade , "emfilledcircle" );  
	KEYVAL ( 0x0adf , "emfilledrect" );  
	KEYVAL ( 0x0ae0 , "enopencircbullet" );  
	KEYVAL ( 0x0ae1 , "enopensquarebullet" );  
	KEYVAL ( 0x0ae2 , "openrectbullet" );  
	KEYVAL ( 0x0ae3 , "opentribulletup" );  
	KEYVAL ( 0x0ae4 , "opentribulletdown" );  
	KEYVAL ( 0x0ae5 , "openstar" );  
	KEYVAL ( 0x0ae6 , "enfilledcircbullet" );  
	KEYVAL ( 0x0ae7 , "enfilledsqbullet" );  
	KEYVAL ( 0x0ae8 , "filledtribulletup" );  
	KEYVAL ( 0x0ae9 , "filledtribulletdown" );  
	KEYVAL ( 0x0aea , "leftpointer" );  
	KEYVAL ( 0x0aeb , "rightpointer" );  
	KEYVAL ( 0x0aec , "club" );  
	KEYVAL ( 0x0aed , "diamond" );  
	KEYVAL ( 0x0aee , "heart" );  
	KEYVAL ( 0x0af0 , "maltesecross" );  
	KEYVAL ( 0x0af1 , "dagger" );  
	KEYVAL ( 0x0af2 , "doubledagger" );  
	KEYVAL ( 0x0af3 , "checkmark" );  
	KEYVAL ( 0x0af4 , "ballotcross" );  
	KEYVAL ( 0x0af5 , "musicalsharp" );  
	KEYVAL ( 0x0af6 , "musicalflat" );  
	KEYVAL ( 0x0af7 , "malesymbol" );  
	KEYVAL ( 0x0af8 , "femalesymbol" );  
	KEYVAL ( 0x0af9 , "telephone" );  
	KEYVAL ( 0x0afa , "telephonerecorder" );  
	KEYVAL ( 0x0afb , "phonographcopyright" );  
	KEYVAL ( 0x0afc , "caret" );  
	KEYVAL ( 0x0afd , "singlelowquotemark" );  
	KEYVAL ( 0x0afe , "doublelowquotemark" );  
	KEYVAL ( 0x0aff , "cursor" );  
	KEYVAL ( 0x0ba3 , "leftcaret" );  
	KEYVAL ( 0x0ba6 , "rightcaret" );  
	KEYVAL ( 0x0ba8 , "downcaret" );  
	KEYVAL ( 0x0ba9 , "upcaret" );  
	KEYVAL ( 0x0bc0 , "overbar" );  
	KEYVAL ( 0x0bc2 , "downtack" );  
	KEYVAL ( 0x0bc3 , "upshoe" );  
	KEYVAL ( 0x0bc4 , "downstile" );  
	KEYVAL ( 0x0bc6 , "underbar" );  
	KEYVAL ( 0x0bca , "jot" );  
	KEYVAL ( 0x0bcc , "quad" );  
	KEYVAL ( 0x0bce , "uptack" );  
	KEYVAL ( 0x0bcf , "circle" );  
	KEYVAL ( 0x0bd3 , "upstile" );  
	KEYVAL ( 0x0bd6 , "downshoe" );  
	KEYVAL ( 0x0bd8 , "rightshoe" );  
	KEYVAL ( 0x0bda , "leftshoe" );  
	KEYVAL ( 0x0bdc , "lefttack" );  
	KEYVAL ( 0x0bfc , "righttack" );  
	KEYVAL ( 0x0cdf , "hebrew_doublelowline" );  
	KEYVAL ( 0x0ce0 , "hebrew_aleph" );  
	KEYVAL ( 0x0ce1 , "hebrew_bet" );  
	KEYVAL ( 0x0ce1 , "hebrew_beth" );  
	KEYVAL ( 0x0ce2 , "hebrew_gimel" );  
	KEYVAL ( 0x0ce2 , "hebrew_gimmel" );  
	KEYVAL ( 0x0ce3 , "hebrew_dalet" );  
	KEYVAL ( 0x0ce3 , "hebrew_daleth" );  
	KEYVAL ( 0x0ce4 , "hebrew_he" );  
	KEYVAL ( 0x0ce5 , "hebrew_waw" );  
	KEYVAL ( 0x0ce6 , "hebrew_zain" );  
	KEYVAL ( 0x0ce6 , "hebrew_zayin" );  
	KEYVAL ( 0x0ce7 , "hebrew_chet" );  
	KEYVAL ( 0x0ce7 , "hebrew_het" );  
	KEYVAL ( 0x0ce8 , "hebrew_tet" );  
	KEYVAL ( 0x0ce8 , "hebrew_teth" );  
	KEYVAL ( 0x0ce9 , "hebrew_yod" );  
	KEYVAL ( 0x0cea , "hebrew_finalkaph" );  
	KEYVAL ( 0x0ceb , "hebrew_kaph" );  
	KEYVAL ( 0x0cec , "hebrew_lamed" );  
	KEYVAL ( 0x0ced , "hebrew_finalmem" );  
	KEYVAL ( 0x0cee , "hebrew_mem" );  
	KEYVAL ( 0x0cef , "hebrew_finalnun" );  
	KEYVAL ( 0x0cf0 , "hebrew_nun" );  
	KEYVAL ( 0x0cf1 , "hebrew_samech" );  
	KEYVAL ( 0x0cf1 , "hebrew_samekh" );  
	KEYVAL ( 0x0cf2 , "hebrew_ayin" );  
	KEYVAL ( 0x0cf3 , "hebrew_finalpe" );  
	KEYVAL ( 0x0cf4 , "hebrew_pe" );  
	KEYVAL ( 0x0cf5 , "hebrew_finalzade" );  
	KEYVAL ( 0x0cf5 , "hebrew_finalzadi" );  
	KEYVAL ( 0x0cf6 , "hebrew_zade" );  
	KEYVAL ( 0x0cf6 , "hebrew_zadi" );  
	KEYVAL ( 0x0cf7 , "hebrew_kuf" );  
	KEYVAL ( 0x0cf7 , "hebrew_qoph" );  
	KEYVAL ( 0x0cf8 , "hebrew_resh" );  
	KEYVAL ( 0x0cf9 , "hebrew_shin" );  
	KEYVAL ( 0x0cfa , "hebrew_taf" );  
	KEYVAL ( 0x0cfa , "hebrew_taw" );  
	KEYVAL ( 0x0da1 , "Thai_kokai" );  
	KEYVAL ( 0x0da2 , "Thai_khokhai" );  
	KEYVAL ( 0x0da3 , "Thai_khokhuat" );  
	KEYVAL ( 0x0da4 , "Thai_khokhwai" );  
	KEYVAL ( 0x0da5 , "Thai_khokhon" );  
	KEYVAL ( 0x0da6 , "Thai_khorakhang" );  
	KEYVAL ( 0x0da7 , "Thai_ngongu" );  
	KEYVAL ( 0x0da8 , "Thai_chochan" );  
	KEYVAL ( 0x0da9 , "Thai_choching" );  
	KEYVAL ( 0x0daa , "Thai_chochang" );  
	KEYVAL ( 0x0dab , "Thai_soso" );  
	KEYVAL ( 0x0dac , "Thai_chochoe" );  
	KEYVAL ( 0x0dad , "Thai_yoying" );  
	KEYVAL ( 0x0dae , "Thai_dochada" );  
	KEYVAL ( 0x0daf , "Thai_topatak" );  
	KEYVAL ( 0x0db0 , "Thai_thothan" );  
	KEYVAL ( 0x0db1 , "Thai_thonangmontho" );  
	KEYVAL ( 0x0db2 , "Thai_thophuthao" );  
	KEYVAL ( 0x0db3 , "Thai_nonen" );  
	KEYVAL ( 0x0db4 , "Thai_dodek" );  
	KEYVAL ( 0x0db5 , "Thai_totao" );  
	KEYVAL ( 0x0db6 , "Thai_thothung" );  
	KEYVAL ( 0x0db7 , "Thai_thothahan" );  
	KEYVAL ( 0x0db8 , "Thai_thothong" );  
	KEYVAL ( 0x0db9 , "Thai_nonu" );  
	KEYVAL ( 0x0dba , "Thai_bobaimai" );  
	KEYVAL ( 0x0dbb , "Thai_popla" );  
	KEYVAL ( 0x0dbc , "Thai_phophung" );  
	KEYVAL ( 0x0dbd , "Thai_fofa" );  
	KEYVAL ( 0x0dbe , "Thai_phophan" );  
	KEYVAL ( 0x0dbf , "Thai_fofan" );  
	KEYVAL ( 0x0dc0 , "Thai_phosamphao" );  
	KEYVAL ( 0x0dc1 , "Thai_moma" );  
	KEYVAL ( 0x0dc2 , "Thai_yoyak" );  
	KEYVAL ( 0x0dc3 , "Thai_rorua" );  
	KEYVAL ( 0x0dc4 , "Thai_ru" );  
	KEYVAL ( 0x0dc5 , "Thai_loling" );  
	KEYVAL ( 0x0dc6 , "Thai_lu" );  
	KEYVAL ( 0x0dc7 , "Thai_wowaen" );  
	KEYVAL ( 0x0dc8 , "Thai_sosala" );  
	KEYVAL ( 0x0dc9 , "Thai_sorusi" );  
	KEYVAL ( 0x0dca , "Thai_sosua" );  
	KEYVAL ( 0x0dcb , "Thai_hohip" );  
	KEYVAL ( 0x0dcc , "Thai_lochula" );  
	KEYVAL ( 0x0dcd , "Thai_oang" );  
	KEYVAL ( 0x0dce , "Thai_honokhuk" );  
	KEYVAL ( 0x0dcf , "Thai_paiyannoi" );  
	KEYVAL ( 0x0dd0 , "Thai_saraa" );  
	KEYVAL ( 0x0dd1 , "Thai_maihanakat" );  
	KEYVAL ( 0x0dd2 , "Thai_saraaa" );  
	KEYVAL ( 0x0dd3 , "Thai_saraam" );  
	KEYVAL ( 0x0dd4 , "Thai_sarai" );  
	KEYVAL ( 0x0dd5 , "Thai_saraii" );  
	KEYVAL ( 0x0dd6 , "Thai_saraue" );  
	KEYVAL ( 0x0dd7 , "Thai_sarauee" );  
	KEYVAL ( 0x0dd8 , "Thai_sarau" );  
	KEYVAL ( 0x0dd9 , "Thai_sarauu" );  
	KEYVAL ( 0x0dda , "Thai_phinthu" );  
	KEYVAL ( 0x0dde , "Thai_maihanakat_maitho" );  
	KEYVAL ( 0x0ddf , "Thai_baht" );  
	KEYVAL ( 0x0de0 , "Thai_sarae" );  
	KEYVAL ( 0x0de1 , "Thai_saraae" );  
	KEYVAL ( 0x0de2 , "Thai_sarao" );  
	KEYVAL ( 0x0de3 , "Thai_saraaimaimuan" );  
	KEYVAL ( 0x0de4 , "Thai_saraaimaimalai" );  
	KEYVAL ( 0x0de5 , "Thai_lakkhangyao" );  
	KEYVAL ( 0x0de6 , "Thai_maiyamok" );  
	KEYVAL ( 0x0de7 , "Thai_maitaikhu" );  
	KEYVAL ( 0x0de8 , "Thai_maiek" );  
	KEYVAL ( 0x0de9 , "Thai_maitho" );  
	KEYVAL ( 0x0dea , "Thai_maitri" );  
	KEYVAL ( 0x0deb , "Thai_maichattawa" );  
	KEYVAL ( 0x0dec , "Thai_thanthakhat" );  
	KEYVAL ( 0x0ded , "Thai_nikhahit" );  
	KEYVAL ( 0x0df0 , "Thai_leksun" );  
	KEYVAL ( 0x0df1 , "Thai_leknung" );  
	KEYVAL ( 0x0df2 , "Thai_leksong" );  
	KEYVAL ( 0x0df3 , "Thai_leksam" );  
	KEYVAL ( 0x0df4 , "Thai_leksi" );  
	KEYVAL ( 0x0df5 , "Thai_lekha" );  
	KEYVAL ( 0x0df6 , "Thai_lekhok" );  
	KEYVAL ( 0x0df7 , "Thai_lekchet" );  
	KEYVAL ( 0x0df8 , "Thai_lekpaet" );  
	KEYVAL ( 0x0df9 , "Thai_lekkao" );  
	KEYVAL ( 0x0ea1 , "Hangul_Kiyeog" );  
	KEYVAL ( 0x0ea2 , "Hangul_SsangKiyeog" );  
	KEYVAL ( 0x0ea3 , "Hangul_KiyeogSios" );  
	KEYVAL ( 0x0ea4 , "Hangul_Nieun" );  
	KEYVAL ( 0x0ea5 , "Hangul_NieunJieuj" );  
	KEYVAL ( 0x0ea6 , "Hangul_NieunHieuh" );  
	KEYVAL ( 0x0ea7 , "Hangul_Dikeud" );  
	KEYVAL ( 0x0ea8 , "Hangul_SsangDikeud" );  
	KEYVAL ( 0x0ea9 , "Hangul_Rieul" );  
	KEYVAL ( 0x0eaa , "Hangul_RieulKiyeog" );  
	KEYVAL ( 0x0eab , "Hangul_RieulMieum" );  
	KEYVAL ( 0x0eac , "Hangul_RieulPieub" );  
	KEYVAL ( 0x0ead , "Hangul_RieulSios" );  
	KEYVAL ( 0x0eae , "Hangul_RieulTieut" );  
	KEYVAL ( 0x0eaf , "Hangul_RieulPhieuf" );  
	KEYVAL ( 0x0eb0 , "Hangul_RieulHieuh" );  
	KEYVAL ( 0x0eb1 , "Hangul_Mieum" );  
	KEYVAL ( 0x0eb2 , "Hangul_Pieub" );  
	KEYVAL ( 0x0eb3 , "Hangul_SsangPieub" );  
	KEYVAL ( 0x0eb4 , "Hangul_PieubSios" );  
	KEYVAL ( 0x0eb5 , "Hangul_Sios" );  
	KEYVAL ( 0x0eb6 , "Hangul_SsangSios" );  
	KEYVAL ( 0x0eb7 , "Hangul_Ieung" );  
	KEYVAL ( 0x0eb8 , "Hangul_Jieuj" );  
	KEYVAL ( 0x0eb9 , "Hangul_SsangJieuj" );  
	KEYVAL ( 0x0eba , "Hangul_Cieuc" );  
	KEYVAL ( 0x0ebb , "Hangul_Khieuq" );  
	KEYVAL ( 0x0ebc , "Hangul_Tieut" );  
	KEYVAL ( 0x0ebd , "Hangul_Phieuf" );  
	KEYVAL ( 0x0ebe , "Hangul_Hieuh" );  
	KEYVAL ( 0x0ebf , "Hangul_A" );  
	KEYVAL ( 0x0ec0 , "Hangul_AE" );  
	KEYVAL ( 0x0ec1 , "Hangul_YA" );  
	KEYVAL ( 0x0ec2 , "Hangul_YAE" );  
	KEYVAL ( 0x0ec3 , "Hangul_EO" );  
	KEYVAL ( 0x0ec4 , "Hangul_E" );  
	KEYVAL ( 0x0ec5 , "Hangul_YEO" );  
	KEYVAL ( 0x0ec6 , "Hangul_YE" );  
	KEYVAL ( 0x0ec7 , "Hangul_O" );  
	KEYVAL ( 0x0ec8 , "Hangul_WA" );  
	KEYVAL ( 0x0ec9 , "Hangul_WAE" );  
	KEYVAL ( 0x0eca , "Hangul_OE" );  
	KEYVAL ( 0x0ecb , "Hangul_YO" );  
	KEYVAL ( 0x0ecc , "Hangul_U" );  
	KEYVAL ( 0x0ecd , "Hangul_WEO" );  
	KEYVAL ( 0x0ece , "Hangul_WE" );  
	KEYVAL ( 0x0ecf , "Hangul_WI" );  
	KEYVAL ( 0x0ed0 , "Hangul_YU" );  
	KEYVAL ( 0x0ed1 , "Hangul_EU" );  
	KEYVAL ( 0x0ed2 , "Hangul_YI" );  
	KEYVAL ( 0x0ed3 , "Hangul_I" );  
	KEYVAL ( 0x0ed4 , "Hangul_J_Kiyeog" );  
	KEYVAL ( 0x0ed5 , "Hangul_J_SsangKiyeog" );  
	KEYVAL ( 0x0ed6 , "Hangul_J_KiyeogSios" );  
	KEYVAL ( 0x0ed7 , "Hangul_J_Nieun" );  
	KEYVAL ( 0x0ed8 , "Hangul_J_NieunJieuj" );  
	KEYVAL ( 0x0ed9 , "Hangul_J_NieunHieuh" );  
	KEYVAL ( 0x0eda , "Hangul_J_Dikeud" );  
	KEYVAL ( 0x0edb , "Hangul_J_Rieul" );  
	KEYVAL ( 0x0edc , "Hangul_J_RieulKiyeog" );  
	KEYVAL ( 0x0edd , "Hangul_J_RieulMieum" );  
	KEYVAL ( 0x0ede , "Hangul_J_RieulPieub" );  
	KEYVAL ( 0x0edf , "Hangul_J_RieulSios" );  
	KEYVAL ( 0x0ee0 , "Hangul_J_RieulTieut" );  
	KEYVAL ( 0x0ee1 , "Hangul_J_RieulPhieuf" );  
	KEYVAL ( 0x0ee2 , "Hangul_J_RieulHieuh" );  
	KEYVAL ( 0x0ee3 , "Hangul_J_Mieum" );  
	KEYVAL ( 0x0ee4 , "Hangul_J_Pieub" );  
	KEYVAL ( 0x0ee5 , "Hangul_J_PieubSios" );  
	KEYVAL ( 0x0ee6 , "Hangul_J_Sios" );  
	KEYVAL ( 0x0ee7 , "Hangul_J_SsangSios" );  
	KEYVAL ( 0x0ee8 , "Hangul_J_Ieung" );  
	KEYVAL ( 0x0ee9 , "Hangul_J_Jieuj" );  
	KEYVAL ( 0x0eea , "Hangul_J_Cieuc" );  
	KEYVAL ( 0x0eeb , "Hangul_J_Khieuq" );  
	KEYVAL ( 0x0eec , "Hangul_J_Tieut" );  
	KEYVAL ( 0x0eed , "Hangul_J_Phieuf" );  
	KEYVAL ( 0x0eee , "Hangul_J_Hieuh" );  
	KEYVAL ( 0x0eef , "Hangul_RieulYeorinHieuh" );  
	KEYVAL ( 0x0ef0 , "Hangul_SunkyeongeumMieum" );  
	KEYVAL ( 0x0ef1 , "Hangul_SunkyeongeumPieub" );  
	KEYVAL ( 0x0ef2 , "Hangul_PanSios" );  
	KEYVAL ( 0x0ef3 , "Hangul_KkogjiDalrinIeung" );  
	KEYVAL ( 0x0ef4 , "Hangul_SunkyeongeumPhieuf" );  
	KEYVAL ( 0x0ef5 , "Hangul_YeorinHieuh" );  
	KEYVAL ( 0x0ef6 , "Hangul_AraeA" );  
	KEYVAL ( 0x0ef7 , "Hangul_AraeAE" );  
	KEYVAL ( 0x0ef8 , "Hangul_J_PanSios" );  
	KEYVAL ( 0x0ef9 , "Hangul_J_KkogjiDalrinIeung" );  
	KEYVAL ( 0x0efa , "Hangul_J_YeorinHieuh" );  
	KEYVAL ( 0x0eff , "Korean_Won" );  
	KEYVAL ( 0x13bc , "OE" );  
	KEYVAL ( 0x13bd , "oe" );  
	KEYVAL ( 0x13be , "Ydiaeresis" );  
	KEYVAL ( 0x20a0 , "EcuSign" );  
	KEYVAL ( 0x20a1 , "ColonSign" );  
	KEYVAL ( 0x20a2 , "CruzeiroSign" );  
	KEYVAL ( 0x20a3 , "FFrancSign" );  
	KEYVAL ( 0x20a4 , "LiraSign" );  
	KEYVAL ( 0x20a5 , "MillSign" );  
	KEYVAL ( 0x20a6 , "NairaSign" );  
	KEYVAL ( 0x20a7 , "PesetaSign" );  
	KEYVAL ( 0x20a8 , "RupeeSign" );  
	KEYVAL ( 0x20a9 , "WonSign" );  
	KEYVAL ( 0x20aa , "NewSheqelSign" );  
	KEYVAL ( 0x20ab , "DongSign" );  
	KEYVAL ( 0x20ac , "EuroSign" );  
	KEYVAL ( 0xFD01 , "3270_Duplicate" );  
	KEYVAL ( 0xFD02 , "3270_FieldMark" );  
	KEYVAL ( 0xFD03 , "3270_Right2" );  
	KEYVAL ( 0xFD04 , "3270_Left2" );  
	KEYVAL ( 0xFD05 , "3270_BackTab" );  
	KEYVAL ( 0xFD06 , "3270_EraseEOF" );  
	KEYVAL ( 0xFD07 , "3270_EraseInput" );  
	KEYVAL ( 0xFD08 , "3270_Reset" );  
	KEYVAL ( 0xFD09 , "3270_Quit" );  
	KEYVAL ( 0xFD0A , "3270_PA1" );  
	KEYVAL ( 0xFD0B , "3270_PA2" );  
	KEYVAL ( 0xFD0C , "3270_PA3" );  
	KEYVAL ( 0xFD0D , "3270_Test" );  
	KEYVAL ( 0xFD0E , "3270_Attn" );  
	KEYVAL ( 0xFD0F , "3270_CursorBlink" );  
	KEYVAL ( 0xFD10 , "3270_AltCursor" );  
	KEYVAL ( 0xFD11 , "3270_KeyClick" );  
	KEYVAL ( 0xFD12 , "3270_Jump" );  
	KEYVAL ( 0xFD13 , "3270_Ident" );  
	KEYVAL ( 0xFD14 , "3270_Rule" );  
	KEYVAL ( 0xFD15 , "3270_Copy" );  
	KEYVAL ( 0xFD16 , "3270_Play" );  
	KEYVAL ( 0xFD17 , "3270_Setup" );  
	KEYVAL ( 0xFD18 , "3270_Record" );  
	KEYVAL ( 0xFD19 , "3270_ChangeScreen" );  
	KEYVAL ( 0xFD1A , "3270_DeleteWord" );  
	KEYVAL ( 0xFD1B , "3270_ExSelect" );  
	KEYVAL ( 0xFD1C , "3270_CursorSelect" );  
	KEYVAL ( 0xFD1D , "3270_PrintScreen" );  
	KEYVAL ( 0xFD1E , "3270_Enter" );  
	KEYVAL ( 0xFE01 , "ISO_Lock" );  
	KEYVAL ( 0xFE02 , "ISO_Level2_Latch" );  
	KEYVAL ( 0xFE03 , "ISO_Level3_Shift" );  
	KEYVAL ( 0xFE04 , "ISO_Level3_Latch" );  
	KEYVAL ( 0xFE05 , "ISO_Level3_Lock" );  
	KEYVAL ( 0xFE06 , "ISO_Group_Latch" );  
	KEYVAL ( 0xFE07 , "ISO_Group_Lock" );  
	KEYVAL ( 0xFE08 , "ISO_Next_Group" );  
	KEYVAL ( 0xFE09 , "ISO_Next_Group_Lock" );  
	KEYVAL ( 0xFE0A , "ISO_Prev_Group" );  
	KEYVAL ( 0xFE0B , "ISO_Prev_Group_Lock" );  
	KEYVAL ( 0xFE0C , "ISO_First_Group" );  
	KEYVAL ( 0xFE0D , "ISO_First_Group_Lock" );  
	KEYVAL ( 0xFE0E , "ISO_Last_Group" );  
	KEYVAL ( 0xFE0F , "ISO_Last_Group_Lock" );  
	KEYVAL ( 0xFE20 , "ISO_Left_Tab" );  
	KEYVAL ( 0xFE21 , "ISO_Move_Line_Up" );  
	KEYVAL ( 0xFE22 , "ISO_Move_Line_Down" );  
	KEYVAL ( 0xFE23 , "ISO_Partial_Line_Up" );  
	KEYVAL ( 0xFE24 , "ISO_Partial_Line_Down" );  
	KEYVAL ( 0xFE25 , "ISO_Partial_Space_Left" );  
	KEYVAL ( 0xFE26 , "ISO_Partial_Space_Right" );  
	KEYVAL ( 0xFE27 , "ISO_Set_Margin_Left" );  
	KEYVAL ( 0xFE28 , "ISO_Set_Margin_Right" );  
	KEYVAL ( 0xFE29 , "ISO_Release_Margin_Left" );  
	KEYVAL ( 0xFE2A , "ISO_Release_Margin_Right" );  
	KEYVAL ( 0xFE2B , "ISO_Release_Both_Margins" );  
	KEYVAL ( 0xFE2C , "ISO_Fast_Cursor_Left" );  
	KEYVAL ( 0xFE2D , "ISO_Fast_Cursor_Right" );  
	KEYVAL ( 0xFE2E , "ISO_Fast_Cursor_Up" );  
	KEYVAL ( 0xFE2F , "ISO_Fast_Cursor_Down" );  
	KEYVAL ( 0xFE30 , "ISO_Continuous_Underline" );  
	KEYVAL ( 0xFE31 , "ISO_Discontinuous_Underline" );  
	KEYVAL ( 0xFE32 , "ISO_Emphasize" );  
	KEYVAL ( 0xFE33 , "ISO_Center_Object" );  
	KEYVAL ( 0xFE34 , "ISO_Enter" );  
	KEYVAL ( 0xFE50 , "dead_grave" );  
	KEYVAL ( 0xFE51 , "dead_acute" );  
	KEYVAL ( 0xFE52 , "dead_circumflex" );  
	KEYVAL ( 0xFE53 , "dead_tilde" );  
	KEYVAL ( 0xFE54 , "dead_macron" );  
	KEYVAL ( 0xFE55 , "dead_breve" );  
	KEYVAL ( 0xFE56 , "dead_abovedot" );  
	KEYVAL ( 0xFE57 , "dead_diaeresis" );  
	KEYVAL ( 0xFE58 , "dead_abovering" );  
	KEYVAL ( 0xFE59 , "dead_doubleacute" );  
	KEYVAL ( 0xFE5A , "dead_caron" );  
	KEYVAL ( 0xFE5B , "dead_cedilla" );  
	KEYVAL ( 0xFE5C , "dead_ogonek" );  
	KEYVAL ( 0xFE5D , "dead_iota" );  
	KEYVAL ( 0xFE5E , "dead_voiced_sound" );  
	KEYVAL ( 0xFE5F , "dead_semivoiced_sound" );  
	KEYVAL ( 0xFE60 , "dead_belowdot" );  
	KEYVAL ( 0xFE61 , "dead_hook" );  
	KEYVAL ( 0xFE62 , "dead_horn" );  
	KEYVAL ( 0xFE70 , "AccessX_Enable" );  
	KEYVAL ( 0xFE71 , "AccessX_Feedback_Enable" );  
	KEYVAL ( 0xFE72 , "RepeatKeys_Enable" );  
	KEYVAL ( 0xFE73 , "SlowKeys_Enable" );  
	KEYVAL ( 0xFE74 , "BounceKeys_Enable" );  
	KEYVAL ( 0xFE75 , "StickyKeys_Enable" );  
	KEYVAL ( 0xFE76 , "MouseKeys_Enable" );  
	KEYVAL ( 0xFE77 , "MouseKeys_Accel_Enable" );  
	KEYVAL ( 0xFE78 , "Overlay1_Enable" );  
	KEYVAL ( 0xFE79 , "Overlay2_Enable" );  
	KEYVAL ( 0xFE7A , "AudibleBell_Enable" );  
	KEYVAL ( 0xFED0 , "First_Virtual_Screen" );  
	KEYVAL ( 0xFED1 , "Prev_Virtual_Screen" );  
	KEYVAL ( 0xFED2 , "Next_Virtual_Screen" );  
	KEYVAL ( 0xFED4 , "Last_Virtual_Screen" );  
	KEYVAL ( 0xFED5 , "Terminate_Server" );  
	KEYVAL ( 0xFEE0 , "Pointer_Left" );  
	KEYVAL ( 0xFEE1 , "Pointer_Right" );  
	KEYVAL ( 0xFEE2 , "Pointer_Up" );  
	KEYVAL ( 0xFEE3 , "Pointer_Down" );  
	KEYVAL ( 0xFEE4 , "Pointer_UpLeft" );  
	KEYVAL ( 0xFEE5 , "Pointer_UpRight" );  
	KEYVAL ( 0xFEE6 , "Pointer_DownLeft" );  
	KEYVAL ( 0xFEE7 , "Pointer_DownRight" );  
	KEYVAL ( 0xFEE8 , "Pointer_Button_Dflt" );  
	KEYVAL ( 0xFEE9 , "Pointer_Button1" );  
	KEYVAL ( 0xFEEA , "Pointer_Button2" );  
	KEYVAL ( 0xFEEB , "Pointer_Button3" );  
	KEYVAL ( 0xFEEC , "Pointer_Button4" );  
	KEYVAL ( 0xFEED , "Pointer_Button5" );  
	KEYVAL ( 0xFEEE , "Pointer_DblClick_Dflt" );  
	KEYVAL ( 0xFEEF , "Pointer_DblClick1" );  
	KEYVAL ( 0xFEF0 , "Pointer_DblClick2" );  
	KEYVAL ( 0xFEF1 , "Pointer_DblClick3" );  
	KEYVAL ( 0xFEF2 , "Pointer_DblClick4" );  
	KEYVAL ( 0xFEF3 , "Pointer_DblClick5" );  
	KEYVAL ( 0xFEF4 , "Pointer_Drag_Dflt" );  
	KEYVAL ( 0xFEF5 , "Pointer_Drag1" );  
	KEYVAL ( 0xFEF6 , "Pointer_Drag2" );  
	KEYVAL ( 0xFEF7 , "Pointer_Drag3" );  
	KEYVAL ( 0xFEF8 , "Pointer_Drag4" );  
	KEYVAL ( 0xFEF9 , "Pointer_EnableKeys" );  
	KEYVAL ( 0xFEFA , "Pointer_Accelerate" );  
	KEYVAL ( 0xFEFB , "Pointer_DfltBtnNext" );  
	KEYVAL ( 0xFEFC , "Pointer_DfltBtnPrev" );  
	KEYVAL ( 0xFEFD , "Pointer_Drag5" );  
	KEYVAL ( 0xFF08 , "BackSpace" );  
	KEYVAL ( 0xFF09 , "Tab" );  
	KEYVAL ( 0xFF0A , "Linefeed" );  
	KEYVAL ( 0xFF0B , "Clear" );  
	KEYVAL ( 0xFF0D , "Return" );  
	KEYVAL ( 0xFF13 , "Pause" );  
	KEYVAL ( 0xFF14 , "Scroll_Lock" );  
	KEYVAL ( 0xFF15 , "Sys_Req" );  
	KEYVAL ( 0xFF1B , "Escape" );  
	KEYVAL ( 0xFF20 , "Multi_key" );  
	KEYVAL ( 0xFF21 , "Kanji" );  
	KEYVAL ( 0xFF22 , "Muhenkan" );  
	KEYVAL ( 0xFF23 , "Henkan" );  
	KEYVAL ( 0xFF23 , "Henkan_Mode" );  
	KEYVAL ( 0xFF24 , "Romaji" );  
	KEYVAL ( 0xFF25 , "Hiragana" );  
	KEYVAL ( 0xFF26 , "Katakana" );  
	KEYVAL ( 0xFF27 , "Hiragana_Katakana" );  
	KEYVAL ( 0xFF28 , "Zenkaku" );  
	KEYVAL ( 0xFF29 , "Hankaku" );  
	KEYVAL ( 0xFF2A , "Zenkaku_Hankaku" );  
	KEYVAL ( 0xFF2B , "Touroku" );  
	KEYVAL ( 0xFF2C , "Massyo" );  
	KEYVAL ( 0xFF2D , "Kana_Lock" );  
	KEYVAL ( 0xFF2E , "Kana_Shift" );  
	KEYVAL ( 0xFF2F , "Eisu_Shift" );  
	KEYVAL ( 0xFF30 , "Eisu_toggle" );  
	KEYVAL ( 0xff31 , "Hangul" );  
	KEYVAL ( 0xff32 , "Hangul_Start" );  
	KEYVAL ( 0xff33 , "Hangul_End" );  
	KEYVAL ( 0xff34 , "Hangul_Hanja" );  
	KEYVAL ( 0xff35 , "Hangul_Jamo" );  
	KEYVAL ( 0xff36 , "Hangul_Romaja" );  
	KEYVAL ( 0xFF37 , "Codeinput" );  
	KEYVAL ( 0xff37 , "Hangul_Codeinput" );  
	KEYVAL ( 0xFF37 , "Kanji_Bangou" );  
	KEYVAL ( 0xff38 , "Hangul_Jeonja" );  
	KEYVAL ( 0xff39 , "Hangul_Banja" );  
	KEYVAL ( 0xff3a , "Hangul_PreHanja" );  
	KEYVAL ( 0xff3b , "Hangul_PostHanja" );  
	KEYVAL ( 0xff3c , "Hangul_SingleCandidate" );  
	KEYVAL ( 0xFF3C , "SingleCandidate" );  
	KEYVAL ( 0xff3d , "Hangul_MultipleCandidate" );  
	KEYVAL ( 0xFF3D , "MultipleCandidate" );  
	KEYVAL ( 0xFF3D , "Zen_Koho" );  
	KEYVAL ( 0xff3e , "Hangul_PreviousCandidate" );  
	KEYVAL ( 0xFF3E , "Mae_Koho" );  
	KEYVAL ( 0xFF3E , "PreviousCandidate" );  
	KEYVAL ( 0xff3f , "Hangul_Special" );  
	KEYVAL ( 0xFF50 , "Home" );  
	KEYVAL ( 0xFF51 , "Left" );  
	KEYVAL ( 0xFF52 , "Up" );  
	KEYVAL ( 0xFF53 , "Right" );  
	KEYVAL ( 0xFF54 , "Down" );  
	KEYVAL ( 0xFF55 , "Page_Up" );  
	KEYVAL ( 0xFF55 , "Prior" );  
	KEYVAL ( 0xFF56 , "Next" );  
	KEYVAL ( 0xFF56 , "Page_Down" );  
	KEYVAL ( 0xFF57 , "End" );  
	KEYVAL ( 0xFF58 , "Begin" );  
	KEYVAL ( 0xFF60 , "Select" );  
	KEYVAL ( 0xFF61 , "Print" );  
	KEYVAL ( 0xFF62 , "Execute" );  
	KEYVAL ( 0xFF63 , "Insert" );  
	KEYVAL ( 0xFF65 , "Undo" );  
	KEYVAL ( 0xFF66 , "Redo" );  
	KEYVAL ( 0xFF67 , "Menu" );  
	KEYVAL ( 0xFF68 , "Find" );  
	KEYVAL ( 0xFF69 , "Cancel" );  
	KEYVAL ( 0xFF6A , "Help" );  
	KEYVAL ( 0xFF6B , "Break" );  
	KEYVAL ( 0xFF7E , "Arabic_switch" );  
	KEYVAL ( 0xFF7E , "Greek_switch" );  
	KEYVAL ( 0xFF7E , "Hangul_switch" );  
	KEYVAL ( 0xFF7E , "Hebrew_switch" );  
	KEYVAL ( 0xFF7E , "ISO_Group_Shift" );  
	KEYVAL ( 0xFF7E , "kana_switch" );  
	KEYVAL ( 0xFF7E , "Mode_switch" );  
	KEYVAL ( 0xFF7E , "script_switch" );  
	KEYVAL ( 0xFF7F , "Num_Lock" );  
	KEYVAL ( 0xFF80 , "KP_Space" );  
	KEYVAL ( 0xFF89 , "KP_Tab" );  
	KEYVAL ( 0xFF8D , "KP_Enter" );  
	KEYVAL ( 0xFF91 , "KP_F1" );  
	KEYVAL ( 0xFF92 , "KP_F2" );  
	KEYVAL ( 0xFF93 , "KP_F3" );  
	KEYVAL ( 0xFF94 , "KP_F4" );  
	KEYVAL ( 0xFF95 , "KP_Home" );  
	KEYVAL ( 0xFF96 , "KP_Left" );  
	KEYVAL ( 0xFF97 , "KP_Up" );  
	KEYVAL ( 0xFF98 , "KP_Right" );  
	KEYVAL ( 0xFF99 , "KP_Down" );  
	KEYVAL ( 0xFF9A , "KP_Page_Up" );  
	KEYVAL ( 0xFF9A , "KP_Prior" );  
	KEYVAL ( 0xFF9B , "KP_Next" );  
	KEYVAL ( 0xFF9B , "KP_Page_Down" );  
	KEYVAL ( 0xFF9C , "KP_End" );  
	KEYVAL ( 0xFF9D , "KP_Begin" );  
	KEYVAL ( 0xFF9E , "KP_Insert" );  
	KEYVAL ( 0xFF9F , "KP_Delete" );  
	KEYVAL ( 0xFFAA , "KP_Multiply" );  
	KEYVAL ( 0xFFAB , "KP_Add" );  
	KEYVAL ( 0xFFAC , "KP_Separator" );  
	KEYVAL ( 0xFFAD , "KP_Subtract" );  
	KEYVAL ( 0xFFAE , "KP_Decimal" );  
	KEYVAL ( 0xFFAF , "KP_Divide" );  
	KEYVAL ( 0xFFB0 , "KP_0" );  
	KEYVAL ( 0xFFB1 , "KP_1" );  
	KEYVAL ( 0xFFB2 , "KP_2" );  
	KEYVAL ( 0xFFB3 , "KP_3" );  
	KEYVAL ( 0xFFB4 , "KP_4" );  
	KEYVAL ( 0xFFB5 , "KP_5" );  
	KEYVAL ( 0xFFB6 , "KP_6" );  
	KEYVAL ( 0xFFB7 , "KP_7" );  
	KEYVAL ( 0xFFB8 , "KP_8" );  
	KEYVAL ( 0xFFB9 , "KP_9" );  
	KEYVAL ( 0xFFBD , "KP_Equal" );  
	KEYVAL ( 0xFFBE , "F1" );  
	KEYVAL ( 0xFFBF , "F2" );  
	KEYVAL ( 0xFFC0 , "F3" );  
	KEYVAL ( 0xFFC1 , "F4" );  
	KEYVAL ( 0xFFC2 , "F5" );  
	KEYVAL ( 0xFFC3 , "F6" );  
	KEYVAL ( 0xFFC4 , "F7" );  
	KEYVAL ( 0xFFC5 , "F8" );  
	KEYVAL ( 0xFFC6 , "F9" );  
	KEYVAL ( 0xFFC7 , "F10" );  
	KEYVAL ( 0xFFC8 , "F11" );  
	KEYVAL ( 0xFFC8 , "L1" );  
	KEYVAL ( 0xFFC9 , "F12" );  
	KEYVAL ( 0xFFC9 , "L2" );  
	KEYVAL ( 0xFFCA , "F13" );  
	KEYVAL ( 0xFFCA , "L3" );  
	KEYVAL ( 0xFFCB , "F14" );  
	KEYVAL ( 0xFFCB , "L4" );  
	KEYVAL ( 0xFFCC , "F15" );  
	KEYVAL ( 0xFFCC , "L5" );  
	KEYVAL ( 0xFFCD , "F16" );  
	KEYVAL ( 0xFFCD , "L6" );  
	KEYVAL ( 0xFFCE , "F17" );  
	KEYVAL ( 0xFFCE , "L7" );  
	KEYVAL ( 0xFFCF , "F18" );  
	KEYVAL ( 0xFFCF , "L8" );  
	KEYVAL ( 0xFFD0 , "F19" );  
	KEYVAL ( 0xFFD0 , "L9" );  
	KEYVAL ( 0xFFD1 , "F20" );  
	KEYVAL ( 0xFFD1 , "L10" );  
	KEYVAL ( 0xFFD2 , "F21" );  
	KEYVAL ( 0xFFD2 , "R1" );  
	KEYVAL ( 0xFFD3 , "F22" );  
	KEYVAL ( 0xFFD3 , "R2" );  
	KEYVAL ( 0xFFD4 , "F23" );  
	KEYVAL ( 0xFFD4 , "R3" );  
	KEYVAL ( 0xFFD5 , "F24" );  
	KEYVAL ( 0xFFD5 , "R4" );  
	KEYVAL ( 0xFFD6 , "F25" );  
	KEYVAL ( 0xFFD6 , "R5" );  
	KEYVAL ( 0xFFD7 , "F26" );  
	KEYVAL ( 0xFFD7 , "R6" );  
	KEYVAL ( 0xFFD8 , "F27" );  
	KEYVAL ( 0xFFD8 , "R7" );  
	KEYVAL ( 0xFFD9 , "F28" );  
	KEYVAL ( 0xFFD9 , "R8" );  
	KEYVAL ( 0xFFDA , "F29" );  
	KEYVAL ( 0xFFDA , "R9" );  
	KEYVAL ( 0xFFDB , "F30" );  
	KEYVAL ( 0xFFDB , "R10" );  
	KEYVAL ( 0xFFDC , "F31" );  
	KEYVAL ( 0xFFDC , "R11" );  
	KEYVAL ( 0xFFDD , "F32" );  
	KEYVAL ( 0xFFDD , "R12" );  
	KEYVAL ( 0xFFDE , "F33" );  
	KEYVAL ( 0xFFDE , "R13" );  
	KEYVAL ( 0xFFDF , "F34" );  
	KEYVAL ( 0xFFDF , "R14" );  
	KEYVAL ( 0xFFE0 , "F35" );  
	KEYVAL ( 0xFFE0 , "R15" );  
	KEYVAL ( 0xFFE1 , "Shift_L" );  
	KEYVAL ( 0xFFE2 , "Shift_R" );  
	KEYVAL ( 0xFFE3 , "Control_L" );  
	KEYVAL ( 0xFFE4 , "Control_R" );  
	KEYVAL ( 0xFFE5 , "Caps_Lock" );  
	KEYVAL ( 0xFFE6 , "Shift_Lock" );  
	KEYVAL ( 0xFFE7 , "Meta_L" );  
	KEYVAL ( 0xFFE8 , "Meta_R" );  
	KEYVAL ( 0xFFE9 , "Alt_L" );  
	KEYVAL ( 0xFFEA , "Alt_R" );  
	KEYVAL ( 0xFFEB , "Super_L" );  
	KEYVAL ( 0xFFEC , "Super_R" );  
	KEYVAL ( 0xFFED , "Hyper_L" );  
	KEYVAL ( 0xFFEE , "Hyper_R" );  
	KEYVAL ( 0xFFFF , "Delete" );  

/*  0xFFFFFF "VoidSymbol" */
}

