#  DHCP D-BUS Daemon 

#  If dhcdbd is to be run by the dbus-daemon's service activation service,
#  then currently it MUST be installed setuid; else, it must have an 
#  initscript and be run as root during boot .

Summary:   DHCP D-BUS daemon (dhcdbd) controls dhclient sessions with D-BUS, stores and presents DHCP options.
Name:      dhcdbd
Version:   2.0
Release:   1%{?dist}
License:   GPL
Group:     System Environment/Daemons
URL:       http://people.redhat.com/dcantrel/%{name}/%{name}-%{version}.tar.bz2
Source0:   %{name}-%{version}.tar.bz2
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
Requires:  dhclient >= 3.0.2-12, dbus >= 0.6
BuildRequires: dbus-devel >= 0.90, pkgconfig

%description
dhcdbd provides a D-BUS interface to the ISC dhclient software.  The
daemon provides access to DHCP configuration operations and stores those
options persistently.  Other D-BUS applications can receive notifications
of changes in the client's DHCP configuration.

%prep
%setup -q

%build
make

%install
DESTDIR=$RPM_BUILD_ROOT make install
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
install -c -m 755 dhcdbd.init $RPM_BUILD_ROOT/etc/rc.d/init.d/dhcdbd

%post
if [ $1 -eq 1 ]; then
    chkconfig --add dhcdbd >/dev/null 2>&1;
fi

%preun
if [ $1 -eq 0 ]; then
    service dhcdbd stop >/dev/null 2>&1
fi

%postun
if [ $1 -ge 1 ]; then
    service dhcdbd condrestart >/dev/null 2>&1
fi

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(0644, root, root, 0755)
%config /usr/share/dbus-1/services/dhcdbd.service
%config /etc/dbus-1/system.d/dhcdbd.conf
%attr(755,root,root) /sbin/dhcdbd
%attr(755,root,root) /etc/rc.d/init.d/dhcdbd
%doc README COPYING ChangeLog TODO

%changelog
* Tue Sep 26 2006 David Cantrell <dcantrell@redhat.com> - 2.0-1
- Rebuild for FC6
- BuildRequires pkgconfig

* Tue Sep 26 2006 David Cantrell <dcantrell@redhat.com> - 1.99.4-1
- Reworked source tree to make builds a little cleaner
- Added more documentation
- Removed named user policy in dhcdbd.conf (#205254)

* Wed Aug 16 2006 Bill Nottingham <notting@redhat.com>
- silence %%postun condrestart, %%preun stop

* Mon Aug 14 2006 David Cantrell <dcantrell@redhat.com> - 1.16-1
- Rolled in dbus-deprecated patch changes to upstream source
- Corrected init script problems (#202219)
- Install the init script from the source archive, not SOURCES

* Wed Jul 19 2006 Matthias Clasen <mclasen@redhat.com> - 1.15-1.FC6.3
- Rebuild against new dbus

* Tue Jul 18 2006 John (J5) Palmieri <johnp@redhat.com> - 1.15-1.FC6.2
- add dbus-deprecated patch

* Wed Jul 12 2006 Jesse Keating <jkeating@redhat.com> - 1.15-1.FC6.1
- rebuild

* Mon May 30 2006 Jason Vas Dias <jvdias@redhat.com> - 1.15-1.FC6
- fix bug 193562: remove 'servicedir' entry from dhcdbd.conf

* Thu Apr 20 2006 Jason Vas Dias <jvdias@redhat.com> - 1.14-1.FC5
- fix bug 189529: prevent potential memory corruption on hex string
  options with single-byte non-ascii values
- modify dhcp option types to be in line with latest ISC dhcp

* Fri Feb 10 2006 Jesse Keating <jkeating@redhat.com> - 1.12-1.FC5.2
- bump again for double-long bug on ppc(64)

* Tue Feb 07 2006 Jesse Keating <jkeating@redhat.com> - 1.12-1.FC5.1
- rebuilt for new gcc4.1 snapshot and glibc changes

* Tue Jan 17 2006 Jason Vas Dias <jvdias@redhat.com> 1.12-1
- Cleanup un-exercised code in dbus_service.c, lines 381 & 391
  (pointed out by David Binderman<dcb314@hotmail.com>)

* Thu Dec 01 2005 Jason Vas Dias <jvdias@redhat.com> 1.11-1
- Rebuild for new dbus-0.6 dependency; remove use of
  DBUS_NAME_FLAG_PROHIBIT_REPLACEMENT

* Wed Nov 16 2005 Jason Vas Dias <jvdias@redhat.com> 1.10-1
- Rebuild for FC-5 (version must compare > FC-4)
- Change dhclient.leases directory to /var/lib/dhclient/ for bug 169164
- fix Makefile to workaround bug 173431
- apply patch contributed by Robert Love<rml@novell.com> :
  o use daemon(3) to daemonize
  o direct stdout/stderr to /dev/null, not console
  o use dhclient -q option

* Thu Oct 06 2005 Jason Vas Dias <jvdias@redhat.com> 1.9-1
- fix bug 169937: do 'chkconfig --add dhcdbd' in %post 
- Add CHANGES changelog file to %doc generated from this changelog
- Rebuild with new dbus / gcc / glibc

* Fri Aug 12 2005 Jason Vas Dias <jvdias@redhat.com> 1.8-1
- Allow named user permission to send in /etc/dbus-1/system.d/dhcdbd.conf
- Fix bug 163711 addendum: handle non-existence of /etc/sysconfig/network

* Wed Jul 27 2005 Jason Vas Dias <jvdias@redhat.com> 1.7-1
- fix bug 163711 / 162857: dhcdbd.init startup order
- improve security with system.d/dhcdbd.conf: allow only
  root user to send to dhcdbd
 
* Mon Jun 06 2005 Jason Vas Dias <jvdias@redhat.com> 1.6-1
- Add GPL licensing
- Make all paths into -D options
- Handle interface specific dhclient-${if}.conf files properly
- Add "up" dhclient flag DHCLIENT_NO_LEASES to remove
  lease database on startup
- Add /var/run/dhcdbd.pid file support
- fix initscript stop & add condrestart
- invoke condrestart on upgrade
- cleanup after dead prospective subscribers properly

* Sun May 15 2005 Jason Vas Dias <jvdias@redhat.com> 1.5-1
- add subscriptions for option signals from ANY interface
- fix handling of .old. options from previous lease

* Tue May 03 2005 Jason Vas Dias <jvdias@redhat.com> 1.4-1
- continue to ship dhcdbd.conf and dhcdbd.service even if
  DHCDBD_SETUID=0
- allow --no_daemon to appear before --system or --session

* Tue May 03 2005 Jason Vas Dias <jvdias@redhat.com> 1.3-1
- added timeout "up" argument

* Mon May 02 2005 Jason Vas Dias <jvdias@redhat.com> 1.2-1
- removed setuid requirement.

* Fri Apr 30 2005 Jason Vas Dias <jvdias@redhat.com> 1.1-1
- added subscription facility.

* Mon Apr 25 2005 Jason Vas Dias <jvdias@redhat.com> - 
- Initial build.
