/*
 *========================================================================
 * $Id: help.c 181 2006-07-12 16:41:25Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

#include "dieharder.h"

/*
 * Print out all results in table format only
 */
void table_line(Dtest *dtest,Test **test)
{

 unsigned int i,j,k;

#if !defined(RDIEHARDER)

 /*
  * There may be more than one statistic (final p-value) generated by
  * this test; we loop over all of them.
  */
 for(i=0;i<dtest->nkps;i++){

   if(tflag & TNAME){
     fprintf(stdout,"|");
     if(fromfile){
       fprintf(stdout,"%30s",filename);
     } else {
       fprintf(stdout,"%30s",dtest->name);
     }
   }
   if(tflag & TSNAME){
     fprintf(stdout,"|");
     if(fromfile){
       fprintf(stdout,"%20s",filename);
     } else {
       fprintf(stdout,"%20s",dtest->sname);
     }
   }
   if(tflag & TNTUPLE){
     fprintf(stdout,"|");
     fprintf(stdout,"%6d",test[0]->ntuple);
   }
   if(tflag & TTSAMPLES){
     fprintf(stdout,"|");
     fprintf(stdout,"%12u",test[0]->tsamples);
   }
   if(tflag & TPSAMPLES){
     fprintf(stdout,"|");
     fprintf(stdout,"%8u",test[0]->psamples);
   }
   if(tflag & TPVALUE){
     fprintf(stdout,"|");
     fprintf(stdout,"%10.8f",test[i]->ks_pvalue);
   }
   if(tflag & TASSESSMENT){
     fprintf(stdout,"|");
     if(test[i]->ks_pvalue < 0.0001 || test[i]->ks_pvalue > 0.9999){
       fprintf(stdout,"%16s","FAILED(0.02%) ");
     } else if(test[i]->ks_pvalue < 0.01 || test[i]->ks_pvalue > 0.99){
       fprintf(stdout,"%16s","MAY BE WEAK(2%)");
     } else {
       fprintf(stdout,"%16s","PASSED     ");
     }
   }

   fprintf(stdout,"|\n");

 }

#endif  /* !defined(RDIEHARDER) */

#ifdef RDIEHARDER
 rdh_testptr = test[0]; /* NB we drop all but the first one!! */
 rdh_dtestptr = dtest;
#endif /* RDIEHARDER */


}

void table_header()
{

 unsigned int i,j,k;

 #if !defined(RDIEHARDER)
 /*
  * We assemble the table header according to what tflag's value is.
  */
 if(tflag & THEADER == 0) return;   /* No header! */

 fprintf(stdout,"#==============================================================================\n");
 if(tflag & TGEN){
   fprintf(stdout,"# Testing generator %s\n",gsl_rng_name(rng));
 }
 
 fprintf(stdout,"#");
 if(tflag & TNAME){
   fprintf(stdout,"|");
   fprintf(stdout,"|%29s","Test (short) Name");
 }
 if(tflag & TSNAME){
   fprintf(stdout,"|");
   fprintf(stdout,"%19s","Test (short) Name");
 }
 if(tflag & TNTUPLE){
   fprintf(stdout,"|");
   fprintf(stdout,"%6s","ntuple");
 }
 if(tflag & TTSAMPLES){
   fprintf(stdout,"|");
   fprintf(stdout,"%12s","  tsamples  ");
 }
 if(tflag & TPSAMPLES){
   fprintf(stdout,"|");
   fprintf(stdout,"%8s","psamples");
 }
 if(tflag & TPVALUE){
   fprintf(stdout,"|");
   fprintf(stdout,"%10s","p-value ");
 }
 if(tflag & TASSESSMENT){
   fprintf(stdout,"|");
   fprintf(stdout,"%16s","Assessment   ");
 }
 fprintf(stdout,"|\n");
 fprintf(stdout,"#==============================================================================\n");

#endif  /* !defined(RDIEHARDER) */

#ifdef RDIEHARDER
 rdh_testptr = test[0]; /* NB we drop all but the first one!! */
 rdh_dtestptr = dtest;
#endif /* RDIEHARDER */


}

