#include "appsupport.h"
#include "profile.h"
#include "users.h"
#include "groups.h"
#include "appglobals.h"
#include "appfunctions.h"
#include "profile.h"
#include "newdruids.h"
#include "usergrouplists.h"

gboolean
newgroup_commit (GnomeDruidPage * gnomedruidpage)
{
  LDAPMod **modifications = NULL;
  diradmin_group *newuser = NULL;
  int ldap_errors = LDAP_SUCCESS;
  GtkWidget *window = NULL;
  gchar *dn = NULL;
  gchar *basedn = NULL;
  gchar *gid = NULL;
  icon_entry *entry = NULL;

  if (connection_profile_is_connected (current_connection_profile) == FALSE)
    return ERROR;

  window = lookup_widget (GTK_WIDGET (gnomedruidpage), "druid_new_group");
  basedn = gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "baseou")));
  //this is a stupid kludge to avoid constructing the DN, for the time being
  if (GTK_TOGGLE_BUTTON
      (lookup_widget (GTK_WIDGET (gnomedruidpage), "automaticgid"))->active)
    gid = get_lowest_gid (current_connection_profile);
  else
    gid =
      g_strdup (gtk_entry_get_text
		(GTK_ENTRY (lookup_widget (window, "gidnumber"))));
  dn =
    g_strconcat ("cn=",
		 gtk_entry_get_text (GTK_ENTRY
				     (lookup_widget (window, "cn"))), ",",
		 basedn, NULL);

  gtk_entry_set_text (GTK_ENTRY (lookup_widget (window, "gidnumber")), gid);

  newuser = create_group_struct_from_dialogbox (current_connection_profile,
						window, dn);

  modifications = diradmin_group_create_ldapdiff (newuser);
  if (modifications)
    {
      ldap_errors =
	connection_profile_create_record (current_connection_profile,
					  modifications, dn);
      ldap_mods_free (modifications, 1);
    }
  if (ldap_errors)
    gtk_widget_show (create_messagebox_with_message
		     (ldap_err2string (ldap_errors)));
  else
    {
      entry =
	icon_entry_new_with_parms (diradmin_group_get_attribute
				   (newuser, "cn"), dn, DIRADMIN_GROUP);
      objectview_add (entry);
      icon_entry_destroy (entry);
    }

  g_free (dn);
  g_free (gid);
  diradmin_group_destroy (newuser);

  if (ldap_errors)
    return ERROR;
  connection_profile_set_last_group_ou (connection_profile_list_getbyname
					(connection_profile_list,
					 connection_profile_get_name
					 (current_connection_profile)),
					basedn);
  return OK;

}

gboolean
newuser_commit (GnomeDruidPage * gnomedruidpage)
{
  LDAPMod **modifications = NULL;
  diradmin_user *newuser = NULL;
  int ldap_errors = LDAP_SUCCESS;
  GtkWidget *window = NULL;
  gchar *dn = NULL;
  gchar *basedn = NULL;
  gchar *uid = NULL;
  icon_entry *entry = NULL;

  if (connection_profile_is_connected (current_connection_profile) == FALSE)
    return ERROR;
  window = lookup_widget (GTK_WIDGET (gnomedruidpage), "druid_new_user");
  basedn = gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "baseou")));
  if (GTK_TOGGLE_BUTTON
      (lookup_widget (GTK_WIDGET (gnomedruidpage), "automaticuid"))->active)
    uid = get_lowest_uid (current_connection_profile);
  else
    uid =
      g_strdup (gtk_entry_get_text
		(GTK_ENTRY (lookup_widget (window, "uidnumber"))));

  gtk_entry_set_text (GTK_ENTRY (lookup_widget (window, "uidnumber")), uid);

  dn = g_strconcat ("uid=",
		    gtk_entry_get_text (GTK_ENTRY
					(lookup_widget (window, "uid"))), ",",
		    basedn, NULL);
  g_print ("Base DN for user creation: %s\n", basedn);

  newuser = create_user_struct_from_dialogbox (current_connection_profile,
					       window, dn);

  modifications = diradmin_user_create_ldapdiff (newuser);
  if (modifications)
    {
      ldap_errors =
	connection_profile_create_record (current_connection_profile,
					  modifications, dn);
      ldap_mods_free (modifications, 1);
    }

  if (ldap_errors)
    gtk_widget_show (create_messagebox_with_message
		     (ldap_err2string (ldap_errors)));

  else
    {
      entry =
	icon_entry_new_with_parms (diradmin_user_get_attribute
				   (newuser, "uid"), dn, DIRADMIN_USER);
      objectview_add (entry);
      icon_entry_destroy (entry);
    }

  g_free (dn);
  g_free (uid);
  diradmin_user_destroy (newuser);

  if (ldap_errors)
    return ERROR;
  connection_profile_set_last_user_ou (connection_profile_list_getbyname
				       (connection_profile_list,
					connection_profile_get_name
					(current_connection_profile)),
				       basedn);
  return OK;

}
