/*
** 1999-06-12 -	A simple command to show popup menu close the mouse pointer. Must be invoked
**		by a command bound to a mouse button, since we need the triggering GdkEventButton
**		handy.
*/

#include "gentoo.h"

#include "cmdarg.h"
#include "events.h"

#include "menus.h"
#include "cmd_menupopup.h"

/* ----------------------------------------------------------------------------------------- */

/* 2000-04-09 -	Pop up the dirpane menu for the current pane. Now also works if bound to a
**		(keyboard) key, as opposed to only working for mouse buttons as before.
** 2000-12-03 -	Generality-boosted, through the new menu module.
*/
int cmd_menupopup(MainInfo *min, DirPane *src, DirPane *dst, CmdArg *ca)
{
	GdkEventButton		*evt;
	const gchar		*name;
	guint			button = 0;
	guint32			ac_time = 0;

/*	dpm_update(src);*/		/* Update context-sensitive part of menu. */

	if((evt = (GdkEventButton *) evt_event_get(GDK_BUTTON_PRESS)) != NULL)
	{
		button  = evt->button;
		ac_time = evt->time;
	}
	name = car_keyword_get_value(ca, "menu", "DirPaneMenu");
	return mnu_menu_popup(min->cfg.menus, name, button, ac_time);
}
