/*
** 1998-10-21 -	A little module to hold the quit commands. Purged them from the main
**		gentoo.c module, in an effort to shrink it a little.
** 1999-05-07 -	Slightly rewritten using the new command argument support. Removed
**		the QuitNow command, use "Quit dialog=false" for the same effect.
** 1999-06-19 -	Adapted for the new dialog module.
** 2000-03-04 -	Modified for the new window handling.
*/

#include "gentoo.h"
#include "dialog.h"
#include "cmdarg.h"
#include "cfg_gui.h"
#include "cmdseq.h"
#include "cmd_quit.h"

/* ----------------------------------------------------------------------------------------- */

/* 1998-09-15 -	Quit the program, but first check if there have been changes to the config. */
int cmd_quit(MainInfo *min, DirPane *src, DirPane *dst, CmdArg *ca)
{
	guint	dd, dialog = FALSE;

	if(win_window_update(min->gui->window))
		cfg_modified_set(min);

	dd     = (min->cfg.flags & CFLG_CHANGED) ? 2 : 0;
	dialog = car_keyword_get_boolean(ca, "dialog", dd);

	if(dialog == 2)
	{
		gint		res;

		res = dlg_dialog_sync_new_simple_wait(_("You may have some unsaved configuration changes.\n"
							"Quitting without saving will lose them. Really quit?"),
							_("Confirm Quitting"), _("Quit|Save, then Quit|Cancel"));
		if(res == -1)
			return TRUE;
		if(res == 1)
			csq_execute(min, "ConfigureSave");
		else if(res == 2)
			return TRUE;
		gtk_main_quit();
	}
	else if(dialog == 1)
	{
		if(dlg_dialog_sync_new_simple_wait(_("Are you sure you want to quit?"), _("Confirm Quitting"), _("Yes|No")) == DLG_POSITIVE)
			gtk_main_quit();
	}
	else
		gtk_main_quit();

	return TRUE;
}
