-- do not edit; automatically generated by UU.AG
module StaticChecks where

import Similarity ( similar )
import Args
import UHA_Syntax
import UHA_Utils
import UHA_Range
import Top.Types
import StaticErrors
import Warnings
import Messages
import List
import Utils ( internalError, fst3, minInt, maxInt )
import TypeConversion
import DerivingShow
import TypeConstraints
import qualified Data.Map as M
import ImportEnvironment
import OperatorTable
import Char ( isUpper )

-- filter undefined errors that are caused by the removal of a duplicate definition
filterRemovedNames :: [(Name,Entity)] -> Error -> Bool
filterRemovedNames list err = 
   case err of  
      Undefined entity name _ _ -> (name,entity) `notElem` list
      _                         -> True
      
filterDerivedNames :: [Range] -> Error -> Bool
filterDerivedNames ranges err = 
   case err of
      Duplicated Definition names -> any (`notElem` ranges) (map getNameRange names) 
      _                           -> True

uniqueKeys :: Ord key => [(key,a)] -> ([(key,a)],[[key]])
uniqueKeys = let comp (x,_) (y,_) = compare x y
                 eq   (x,_) (y,_) = x == y
                 predicate xs = length xs == 1 
             in (\(xs, ys) -> (map head xs, map (map fst) ys)) 
              . partition predicate 
              . groupBy eq 
              . sortBy comp
                  
type ScopeInfo = ( [Names]          -- duplicated variables
                 , [Name]           -- unused variables
                 , [(Name, Name)]   -- shadowed variables
                 )

changeOfScope :: Names -> Names -> Names -> (Names, Names, ScopeInfo)
changeOfScope names unboundNames namesInScope = 
   let (uniqueNames, duplicatedNames) = uniqueAppearance names
       unusedNames   = uniqueNames \\ unboundNames
       shadowedNames = let f n = [ (n, n') | n' <- namesInScope, n == n' ]
                       in concatMap f uniqueNames
   in ( uniqueNames ++ map head duplicatedNames ++ (namesInScope \\ names)
      , unboundNames \\ names
      , (duplicatedNames, unusedNames, shadowedNames)
      )
      
uniqueAppearance :: Ord a => [a] -> ([a],[[a]])
uniqueAppearance = foldr insert ([],[]) . group . sort
   where insert [x] (as,bs) = (x:as,bs)
         insert xs  (as,bs) = (as,xs:bs)

checkType :: M.Map Name Int -> Names -> Type -> [Error]
checkType typeConstructors namesInScope t =
    let (f, xs) = walkSpine t
        xsErrors = concatMap (checkType typeConstructors namesInScope) xs
    in
        xsErrors
        ++
        case f of
            Type_Constructor r c ->
                checkKind c typeConstructors (length xs) namesInScope
                ++ [ TupleTooBig r
 	                 | let nameAsString = show c
 	                 , isTupleConstructor nameAsString
 	                 , length nameAsString - 1 > 10
 	                 ]
            Type_Variable _ v ->
                if length xs /= 0 then
                    [ TypeVarApplication v ]
                else
                    []
            _ ->
                internalError "StaticAnalysis" "checkType" "unexpected type"

walkSpine :: Type -> (Type, [Type])
walkSpine t =
    case t of
        Type_Variable _ _ -> (t, [])
        Type_Constructor _ _ -> (t, [])
        Type_Application _ _ f xs ->
            let (t, ys) = walkSpine f
            in (t, ys ++ xs)
        Type_Parenthesized _ t -> walkSpine t
        Type_Qualified _ _ t -> walkSpine t
        _ -> internalError "StaticAnalysis" "walkSpine" "unexpected type"

checkKind :: Name -> M.Map Name Int -> Int -> Names -> [Error]
checkKind tycon@(Name_Special _ _ ('(':commas)) _ useArity namesInScope = -- !!!Name
    if expected == useArity then
        []
    else
        [ ArityMismatch TypeConstructor tycon expected useArity]
    where
        expected =
            case length (takeWhile (== ',') commas) of
                 0 -> 0  -- ()
                 n -> n + 1 -- (,) (,,) ...

checkKind tycon typeConstructors useArity namesInScope =
    case M.lookup tycon typeConstructors of
        Nothing ->
            let hint = [ "Constructor "++show (show tycon)++" cannot be used in a type"
                       | tycon `elem` namesInScope
                       ]
            in [ Undefined TypeConstructor tycon (M.keys typeConstructors) hint ]
        Just defArity ->
            if useArity /= defArity then
                [ ArityMismatch TypeConstructor tycon defArity useArity ]
            else
                [ ]

findSimilarFunctionBindings :: [(Name, TpScheme)] -> [(Name,Name)] -> [Warning]
findSimilarFunctionBindings environment candidates = 
   let namesWithTypeDef = map fst environment
   in [ uncurry SimilarFunctionBindings pair
      | (n1,n2) <- candidates
      , let bool1 = n1 `elem` namesWithTypeDef
            bool2 = n2 `elem` namesWithTypeDef
            pair  = if bool1 then (n2,n1) else (n1,n2)
      , bool1 `xor` bool2
      ]

xor :: Bool -> Bool -> Bool
xor b1 b2 = not (b1 == b2)

simplifyContext :: OrderedTypeSynonyms -> Range -> [(Int, Name)] -> TpScheme -> Warnings
simplifyContext synonyms range intMap typescheme = 
   let predicates = qualifiers (unquantify typescheme)
       reduced    = f predicates []
          where f [] as = reverse as -- reverse to original order
                f (p:ps) as 
                   | entail synonyms standardClasses (ps++as) p = f ps as
                   | otherwise = f ps (p:as)
       sub = listToSubstitution [ (i, TCon (show n)) | (i, n) <- intMap ]
   in if length reduced == length predicates 
        then []
        else [ ReduceContext range (sub |-> predicates) (sub |-> reduced) ]

mode :: Ord a => [a] -> Maybe a -- Just ... IF any of the elements is more common
mode xs = 
    case filter ((== maxFreq) . snd) fs of
        [(x, _)] -> Just x
        _ -> Nothing        
  where
    maxFreq = maximum (map snd fs)
    fs = frequencies xs

frequencies :: Ord a => [a] -> [(a, Int)]
frequencies = map (\ys -> (head ys, length ys)) . group . sort

patternConstructorErrors :: Maybe TpScheme -> Name -> Names -> Int -> Bool -> Names -> [Error]
patternConstructorErrors maybetparity name env useArity lhsPattern namesTyconEnv =
    case maybetparity of
        Nothing ->
            [ undefinedConstructorInPat lhsPattern name env namesTyconEnv ]
        Just tpScheme ->
            let arity = arityOfTpScheme tpScheme
            in if arity /= useArity
               then [ ArityMismatch Constructor name arity useArity ]
               else []

simplePattern :: Pattern -> Bool
simplePattern pattern =
   case pattern of
      Pattern_Constructor _ name _ -> case show name of 
                                         x:_ -> isUpper x
                                         _   -> False
      _                            -> False

-- Type signature but no function definition
-- Duplicated type signatures
-- Overloaded type scheme for a restricted pattern
checkTypeSignatures :: Names -> Names -> [(Name,TpScheme)] -> Errors
checkTypeSignatures declVarNames restrictedNames xs = 
   let (unique, doubles) = uniqueAppearance (map fst xs)
   in [ Duplicated TypeSignature names 
      | names <- doubles 
      ] 
   ++ [ NoFunDef TypeSignature name declVarNames
      | name <- unique
      , name `notElem` declVarNames
      ]
   ++ [ OverloadedRestrPat name
      | (name, scheme) <- xs
      , name `elem` unique 
      , name `elem` restrictedNames     
      , isOverloaded scheme
      ] 

isSimplePattern :: Pattern -> Bool
isSimplePattern pattern =
   case pattern of
      Pattern_Variable _ _ -> True
      Pattern_Parenthesized  _ p -> isSimplePattern p
      _ -> False

checkExport entity name inScope =
    makeUndefined entity
        (if name `elem` inScope then
            []
         else
            [name]
        )
        (nubBy equalName inScope)

equalName x y =
    getNameName x == getNameName y        

topLevelScopeInfo :: ScopeInfo -> ScopeInfo
topLevelScopeInfo (xs, _, _) = (xs, [], [])

makeErrors :: [(ScopeInfo, Entity)] -> Errors
makeErrors xs = [ Duplicated entity ys | ((yss, _, _), entity) <- xs, ys <- yss ]

makeWarnings :: [(ScopeInfo, Entity)] -> Warnings
makeWarnings xs =  [ Unused entity name | ((_, names, _), entity) <- xs, name <- names ]
                ++ [ Shadow n2 n1 | ((_, _, pairs), entity) <- xs, (n1, n2) <- pairs ]
-- Alternative -------------------------------------------------
-- semantic domain
type T_Alternative = (Names) ->
                     (Names) ->
                     (ClassEnvironment) ->
                     ([(ScopeInfo, Entity)]) ->
                     ([Error]) ->
                     ([Error]) ->
                     (Names) ->
                     ([Option]) ->
                     (OrderedTypeSynonyms) ->
                     (M.Map Name Int) ->
                     (M.Map Name TpScheme) ->
                     ([Warning]) ->
                     ( ([(Name, Instance)]),([(ScopeInfo, Entity)]),([Error]),([Error]),(Alternative),(Names),([Warning]))
-- cata
sem_Alternative :: (Alternative) ->
                   (T_Alternative)
sem_Alternative ((Alternative_Alternative (_range) (_pattern) (_righthandside))) =
    (sem_Alternative_Alternative ((sem_Range (_range))) ((sem_Pattern (_pattern))) ((sem_RightHandSide (_righthandside))))
sem_Alternative ((Alternative_Empty (_range))) =
    (sem_Alternative_Empty ((sem_Range (_range))))
sem_Alternative_Alternative :: (T_Range) ->
                               (T_Pattern) ->
                               (T_RightHandSide) ->
                               (T_Alternative)
sem_Alternative_Alternative (range_) (pattern_) (righthandside_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Alternative)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _patternIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _patternImiscerrors :: ([Error])
            _patternIpatVarNames :: (Names)
            _patternIself :: (Pattern)
            _patternIunboundNames :: (Names)
            _patternIwarnings :: ([Warning])
            _patternOallTypeConstructors :: (Names)
            _patternOallValueConstructors :: (Names)
            _patternOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _patternOlhsPattern :: (Bool)
            _patternOmiscerrors :: ([Error])
            _patternOnamesInScope :: (Names)
            _patternOtypeConstructors :: (M.Map Name Int)
            _patternOvalueConstructors :: (M.Map Name TpScheme)
            _patternOwarnings :: ([Warning])
            _righthandsideIcollectInstances :: ([(Name, Instance)])
            _righthandsideIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _righthandsideIkindErrors :: ([Error])
            _righthandsideImiscerrors :: ([Error])
            _righthandsideIself :: (RightHandSide)
            _righthandsideIunboundNames :: (Names)
            _righthandsideIwarnings :: ([Warning])
            _righthandsideOallTypeConstructors :: (Names)
            _righthandsideOallValueConstructors :: (Names)
            _righthandsideOclassEnvironment :: (ClassEnvironment)
            _righthandsideOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _righthandsideOkindErrors :: ([Error])
            _righthandsideOmiscerrors :: ([Error])
            _righthandsideOnamesInScope :: (Names)
            _righthandsideOoptions :: ([Option])
            _righthandsideOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _righthandsideOtypeConstructors :: (M.Map Name Int)
            _righthandsideOvalueConstructors :: (M.Map Name TpScheme)
            _righthandsideOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _patternIcollectScopeInfos,_patternImiscerrors,_patternIpatVarNames,_patternIself,_patternIunboundNames,_patternIwarnings) =
                (pattern_ (_patternOallTypeConstructors) (_patternOallValueConstructors) (_patternOcollectScopeInfos) (_patternOlhsPattern) (_patternOmiscerrors) (_patternOnamesInScope) (_patternOtypeConstructors) (_patternOvalueConstructors) (_patternOwarnings))
            ( _righthandsideIcollectInstances,_righthandsideIcollectScopeInfos,_righthandsideIkindErrors,_righthandsideImiscerrors,_righthandsideIself,_righthandsideIunboundNames,_righthandsideIwarnings) =
                (righthandside_ (_righthandsideOallTypeConstructors) (_righthandsideOallValueConstructors) (_righthandsideOclassEnvironment) (_righthandsideOcollectScopeInfos) (_righthandsideOkindErrors) (_righthandsideOmiscerrors) (_righthandsideOnamesInScope) (_righthandsideOoptions) (_righthandsideOorderedTypeSynonyms) (_righthandsideOtypeConstructors) (_righthandsideOvalueConstructors) (_righthandsideOwarnings))
            (_lhsOunboundNames@_) =
                _unboundNames
            ((_namesInScope@_,_unboundNames@_,_scopeInfo@_)) =
                changeOfScope _patternIpatVarNames _righthandsideIunboundNames _lhsInamesInScope
            (_patternOlhsPattern@_) =
                False
            (_lhsOcollectScopeInfos@_) =
                (_scopeInfo, Variable)   : _righthandsideIcollectScopeInfos
            (_lhsOcollectInstances@_) =
                _righthandsideIcollectInstances
            (_self@_) =
                Alternative_Alternative _rangeIself _patternIself _righthandsideIself
            (_lhsOself@_) =
                _self
            (_lhsOkindErrors@_) =
                _righthandsideIkindErrors
            (_lhsOmiscerrors@_) =
                _righthandsideImiscerrors
            (_lhsOwarnings@_) =
                _righthandsideIwarnings
            (_patternOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_patternOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_patternOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_patternOmiscerrors@_) =
                _lhsImiscerrors
            (_patternOnamesInScope@_) =
                _namesInScope
            (_patternOtypeConstructors@_) =
                _lhsItypeConstructors
            (_patternOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_patternOwarnings@_) =
                _lhsIwarnings
            (_righthandsideOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_righthandsideOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_righthandsideOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_righthandsideOcollectScopeInfos@_) =
                _patternIcollectScopeInfos
            (_righthandsideOkindErrors@_) =
                _lhsIkindErrors
            (_righthandsideOmiscerrors@_) =
                _patternImiscerrors
            (_righthandsideOnamesInScope@_) =
                _namesInScope
            (_righthandsideOoptions@_) =
                _lhsIoptions
            (_righthandsideOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_righthandsideOtypeConstructors@_) =
                _lhsItypeConstructors
            (_righthandsideOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_righthandsideOwarnings@_) =
                _patternIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Alternative_Empty :: (T_Range) ->
                         (T_Alternative)
sem_Alternative_Empty (range_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Alternative)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            ( _rangeIself) =
                (range_ )
            (_lhsOcollectInstances@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                Alternative_Empty _rangeIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _lhsIkindErrors
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
            (_lhsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
-- Alternatives ------------------------------------------------
-- semantic domain
type T_Alternatives = (Names) ->
                      (Names) ->
                      (ClassEnvironment) ->
                      ([(ScopeInfo, Entity)]) ->
                      ([Error]) ->
                      ([Error]) ->
                      (Names) ->
                      ([Option]) ->
                      (OrderedTypeSynonyms) ->
                      (M.Map Name Int) ->
                      (M.Map Name TpScheme) ->
                      ([Warning]) ->
                      ( ([(Name, Instance)]),([(ScopeInfo, Entity)]),([Error]),([Error]),(Alternatives),(Names),([Warning]))
-- cata
sem_Alternatives :: (Alternatives) ->
                    (T_Alternatives)
sem_Alternatives (list) =
    (Prelude.foldr (sem_Alternatives_Cons) (sem_Alternatives_Nil) ((Prelude.map sem_Alternative list)))
sem_Alternatives_Cons :: (T_Alternative) ->
                         (T_Alternatives) ->
                         (T_Alternatives)
sem_Alternatives_Cons (hd_) (tl_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Alternatives)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _hdIcollectInstances :: ([(Name, Instance)])
            _hdIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _hdIkindErrors :: ([Error])
            _hdImiscerrors :: ([Error])
            _hdIself :: (Alternative)
            _hdIunboundNames :: (Names)
            _hdIwarnings :: ([Warning])
            _hdOallTypeConstructors :: (Names)
            _hdOallValueConstructors :: (Names)
            _hdOclassEnvironment :: (ClassEnvironment)
            _hdOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _hdOkindErrors :: ([Error])
            _hdOmiscerrors :: ([Error])
            _hdOnamesInScope :: (Names)
            _hdOoptions :: ([Option])
            _hdOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _hdOtypeConstructors :: (M.Map Name Int)
            _hdOvalueConstructors :: (M.Map Name TpScheme)
            _hdOwarnings :: ([Warning])
            _tlIcollectInstances :: ([(Name, Instance)])
            _tlIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _tlIkindErrors :: ([Error])
            _tlImiscerrors :: ([Error])
            _tlIself :: (Alternatives)
            _tlIunboundNames :: (Names)
            _tlIwarnings :: ([Warning])
            _tlOallTypeConstructors :: (Names)
            _tlOallValueConstructors :: (Names)
            _tlOclassEnvironment :: (ClassEnvironment)
            _tlOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _tlOkindErrors :: ([Error])
            _tlOmiscerrors :: ([Error])
            _tlOnamesInScope :: (Names)
            _tlOoptions :: ([Option])
            _tlOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _tlOtypeConstructors :: (M.Map Name Int)
            _tlOvalueConstructors :: (M.Map Name TpScheme)
            _tlOwarnings :: ([Warning])
            ( _hdIcollectInstances,_hdIcollectScopeInfos,_hdIkindErrors,_hdImiscerrors,_hdIself,_hdIunboundNames,_hdIwarnings) =
                (hd_ (_hdOallTypeConstructors) (_hdOallValueConstructors) (_hdOclassEnvironment) (_hdOcollectScopeInfos) (_hdOkindErrors) (_hdOmiscerrors) (_hdOnamesInScope) (_hdOoptions) (_hdOorderedTypeSynonyms) (_hdOtypeConstructors) (_hdOvalueConstructors) (_hdOwarnings))
            ( _tlIcollectInstances,_tlIcollectScopeInfos,_tlIkindErrors,_tlImiscerrors,_tlIself,_tlIunboundNames,_tlIwarnings) =
                (tl_ (_tlOallTypeConstructors) (_tlOallValueConstructors) (_tlOclassEnvironment) (_tlOcollectScopeInfos) (_tlOkindErrors) (_tlOmiscerrors) (_tlOnamesInScope) (_tlOoptions) (_tlOorderedTypeSynonyms) (_tlOtypeConstructors) (_tlOvalueConstructors) (_tlOwarnings))
            (_lhsOcollectInstances@_) =
                _hdIcollectInstances  ++  _tlIcollectInstances
            (_lhsOunboundNames@_) =
                _hdIunboundNames ++ _tlIunboundNames
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _tlIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _tlIkindErrors
            (_lhsOmiscerrors@_) =
                _tlImiscerrors
            (_lhsOwarnings@_) =
                _tlIwarnings
            (_hdOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_hdOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_hdOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_hdOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_hdOkindErrors@_) =
                _lhsIkindErrors
            (_hdOmiscerrors@_) =
                _lhsImiscerrors
            (_hdOnamesInScope@_) =
                _lhsInamesInScope
            (_hdOoptions@_) =
                _lhsIoptions
            (_hdOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_hdOtypeConstructors@_) =
                _lhsItypeConstructors
            (_hdOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_hdOwarnings@_) =
                _lhsIwarnings
            (_tlOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_tlOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_tlOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_tlOcollectScopeInfos@_) =
                _hdIcollectScopeInfos
            (_tlOkindErrors@_) =
                _hdIkindErrors
            (_tlOmiscerrors@_) =
                _hdImiscerrors
            (_tlOnamesInScope@_) =
                _lhsInamesInScope
            (_tlOoptions@_) =
                _lhsIoptions
            (_tlOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_tlOtypeConstructors@_) =
                _lhsItypeConstructors
            (_tlOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_tlOwarnings@_) =
                _hdIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Alternatives_Nil :: (T_Alternatives)
sem_Alternatives_Nil  =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Alternatives)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            (_lhsOcollectInstances@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _lhsIkindErrors
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
            (_lhsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
-- AnnotatedType -----------------------------------------------
-- semantic domain
type T_AnnotatedType = (Names) ->
                       (Names) ->
                       ([Error]) ->
                       ([Error]) ->
                       (Names) ->
                       ([Option]) ->
                       (M.Map Name Int) ->
                       (M.Map Name TpScheme) ->
                       ([Warning]) ->
                       ( ([Error]),([Error]),(AnnotatedType),(Type),(Names),(Names),([Warning]))
-- cata
sem_AnnotatedType :: (AnnotatedType) ->
                     (T_AnnotatedType)
sem_AnnotatedType ((AnnotatedType_AnnotatedType (_range) (_strict) (_type))) =
    (sem_AnnotatedType_AnnotatedType ((sem_Range (_range))) (_strict) ((sem_Type (_type))))
sem_AnnotatedType_AnnotatedType :: (T_Range) ->
                                   (Bool) ->
                                   (T_Type) ->
                                   (T_AnnotatedType)
sem_AnnotatedType_AnnotatedType (range_) (strict_) (type_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (AnnotatedType)
            _lhsOtype :: (Type)
            _lhsOtypevariables :: (Names)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _typeIcontextRange :: (Range)
            _typeImiscerrors :: ([Error])
            _typeIself :: (Type)
            _typeItypevariables :: (Names)
            _typeIwarnings :: ([Warning])
            _typeOallTypeConstructors :: (Names)
            _typeOmiscerrors :: ([Error])
            _typeOoptions :: ([Option])
            _typeOtypeConstructors :: (M.Map Name Int)
            _typeOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _typeIcontextRange,_typeImiscerrors,_typeIself,_typeItypevariables,_typeIwarnings) =
                (type_ (_typeOallTypeConstructors) (_typeOmiscerrors) (_typeOoptions) (_typeOtypeConstructors) (_typeOwarnings))
            (_lhsOtype@_) =
                _typeIself
            (_newErrors@_) =
                checkType _lhsItypeConstructors (_lhsInamesInScope ++ _lhsIallValueConstructors) _typeIself
            (_lhsOkindErrors@_) =
                _newErrors ++ _lhsIkindErrors
            (_lhsOtypevariables@_) =
                _typeItypevariables
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                AnnotatedType_AnnotatedType _rangeIself strict_ _typeIself
            (_lhsOself@_) =
                _self
            (_lhsOmiscerrors@_) =
                _typeImiscerrors
            (_lhsOwarnings@_) =
                _typeIwarnings
            (_typeOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_typeOmiscerrors@_) =
                _lhsImiscerrors
            (_typeOoptions@_) =
                _lhsIoptions
            (_typeOtypeConstructors@_) =
                _lhsItypeConstructors
            (_typeOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOtype,_lhsOtypevariables,_lhsOunboundNames,_lhsOwarnings)
-- AnnotatedTypes ----------------------------------------------
-- semantic domain
type T_AnnotatedTypes = (Names) ->
                        (Names) ->
                        ([Error]) ->
                        ([Error]) ->
                        (Names) ->
                        ([Option]) ->
                        (M.Map Name Int) ->
                        (M.Map Name TpScheme) ->
                        ([Warning]) ->
                        ( ([Error]),([Error]),(AnnotatedTypes),(Types),(Names),(Names),([Warning]))
-- cata
sem_AnnotatedTypes :: (AnnotatedTypes) ->
                      (T_AnnotatedTypes)
sem_AnnotatedTypes (list) =
    (Prelude.foldr (sem_AnnotatedTypes_Cons) (sem_AnnotatedTypes_Nil) ((Prelude.map sem_AnnotatedType list)))
sem_AnnotatedTypes_Cons :: (T_AnnotatedType) ->
                           (T_AnnotatedTypes) ->
                           (T_AnnotatedTypes)
sem_AnnotatedTypes_Cons (hd_) (tl_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (AnnotatedTypes)
            _lhsOtypes :: (Types)
            _lhsOtypevariables :: (Names)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _hdIkindErrors :: ([Error])
            _hdImiscerrors :: ([Error])
            _hdIself :: (AnnotatedType)
            _hdItype :: (Type)
            _hdItypevariables :: (Names)
            _hdIunboundNames :: (Names)
            _hdIwarnings :: ([Warning])
            _hdOallTypeConstructors :: (Names)
            _hdOallValueConstructors :: (Names)
            _hdOkindErrors :: ([Error])
            _hdOmiscerrors :: ([Error])
            _hdOnamesInScope :: (Names)
            _hdOoptions :: ([Option])
            _hdOtypeConstructors :: (M.Map Name Int)
            _hdOvalueConstructors :: (M.Map Name TpScheme)
            _hdOwarnings :: ([Warning])
            _tlIkindErrors :: ([Error])
            _tlImiscerrors :: ([Error])
            _tlIself :: (AnnotatedTypes)
            _tlItypes :: (Types)
            _tlItypevariables :: (Names)
            _tlIunboundNames :: (Names)
            _tlIwarnings :: ([Warning])
            _tlOallTypeConstructors :: (Names)
            _tlOallValueConstructors :: (Names)
            _tlOkindErrors :: ([Error])
            _tlOmiscerrors :: ([Error])
            _tlOnamesInScope :: (Names)
            _tlOoptions :: ([Option])
            _tlOtypeConstructors :: (M.Map Name Int)
            _tlOvalueConstructors :: (M.Map Name TpScheme)
            _tlOwarnings :: ([Warning])
            ( _hdIkindErrors,_hdImiscerrors,_hdIself,_hdItype,_hdItypevariables,_hdIunboundNames,_hdIwarnings) =
                (hd_ (_hdOallTypeConstructors) (_hdOallValueConstructors) (_hdOkindErrors) (_hdOmiscerrors) (_hdOnamesInScope) (_hdOoptions) (_hdOtypeConstructors) (_hdOvalueConstructors) (_hdOwarnings))
            ( _tlIkindErrors,_tlImiscerrors,_tlIself,_tlItypes,_tlItypevariables,_tlIunboundNames,_tlIwarnings) =
                (tl_ (_tlOallTypeConstructors) (_tlOallValueConstructors) (_tlOkindErrors) (_tlOmiscerrors) (_tlOnamesInScope) (_tlOoptions) (_tlOtypeConstructors) (_tlOvalueConstructors) (_tlOwarnings))
            (_lhsOtypes@_) =
                _hdItype : _tlItypes
            (_lhsOtypevariables@_) =
                _hdItypevariables  ++  _tlItypevariables
            (_lhsOunboundNames@_) =
                _hdIunboundNames ++ _tlIunboundNames
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsOkindErrors@_) =
                _tlIkindErrors
            (_lhsOmiscerrors@_) =
                _tlImiscerrors
            (_lhsOwarnings@_) =
                _tlIwarnings
            (_hdOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_hdOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_hdOkindErrors@_) =
                _lhsIkindErrors
            (_hdOmiscerrors@_) =
                _lhsImiscerrors
            (_hdOnamesInScope@_) =
                _lhsInamesInScope
            (_hdOoptions@_) =
                _lhsIoptions
            (_hdOtypeConstructors@_) =
                _lhsItypeConstructors
            (_hdOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_hdOwarnings@_) =
                _lhsIwarnings
            (_tlOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_tlOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_tlOkindErrors@_) =
                _hdIkindErrors
            (_tlOmiscerrors@_) =
                _hdImiscerrors
            (_tlOnamesInScope@_) =
                _lhsInamesInScope
            (_tlOoptions@_) =
                _lhsIoptions
            (_tlOtypeConstructors@_) =
                _lhsItypeConstructors
            (_tlOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_tlOwarnings@_) =
                _hdIwarnings
        in  ( _lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOtypes,_lhsOtypevariables,_lhsOunboundNames,_lhsOwarnings)
sem_AnnotatedTypes_Nil :: (T_AnnotatedTypes)
sem_AnnotatedTypes_Nil  =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (AnnotatedTypes)
            _lhsOtypes :: (Types)
            _lhsOtypevariables :: (Names)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            (_lhsOtypes@_) =
                []
            (_lhsOtypevariables@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsOkindErrors@_) =
                _lhsIkindErrors
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
            (_lhsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOtypes,_lhsOtypevariables,_lhsOunboundNames,_lhsOwarnings)
-- Body --------------------------------------------------------
-- semantic domain
type T_Body = (Names) ->
              (Names) ->
              (ClassEnvironment) ->
              ([(ScopeInfo, Entity)]) ->
              ([(Name,Int)]) ->
              ([(Name,(Int,Tps -> Tp))]) ->
              ([(Name,TpScheme)]) ->
              ([Error]) ->
              ([Error]) ->
              (Names) ->
              ([(Name,(Int,Assoc))]) ->
              ([Option]) ->
              (OrderedTypeSynonyms) ->
              (M.Map Name Int) ->
              (M.Map Name TpScheme) ->
              ([Warning]) ->
              ( ([(Name, Instance)]),([(ScopeInfo, Entity)]),([(Name,Int)]),([(Name,(Int,Tps -> Tp))]),([(Name,TpScheme)]),(Names),(Names),([Error]),([Error]),([(Name,(Int,Assoc))]),(Body),([(Name,TpScheme)]),(Names),([Warning]))
-- cata
sem_Body :: (Body) ->
            (T_Body)
sem_Body ((Body_Body (_range) (_importdeclarations) (_declarations))) =
    (sem_Body_Body ((sem_Range (_range))) ((sem_ImportDeclarations (_importdeclarations))) ((sem_Declarations (_declarations))))
sem_Body_Body :: (T_Range) ->
                 (T_ImportDeclarations) ->
                 (T_Declarations) ->
                 (T_Body)
sem_Body_Body (range_) (importdeclarations_) (declarations_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIcollectTypeConstructors
      _lhsIcollectTypeSynonyms
      _lhsIcollectValueConstructors
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoperatorFixities
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOcollectTypeConstructors :: ([(Name,Int)])
            _lhsOcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _lhsOcollectValueConstructors :: ([(Name,TpScheme)])
            _lhsOdeclVarNames :: (Names)
            _lhsOimportedModules :: (Names)
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOoperatorFixities :: ([(Name,(Int,Assoc))])
            _lhsOself :: (Body)
            _lhsOtypeSignatures :: ([(Name,TpScheme)])
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _importdeclarationsIimportedModules :: (Names)
            _importdeclarationsIself :: (ImportDeclarations)
            _importdeclarationsOimportedModules :: (Names)
            _declarationsIcollectInstances :: ([(Name, Instance)])
            _declarationsIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _declarationsIcollectTypeConstructors :: ([(Name,Int)])
            _declarationsIcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _declarationsIcollectValueConstructors :: ([(Name,TpScheme)])
            _declarationsIdeclVarNames :: (Names)
            _declarationsIkindErrors :: ([Error])
            _declarationsImiscerrors :: ([Error])
            _declarationsIoperatorFixities :: ([(Name,(Int,Assoc))])
            _declarationsIpreviousWasAlsoFB :: (Maybe Name)
            _declarationsIrestrictedNames :: (Names)
            _declarationsIself :: (Declarations)
            _declarationsIsuspiciousFBs :: ([(Name,Name)])
            _declarationsItypeSignatures :: ([(Name,TpScheme)])
            _declarationsIunboundNames :: (Names)
            _declarationsIwarnings :: ([Warning])
            _declarationsOallTypeConstructors :: (Names)
            _declarationsOallValueConstructors :: (Names)
            _declarationsOclassEnvironment :: (ClassEnvironment)
            _declarationsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _declarationsOcollectTypeConstructors :: ([(Name,Int)])
            _declarationsOcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _declarationsOcollectValueConstructors :: ([(Name,TpScheme)])
            _declarationsOkindErrors :: ([Error])
            _declarationsOmiscerrors :: ([Error])
            _declarationsOnamesInScope :: (Names)
            _declarationsOoperatorFixities :: ([(Name,(Int,Assoc))])
            _declarationsOoptions :: ([Option])
            _declarationsOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _declarationsOpreviousWasAlsoFB :: (Maybe Name)
            _declarationsOsuspiciousFBs :: ([(Name,Name)])
            _declarationsOtypeConstructors :: (M.Map Name Int)
            _declarationsOtypeSignatures :: ([(Name,TpScheme)])
            _declarationsOvalueConstructors :: (M.Map Name TpScheme)
            _declarationsOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _importdeclarationsIimportedModules,_importdeclarationsIself) =
                (importdeclarations_ (_importdeclarationsOimportedModules))
            ( _declarationsIcollectInstances
             ,_declarationsIcollectScopeInfos
             ,_declarationsIcollectTypeConstructors
             ,_declarationsIcollectTypeSynonyms
             ,_declarationsIcollectValueConstructors
             ,_declarationsIdeclVarNames
             ,_declarationsIkindErrors
             ,_declarationsImiscerrors
             ,_declarationsIoperatorFixities
             ,_declarationsIpreviousWasAlsoFB
             ,_declarationsIrestrictedNames
             ,_declarationsIself
             ,_declarationsIsuspiciousFBs
             ,_declarationsItypeSignatures
             ,_declarationsIunboundNames
             ,_declarationsIwarnings
             ) =
                (declarations_ (_declarationsOallTypeConstructors)
                               (_declarationsOallValueConstructors)
                               (_declarationsOclassEnvironment)
                               (_declarationsOcollectScopeInfos)
                               (_declarationsOcollectTypeConstructors)
                               (_declarationsOcollectTypeSynonyms)
                               (_declarationsOcollectValueConstructors)
                               (_declarationsOkindErrors)
                               (_declarationsOmiscerrors)
                               (_declarationsOnamesInScope)
                               (_declarationsOoperatorFixities)
                               (_declarationsOoptions)
                               (_declarationsOorderedTypeSynonyms)
                               (_declarationsOpreviousWasAlsoFB)
                               (_declarationsOsuspiciousFBs)
                               (_declarationsOtypeConstructors)
                               (_declarationsOtypeSignatures)
                               (_declarationsOvalueConstructors)
                               (_declarationsOwarnings))
            (_declarationsOtypeSignatures@_) =
                []
            (_lhsOwarnings@_) =
                _declarationsIwarnings ++
                _suspiciousErrors
            (_suspiciousErrors@_) =
                findSimilarFunctionBindings _declarationsItypeSignatures _declarationsIsuspiciousFBs
            (_declarationsOsuspiciousFBs@_) =
                []
            (_declarationsOpreviousWasAlsoFB@_) =
                Nothing
            (_typeSignatureErrors@_) =
                checkTypeSignatures _declarationsIdeclVarNames _declarationsIrestrictedNames _declarationsItypeSignatures
            (_lhsOmiscerrors@_) =
                _typeSignatureErrors ++ _declarationsImiscerrors
            (_importdeclarationsOimportedModules@_) =
                []
            (_lhsOcollectInstances@_) =
                _declarationsIcollectInstances
            (_lhsOdeclVarNames@_) =
                _declarationsIdeclVarNames
            (_lhsOunboundNames@_) =
                _declarationsIunboundNames
            (_self@_) =
                Body_Body _rangeIself _importdeclarationsIself _declarationsIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _declarationsIcollectScopeInfos
            (_lhsOcollectTypeConstructors@_) =
                _declarationsIcollectTypeConstructors
            (_lhsOcollectTypeSynonyms@_) =
                _declarationsIcollectTypeSynonyms
            (_lhsOcollectValueConstructors@_) =
                _declarationsIcollectValueConstructors
            (_lhsOimportedModules@_) =
                _importdeclarationsIimportedModules
            (_lhsOkindErrors@_) =
                _declarationsIkindErrors
            (_lhsOoperatorFixities@_) =
                _declarationsIoperatorFixities
            (_lhsOtypeSignatures@_) =
                _declarationsItypeSignatures
            (_declarationsOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_declarationsOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_declarationsOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_declarationsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_declarationsOcollectTypeConstructors@_) =
                _lhsIcollectTypeConstructors
            (_declarationsOcollectTypeSynonyms@_) =
                _lhsIcollectTypeSynonyms
            (_declarationsOcollectValueConstructors@_) =
                _lhsIcollectValueConstructors
            (_declarationsOkindErrors@_) =
                _lhsIkindErrors
            (_declarationsOmiscerrors@_) =
                _lhsImiscerrors
            (_declarationsOnamesInScope@_) =
                _lhsInamesInScope
            (_declarationsOoperatorFixities@_) =
                _lhsIoperatorFixities
            (_declarationsOoptions@_) =
                _lhsIoptions
            (_declarationsOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_declarationsOtypeConstructors@_) =
                _lhsItypeConstructors
            (_declarationsOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_declarationsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOcollectTypeConstructors,_lhsOcollectTypeSynonyms,_lhsOcollectValueConstructors,_lhsOdeclVarNames,_lhsOimportedModules,_lhsOkindErrors,_lhsOmiscerrors,_lhsOoperatorFixities,_lhsOself,_lhsOtypeSignatures,_lhsOunboundNames,_lhsOwarnings)
-- Constructor -------------------------------------------------
-- semantic domain
type T_Constructor = (Names) ->
                     (Names) ->
                     ([(Name,TpScheme)]) ->
                     ([Error]) ->
                     ([Error]) ->
                     (Names) ->
                     ([Option]) ->
                     (SimpleType) ->
                     (M.Map Name Int) ->
                     (M.Map Name TpScheme) ->
                     ([Warning]) ->
                     ( ([(Name,TpScheme)]),([Error]),([Error]),(Tps),(Constructor),(Names),(Names),([Warning]))
-- cata
sem_Constructor :: (Constructor) ->
                   (T_Constructor)
sem_Constructor ((Constructor_Constructor (_range) (_constructor) (_types))) =
    (sem_Constructor_Constructor ((sem_Range (_range))) ((sem_Name (_constructor))) ((sem_AnnotatedTypes (_types))))
sem_Constructor ((Constructor_Infix (_range) (_leftType) (_constructorOperator) (_rightType))) =
    (sem_Constructor_Infix ((sem_Range (_range))) ((sem_AnnotatedType (_leftType))) ((sem_Name (_constructorOperator))) ((sem_AnnotatedType (_rightType))))
sem_Constructor ((Constructor_Record (_range) (_constructor) (_fieldDeclarations))) =
    (sem_Constructor_Record ((sem_Range (_range))) ((sem_Name (_constructor))) ((sem_FieldDeclarations (_fieldDeclarations))))
sem_Constructor_Constructor :: (T_Range) ->
                               (T_Name) ->
                               (T_AnnotatedTypes) ->
                               (T_Constructor)
sem_Constructor_Constructor (range_) (constructor_) (types_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIcollectValueConstructors
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIsimpletype
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectValueConstructors :: ([(Name,TpScheme)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOparameterTypes :: (Tps)
            _lhsOself :: (Constructor)
            _lhsOtypevariables :: (Names)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _constructorIself :: (Name)
            _typesIkindErrors :: ([Error])
            _typesImiscerrors :: ([Error])
            _typesIself :: (AnnotatedTypes)
            _typesItypes :: (Types)
            _typesItypevariables :: (Names)
            _typesIunboundNames :: (Names)
            _typesIwarnings :: ([Warning])
            _typesOallTypeConstructors :: (Names)
            _typesOallValueConstructors :: (Names)
            _typesOkindErrors :: ([Error])
            _typesOmiscerrors :: ([Error])
            _typesOnamesInScope :: (Names)
            _typesOoptions :: ([Option])
            _typesOtypeConstructors :: (M.Map Name Int)
            _typesOvalueConstructors :: (M.Map Name TpScheme)
            _typesOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _constructorIself) =
                (constructor_ )
            ( _typesIkindErrors,_typesImiscerrors,_typesIself,_typesItypes,_typesItypevariables,_typesIunboundNames,_typesIwarnings) =
                (types_ (_typesOallTypeConstructors) (_typesOallValueConstructors) (_typesOkindErrors) (_typesOmiscerrors) (_typesOnamesInScope) (_typesOoptions) (_typesOtypeConstructors) (_typesOvalueConstructors) (_typesOwarnings))
            ((_tp@_,_tps@_)) =
                convertFromSimpleTypeAndTypes _lhsIsimpletype _typesItypes
            (_typeScheme@_) =
                generalizeAll ([] .=>. foldr (.->.) _tp _tps)
            (_lhsOparameterTypes@_) =
                _tps
            (_lhsOcollectValueConstructors@_) =
                (_constructorIself, _typeScheme) : _lhsIcollectValueConstructors
            (_lhsOtypevariables@_) =
                _typesItypevariables
            (_lhsOunboundNames@_) =
                _typesIunboundNames
            (_self@_) =
                Constructor_Constructor _rangeIself _constructorIself _typesIself
            (_lhsOself@_) =
                _self
            (_lhsOkindErrors@_) =
                _typesIkindErrors
            (_lhsOmiscerrors@_) =
                _typesImiscerrors
            (_lhsOwarnings@_) =
                _typesIwarnings
            (_typesOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_typesOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_typesOkindErrors@_) =
                _lhsIkindErrors
            (_typesOmiscerrors@_) =
                _lhsImiscerrors
            (_typesOnamesInScope@_) =
                _lhsInamesInScope
            (_typesOoptions@_) =
                _lhsIoptions
            (_typesOtypeConstructors@_) =
                _lhsItypeConstructors
            (_typesOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_typesOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectValueConstructors,_lhsOkindErrors,_lhsOmiscerrors,_lhsOparameterTypes,_lhsOself,_lhsOtypevariables,_lhsOunboundNames,_lhsOwarnings)
sem_Constructor_Infix :: (T_Range) ->
                         (T_AnnotatedType) ->
                         (T_Name) ->
                         (T_AnnotatedType) ->
                         (T_Constructor)
sem_Constructor_Infix (range_) (leftType_) (constructorOperator_) (rightType_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIcollectValueConstructors
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIsimpletype
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectValueConstructors :: ([(Name,TpScheme)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOparameterTypes :: (Tps)
            _lhsOself :: (Constructor)
            _lhsOtypevariables :: (Names)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _leftTypeIkindErrors :: ([Error])
            _leftTypeImiscerrors :: ([Error])
            _leftTypeIself :: (AnnotatedType)
            _leftTypeItype :: (Type)
            _leftTypeItypevariables :: (Names)
            _leftTypeIunboundNames :: (Names)
            _leftTypeIwarnings :: ([Warning])
            _leftTypeOallTypeConstructors :: (Names)
            _leftTypeOallValueConstructors :: (Names)
            _leftTypeOkindErrors :: ([Error])
            _leftTypeOmiscerrors :: ([Error])
            _leftTypeOnamesInScope :: (Names)
            _leftTypeOoptions :: ([Option])
            _leftTypeOtypeConstructors :: (M.Map Name Int)
            _leftTypeOvalueConstructors :: (M.Map Name TpScheme)
            _leftTypeOwarnings :: ([Warning])
            _constructorOperatorIself :: (Name)
            _rightTypeIkindErrors :: ([Error])
            _rightTypeImiscerrors :: ([Error])
            _rightTypeIself :: (AnnotatedType)
            _rightTypeItype :: (Type)
            _rightTypeItypevariables :: (Names)
            _rightTypeIunboundNames :: (Names)
            _rightTypeIwarnings :: ([Warning])
            _rightTypeOallTypeConstructors :: (Names)
            _rightTypeOallValueConstructors :: (Names)
            _rightTypeOkindErrors :: ([Error])
            _rightTypeOmiscerrors :: ([Error])
            _rightTypeOnamesInScope :: (Names)
            _rightTypeOoptions :: ([Option])
            _rightTypeOtypeConstructors :: (M.Map Name Int)
            _rightTypeOvalueConstructors :: (M.Map Name TpScheme)
            _rightTypeOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _leftTypeIkindErrors,_leftTypeImiscerrors,_leftTypeIself,_leftTypeItype,_leftTypeItypevariables,_leftTypeIunboundNames,_leftTypeIwarnings) =
                (leftType_ (_leftTypeOallTypeConstructors) (_leftTypeOallValueConstructors) (_leftTypeOkindErrors) (_leftTypeOmiscerrors) (_leftTypeOnamesInScope) (_leftTypeOoptions) (_leftTypeOtypeConstructors) (_leftTypeOvalueConstructors) (_leftTypeOwarnings))
            ( _constructorOperatorIself) =
                (constructorOperator_ )
            ( _rightTypeIkindErrors,_rightTypeImiscerrors,_rightTypeIself,_rightTypeItype,_rightTypeItypevariables,_rightTypeIunboundNames,_rightTypeIwarnings) =
                (rightType_ (_rightTypeOallTypeConstructors) (_rightTypeOallValueConstructors) (_rightTypeOkindErrors) (_rightTypeOmiscerrors) (_rightTypeOnamesInScope) (_rightTypeOoptions) (_rightTypeOtypeConstructors) (_rightTypeOvalueConstructors) (_rightTypeOwarnings))
            ((_tp@_,_tps@_)) =
                convertFromSimpleTypeAndTypes _lhsIsimpletype [_leftTypeItype,_rightTypeItype]
            (_typeScheme@_) =
                generalizeAll ([] .=>. foldr (.->.) _tp _tps)
            (_lhsOparameterTypes@_) =
                _tps
            (_lhsOcollectValueConstructors@_) =
                (_constructorOperatorIself, _typeScheme) : _lhsIcollectValueConstructors
            (_lhsOtypevariables@_) =
                _leftTypeItypevariables  ++  _rightTypeItypevariables
            (_lhsOunboundNames@_) =
                _leftTypeIunboundNames ++ _rightTypeIunboundNames
            (_self@_) =
                Constructor_Infix _rangeIself _leftTypeIself _constructorOperatorIself _rightTypeIself
            (_lhsOself@_) =
                _self
            (_lhsOkindErrors@_) =
                _rightTypeIkindErrors
            (_lhsOmiscerrors@_) =
                _rightTypeImiscerrors
            (_lhsOwarnings@_) =
                _rightTypeIwarnings
            (_leftTypeOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_leftTypeOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_leftTypeOkindErrors@_) =
                _lhsIkindErrors
            (_leftTypeOmiscerrors@_) =
                _lhsImiscerrors
            (_leftTypeOnamesInScope@_) =
                _lhsInamesInScope
            (_leftTypeOoptions@_) =
                _lhsIoptions
            (_leftTypeOtypeConstructors@_) =
                _lhsItypeConstructors
            (_leftTypeOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_leftTypeOwarnings@_) =
                _lhsIwarnings
            (_rightTypeOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_rightTypeOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_rightTypeOkindErrors@_) =
                _leftTypeIkindErrors
            (_rightTypeOmiscerrors@_) =
                _leftTypeImiscerrors
            (_rightTypeOnamesInScope@_) =
                _lhsInamesInScope
            (_rightTypeOoptions@_) =
                _lhsIoptions
            (_rightTypeOtypeConstructors@_) =
                _lhsItypeConstructors
            (_rightTypeOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_rightTypeOwarnings@_) =
                _leftTypeIwarnings
        in  ( _lhsOcollectValueConstructors,_lhsOkindErrors,_lhsOmiscerrors,_lhsOparameterTypes,_lhsOself,_lhsOtypevariables,_lhsOunboundNames,_lhsOwarnings)
sem_Constructor_Record :: (T_Range) ->
                          (T_Name) ->
                          (T_FieldDeclarations) ->
                          (T_Constructor)
sem_Constructor_Record (range_) (constructor_) (fieldDeclarations_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIcollectValueConstructors
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIsimpletype
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectValueConstructors :: ([(Name,TpScheme)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOparameterTypes :: (Tps)
            _lhsOself :: (Constructor)
            _lhsOtypevariables :: (Names)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _constructorIself :: (Name)
            _fieldDeclarationsImiscerrors :: ([Error])
            _fieldDeclarationsIself :: (FieldDeclarations)
            _fieldDeclarationsIunboundNames :: (Names)
            _fieldDeclarationsOmiscerrors :: ([Error])
            _fieldDeclarationsOnamesInScope :: (Names)
            _fieldDeclarationsOoptions :: ([Option])
            ( _rangeIself) =
                (range_ )
            ( _constructorIself) =
                (constructor_ )
            ( _fieldDeclarationsImiscerrors,_fieldDeclarationsIself,_fieldDeclarationsIunboundNames) =
                (fieldDeclarations_ (_fieldDeclarationsOmiscerrors) (_fieldDeclarationsOnamesInScope) (_fieldDeclarationsOoptions))
            (_lhsOparameterTypes@_) =
                []
            (_lhsOtypevariables@_) =
                []
            (_lhsOunboundNames@_) =
                _fieldDeclarationsIunboundNames
            (_self@_) =
                Constructor_Record _rangeIself _constructorIself _fieldDeclarationsIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectValueConstructors@_) =
                _lhsIcollectValueConstructors
            (_lhsOkindErrors@_) =
                _lhsIkindErrors
            (_lhsOmiscerrors@_) =
                _fieldDeclarationsImiscerrors
            (_lhsOwarnings@_) =
                _lhsIwarnings
            (_fieldDeclarationsOmiscerrors@_) =
                _lhsImiscerrors
            (_fieldDeclarationsOnamesInScope@_) =
                _lhsInamesInScope
            (_fieldDeclarationsOoptions@_) =
                _lhsIoptions
        in  ( _lhsOcollectValueConstructors,_lhsOkindErrors,_lhsOmiscerrors,_lhsOparameterTypes,_lhsOself,_lhsOtypevariables,_lhsOunboundNames,_lhsOwarnings)
-- Constructors ------------------------------------------------
-- semantic domain
type T_Constructors = (Names) ->
                      (Names) ->
                      ([(Name,TpScheme)]) ->
                      ([Error]) ->
                      ([Error]) ->
                      (Names) ->
                      ([Option]) ->
                      (SimpleType) ->
                      (M.Map Name Int) ->
                      (M.Map Name TpScheme) ->
                      ([Warning]) ->
                      ( ([(Name,TpScheme)]),([Error]),([Error]),(Tps),(Constructors),(Names),(Names),([Warning]))
-- cata
sem_Constructors :: (Constructors) ->
                    (T_Constructors)
sem_Constructors (list) =
    (Prelude.foldr (sem_Constructors_Cons) (sem_Constructors_Nil) ((Prelude.map sem_Constructor list)))
sem_Constructors_Cons :: (T_Constructor) ->
                         (T_Constructors) ->
                         (T_Constructors)
sem_Constructors_Cons (hd_) (tl_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIcollectValueConstructors
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIsimpletype
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectValueConstructors :: ([(Name,TpScheme)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOparameterTypes :: (Tps)
            _lhsOself :: (Constructors)
            _lhsOtypevariables :: (Names)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _hdIcollectValueConstructors :: ([(Name,TpScheme)])
            _hdIkindErrors :: ([Error])
            _hdImiscerrors :: ([Error])
            _hdIparameterTypes :: (Tps)
            _hdIself :: (Constructor)
            _hdItypevariables :: (Names)
            _hdIunboundNames :: (Names)
            _hdIwarnings :: ([Warning])
            _hdOallTypeConstructors :: (Names)
            _hdOallValueConstructors :: (Names)
            _hdOcollectValueConstructors :: ([(Name,TpScheme)])
            _hdOkindErrors :: ([Error])
            _hdOmiscerrors :: ([Error])
            _hdOnamesInScope :: (Names)
            _hdOoptions :: ([Option])
            _hdOsimpletype :: (SimpleType)
            _hdOtypeConstructors :: (M.Map Name Int)
            _hdOvalueConstructors :: (M.Map Name TpScheme)
            _hdOwarnings :: ([Warning])
            _tlIcollectValueConstructors :: ([(Name,TpScheme)])
            _tlIkindErrors :: ([Error])
            _tlImiscerrors :: ([Error])
            _tlIparameterTypes :: (Tps)
            _tlIself :: (Constructors)
            _tlItypevariables :: (Names)
            _tlIunboundNames :: (Names)
            _tlIwarnings :: ([Warning])
            _tlOallTypeConstructors :: (Names)
            _tlOallValueConstructors :: (Names)
            _tlOcollectValueConstructors :: ([(Name,TpScheme)])
            _tlOkindErrors :: ([Error])
            _tlOmiscerrors :: ([Error])
            _tlOnamesInScope :: (Names)
            _tlOoptions :: ([Option])
            _tlOsimpletype :: (SimpleType)
            _tlOtypeConstructors :: (M.Map Name Int)
            _tlOvalueConstructors :: (M.Map Name TpScheme)
            _tlOwarnings :: ([Warning])
            ( _hdIcollectValueConstructors,_hdIkindErrors,_hdImiscerrors,_hdIparameterTypes,_hdIself,_hdItypevariables,_hdIunboundNames,_hdIwarnings) =
                (hd_ (_hdOallTypeConstructors) (_hdOallValueConstructors) (_hdOcollectValueConstructors) (_hdOkindErrors) (_hdOmiscerrors) (_hdOnamesInScope) (_hdOoptions) (_hdOsimpletype) (_hdOtypeConstructors) (_hdOvalueConstructors) (_hdOwarnings))
            ( _tlIcollectValueConstructors,_tlIkindErrors,_tlImiscerrors,_tlIparameterTypes,_tlIself,_tlItypevariables,_tlIunboundNames,_tlIwarnings) =
                (tl_ (_tlOallTypeConstructors) (_tlOallValueConstructors) (_tlOcollectValueConstructors) (_tlOkindErrors) (_tlOmiscerrors) (_tlOnamesInScope) (_tlOoptions) (_tlOsimpletype) (_tlOtypeConstructors) (_tlOvalueConstructors) (_tlOwarnings))
            (_lhsOparameterTypes@_) =
                _hdIparameterTypes  ++  _tlIparameterTypes
            (_lhsOtypevariables@_) =
                _hdItypevariables  ++  _tlItypevariables
            (_lhsOunboundNames@_) =
                _hdIunboundNames ++ _tlIunboundNames
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectValueConstructors@_) =
                _tlIcollectValueConstructors
            (_lhsOkindErrors@_) =
                _tlIkindErrors
            (_lhsOmiscerrors@_) =
                _tlImiscerrors
            (_lhsOwarnings@_) =
                _tlIwarnings
            (_hdOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_hdOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_hdOcollectValueConstructors@_) =
                _lhsIcollectValueConstructors
            (_hdOkindErrors@_) =
                _lhsIkindErrors
            (_hdOmiscerrors@_) =
                _lhsImiscerrors
            (_hdOnamesInScope@_) =
                _lhsInamesInScope
            (_hdOoptions@_) =
                _lhsIoptions
            (_hdOsimpletype@_) =
                _lhsIsimpletype
            (_hdOtypeConstructors@_) =
                _lhsItypeConstructors
            (_hdOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_hdOwarnings@_) =
                _lhsIwarnings
            (_tlOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_tlOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_tlOcollectValueConstructors@_) =
                _hdIcollectValueConstructors
            (_tlOkindErrors@_) =
                _hdIkindErrors
            (_tlOmiscerrors@_) =
                _hdImiscerrors
            (_tlOnamesInScope@_) =
                _lhsInamesInScope
            (_tlOoptions@_) =
                _lhsIoptions
            (_tlOsimpletype@_) =
                _lhsIsimpletype
            (_tlOtypeConstructors@_) =
                _lhsItypeConstructors
            (_tlOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_tlOwarnings@_) =
                _hdIwarnings
        in  ( _lhsOcollectValueConstructors,_lhsOkindErrors,_lhsOmiscerrors,_lhsOparameterTypes,_lhsOself,_lhsOtypevariables,_lhsOunboundNames,_lhsOwarnings)
sem_Constructors_Nil :: (T_Constructors)
sem_Constructors_Nil  =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIcollectValueConstructors
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIsimpletype
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectValueConstructors :: ([(Name,TpScheme)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOparameterTypes :: (Tps)
            _lhsOself :: (Constructors)
            _lhsOtypevariables :: (Names)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            (_lhsOparameterTypes@_) =
                []
            (_lhsOtypevariables@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsOcollectValueConstructors@_) =
                _lhsIcollectValueConstructors
            (_lhsOkindErrors@_) =
                _lhsIkindErrors
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
            (_lhsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectValueConstructors,_lhsOkindErrors,_lhsOmiscerrors,_lhsOparameterTypes,_lhsOself,_lhsOtypevariables,_lhsOunboundNames,_lhsOwarnings)
-- ContextItem -------------------------------------------------
-- semantic domain
type T_ContextItem = (Names) ->
                     ([Error]) ->
                     ([Option]) ->
                     (M.Map Name Int) ->
                     ([Warning]) ->
                     ( ([Range]),([Name]),([Error]),(ContextItem),([Warning]))
-- cata
sem_ContextItem :: (ContextItem) ->
                   (T_ContextItem)
sem_ContextItem ((ContextItem_ContextItem (_range) (_name) (_types))) =
    (sem_ContextItem_ContextItem ((sem_Range (_range))) ((sem_Name (_name))) ((sem_Types (_types))))
sem_ContextItem_ContextItem :: (T_Range) ->
                               (T_Name) ->
                               (T_Types) ->
                               (T_ContextItem)
sem_ContextItem_ContextItem (range_) (name_) (types_) =
    \ _lhsIallTypeConstructors
      _lhsImiscerrors
      _lhsIoptions
      _lhsItypeConstructors
      _lhsIwarnings ->
        let _lhsOcontextRanges :: ([Range])
            _lhsOcontextVars :: ([Name])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (ContextItem)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _nameIself :: (Name)
            _typesImiscerrors :: ([Error])
            _typesIself :: (Types)
            _typesItypevariables :: (Names)
            _typesIwarnings :: ([Warning])
            _typesOallTypeConstructors :: (Names)
            _typesOmiscerrors :: ([Error])
            _typesOoptions :: ([Option])
            _typesOtypeConstructors :: (M.Map Name Int)
            _typesOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            ( _typesImiscerrors,_typesIself,_typesItypevariables,_typesIwarnings) =
                (types_ (_typesOallTypeConstructors) (_typesOmiscerrors) (_typesOoptions) (_typesOtypeConstructors) (_typesOwarnings))
            (_lhsOcontextRanges@_) =
                [range_]
            (_lhsOmiscerrors@_) =
                if elem (getNameName name_) (M.keys standardClasses)
                   then _typesImiscerrors
                   else UnknownClass name_ : _typesImiscerrors
            (_lhsOcontextVars@_) =
                _typesItypevariables
            (_tyconEnv@_) =
                internalError "PartialSyntax.ag" "n/a" "ContextItem.ContextItem"
            (_self@_) =
                ContextItem_ContextItem _rangeIself _nameIself _typesIself
            (_lhsOself@_) =
                _self
            (_lhsOwarnings@_) =
                _typesIwarnings
            (_typesOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_typesOmiscerrors@_) =
                _lhsImiscerrors
            (_typesOoptions@_) =
                _lhsIoptions
            (_typesOtypeConstructors@_) =
                _lhsItypeConstructors
            (_typesOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcontextRanges,_lhsOcontextVars,_lhsOmiscerrors,_lhsOself,_lhsOwarnings)
-- ContextItems ------------------------------------------------
-- semantic domain
type T_ContextItems = (Names) ->
                      ([Error]) ->
                      ([Option]) ->
                      (M.Map Name Int) ->
                      ([Warning]) ->
                      ( ([Range]),([Name]),([Error]),(ContextItems),([Warning]))
-- cata
sem_ContextItems :: (ContextItems) ->
                    (T_ContextItems)
sem_ContextItems (list) =
    (Prelude.foldr (sem_ContextItems_Cons) (sem_ContextItems_Nil) ((Prelude.map sem_ContextItem list)))
sem_ContextItems_Cons :: (T_ContextItem) ->
                         (T_ContextItems) ->
                         (T_ContextItems)
sem_ContextItems_Cons (hd_) (tl_) =
    \ _lhsIallTypeConstructors
      _lhsImiscerrors
      _lhsIoptions
      _lhsItypeConstructors
      _lhsIwarnings ->
        let _lhsOcontextRanges :: ([Range])
            _lhsOcontextVars :: ([Name])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (ContextItems)
            _lhsOwarnings :: ([Warning])
            _hdIcontextRanges :: ([Range])
            _hdIcontextVars :: ([Name])
            _hdImiscerrors :: ([Error])
            _hdIself :: (ContextItem)
            _hdIwarnings :: ([Warning])
            _hdOallTypeConstructors :: (Names)
            _hdOmiscerrors :: ([Error])
            _hdOoptions :: ([Option])
            _hdOtypeConstructors :: (M.Map Name Int)
            _hdOwarnings :: ([Warning])
            _tlIcontextRanges :: ([Range])
            _tlIcontextVars :: ([Name])
            _tlImiscerrors :: ([Error])
            _tlIself :: (ContextItems)
            _tlIwarnings :: ([Warning])
            _tlOallTypeConstructors :: (Names)
            _tlOmiscerrors :: ([Error])
            _tlOoptions :: ([Option])
            _tlOtypeConstructors :: (M.Map Name Int)
            _tlOwarnings :: ([Warning])
            ( _hdIcontextRanges,_hdIcontextVars,_hdImiscerrors,_hdIself,_hdIwarnings) =
                (hd_ (_hdOallTypeConstructors) (_hdOmiscerrors) (_hdOoptions) (_hdOtypeConstructors) (_hdOwarnings))
            ( _tlIcontextRanges,_tlIcontextVars,_tlImiscerrors,_tlIself,_tlIwarnings) =
                (tl_ (_tlOallTypeConstructors) (_tlOmiscerrors) (_tlOoptions) (_tlOtypeConstructors) (_tlOwarnings))
            (_lhsOcontextRanges@_) =
                _hdIcontextRanges ++ _tlIcontextRanges
            (_lhsOcontextVars@_) =
                _hdIcontextVars  ++  _tlIcontextVars
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsOmiscerrors@_) =
                _tlImiscerrors
            (_lhsOwarnings@_) =
                _tlIwarnings
            (_hdOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_hdOmiscerrors@_) =
                _lhsImiscerrors
            (_hdOoptions@_) =
                _lhsIoptions
            (_hdOtypeConstructors@_) =
                _lhsItypeConstructors
            (_hdOwarnings@_) =
                _lhsIwarnings
            (_tlOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_tlOmiscerrors@_) =
                _hdImiscerrors
            (_tlOoptions@_) =
                _lhsIoptions
            (_tlOtypeConstructors@_) =
                _lhsItypeConstructors
            (_tlOwarnings@_) =
                _hdIwarnings
        in  ( _lhsOcontextRanges,_lhsOcontextVars,_lhsOmiscerrors,_lhsOself,_lhsOwarnings)
sem_ContextItems_Nil :: (T_ContextItems)
sem_ContextItems_Nil  =
    \ _lhsIallTypeConstructors
      _lhsImiscerrors
      _lhsIoptions
      _lhsItypeConstructors
      _lhsIwarnings ->
        let _lhsOcontextRanges :: ([Range])
            _lhsOcontextVars :: ([Name])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (ContextItems)
            _lhsOwarnings :: ([Warning])
            (_lhsOcontextRanges@_) =
                []
            (_lhsOcontextVars@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
            (_lhsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcontextRanges,_lhsOcontextVars,_lhsOmiscerrors,_lhsOself,_lhsOwarnings)
-- Declaration -------------------------------------------------
-- semantic domain
type T_Declaration = (Names) ->
                     (Names) ->
                     (ClassEnvironment) ->
                     ([(ScopeInfo, Entity)]) ->
                     ([(Name,Int)]) ->
                     ([(Name,(Int,Tps -> Tp))]) ->
                     ([(Name,TpScheme)]) ->
                     ([Error]) ->
                     ([Error]) ->
                     (Names) ->
                     ([(Name,(Int,Assoc))]) ->
                     ([Option]) ->
                     (OrderedTypeSynonyms) ->
                     (Maybe Name) ->
                     ([(Name,Name)]) ->
                     (M.Map Name Int) ->
                     ([(Name,TpScheme)]) ->
                     (M.Map Name TpScheme) ->
                     ([Warning]) ->
                     ( ([(Name, Instance)]),([(ScopeInfo, Entity)]),([(Name,Int)]),([(Name,(Int,Tps -> Tp))]),([(Name,TpScheme)]),(Names),([Error]),([Error]),([(Name,(Int,Assoc))]),(Maybe Name),(Names),(Declaration),([(Name,Name)]),([(Name,TpScheme)]),(Names),([Warning]))
-- cata
sem_Declaration :: (Declaration) ->
                   (T_Declaration)
sem_Declaration ((Declaration_Class (_range) (_context) (_simpletype) (_where))) =
    (sem_Declaration_Class ((sem_Range (_range))) ((sem_ContextItems (_context))) ((sem_SimpleType (_simpletype))) ((sem_MaybeDeclarations (_where))))
sem_Declaration ((Declaration_Data (_range) (_context) (_simpletype) (_constructors) (_derivings))) =
    (sem_Declaration_Data ((sem_Range (_range))) ((sem_ContextItems (_context))) ((sem_SimpleType (_simpletype))) ((sem_Constructors (_constructors))) ((sem_Names (_derivings))))
sem_Declaration ((Declaration_Default (_range) (_types))) =
    (sem_Declaration_Default ((sem_Range (_range))) ((sem_Types (_types))))
sem_Declaration ((Declaration_Empty (_range))) =
    (sem_Declaration_Empty ((sem_Range (_range))))
sem_Declaration ((Declaration_Fixity (_range) (_fixity) (_priority) (_operators))) =
    (sem_Declaration_Fixity ((sem_Range (_range))) ((sem_Fixity (_fixity))) ((sem_MaybeInt (_priority))) ((sem_Names (_operators))))
sem_Declaration ((Declaration_FunctionBindings (_range) (_bindings))) =
    (sem_Declaration_FunctionBindings ((sem_Range (_range))) ((sem_FunctionBindings (_bindings))))
sem_Declaration ((Declaration_Instance (_range) (_context) (_name) (_types) (_where))) =
    (sem_Declaration_Instance ((sem_Range (_range))) ((sem_ContextItems (_context))) ((sem_Name (_name))) ((sem_Types (_types))) ((sem_MaybeDeclarations (_where))))
sem_Declaration ((Declaration_Newtype (_range) (_context) (_simpletype) (_constructor) (_derivings))) =
    (sem_Declaration_Newtype ((sem_Range (_range))) ((sem_ContextItems (_context))) ((sem_SimpleType (_simpletype))) ((sem_Constructor (_constructor))) ((sem_Names (_derivings))))
sem_Declaration ((Declaration_PatternBinding (_range) (_pattern) (_righthandside))) =
    (sem_Declaration_PatternBinding ((sem_Range (_range))) ((sem_Pattern (_pattern))) ((sem_RightHandSide (_righthandside))))
sem_Declaration ((Declaration_Type (_range) (_simpletype) (_type))) =
    (sem_Declaration_Type ((sem_Range (_range))) ((sem_SimpleType (_simpletype))) ((sem_Type (_type))))
sem_Declaration ((Declaration_TypeSignature (_range) (_names) (_type))) =
    (sem_Declaration_TypeSignature ((sem_Range (_range))) ((sem_Names (_names))) ((sem_Type (_type))))
sem_Declaration_Class :: (T_Range) ->
                         (T_ContextItems) ->
                         (T_SimpleType) ->
                         (T_MaybeDeclarations) ->
                         (T_Declaration)
sem_Declaration_Class (range_) (context_) (simpletype_) (where_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIcollectTypeConstructors
      _lhsIcollectTypeSynonyms
      _lhsIcollectValueConstructors
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoperatorFixities
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsIpreviousWasAlsoFB
      _lhsIsuspiciousFBs
      _lhsItypeConstructors
      _lhsItypeSignatures
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOcollectTypeConstructors :: ([(Name,Int)])
            _lhsOcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _lhsOcollectValueConstructors :: ([(Name,TpScheme)])
            _lhsOdeclVarNames :: (Names)
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOoperatorFixities :: ([(Name,(Int,Assoc))])
            _lhsOpreviousWasAlsoFB :: (Maybe Name)
            _lhsOrestrictedNames :: (Names)
            _lhsOself :: (Declaration)
            _lhsOsuspiciousFBs :: ([(Name,Name)])
            _lhsOtypeSignatures :: ([(Name,TpScheme)])
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _contextIcontextRanges :: ([Range])
            _contextIcontextVars :: ([Name])
            _contextImiscerrors :: ([Error])
            _contextIself :: (ContextItems)
            _contextIwarnings :: ([Warning])
            _contextOallTypeConstructors :: (Names)
            _contextOmiscerrors :: ([Error])
            _contextOoptions :: ([Option])
            _contextOtypeConstructors :: (M.Map Name Int)
            _contextOwarnings :: ([Warning])
            _simpletypeIname :: (Name)
            _simpletypeIself :: (SimpleType)
            _simpletypeItypevariables :: (Names)
            _whereIcollectInstances :: ([(Name, Instance)])
            _whereIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _whereIkindErrors :: ([Error])
            _whereImiscerrors :: ([Error])
            _whereInamesInScope :: (Names)
            _whereIself :: (MaybeDeclarations)
            _whereIunboundNames :: (Names)
            _whereIwarnings :: ([Warning])
            _whereOallTypeConstructors :: (Names)
            _whereOallValueConstructors :: (Names)
            _whereOclassEnvironment :: (ClassEnvironment)
            _whereOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _whereOkindErrors :: ([Error])
            _whereOmiscerrors :: ([Error])
            _whereOnamesInScope :: (Names)
            _whereOoptions :: ([Option])
            _whereOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _whereOtypeConstructors :: (M.Map Name Int)
            _whereOunboundNames :: (Names)
            _whereOvalueConstructors :: (M.Map Name TpScheme)
            _whereOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _contextIcontextRanges,_contextIcontextVars,_contextImiscerrors,_contextIself,_contextIwarnings) =
                (context_ (_contextOallTypeConstructors) (_contextOmiscerrors) (_contextOoptions) (_contextOtypeConstructors) (_contextOwarnings))
            ( _simpletypeIname,_simpletypeIself,_simpletypeItypevariables) =
                (simpletype_ )
            ( _whereIcollectInstances,_whereIcollectScopeInfos,_whereIkindErrors,_whereImiscerrors,_whereInamesInScope,_whereIself,_whereIunboundNames,_whereIwarnings) =
                (where_ (_whereOallTypeConstructors) (_whereOallValueConstructors) (_whereOclassEnvironment) (_whereOcollectScopeInfos) (_whereOkindErrors) (_whereOmiscerrors) (_whereOnamesInScope) (_whereOoptions) (_whereOorderedTypeSynonyms) (_whereOtypeConstructors) (_whereOunboundNames) (_whereOvalueConstructors) (_whereOwarnings))
            (_lhsOpreviousWasAlsoFB@_) =
                Nothing
            ((_assumptions@_,_constraints@_,_unboundNames@_)) =
                internalError "PartialSyntax.ag" "n/a" "Declaration.Class"
            (_lhsOcollectInstances@_) =
                _whereIcollectInstances
            (_lhsOdeclVarNames@_) =
                []
            (_lhsOrestrictedNames@_) =
                []
            (_lhsOunboundNames@_) =
                _unboundNames
            (_self@_) =
                Declaration_Class _rangeIself _contextIself _simpletypeIself _whereIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _whereIcollectScopeInfos
            (_lhsOcollectTypeConstructors@_) =
                _lhsIcollectTypeConstructors
            (_lhsOcollectTypeSynonyms@_) =
                _lhsIcollectTypeSynonyms
            (_lhsOcollectValueConstructors@_) =
                _lhsIcollectValueConstructors
            (_lhsOkindErrors@_) =
                _whereIkindErrors
            (_lhsOmiscerrors@_) =
                _whereImiscerrors
            (_lhsOoperatorFixities@_) =
                _lhsIoperatorFixities
            (_lhsOsuspiciousFBs@_) =
                _lhsIsuspiciousFBs
            (_lhsOtypeSignatures@_) =
                _lhsItypeSignatures
            (_lhsOwarnings@_) =
                _whereIwarnings
            (_contextOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_contextOmiscerrors@_) =
                _lhsImiscerrors
            (_contextOoptions@_) =
                _lhsIoptions
            (_contextOtypeConstructors@_) =
                _lhsItypeConstructors
            (_contextOwarnings@_) =
                _lhsIwarnings
            (_whereOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_whereOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_whereOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_whereOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_whereOkindErrors@_) =
                _lhsIkindErrors
            (_whereOmiscerrors@_) =
                _contextImiscerrors
            (_whereOnamesInScope@_) =
                _lhsInamesInScope
            (_whereOoptions@_) =
                _lhsIoptions
            (_whereOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_whereOtypeConstructors@_) =
                _lhsItypeConstructors
            (_whereOunboundNames@_) =
                _unboundNames
            (_whereOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_whereOwarnings@_) =
                _contextIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOcollectTypeConstructors,_lhsOcollectTypeSynonyms,_lhsOcollectValueConstructors,_lhsOdeclVarNames,_lhsOkindErrors,_lhsOmiscerrors,_lhsOoperatorFixities,_lhsOpreviousWasAlsoFB,_lhsOrestrictedNames,_lhsOself,_lhsOsuspiciousFBs,_lhsOtypeSignatures,_lhsOunboundNames,_lhsOwarnings)
sem_Declaration_Data :: (T_Range) ->
                        (T_ContextItems) ->
                        (T_SimpleType) ->
                        (T_Constructors) ->
                        (T_Names) ->
                        (T_Declaration)
sem_Declaration_Data (range_) (context_) (simpletype_) (constructors_) (derivings_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIcollectTypeConstructors
      _lhsIcollectTypeSynonyms
      _lhsIcollectValueConstructors
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoperatorFixities
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsIpreviousWasAlsoFB
      _lhsIsuspiciousFBs
      _lhsItypeConstructors
      _lhsItypeSignatures
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOcollectTypeConstructors :: ([(Name,Int)])
            _lhsOcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _lhsOcollectValueConstructors :: ([(Name,TpScheme)])
            _lhsOdeclVarNames :: (Names)
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOoperatorFixities :: ([(Name,(Int,Assoc))])
            _lhsOpreviousWasAlsoFB :: (Maybe Name)
            _lhsOrestrictedNames :: (Names)
            _lhsOself :: (Declaration)
            _lhsOsuspiciousFBs :: ([(Name,Name)])
            _lhsOtypeSignatures :: ([(Name,TpScheme)])
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _contextIcontextRanges :: ([Range])
            _contextIcontextVars :: ([Name])
            _contextImiscerrors :: ([Error])
            _contextIself :: (ContextItems)
            _contextIwarnings :: ([Warning])
            _contextOallTypeConstructors :: (Names)
            _contextOmiscerrors :: ([Error])
            _contextOoptions :: ([Option])
            _contextOtypeConstructors :: (M.Map Name Int)
            _contextOwarnings :: ([Warning])
            _simpletypeIname :: (Name)
            _simpletypeIself :: (SimpleType)
            _simpletypeItypevariables :: (Names)
            _constructorsIcollectValueConstructors :: ([(Name,TpScheme)])
            _constructorsIkindErrors :: ([Error])
            _constructorsImiscerrors :: ([Error])
            _constructorsIparameterTypes :: (Tps)
            _constructorsIself :: (Constructors)
            _constructorsItypevariables :: (Names)
            _constructorsIunboundNames :: (Names)
            _constructorsIwarnings :: ([Warning])
            _constructorsOallTypeConstructors :: (Names)
            _constructorsOallValueConstructors :: (Names)
            _constructorsOcollectValueConstructors :: ([(Name,TpScheme)])
            _constructorsOkindErrors :: ([Error])
            _constructorsOmiscerrors :: ([Error])
            _constructorsOnamesInScope :: (Names)
            _constructorsOoptions :: ([Option])
            _constructorsOsimpletype :: (SimpleType)
            _constructorsOtypeConstructors :: (M.Map Name Int)
            _constructorsOvalueConstructors :: (M.Map Name TpScheme)
            _constructorsOwarnings :: ([Warning])
            _derivingsIself :: (Names)
            ( _rangeIself) =
                (range_ )
            ( _contextIcontextRanges,_contextIcontextVars,_contextImiscerrors,_contextIself,_contextIwarnings) =
                (context_ (_contextOallTypeConstructors) (_contextOmiscerrors) (_contextOoptions) (_contextOtypeConstructors) (_contextOwarnings))
            ( _simpletypeIname,_simpletypeIself,_simpletypeItypevariables) =
                (simpletype_ )
            ( _constructorsIcollectValueConstructors,_constructorsIkindErrors,_constructorsImiscerrors,_constructorsIparameterTypes,_constructorsIself,_constructorsItypevariables,_constructorsIunboundNames,_constructorsIwarnings) =
                (constructors_ (_constructorsOallTypeConstructors) (_constructorsOallValueConstructors) (_constructorsOcollectValueConstructors) (_constructorsOkindErrors) (_constructorsOmiscerrors) (_constructorsOnamesInScope) (_constructorsOoptions) (_constructorsOsimpletype) (_constructorsOtypeConstructors) (_constructorsOvalueConstructors) (_constructorsOwarnings))
            ( _derivingsIself) =
                (derivings_ )
            (_lhsOcollectTypeConstructors@_) =
                (_simpletypeIname,length _simpletypeItypevariables) : _lhsIcollectTypeConstructors
            (_lhsOcollectInstances@_) =
                [ (cl, makeInstance (show cl) (length _simpletypeItypevariables) (show _simpletypeIname) )
                | cl <- derivings_
                ]
            (_constructorsOsimpletype@_) =
                _simpletypeIself
            (_lhsOwarnings@_) =
                map (Unused TypeVariable) _unused ++ _lhsIwarnings
            (_lhsOpreviousWasAlsoFB@_) =
                Nothing
            (_cantDer@_) =
                [ CannotDerive c [ tp | ReductionError (Predicate _ tp) <- errs ]
                | c <- derivings_
                , let preds     = map (Predicate (show c)) _constructorsIparameterTypes
                      (_, errs) = contextReduction _lhsIorderedTypeSynonyms _lhsIclassEnvironment preds
                , not (null errs)
                ]
            (_unknCls@_) =
                [ if className `elem` [ "Num", "Enum", "Ord" ]
                   then NonDerivableClass c
                   else UnknownClass c
                | c <- derivings_, let className = show c
                , className `notElem` ["Show", "Eq"]
                ]
            (_undef@_) =
                filter (`notElem` _simpletypeItypevariables)   _constructorsItypevariables
            (_doubles@_) =
                filter ((>1) . length) . group . sort $        _simpletypeItypevariables
            (_unused@_) =
                filter (`notElem` _constructorsItypevariables) _simpletypeItypevariables
            (_lhsOmiscerrors@_) =
                concat [ makeDuplicated TypeVariable _doubles
                       , makeUndefined TypeVariable _undef _simpletypeItypevariables
                       , _lhsImiscerrors
                       , _unknCls
                       , if null _unknCls then _cantDer else []
                       ]
            (_lhsOdeclVarNames@_) =
                []
            (_lhsOrestrictedNames@_) =
                []
            (_lhsOunboundNames@_) =
                _constructorsIunboundNames
            (_self@_) =
                Declaration_Data _rangeIself _contextIself _simpletypeIself _constructorsIself _derivingsIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lhsOcollectTypeSynonyms@_) =
                _lhsIcollectTypeSynonyms
            (_lhsOcollectValueConstructors@_) =
                _constructorsIcollectValueConstructors
            (_lhsOkindErrors@_) =
                _constructorsIkindErrors
            (_lhsOoperatorFixities@_) =
                _lhsIoperatorFixities
            (_lhsOsuspiciousFBs@_) =
                _lhsIsuspiciousFBs
            (_lhsOtypeSignatures@_) =
                _lhsItypeSignatures
            (_contextOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_contextOmiscerrors@_) =
                _lhsImiscerrors
            (_contextOoptions@_) =
                _lhsIoptions
            (_contextOtypeConstructors@_) =
                _lhsItypeConstructors
            (_contextOwarnings@_) =
                _lhsIwarnings
            (_constructorsOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_constructorsOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_constructorsOcollectValueConstructors@_) =
                _lhsIcollectValueConstructors
            (_constructorsOkindErrors@_) =
                _lhsIkindErrors
            (_constructorsOmiscerrors@_) =
                _contextImiscerrors
            (_constructorsOnamesInScope@_) =
                _lhsInamesInScope
            (_constructorsOoptions@_) =
                _lhsIoptions
            (_constructorsOtypeConstructors@_) =
                _lhsItypeConstructors
            (_constructorsOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_constructorsOwarnings@_) =
                _contextIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOcollectTypeConstructors,_lhsOcollectTypeSynonyms,_lhsOcollectValueConstructors,_lhsOdeclVarNames,_lhsOkindErrors,_lhsOmiscerrors,_lhsOoperatorFixities,_lhsOpreviousWasAlsoFB,_lhsOrestrictedNames,_lhsOself,_lhsOsuspiciousFBs,_lhsOtypeSignatures,_lhsOunboundNames,_lhsOwarnings)
sem_Declaration_Default :: (T_Range) ->
                           (T_Types) ->
                           (T_Declaration)
sem_Declaration_Default (range_) (types_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIcollectTypeConstructors
      _lhsIcollectTypeSynonyms
      _lhsIcollectValueConstructors
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoperatorFixities
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsIpreviousWasAlsoFB
      _lhsIsuspiciousFBs
      _lhsItypeConstructors
      _lhsItypeSignatures
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOcollectTypeConstructors :: ([(Name,Int)])
            _lhsOcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _lhsOcollectValueConstructors :: ([(Name,TpScheme)])
            _lhsOdeclVarNames :: (Names)
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOoperatorFixities :: ([(Name,(Int,Assoc))])
            _lhsOpreviousWasAlsoFB :: (Maybe Name)
            _lhsOrestrictedNames :: (Names)
            _lhsOself :: (Declaration)
            _lhsOsuspiciousFBs :: ([(Name,Name)])
            _lhsOtypeSignatures :: ([(Name,TpScheme)])
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _typesImiscerrors :: ([Error])
            _typesIself :: (Types)
            _typesItypevariables :: (Names)
            _typesIwarnings :: ([Warning])
            _typesOallTypeConstructors :: (Names)
            _typesOmiscerrors :: ([Error])
            _typesOoptions :: ([Option])
            _typesOtypeConstructors :: (M.Map Name Int)
            _typesOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _typesImiscerrors,_typesIself,_typesItypevariables,_typesIwarnings) =
                (types_ (_typesOallTypeConstructors) (_typesOmiscerrors) (_typesOoptions) (_typesOtypeConstructors) (_typesOwarnings))
            (_lhsOpreviousWasAlsoFB@_) =
                Nothing
            (_lhsOcollectInstances@_) =
                []
            (_lhsOdeclVarNames@_) =
                []
            (_lhsOrestrictedNames@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                Declaration_Default _rangeIself _typesIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lhsOcollectTypeConstructors@_) =
                _lhsIcollectTypeConstructors
            (_lhsOcollectTypeSynonyms@_) =
                _lhsIcollectTypeSynonyms
            (_lhsOcollectValueConstructors@_) =
                _lhsIcollectValueConstructors
            (_lhsOkindErrors@_) =
                _lhsIkindErrors
            (_lhsOmiscerrors@_) =
                _typesImiscerrors
            (_lhsOoperatorFixities@_) =
                _lhsIoperatorFixities
            (_lhsOsuspiciousFBs@_) =
                _lhsIsuspiciousFBs
            (_lhsOtypeSignatures@_) =
                _lhsItypeSignatures
            (_lhsOwarnings@_) =
                _typesIwarnings
            (_typesOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_typesOmiscerrors@_) =
                _lhsImiscerrors
            (_typesOoptions@_) =
                _lhsIoptions
            (_typesOtypeConstructors@_) =
                _lhsItypeConstructors
            (_typesOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOcollectTypeConstructors,_lhsOcollectTypeSynonyms,_lhsOcollectValueConstructors,_lhsOdeclVarNames,_lhsOkindErrors,_lhsOmiscerrors,_lhsOoperatorFixities,_lhsOpreviousWasAlsoFB,_lhsOrestrictedNames,_lhsOself,_lhsOsuspiciousFBs,_lhsOtypeSignatures,_lhsOunboundNames,_lhsOwarnings)
sem_Declaration_Empty :: (T_Range) ->
                         (T_Declaration)
sem_Declaration_Empty (range_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIcollectTypeConstructors
      _lhsIcollectTypeSynonyms
      _lhsIcollectValueConstructors
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoperatorFixities
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsIpreviousWasAlsoFB
      _lhsIsuspiciousFBs
      _lhsItypeConstructors
      _lhsItypeSignatures
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOcollectTypeConstructors :: ([(Name,Int)])
            _lhsOcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _lhsOcollectValueConstructors :: ([(Name,TpScheme)])
            _lhsOdeclVarNames :: (Names)
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOoperatorFixities :: ([(Name,(Int,Assoc))])
            _lhsOpreviousWasAlsoFB :: (Maybe Name)
            _lhsOrestrictedNames :: (Names)
            _lhsOself :: (Declaration)
            _lhsOsuspiciousFBs :: ([(Name,Name)])
            _lhsOtypeSignatures :: ([(Name,TpScheme)])
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            ( _rangeIself) =
                (range_ )
            (_lhsOcollectInstances@_) =
                []
            (_lhsOdeclVarNames@_) =
                []
            (_lhsOrestrictedNames@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                Declaration_Empty _rangeIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lhsOcollectTypeConstructors@_) =
                _lhsIcollectTypeConstructors
            (_lhsOcollectTypeSynonyms@_) =
                _lhsIcollectTypeSynonyms
            (_lhsOcollectValueConstructors@_) =
                _lhsIcollectValueConstructors
            (_lhsOkindErrors@_) =
                _lhsIkindErrors
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
            (_lhsOoperatorFixities@_) =
                _lhsIoperatorFixities
            (_lhsOpreviousWasAlsoFB@_) =
                _lhsIpreviousWasAlsoFB
            (_lhsOsuspiciousFBs@_) =
                _lhsIsuspiciousFBs
            (_lhsOtypeSignatures@_) =
                _lhsItypeSignatures
            (_lhsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOcollectTypeConstructors,_lhsOcollectTypeSynonyms,_lhsOcollectValueConstructors,_lhsOdeclVarNames,_lhsOkindErrors,_lhsOmiscerrors,_lhsOoperatorFixities,_lhsOpreviousWasAlsoFB,_lhsOrestrictedNames,_lhsOself,_lhsOsuspiciousFBs,_lhsOtypeSignatures,_lhsOunboundNames,_lhsOwarnings)
sem_Declaration_Fixity :: (T_Range) ->
                          (T_Fixity) ->
                          (T_MaybeInt) ->
                          (T_Names) ->
                          (T_Declaration)
sem_Declaration_Fixity (range_) (fixity_) (priority_) (operators_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIcollectTypeConstructors
      _lhsIcollectTypeSynonyms
      _lhsIcollectValueConstructors
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoperatorFixities
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsIpreviousWasAlsoFB
      _lhsIsuspiciousFBs
      _lhsItypeConstructors
      _lhsItypeSignatures
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOcollectTypeConstructors :: ([(Name,Int)])
            _lhsOcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _lhsOcollectValueConstructors :: ([(Name,TpScheme)])
            _lhsOdeclVarNames :: (Names)
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOoperatorFixities :: ([(Name,(Int,Assoc))])
            _lhsOpreviousWasAlsoFB :: (Maybe Name)
            _lhsOrestrictedNames :: (Names)
            _lhsOself :: (Declaration)
            _lhsOsuspiciousFBs :: ([(Name,Name)])
            _lhsOtypeSignatures :: ([(Name,TpScheme)])
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _fixityIself :: (Fixity)
            _priorityIself :: (MaybeInt)
            _operatorsIself :: (Names)
            ( _rangeIself) =
                (range_ )
            ( _fixityIself) =
                (fixity_ )
            ( _priorityIself) =
                (priority_ )
            ( _operatorsIself) =
                (operators_ )
            (_lhsOoperatorFixities@_) =
                let associativity = case _fixityIself of
                                       Fixity_Infix _  -> AssocNone
                                       Fixity_Infixl _ -> AssocLeft
                                       Fixity_Infixr _ -> AssocRight
                    priority      = case _priorityIself of
                                       MaybeInt_Just i  -> i
                                       MaybeInt_Nothing -> 9
                in [ (name, (priority, associativity)) | name <- _operatorsIself ] ++ _lhsIoperatorFixities
            (_lhsOpreviousWasAlsoFB@_) =
                Nothing
            (_lhsOcollectInstances@_) =
                []
            (_lhsOdeclVarNames@_) =
                []
            (_lhsOrestrictedNames@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                Declaration_Fixity _rangeIself _fixityIself _priorityIself _operatorsIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lhsOcollectTypeConstructors@_) =
                _lhsIcollectTypeConstructors
            (_lhsOcollectTypeSynonyms@_) =
                _lhsIcollectTypeSynonyms
            (_lhsOcollectValueConstructors@_) =
                _lhsIcollectValueConstructors
            (_lhsOkindErrors@_) =
                _lhsIkindErrors
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
            (_lhsOsuspiciousFBs@_) =
                _lhsIsuspiciousFBs
            (_lhsOtypeSignatures@_) =
                _lhsItypeSignatures
            (_lhsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOcollectTypeConstructors,_lhsOcollectTypeSynonyms,_lhsOcollectValueConstructors,_lhsOdeclVarNames,_lhsOkindErrors,_lhsOmiscerrors,_lhsOoperatorFixities,_lhsOpreviousWasAlsoFB,_lhsOrestrictedNames,_lhsOself,_lhsOsuspiciousFBs,_lhsOtypeSignatures,_lhsOunboundNames,_lhsOwarnings)
sem_Declaration_FunctionBindings :: (T_Range) ->
                                    (T_FunctionBindings) ->
                                    (T_Declaration)
sem_Declaration_FunctionBindings (range_) (bindings_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIcollectTypeConstructors
      _lhsIcollectTypeSynonyms
      _lhsIcollectValueConstructors
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoperatorFixities
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsIpreviousWasAlsoFB
      _lhsIsuspiciousFBs
      _lhsItypeConstructors
      _lhsItypeSignatures
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOcollectTypeConstructors :: ([(Name,Int)])
            _lhsOcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _lhsOcollectValueConstructors :: ([(Name,TpScheme)])
            _lhsOdeclVarNames :: (Names)
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOoperatorFixities :: ([(Name,(Int,Assoc))])
            _lhsOpreviousWasAlsoFB :: (Maybe Name)
            _lhsOrestrictedNames :: (Names)
            _lhsOself :: (Declaration)
            _lhsOsuspiciousFBs :: ([(Name,Name)])
            _lhsOtypeSignatures :: ([(Name,TpScheme)])
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _bindingsIarities :: ( [Int] )
            _bindingsIcollectInstances :: ([(Name, Instance)])
            _bindingsIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _bindingsIkindErrors :: ([Error])
            _bindingsImiscerrors :: ([Error])
            _bindingsIname :: (Name)
            _bindingsIself :: (FunctionBindings)
            _bindingsIunboundNames :: (Names)
            _bindingsIwarnings :: ([Warning])
            _bindingsOallTypeConstructors :: (Names)
            _bindingsOallValueConstructors :: (Names)
            _bindingsOclassEnvironment :: (ClassEnvironment)
            _bindingsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _bindingsOkindErrors :: ([Error])
            _bindingsOmiscerrors :: ([Error])
            _bindingsOnamesInScope :: (Names)
            _bindingsOoptions :: ([Option])
            _bindingsOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _bindingsOtypeConstructors :: (M.Map Name Int)
            _bindingsOvalueConstructors :: (M.Map Name TpScheme)
            _bindingsOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _bindingsIarities,_bindingsIcollectInstances,_bindingsIcollectScopeInfos,_bindingsIkindErrors,_bindingsImiscerrors,_bindingsIname,_bindingsIself,_bindingsIunboundNames,_bindingsIwarnings) =
                (bindings_ (_bindingsOallTypeConstructors) (_bindingsOallValueConstructors) (_bindingsOclassEnvironment) (_bindingsOcollectScopeInfos) (_bindingsOkindErrors) (_bindingsOmiscerrors) (_bindingsOnamesInScope) (_bindingsOoptions) (_bindingsOorderedTypeSynonyms) (_bindingsOtypeConstructors) (_bindingsOvalueConstructors) (_bindingsOwarnings))
            (_lhsOdeclVarNames@_) =
                [_bindingsIname]
            (_lhsOsuspiciousFBs@_) =
                case _lhsIpreviousWasAlsoFB of
                   Just name | show name `similar` show _bindingsIname
                      -> (name,_bindingsIname) : _lhsIsuspiciousFBs
                   _  -> _lhsIsuspiciousFBs
            (_lhsOpreviousWasAlsoFB@_) =
                Just _bindingsIname
            (_arityErrors@_) =
                if all (== head _bindingsIarities) _bindingsIarities
                  then []
                  else [ DefArityMismatch _bindingsIname (mode _bindingsIarities) _rangeIself ]
            (_lhsOmiscerrors@_) =
                _arityErrors ++ _bindingsImiscerrors
            (_lhsOcollectInstances@_) =
                _bindingsIcollectInstances
            (_lhsOrestrictedNames@_) =
                []
            (_lhsOunboundNames@_) =
                _bindingsIunboundNames
            (_self@_) =
                Declaration_FunctionBindings _rangeIself _bindingsIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _bindingsIcollectScopeInfos
            (_lhsOcollectTypeConstructors@_) =
                _lhsIcollectTypeConstructors
            (_lhsOcollectTypeSynonyms@_) =
                _lhsIcollectTypeSynonyms
            (_lhsOcollectValueConstructors@_) =
                _lhsIcollectValueConstructors
            (_lhsOkindErrors@_) =
                _bindingsIkindErrors
            (_lhsOoperatorFixities@_) =
                _lhsIoperatorFixities
            (_lhsOtypeSignatures@_) =
                _lhsItypeSignatures
            (_lhsOwarnings@_) =
                _bindingsIwarnings
            (_bindingsOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_bindingsOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_bindingsOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_bindingsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_bindingsOkindErrors@_) =
                _lhsIkindErrors
            (_bindingsOmiscerrors@_) =
                _lhsImiscerrors
            (_bindingsOnamesInScope@_) =
                _lhsInamesInScope
            (_bindingsOoptions@_) =
                _lhsIoptions
            (_bindingsOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_bindingsOtypeConstructors@_) =
                _lhsItypeConstructors
            (_bindingsOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_bindingsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOcollectTypeConstructors,_lhsOcollectTypeSynonyms,_lhsOcollectValueConstructors,_lhsOdeclVarNames,_lhsOkindErrors,_lhsOmiscerrors,_lhsOoperatorFixities,_lhsOpreviousWasAlsoFB,_lhsOrestrictedNames,_lhsOself,_lhsOsuspiciousFBs,_lhsOtypeSignatures,_lhsOunboundNames,_lhsOwarnings)
sem_Declaration_Instance :: (T_Range) ->
                            (T_ContextItems) ->
                            (T_Name) ->
                            (T_Types) ->
                            (T_MaybeDeclarations) ->
                            (T_Declaration)
sem_Declaration_Instance (range_) (context_) (name_) (types_) (where_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIcollectTypeConstructors
      _lhsIcollectTypeSynonyms
      _lhsIcollectValueConstructors
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoperatorFixities
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsIpreviousWasAlsoFB
      _lhsIsuspiciousFBs
      _lhsItypeConstructors
      _lhsItypeSignatures
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOcollectTypeConstructors :: ([(Name,Int)])
            _lhsOcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _lhsOcollectValueConstructors :: ([(Name,TpScheme)])
            _lhsOdeclVarNames :: (Names)
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOoperatorFixities :: ([(Name,(Int,Assoc))])
            _lhsOpreviousWasAlsoFB :: (Maybe Name)
            _lhsOrestrictedNames :: (Names)
            _lhsOself :: (Declaration)
            _lhsOsuspiciousFBs :: ([(Name,Name)])
            _lhsOtypeSignatures :: ([(Name,TpScheme)])
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _contextIcontextRanges :: ([Range])
            _contextIcontextVars :: ([Name])
            _contextImiscerrors :: ([Error])
            _contextIself :: (ContextItems)
            _contextIwarnings :: ([Warning])
            _contextOallTypeConstructors :: (Names)
            _contextOmiscerrors :: ([Error])
            _contextOoptions :: ([Option])
            _contextOtypeConstructors :: (M.Map Name Int)
            _contextOwarnings :: ([Warning])
            _nameIself :: (Name)
            _typesImiscerrors :: ([Error])
            _typesIself :: (Types)
            _typesItypevariables :: (Names)
            _typesIwarnings :: ([Warning])
            _typesOallTypeConstructors :: (Names)
            _typesOmiscerrors :: ([Error])
            _typesOoptions :: ([Option])
            _typesOtypeConstructors :: (M.Map Name Int)
            _typesOwarnings :: ([Warning])
            _whereIcollectInstances :: ([(Name, Instance)])
            _whereIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _whereIkindErrors :: ([Error])
            _whereImiscerrors :: ([Error])
            _whereInamesInScope :: (Names)
            _whereIself :: (MaybeDeclarations)
            _whereIunboundNames :: (Names)
            _whereIwarnings :: ([Warning])
            _whereOallTypeConstructors :: (Names)
            _whereOallValueConstructors :: (Names)
            _whereOclassEnvironment :: (ClassEnvironment)
            _whereOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _whereOkindErrors :: ([Error])
            _whereOmiscerrors :: ([Error])
            _whereOnamesInScope :: (Names)
            _whereOoptions :: ([Option])
            _whereOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _whereOtypeConstructors :: (M.Map Name Int)
            _whereOunboundNames :: (Names)
            _whereOvalueConstructors :: (M.Map Name TpScheme)
            _whereOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _contextIcontextRanges,_contextIcontextVars,_contextImiscerrors,_contextIself,_contextIwarnings) =
                (context_ (_contextOallTypeConstructors) (_contextOmiscerrors) (_contextOoptions) (_contextOtypeConstructors) (_contextOwarnings))
            ( _nameIself) =
                (name_ )
            ( _typesImiscerrors,_typesIself,_typesItypevariables,_typesIwarnings) =
                (types_ (_typesOallTypeConstructors) (_typesOmiscerrors) (_typesOoptions) (_typesOtypeConstructors) (_typesOwarnings))
            ( _whereIcollectInstances,_whereIcollectScopeInfos,_whereIkindErrors,_whereImiscerrors,_whereInamesInScope,_whereIself,_whereIunboundNames,_whereIwarnings) =
                (where_ (_whereOallTypeConstructors) (_whereOallValueConstructors) (_whereOclassEnvironment) (_whereOcollectScopeInfos) (_whereOkindErrors) (_whereOmiscerrors) (_whereOnamesInScope) (_whereOoptions) (_whereOorderedTypeSynonyms) (_whereOtypeConstructors) (_whereOunboundNames) (_whereOvalueConstructors) (_whereOwarnings))
            (_lhsOpreviousWasAlsoFB@_) =
                Nothing
            ((_assumptions@_,_constraints@_,_unboundNames@_)) =
                internalError "PartialSyntax.ag" "n/a" "Declaration.Instance"
            (_lhsOcollectInstances@_) =
                _whereIcollectInstances
            (_lhsOdeclVarNames@_) =
                []
            (_lhsOrestrictedNames@_) =
                []
            (_lhsOunboundNames@_) =
                _unboundNames
            (_self@_) =
                Declaration_Instance _rangeIself _contextIself _nameIself _typesIself _whereIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _whereIcollectScopeInfos
            (_lhsOcollectTypeConstructors@_) =
                _lhsIcollectTypeConstructors
            (_lhsOcollectTypeSynonyms@_) =
                _lhsIcollectTypeSynonyms
            (_lhsOcollectValueConstructors@_) =
                _lhsIcollectValueConstructors
            (_lhsOkindErrors@_) =
                _whereIkindErrors
            (_lhsOmiscerrors@_) =
                _whereImiscerrors
            (_lhsOoperatorFixities@_) =
                _lhsIoperatorFixities
            (_lhsOsuspiciousFBs@_) =
                _lhsIsuspiciousFBs
            (_lhsOtypeSignatures@_) =
                _lhsItypeSignatures
            (_lhsOwarnings@_) =
                _whereIwarnings
            (_contextOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_contextOmiscerrors@_) =
                _lhsImiscerrors
            (_contextOoptions@_) =
                _lhsIoptions
            (_contextOtypeConstructors@_) =
                _lhsItypeConstructors
            (_contextOwarnings@_) =
                _lhsIwarnings
            (_typesOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_typesOmiscerrors@_) =
                _contextImiscerrors
            (_typesOoptions@_) =
                _lhsIoptions
            (_typesOtypeConstructors@_) =
                _lhsItypeConstructors
            (_typesOwarnings@_) =
                _contextIwarnings
            (_whereOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_whereOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_whereOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_whereOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_whereOkindErrors@_) =
                _lhsIkindErrors
            (_whereOmiscerrors@_) =
                _typesImiscerrors
            (_whereOnamesInScope@_) =
                _lhsInamesInScope
            (_whereOoptions@_) =
                _lhsIoptions
            (_whereOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_whereOtypeConstructors@_) =
                _lhsItypeConstructors
            (_whereOunboundNames@_) =
                _unboundNames
            (_whereOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_whereOwarnings@_) =
                _typesIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOcollectTypeConstructors,_lhsOcollectTypeSynonyms,_lhsOcollectValueConstructors,_lhsOdeclVarNames,_lhsOkindErrors,_lhsOmiscerrors,_lhsOoperatorFixities,_lhsOpreviousWasAlsoFB,_lhsOrestrictedNames,_lhsOself,_lhsOsuspiciousFBs,_lhsOtypeSignatures,_lhsOunboundNames,_lhsOwarnings)
sem_Declaration_Newtype :: (T_Range) ->
                           (T_ContextItems) ->
                           (T_SimpleType) ->
                           (T_Constructor) ->
                           (T_Names) ->
                           (T_Declaration)
sem_Declaration_Newtype (range_) (context_) (simpletype_) (constructor_) (derivings_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIcollectTypeConstructors
      _lhsIcollectTypeSynonyms
      _lhsIcollectValueConstructors
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoperatorFixities
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsIpreviousWasAlsoFB
      _lhsIsuspiciousFBs
      _lhsItypeConstructors
      _lhsItypeSignatures
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOcollectTypeConstructors :: ([(Name,Int)])
            _lhsOcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _lhsOcollectValueConstructors :: ([(Name,TpScheme)])
            _lhsOdeclVarNames :: (Names)
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOoperatorFixities :: ([(Name,(Int,Assoc))])
            _lhsOpreviousWasAlsoFB :: (Maybe Name)
            _lhsOrestrictedNames :: (Names)
            _lhsOself :: (Declaration)
            _lhsOsuspiciousFBs :: ([(Name,Name)])
            _lhsOtypeSignatures :: ([(Name,TpScheme)])
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _contextIcontextRanges :: ([Range])
            _contextIcontextVars :: ([Name])
            _contextImiscerrors :: ([Error])
            _contextIself :: (ContextItems)
            _contextIwarnings :: ([Warning])
            _contextOallTypeConstructors :: (Names)
            _contextOmiscerrors :: ([Error])
            _contextOoptions :: ([Option])
            _contextOtypeConstructors :: (M.Map Name Int)
            _contextOwarnings :: ([Warning])
            _simpletypeIname :: (Name)
            _simpletypeIself :: (SimpleType)
            _simpletypeItypevariables :: (Names)
            _constructorIcollectValueConstructors :: ([(Name,TpScheme)])
            _constructorIkindErrors :: ([Error])
            _constructorImiscerrors :: ([Error])
            _constructorIparameterTypes :: (Tps)
            _constructorIself :: (Constructor)
            _constructorItypevariables :: (Names)
            _constructorIunboundNames :: (Names)
            _constructorIwarnings :: ([Warning])
            _constructorOallTypeConstructors :: (Names)
            _constructorOallValueConstructors :: (Names)
            _constructorOcollectValueConstructors :: ([(Name,TpScheme)])
            _constructorOkindErrors :: ([Error])
            _constructorOmiscerrors :: ([Error])
            _constructorOnamesInScope :: (Names)
            _constructorOoptions :: ([Option])
            _constructorOsimpletype :: (SimpleType)
            _constructorOtypeConstructors :: (M.Map Name Int)
            _constructorOvalueConstructors :: (M.Map Name TpScheme)
            _constructorOwarnings :: ([Warning])
            _derivingsIself :: (Names)
            ( _rangeIself) =
                (range_ )
            ( _contextIcontextRanges,_contextIcontextVars,_contextImiscerrors,_contextIself,_contextIwarnings) =
                (context_ (_contextOallTypeConstructors) (_contextOmiscerrors) (_contextOoptions) (_contextOtypeConstructors) (_contextOwarnings))
            ( _simpletypeIname,_simpletypeIself,_simpletypeItypevariables) =
                (simpletype_ )
            ( _constructorIcollectValueConstructors,_constructorIkindErrors,_constructorImiscerrors,_constructorIparameterTypes,_constructorIself,_constructorItypevariables,_constructorIunboundNames,_constructorIwarnings) =
                (constructor_ (_constructorOallTypeConstructors) (_constructorOallValueConstructors) (_constructorOcollectValueConstructors) (_constructorOkindErrors) (_constructorOmiscerrors) (_constructorOnamesInScope) (_constructorOoptions) (_constructorOsimpletype) (_constructorOtypeConstructors) (_constructorOvalueConstructors) (_constructorOwarnings))
            ( _derivingsIself) =
                (derivings_ )
            (_constructorOsimpletype@_) =
                _simpletypeIself
            (_lhsOpreviousWasAlsoFB@_) =
                Nothing
            (_lhsOcollectInstances@_) =
                []
            (_lhsOdeclVarNames@_) =
                []
            (_lhsOrestrictedNames@_) =
                []
            (_lhsOunboundNames@_) =
                _constructorIunboundNames
            (_self@_) =
                Declaration_Newtype _rangeIself _contextIself _simpletypeIself _constructorIself _derivingsIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lhsOcollectTypeConstructors@_) =
                _lhsIcollectTypeConstructors
            (_lhsOcollectTypeSynonyms@_) =
                _lhsIcollectTypeSynonyms
            (_lhsOcollectValueConstructors@_) =
                _constructorIcollectValueConstructors
            (_lhsOkindErrors@_) =
                _constructorIkindErrors
            (_lhsOmiscerrors@_) =
                _constructorImiscerrors
            (_lhsOoperatorFixities@_) =
                _lhsIoperatorFixities
            (_lhsOsuspiciousFBs@_) =
                _lhsIsuspiciousFBs
            (_lhsOtypeSignatures@_) =
                _lhsItypeSignatures
            (_lhsOwarnings@_) =
                _constructorIwarnings
            (_contextOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_contextOmiscerrors@_) =
                _lhsImiscerrors
            (_contextOoptions@_) =
                _lhsIoptions
            (_contextOtypeConstructors@_) =
                _lhsItypeConstructors
            (_contextOwarnings@_) =
                _lhsIwarnings
            (_constructorOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_constructorOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_constructorOcollectValueConstructors@_) =
                _lhsIcollectValueConstructors
            (_constructorOkindErrors@_) =
                _lhsIkindErrors
            (_constructorOmiscerrors@_) =
                _contextImiscerrors
            (_constructorOnamesInScope@_) =
                _lhsInamesInScope
            (_constructorOoptions@_) =
                _lhsIoptions
            (_constructorOtypeConstructors@_) =
                _lhsItypeConstructors
            (_constructorOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_constructorOwarnings@_) =
                _contextIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOcollectTypeConstructors,_lhsOcollectTypeSynonyms,_lhsOcollectValueConstructors,_lhsOdeclVarNames,_lhsOkindErrors,_lhsOmiscerrors,_lhsOoperatorFixities,_lhsOpreviousWasAlsoFB,_lhsOrestrictedNames,_lhsOself,_lhsOsuspiciousFBs,_lhsOtypeSignatures,_lhsOunboundNames,_lhsOwarnings)
sem_Declaration_PatternBinding :: (T_Range) ->
                                  (T_Pattern) ->
                                  (T_RightHandSide) ->
                                  (T_Declaration)
sem_Declaration_PatternBinding (range_) (pattern_) (righthandside_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIcollectTypeConstructors
      _lhsIcollectTypeSynonyms
      _lhsIcollectValueConstructors
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoperatorFixities
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsIpreviousWasAlsoFB
      _lhsIsuspiciousFBs
      _lhsItypeConstructors
      _lhsItypeSignatures
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOcollectTypeConstructors :: ([(Name,Int)])
            _lhsOcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _lhsOcollectValueConstructors :: ([(Name,TpScheme)])
            _lhsOdeclVarNames :: (Names)
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOoperatorFixities :: ([(Name,(Int,Assoc))])
            _lhsOpreviousWasAlsoFB :: (Maybe Name)
            _lhsOrestrictedNames :: (Names)
            _lhsOself :: (Declaration)
            _lhsOsuspiciousFBs :: ([(Name,Name)])
            _lhsOtypeSignatures :: ([(Name,TpScheme)])
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _patternIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _patternImiscerrors :: ([Error])
            _patternIpatVarNames :: (Names)
            _patternIself :: (Pattern)
            _patternIunboundNames :: (Names)
            _patternIwarnings :: ([Warning])
            _patternOallTypeConstructors :: (Names)
            _patternOallValueConstructors :: (Names)
            _patternOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _patternOlhsPattern :: (Bool)
            _patternOmiscerrors :: ([Error])
            _patternOnamesInScope :: (Names)
            _patternOtypeConstructors :: (M.Map Name Int)
            _patternOvalueConstructors :: (M.Map Name TpScheme)
            _patternOwarnings :: ([Warning])
            _righthandsideIcollectInstances :: ([(Name, Instance)])
            _righthandsideIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _righthandsideIkindErrors :: ([Error])
            _righthandsideImiscerrors :: ([Error])
            _righthandsideIself :: (RightHandSide)
            _righthandsideIunboundNames :: (Names)
            _righthandsideIwarnings :: ([Warning])
            _righthandsideOallTypeConstructors :: (Names)
            _righthandsideOallValueConstructors :: (Names)
            _righthandsideOclassEnvironment :: (ClassEnvironment)
            _righthandsideOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _righthandsideOkindErrors :: ([Error])
            _righthandsideOmiscerrors :: ([Error])
            _righthandsideOnamesInScope :: (Names)
            _righthandsideOoptions :: ([Option])
            _righthandsideOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _righthandsideOtypeConstructors :: (M.Map Name Int)
            _righthandsideOvalueConstructors :: (M.Map Name TpScheme)
            _righthandsideOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _patternIcollectScopeInfos,_patternImiscerrors,_patternIpatVarNames,_patternIself,_patternIunboundNames,_patternIwarnings) =
                (pattern_ (_patternOallTypeConstructors) (_patternOallValueConstructors) (_patternOcollectScopeInfos) (_patternOlhsPattern) (_patternOmiscerrors) (_patternOnamesInScope) (_patternOtypeConstructors) (_patternOvalueConstructors) (_patternOwarnings))
            ( _righthandsideIcollectInstances,_righthandsideIcollectScopeInfos,_righthandsideIkindErrors,_righthandsideImiscerrors,_righthandsideIself,_righthandsideIunboundNames,_righthandsideIwarnings) =
                (righthandside_ (_righthandsideOallTypeConstructors) (_righthandsideOallValueConstructors) (_righthandsideOclassEnvironment) (_righthandsideOcollectScopeInfos) (_righthandsideOkindErrors) (_righthandsideOmiscerrors) (_righthandsideOnamesInScope) (_righthandsideOoptions) (_righthandsideOorderedTypeSynonyms) (_righthandsideOtypeConstructors) (_righthandsideOvalueConstructors) (_righthandsideOwarnings))
            (_lhsOdeclVarNames@_) =
                _patternIpatVarNames
            (_lhsOpreviousWasAlsoFB@_) =
                Nothing
            (_patternDefinesNoVarsErrors@_) =
                if null _patternIpatVarNames
                  then [ PatternDefinesNoVars (getPatRange _patternIself) ]
                  else []
            (_lhsOmiscerrors@_) =
                _patternDefinesNoVarsErrors ++ _righthandsideImiscerrors
            (_patternOlhsPattern@_) =
                simplePattern _patternIself
            (_lhsOrestrictedNames@_) =
                if isSimplePattern _patternIself
                  then []
                  else _patternIpatVarNames
            (_lhsOcollectInstances@_) =
                _righthandsideIcollectInstances
            (_lhsOunboundNames@_) =
                _patternIunboundNames ++ _righthandsideIunboundNames
            (_self@_) =
                Declaration_PatternBinding _rangeIself _patternIself _righthandsideIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _righthandsideIcollectScopeInfos
            (_lhsOcollectTypeConstructors@_) =
                _lhsIcollectTypeConstructors
            (_lhsOcollectTypeSynonyms@_) =
                _lhsIcollectTypeSynonyms
            (_lhsOcollectValueConstructors@_) =
                _lhsIcollectValueConstructors
            (_lhsOkindErrors@_) =
                _righthandsideIkindErrors
            (_lhsOoperatorFixities@_) =
                _lhsIoperatorFixities
            (_lhsOsuspiciousFBs@_) =
                _lhsIsuspiciousFBs
            (_lhsOtypeSignatures@_) =
                _lhsItypeSignatures
            (_lhsOwarnings@_) =
                _righthandsideIwarnings
            (_patternOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_patternOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_patternOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_patternOmiscerrors@_) =
                _lhsImiscerrors
            (_patternOnamesInScope@_) =
                _lhsInamesInScope
            (_patternOtypeConstructors@_) =
                _lhsItypeConstructors
            (_patternOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_patternOwarnings@_) =
                _lhsIwarnings
            (_righthandsideOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_righthandsideOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_righthandsideOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_righthandsideOcollectScopeInfos@_) =
                _patternIcollectScopeInfos
            (_righthandsideOkindErrors@_) =
                _lhsIkindErrors
            (_righthandsideOmiscerrors@_) =
                _patternImiscerrors
            (_righthandsideOnamesInScope@_) =
                _lhsInamesInScope
            (_righthandsideOoptions@_) =
                _lhsIoptions
            (_righthandsideOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_righthandsideOtypeConstructors@_) =
                _lhsItypeConstructors
            (_righthandsideOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_righthandsideOwarnings@_) =
                _patternIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOcollectTypeConstructors,_lhsOcollectTypeSynonyms,_lhsOcollectValueConstructors,_lhsOdeclVarNames,_lhsOkindErrors,_lhsOmiscerrors,_lhsOoperatorFixities,_lhsOpreviousWasAlsoFB,_lhsOrestrictedNames,_lhsOself,_lhsOsuspiciousFBs,_lhsOtypeSignatures,_lhsOunboundNames,_lhsOwarnings)
sem_Declaration_Type :: (T_Range) ->
                        (T_SimpleType) ->
                        (T_Type) ->
                        (T_Declaration)
sem_Declaration_Type (range_) (simpletype_) (type_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIcollectTypeConstructors
      _lhsIcollectTypeSynonyms
      _lhsIcollectValueConstructors
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoperatorFixities
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsIpreviousWasAlsoFB
      _lhsIsuspiciousFBs
      _lhsItypeConstructors
      _lhsItypeSignatures
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOcollectTypeConstructors :: ([(Name,Int)])
            _lhsOcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _lhsOcollectValueConstructors :: ([(Name,TpScheme)])
            _lhsOdeclVarNames :: (Names)
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOoperatorFixities :: ([(Name,(Int,Assoc))])
            _lhsOpreviousWasAlsoFB :: (Maybe Name)
            _lhsOrestrictedNames :: (Names)
            _lhsOself :: (Declaration)
            _lhsOsuspiciousFBs :: ([(Name,Name)])
            _lhsOtypeSignatures :: ([(Name,TpScheme)])
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _simpletypeIname :: (Name)
            _simpletypeIself :: (SimpleType)
            _simpletypeItypevariables :: (Names)
            _typeIcontextRange :: (Range)
            _typeImiscerrors :: ([Error])
            _typeIself :: (Type)
            _typeItypevariables :: (Names)
            _typeIwarnings :: ([Warning])
            _typeOallTypeConstructors :: (Names)
            _typeOmiscerrors :: ([Error])
            _typeOoptions :: ([Option])
            _typeOtypeConstructors :: (M.Map Name Int)
            _typeOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _simpletypeIname,_simpletypeIself,_simpletypeItypevariables) =
                (simpletype_ )
            ( _typeIcontextRange,_typeImiscerrors,_typeIself,_typeItypevariables,_typeIwarnings) =
                (type_ (_typeOallTypeConstructors) (_typeOmiscerrors) (_typeOoptions) (_typeOtypeConstructors) (_typeOwarnings))
            (_typeSynonymInfo@_) =
                (length _simpletypeItypevariables,\tps -> makeTpFromType (zip _simpletypeItypevariables tps) _typeIself)
            (_lhsOcollectTypeSynonyms@_) =
                (_simpletypeIname, _typeSynonymInfo) : _lhsIcollectTypeSynonyms
            (_newErrors@_) =
                checkType _lhsItypeConstructors (_lhsInamesInScope ++ _lhsIallValueConstructors) _typeIself
            (_lhsOkindErrors@_) =
                _newErrors ++ _lhsIkindErrors
            (_lhsOwarnings@_) =
                map (Unused TypeVariable) _unused ++ _lhsIwarnings
            (_lhsOpreviousWasAlsoFB@_) =
                Nothing
            (_undef@_) =
                filter (`notElem` _simpletypeItypevariables) _typeItypevariables
            (_doubles@_) =
                filter ((>1) . length) . group . sort $      _simpletypeItypevariables
            (_unused@_) =
                filter (`notElem` _typeItypevariables)       _simpletypeItypevariables
            (_lhsOmiscerrors@_) =
                concat [ makeDuplicated TypeVariable _doubles
                       , makeUndefined TypeVariable _undef _simpletypeItypevariables
                       , _lhsImiscerrors
                       ]
            (_lhsOcollectInstances@_) =
                []
            (_lhsOdeclVarNames@_) =
                []
            (_lhsOrestrictedNames@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                Declaration_Type _rangeIself _simpletypeIself _typeIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lhsOcollectTypeConstructors@_) =
                _lhsIcollectTypeConstructors
            (_lhsOcollectValueConstructors@_) =
                _lhsIcollectValueConstructors
            (_lhsOoperatorFixities@_) =
                _lhsIoperatorFixities
            (_lhsOsuspiciousFBs@_) =
                _lhsIsuspiciousFBs
            (_lhsOtypeSignatures@_) =
                _lhsItypeSignatures
            (_typeOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_typeOmiscerrors@_) =
                _lhsImiscerrors
            (_typeOoptions@_) =
                _lhsIoptions
            (_typeOtypeConstructors@_) =
                _lhsItypeConstructors
            (_typeOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOcollectTypeConstructors,_lhsOcollectTypeSynonyms,_lhsOcollectValueConstructors,_lhsOdeclVarNames,_lhsOkindErrors,_lhsOmiscerrors,_lhsOoperatorFixities,_lhsOpreviousWasAlsoFB,_lhsOrestrictedNames,_lhsOself,_lhsOsuspiciousFBs,_lhsOtypeSignatures,_lhsOunboundNames,_lhsOwarnings)
sem_Declaration_TypeSignature :: (T_Range) ->
                                 (T_Names) ->
                                 (T_Type) ->
                                 (T_Declaration)
sem_Declaration_TypeSignature (range_) (names_) (type_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIcollectTypeConstructors
      _lhsIcollectTypeSynonyms
      _lhsIcollectValueConstructors
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoperatorFixities
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsIpreviousWasAlsoFB
      _lhsIsuspiciousFBs
      _lhsItypeConstructors
      _lhsItypeSignatures
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOcollectTypeConstructors :: ([(Name,Int)])
            _lhsOcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _lhsOcollectValueConstructors :: ([(Name,TpScheme)])
            _lhsOdeclVarNames :: (Names)
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOoperatorFixities :: ([(Name,(Int,Assoc))])
            _lhsOpreviousWasAlsoFB :: (Maybe Name)
            _lhsOrestrictedNames :: (Names)
            _lhsOself :: (Declaration)
            _lhsOsuspiciousFBs :: ([(Name,Name)])
            _lhsOtypeSignatures :: ([(Name,TpScheme)])
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _namesIself :: (Names)
            _typeIcontextRange :: (Range)
            _typeImiscerrors :: ([Error])
            _typeIself :: (Type)
            _typeItypevariables :: (Names)
            _typeIwarnings :: ([Warning])
            _typeOallTypeConstructors :: (Names)
            _typeOmiscerrors :: ([Error])
            _typeOoptions :: ([Option])
            _typeOtypeConstructors :: (M.Map Name Int)
            _typeOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _namesIself) =
                (names_ )
            ( _typeIcontextRange,_typeImiscerrors,_typeIself,_typeItypevariables,_typeIwarnings) =
                (type_ (_typeOallTypeConstructors) (_typeOmiscerrors) (_typeOoptions) (_typeOtypeConstructors) (_typeOwarnings))
            ((_typeScheme@_,_intMap@_)) =
                makeTpSchemeFromType' _typeIself
            (_lhsOtypeSignatures@_) =
                [ (name, _typeScheme) | name <- _namesIself ] ++ _lhsItypeSignatures
            (_newErrors@_) =
                checkType _lhsItypeConstructors (_lhsInamesInScope ++ _lhsIallValueConstructors) _typeIself
            (_lhsOkindErrors@_) =
                _newErrors ++ _lhsIkindErrors
            (_lhsOpreviousWasAlsoFB@_) =
                Nothing
            (_lhsOwarnings@_) =
                simplifyContext _lhsIorderedTypeSynonyms _typeIcontextRange _intMap _typeScheme ++ _typeIwarnings
            (_lhsOcollectInstances@_) =
                []
            (_lhsOdeclVarNames@_) =
                []
            (_lhsOrestrictedNames@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                Declaration_TypeSignature _rangeIself _namesIself _typeIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lhsOcollectTypeConstructors@_) =
                _lhsIcollectTypeConstructors
            (_lhsOcollectTypeSynonyms@_) =
                _lhsIcollectTypeSynonyms
            (_lhsOcollectValueConstructors@_) =
                _lhsIcollectValueConstructors
            (_lhsOmiscerrors@_) =
                _typeImiscerrors
            (_lhsOoperatorFixities@_) =
                _lhsIoperatorFixities
            (_lhsOsuspiciousFBs@_) =
                _lhsIsuspiciousFBs
            (_typeOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_typeOmiscerrors@_) =
                _lhsImiscerrors
            (_typeOoptions@_) =
                _lhsIoptions
            (_typeOtypeConstructors@_) =
                _lhsItypeConstructors
            (_typeOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOcollectTypeConstructors,_lhsOcollectTypeSynonyms,_lhsOcollectValueConstructors,_lhsOdeclVarNames,_lhsOkindErrors,_lhsOmiscerrors,_lhsOoperatorFixities,_lhsOpreviousWasAlsoFB,_lhsOrestrictedNames,_lhsOself,_lhsOsuspiciousFBs,_lhsOtypeSignatures,_lhsOunboundNames,_lhsOwarnings)
-- Declarations ------------------------------------------------
-- semantic domain
type T_Declarations = (Names) ->
                      (Names) ->
                      (ClassEnvironment) ->
                      ([(ScopeInfo, Entity)]) ->
                      ([(Name,Int)]) ->
                      ([(Name,(Int,Tps -> Tp))]) ->
                      ([(Name,TpScheme)]) ->
                      ([Error]) ->
                      ([Error]) ->
                      (Names) ->
                      ([(Name,(Int,Assoc))]) ->
                      ([Option]) ->
                      (OrderedTypeSynonyms) ->
                      (Maybe Name) ->
                      ([(Name,Name)]) ->
                      (M.Map Name Int) ->
                      ([(Name,TpScheme)]) ->
                      (M.Map Name TpScheme) ->
                      ([Warning]) ->
                      ( ([(Name, Instance)]),([(ScopeInfo, Entity)]),([(Name,Int)]),([(Name,(Int,Tps -> Tp))]),([(Name,TpScheme)]),(Names),([Error]),([Error]),([(Name,(Int,Assoc))]),(Maybe Name),(Names),(Declarations),([(Name,Name)]),([(Name,TpScheme)]),(Names),([Warning]))
-- cata
sem_Declarations :: (Declarations) ->
                    (T_Declarations)
sem_Declarations (list) =
    (Prelude.foldr (sem_Declarations_Cons) (sem_Declarations_Nil) ((Prelude.map sem_Declaration list)))
sem_Declarations_Cons :: (T_Declaration) ->
                         (T_Declarations) ->
                         (T_Declarations)
sem_Declarations_Cons (hd_) (tl_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIcollectTypeConstructors
      _lhsIcollectTypeSynonyms
      _lhsIcollectValueConstructors
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoperatorFixities
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsIpreviousWasAlsoFB
      _lhsIsuspiciousFBs
      _lhsItypeConstructors
      _lhsItypeSignatures
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOcollectTypeConstructors :: ([(Name,Int)])
            _lhsOcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _lhsOcollectValueConstructors :: ([(Name,TpScheme)])
            _lhsOdeclVarNames :: (Names)
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOoperatorFixities :: ([(Name,(Int,Assoc))])
            _lhsOpreviousWasAlsoFB :: (Maybe Name)
            _lhsOrestrictedNames :: (Names)
            _lhsOself :: (Declarations)
            _lhsOsuspiciousFBs :: ([(Name,Name)])
            _lhsOtypeSignatures :: ([(Name,TpScheme)])
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _hdIcollectInstances :: ([(Name, Instance)])
            _hdIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _hdIcollectTypeConstructors :: ([(Name,Int)])
            _hdIcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _hdIcollectValueConstructors :: ([(Name,TpScheme)])
            _hdIdeclVarNames :: (Names)
            _hdIkindErrors :: ([Error])
            _hdImiscerrors :: ([Error])
            _hdIoperatorFixities :: ([(Name,(Int,Assoc))])
            _hdIpreviousWasAlsoFB :: (Maybe Name)
            _hdIrestrictedNames :: (Names)
            _hdIself :: (Declaration)
            _hdIsuspiciousFBs :: ([(Name,Name)])
            _hdItypeSignatures :: ([(Name,TpScheme)])
            _hdIunboundNames :: (Names)
            _hdIwarnings :: ([Warning])
            _hdOallTypeConstructors :: (Names)
            _hdOallValueConstructors :: (Names)
            _hdOclassEnvironment :: (ClassEnvironment)
            _hdOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _hdOcollectTypeConstructors :: ([(Name,Int)])
            _hdOcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _hdOcollectValueConstructors :: ([(Name,TpScheme)])
            _hdOkindErrors :: ([Error])
            _hdOmiscerrors :: ([Error])
            _hdOnamesInScope :: (Names)
            _hdOoperatorFixities :: ([(Name,(Int,Assoc))])
            _hdOoptions :: ([Option])
            _hdOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _hdOpreviousWasAlsoFB :: (Maybe Name)
            _hdOsuspiciousFBs :: ([(Name,Name)])
            _hdOtypeConstructors :: (M.Map Name Int)
            _hdOtypeSignatures :: ([(Name,TpScheme)])
            _hdOvalueConstructors :: (M.Map Name TpScheme)
            _hdOwarnings :: ([Warning])
            _tlIcollectInstances :: ([(Name, Instance)])
            _tlIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _tlIcollectTypeConstructors :: ([(Name,Int)])
            _tlIcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _tlIcollectValueConstructors :: ([(Name,TpScheme)])
            _tlIdeclVarNames :: (Names)
            _tlIkindErrors :: ([Error])
            _tlImiscerrors :: ([Error])
            _tlIoperatorFixities :: ([(Name,(Int,Assoc))])
            _tlIpreviousWasAlsoFB :: (Maybe Name)
            _tlIrestrictedNames :: (Names)
            _tlIself :: (Declarations)
            _tlIsuspiciousFBs :: ([(Name,Name)])
            _tlItypeSignatures :: ([(Name,TpScheme)])
            _tlIunboundNames :: (Names)
            _tlIwarnings :: ([Warning])
            _tlOallTypeConstructors :: (Names)
            _tlOallValueConstructors :: (Names)
            _tlOclassEnvironment :: (ClassEnvironment)
            _tlOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _tlOcollectTypeConstructors :: ([(Name,Int)])
            _tlOcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _tlOcollectValueConstructors :: ([(Name,TpScheme)])
            _tlOkindErrors :: ([Error])
            _tlOmiscerrors :: ([Error])
            _tlOnamesInScope :: (Names)
            _tlOoperatorFixities :: ([(Name,(Int,Assoc))])
            _tlOoptions :: ([Option])
            _tlOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _tlOpreviousWasAlsoFB :: (Maybe Name)
            _tlOsuspiciousFBs :: ([(Name,Name)])
            _tlOtypeConstructors :: (M.Map Name Int)
            _tlOtypeSignatures :: ([(Name,TpScheme)])
            _tlOvalueConstructors :: (M.Map Name TpScheme)
            _tlOwarnings :: ([Warning])
            ( _hdIcollectInstances,_hdIcollectScopeInfos,_hdIcollectTypeConstructors,_hdIcollectTypeSynonyms,_hdIcollectValueConstructors,_hdIdeclVarNames,_hdIkindErrors,_hdImiscerrors,_hdIoperatorFixities,_hdIpreviousWasAlsoFB,_hdIrestrictedNames,_hdIself,_hdIsuspiciousFBs,_hdItypeSignatures,_hdIunboundNames,_hdIwarnings) =
                (hd_ (_hdOallTypeConstructors)
                     (_hdOallValueConstructors)
                     (_hdOclassEnvironment)
                     (_hdOcollectScopeInfos)
                     (_hdOcollectTypeConstructors)
                     (_hdOcollectTypeSynonyms)
                     (_hdOcollectValueConstructors)
                     (_hdOkindErrors)
                     (_hdOmiscerrors)
                     (_hdOnamesInScope)
                     (_hdOoperatorFixities)
                     (_hdOoptions)
                     (_hdOorderedTypeSynonyms)
                     (_hdOpreviousWasAlsoFB)
                     (_hdOsuspiciousFBs)
                     (_hdOtypeConstructors)
                     (_hdOtypeSignatures)
                     (_hdOvalueConstructors)
                     (_hdOwarnings))
            ( _tlIcollectInstances,_tlIcollectScopeInfos,_tlIcollectTypeConstructors,_tlIcollectTypeSynonyms,_tlIcollectValueConstructors,_tlIdeclVarNames,_tlIkindErrors,_tlImiscerrors,_tlIoperatorFixities,_tlIpreviousWasAlsoFB,_tlIrestrictedNames,_tlIself,_tlIsuspiciousFBs,_tlItypeSignatures,_tlIunboundNames,_tlIwarnings) =
                (tl_ (_tlOallTypeConstructors)
                     (_tlOallValueConstructors)
                     (_tlOclassEnvironment)
                     (_tlOcollectScopeInfos)
                     (_tlOcollectTypeConstructors)
                     (_tlOcollectTypeSynonyms)
                     (_tlOcollectValueConstructors)
                     (_tlOkindErrors)
                     (_tlOmiscerrors)
                     (_tlOnamesInScope)
                     (_tlOoperatorFixities)
                     (_tlOoptions)
                     (_tlOorderedTypeSynonyms)
                     (_tlOpreviousWasAlsoFB)
                     (_tlOsuspiciousFBs)
                     (_tlOtypeConstructors)
                     (_tlOtypeSignatures)
                     (_tlOvalueConstructors)
                     (_tlOwarnings))
            (_lhsOcollectInstances@_) =
                _hdIcollectInstances  ++  _tlIcollectInstances
            (_lhsOdeclVarNames@_) =
                _hdIdeclVarNames ++ _tlIdeclVarNames
            (_lhsOrestrictedNames@_) =
                _hdIrestrictedNames  ++  _tlIrestrictedNames
            (_lhsOunboundNames@_) =
                _hdIunboundNames ++ _tlIunboundNames
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _tlIcollectScopeInfos
            (_lhsOcollectTypeConstructors@_) =
                _tlIcollectTypeConstructors
            (_lhsOcollectTypeSynonyms@_) =
                _tlIcollectTypeSynonyms
            (_lhsOcollectValueConstructors@_) =
                _tlIcollectValueConstructors
            (_lhsOkindErrors@_) =
                _tlIkindErrors
            (_lhsOmiscerrors@_) =
                _tlImiscerrors
            (_lhsOoperatorFixities@_) =
                _tlIoperatorFixities
            (_lhsOpreviousWasAlsoFB@_) =
                _tlIpreviousWasAlsoFB
            (_lhsOsuspiciousFBs@_) =
                _tlIsuspiciousFBs
            (_lhsOtypeSignatures@_) =
                _tlItypeSignatures
            (_lhsOwarnings@_) =
                _tlIwarnings
            (_hdOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_hdOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_hdOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_hdOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_hdOcollectTypeConstructors@_) =
                _lhsIcollectTypeConstructors
            (_hdOcollectTypeSynonyms@_) =
                _lhsIcollectTypeSynonyms
            (_hdOcollectValueConstructors@_) =
                _lhsIcollectValueConstructors
            (_hdOkindErrors@_) =
                _lhsIkindErrors
            (_hdOmiscerrors@_) =
                _lhsImiscerrors
            (_hdOnamesInScope@_) =
                _lhsInamesInScope
            (_hdOoperatorFixities@_) =
                _lhsIoperatorFixities
            (_hdOoptions@_) =
                _lhsIoptions
            (_hdOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_hdOpreviousWasAlsoFB@_) =
                _lhsIpreviousWasAlsoFB
            (_hdOsuspiciousFBs@_) =
                _lhsIsuspiciousFBs
            (_hdOtypeConstructors@_) =
                _lhsItypeConstructors
            (_hdOtypeSignatures@_) =
                _lhsItypeSignatures
            (_hdOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_hdOwarnings@_) =
                _lhsIwarnings
            (_tlOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_tlOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_tlOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_tlOcollectScopeInfos@_) =
                _hdIcollectScopeInfos
            (_tlOcollectTypeConstructors@_) =
                _hdIcollectTypeConstructors
            (_tlOcollectTypeSynonyms@_) =
                _hdIcollectTypeSynonyms
            (_tlOcollectValueConstructors@_) =
                _hdIcollectValueConstructors
            (_tlOkindErrors@_) =
                _hdIkindErrors
            (_tlOmiscerrors@_) =
                _hdImiscerrors
            (_tlOnamesInScope@_) =
                _lhsInamesInScope
            (_tlOoperatorFixities@_) =
                _hdIoperatorFixities
            (_tlOoptions@_) =
                _lhsIoptions
            (_tlOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_tlOpreviousWasAlsoFB@_) =
                _hdIpreviousWasAlsoFB
            (_tlOsuspiciousFBs@_) =
                _hdIsuspiciousFBs
            (_tlOtypeConstructors@_) =
                _lhsItypeConstructors
            (_tlOtypeSignatures@_) =
                _hdItypeSignatures
            (_tlOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_tlOwarnings@_) =
                _hdIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOcollectTypeConstructors,_lhsOcollectTypeSynonyms,_lhsOcollectValueConstructors,_lhsOdeclVarNames,_lhsOkindErrors,_lhsOmiscerrors,_lhsOoperatorFixities,_lhsOpreviousWasAlsoFB,_lhsOrestrictedNames,_lhsOself,_lhsOsuspiciousFBs,_lhsOtypeSignatures,_lhsOunboundNames,_lhsOwarnings)
sem_Declarations_Nil :: (T_Declarations)
sem_Declarations_Nil  =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIcollectTypeConstructors
      _lhsIcollectTypeSynonyms
      _lhsIcollectValueConstructors
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoperatorFixities
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsIpreviousWasAlsoFB
      _lhsIsuspiciousFBs
      _lhsItypeConstructors
      _lhsItypeSignatures
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOcollectTypeConstructors :: ([(Name,Int)])
            _lhsOcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _lhsOcollectValueConstructors :: ([(Name,TpScheme)])
            _lhsOdeclVarNames :: (Names)
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOoperatorFixities :: ([(Name,(Int,Assoc))])
            _lhsOpreviousWasAlsoFB :: (Maybe Name)
            _lhsOrestrictedNames :: (Names)
            _lhsOself :: (Declarations)
            _lhsOsuspiciousFBs :: ([(Name,Name)])
            _lhsOtypeSignatures :: ([(Name,TpScheme)])
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            (_lhsOcollectInstances@_) =
                []
            (_lhsOdeclVarNames@_) =
                []
            (_lhsOrestrictedNames@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lhsOcollectTypeConstructors@_) =
                _lhsIcollectTypeConstructors
            (_lhsOcollectTypeSynonyms@_) =
                _lhsIcollectTypeSynonyms
            (_lhsOcollectValueConstructors@_) =
                _lhsIcollectValueConstructors
            (_lhsOkindErrors@_) =
                _lhsIkindErrors
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
            (_lhsOoperatorFixities@_) =
                _lhsIoperatorFixities
            (_lhsOpreviousWasAlsoFB@_) =
                _lhsIpreviousWasAlsoFB
            (_lhsOsuspiciousFBs@_) =
                _lhsIsuspiciousFBs
            (_lhsOtypeSignatures@_) =
                _lhsItypeSignatures
            (_lhsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOcollectTypeConstructors,_lhsOcollectTypeSynonyms,_lhsOcollectValueConstructors,_lhsOdeclVarNames,_lhsOkindErrors,_lhsOmiscerrors,_lhsOoperatorFixities,_lhsOpreviousWasAlsoFB,_lhsOrestrictedNames,_lhsOself,_lhsOsuspiciousFBs,_lhsOtypeSignatures,_lhsOunboundNames,_lhsOwarnings)
-- Export ------------------------------------------------------
-- semantic domain
type T_Export = (Names) ->
                (Names) ->
                (Names) ->
                (Names) ->
                ( ([Error]),(Export))
-- cata
sem_Export :: (Export) ->
              (T_Export)
sem_Export ((Export_Module (_range) (_name))) =
    (sem_Export_Module ((sem_Range (_range))) ((sem_Name (_name))))
sem_Export ((Export_TypeOrClass (_range) (_name) (_names))) =
    (sem_Export_TypeOrClass ((sem_Range (_range))) ((sem_Name (_name))) ((sem_MaybeNames (_names))))
sem_Export ((Export_TypeOrClassComplete (_range) (_name))) =
    (sem_Export_TypeOrClassComplete ((sem_Range (_range))) ((sem_Name (_name))))
sem_Export ((Export_Variable (_range) (_name))) =
    (sem_Export_Variable ((sem_Range (_range))) ((sem_Name (_name))))
sem_Export_Module :: (T_Range) ->
                     (T_Name) ->
                     (T_Export)
sem_Export_Module (range_) (name_) =
    \ _lhsIconsInScope
      _lhsImodulesInScope
      _lhsInamesInScop
      _lhsItyconsInScope ->
        let _lhsOexportErrors :: ([Error])
            _lhsOself :: (Export)
            _rangeIself :: (Range)
            _nameIself :: (Name)
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            (_lhsOexportErrors@_) =
                checkExport ExportModule _nameIself
                   _lhsImodulesInScope
            (_self@_) =
                Export_Module _rangeIself _nameIself
            (_lhsOself@_) =
                _self
        in  ( _lhsOexportErrors,_lhsOself)
sem_Export_TypeOrClass :: (T_Range) ->
                          (T_Name) ->
                          (T_MaybeNames) ->
                          (T_Export)
sem_Export_TypeOrClass (range_) (name_) (names_) =
    \ _lhsIconsInScope
      _lhsImodulesInScope
      _lhsInamesInScop
      _lhsItyconsInScope ->
        let _lhsOexportErrors :: ([Error])
            _lhsOself :: (Export)
            _rangeIself :: (Range)
            _nameIself :: (Name)
            _namesIself :: (MaybeNames)
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            ( _namesIself) =
                (names_ )
            (_lhsOexportErrors@_) =
                []
            (_self@_) =
                Export_TypeOrClass _rangeIself _nameIself _namesIself
            (_lhsOself@_) =
                _self
        in  ( _lhsOexportErrors,_lhsOself)
sem_Export_TypeOrClassComplete :: (T_Range) ->
                                  (T_Name) ->
                                  (T_Export)
sem_Export_TypeOrClassComplete (range_) (name_) =
    \ _lhsIconsInScope
      _lhsImodulesInScope
      _lhsInamesInScop
      _lhsItyconsInScope ->
        let _lhsOexportErrors :: ([Error])
            _lhsOself :: (Export)
            _rangeIself :: (Range)
            _nameIself :: (Name)
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            (_lhsOexportErrors@_) =
                []
            (_self@_) =
                Export_TypeOrClassComplete _rangeIself _nameIself
            (_lhsOself@_) =
                _self
        in  ( _lhsOexportErrors,_lhsOself)
sem_Export_Variable :: (T_Range) ->
                       (T_Name) ->
                       (T_Export)
sem_Export_Variable (range_) (name_) =
    \ _lhsIconsInScope
      _lhsImodulesInScope
      _lhsInamesInScop
      _lhsItyconsInScope ->
        let _lhsOexportErrors :: ([Error])
            _lhsOself :: (Export)
            _rangeIself :: (Range)
            _nameIself :: (Name)
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            (_lhsOexportErrors@_) =
                checkExport ExportVariable _nameIself
                   _lhsInamesInScop
            (_self@_) =
                Export_Variable _rangeIself _nameIself
            (_lhsOself@_) =
                _self
        in  ( _lhsOexportErrors,_lhsOself)
-- Exports -----------------------------------------------------
-- semantic domain
type T_Exports = (Names) ->
                 (Names) ->
                 (Names) ->
                 (Names) ->
                 ( ([Error]),(Exports))
-- cata
sem_Exports :: (Exports) ->
               (T_Exports)
sem_Exports (list) =
    (Prelude.foldr (sem_Exports_Cons) (sem_Exports_Nil) ((Prelude.map sem_Export list)))
sem_Exports_Cons :: (T_Export) ->
                    (T_Exports) ->
                    (T_Exports)
sem_Exports_Cons (hd_) (tl_) =
    \ _lhsIconsInScope
      _lhsImodulesInScope
      _lhsInamesInScop
      _lhsItyconsInScope ->
        let _lhsOexportErrors :: ([Error])
            _lhsOself :: (Exports)
            _hdIexportErrors :: ([Error])
            _hdIself :: (Export)
            _hdOconsInScope :: (Names)
            _hdOmodulesInScope :: (Names)
            _hdOnamesInScop :: (Names)
            _hdOtyconsInScope :: (Names)
            _tlIexportErrors :: ([Error])
            _tlIself :: (Exports)
            _tlOconsInScope :: (Names)
            _tlOmodulesInScope :: (Names)
            _tlOnamesInScop :: (Names)
            _tlOtyconsInScope :: (Names)
            ( _hdIexportErrors,_hdIself) =
                (hd_ (_hdOconsInScope) (_hdOmodulesInScope) (_hdOnamesInScop) (_hdOtyconsInScope))
            ( _tlIexportErrors,_tlIself) =
                (tl_ (_tlOconsInScope) (_tlOmodulesInScope) (_tlOnamesInScop) (_tlOtyconsInScope))
            (_lhsOexportErrors@_) =
                _hdIexportErrors  ++  _tlIexportErrors
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_hdOconsInScope@_) =
                _lhsIconsInScope
            (_hdOmodulesInScope@_) =
                _lhsImodulesInScope
            (_hdOnamesInScop@_) =
                _lhsInamesInScop
            (_hdOtyconsInScope@_) =
                _lhsItyconsInScope
            (_tlOconsInScope@_) =
                _lhsIconsInScope
            (_tlOmodulesInScope@_) =
                _lhsImodulesInScope
            (_tlOnamesInScop@_) =
                _lhsInamesInScop
            (_tlOtyconsInScope@_) =
                _lhsItyconsInScope
        in  ( _lhsOexportErrors,_lhsOself)
sem_Exports_Nil :: (T_Exports)
sem_Exports_Nil  =
    \ _lhsIconsInScope
      _lhsImodulesInScope
      _lhsInamesInScop
      _lhsItyconsInScope ->
        let _lhsOexportErrors :: ([Error])
            _lhsOself :: (Exports)
            (_lhsOexportErrors@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
        in  ( _lhsOexportErrors,_lhsOself)
-- Expression --------------------------------------------------
-- semantic domain
type T_Expression = (Names) ->
                    (Names) ->
                    (ClassEnvironment) ->
                    ([(ScopeInfo, Entity)]) ->
                    ([Error]) ->
                    ([Error]) ->
                    (Names) ->
                    ([Option]) ->
                    (OrderedTypeSynonyms) ->
                    (M.Map Name Int) ->
                    (M.Map Name TpScheme) ->
                    ([Warning]) ->
                    ( ([(Name, Instance)]),([(ScopeInfo, Entity)]),([Error]),([Error]),(Expression),(Names),([Warning]))
-- cata
sem_Expression :: (Expression) ->
                  (T_Expression)
sem_Expression ((Expression_Case (_range) (_expression) (_alternatives))) =
    (sem_Expression_Case ((sem_Range (_range))) ((sem_Expression (_expression))) ((sem_Alternatives (_alternatives))))
sem_Expression ((Expression_Comprehension (_range) (_expression) (_qualifiers))) =
    (sem_Expression_Comprehension ((sem_Range (_range))) ((sem_Expression (_expression))) ((sem_Qualifiers (_qualifiers))))
sem_Expression ((Expression_Constructor (_range) (_name))) =
    (sem_Expression_Constructor ((sem_Range (_range))) ((sem_Name (_name))))
sem_Expression ((Expression_Do (_range) (_statements))) =
    (sem_Expression_Do ((sem_Range (_range))) ((sem_Statements (_statements))))
sem_Expression ((Expression_Enum (_range) (_from) (_then) (_to))) =
    (sem_Expression_Enum ((sem_Range (_range))) ((sem_Expression (_from))) ((sem_MaybeExpression (_then))) ((sem_MaybeExpression (_to))))
sem_Expression ((Expression_If (_range) (_guardExpression) (_thenExpression) (_elseExpression))) =
    (sem_Expression_If ((sem_Range (_range))) ((sem_Expression (_guardExpression))) ((sem_Expression (_thenExpression))) ((sem_Expression (_elseExpression))))
sem_Expression ((Expression_InfixApplication (_range) (_leftExpression) (_operator) (_rightExpression))) =
    (sem_Expression_InfixApplication ((sem_Range (_range))) ((sem_MaybeExpression (_leftExpression))) ((sem_Expression (_operator))) ((sem_MaybeExpression (_rightExpression))))
sem_Expression ((Expression_Lambda (_range) (_patterns) (_expression))) =
    (sem_Expression_Lambda ((sem_Range (_range))) ((sem_Patterns (_patterns))) ((sem_Expression (_expression))))
sem_Expression ((Expression_Let (_range) (_declarations) (_expression))) =
    (sem_Expression_Let ((sem_Range (_range))) ((sem_Declarations (_declarations))) ((sem_Expression (_expression))))
sem_Expression ((Expression_List (_range) (_expressions))) =
    (sem_Expression_List ((sem_Range (_range))) ((sem_Expressions (_expressions))))
sem_Expression ((Expression_Literal (_range) (_literal))) =
    (sem_Expression_Literal ((sem_Range (_range))) ((sem_Literal (_literal))))
sem_Expression ((Expression_Negate (_range) (_expression))) =
    (sem_Expression_Negate ((sem_Range (_range))) ((sem_Expression (_expression))))
sem_Expression ((Expression_NegateFloat (_range) (_expression))) =
    (sem_Expression_NegateFloat ((sem_Range (_range))) ((sem_Expression (_expression))))
sem_Expression ((Expression_NormalApplication (_range) (_function) (_arguments))) =
    (sem_Expression_NormalApplication ((sem_Range (_range))) ((sem_Expression (_function))) ((sem_Expressions (_arguments))))
sem_Expression ((Expression_Parenthesized (_range) (_expression))) =
    (sem_Expression_Parenthesized ((sem_Range (_range))) ((sem_Expression (_expression))))
sem_Expression ((Expression_RecordConstruction (_range) (_name) (_recordExpressionBindings))) =
    (sem_Expression_RecordConstruction ((sem_Range (_range))) ((sem_Name (_name))) ((sem_RecordExpressionBindings (_recordExpressionBindings))))
sem_Expression ((Expression_RecordUpdate (_range) (_expression) (_recordExpressionBindings))) =
    (sem_Expression_RecordUpdate ((sem_Range (_range))) ((sem_Expression (_expression))) ((sem_RecordExpressionBindings (_recordExpressionBindings))))
sem_Expression ((Expression_Tuple (_range) (_expressions))) =
    (sem_Expression_Tuple ((sem_Range (_range))) ((sem_Expressions (_expressions))))
sem_Expression ((Expression_Typed (_range) (_expression) (_type))) =
    (sem_Expression_Typed ((sem_Range (_range))) ((sem_Expression (_expression))) ((sem_Type (_type))))
sem_Expression ((Expression_Variable (_range) (_name))) =
    (sem_Expression_Variable ((sem_Range (_range))) ((sem_Name (_name))))
sem_Expression_Case :: (T_Range) ->
                       (T_Expression) ->
                       (T_Alternatives) ->
                       (T_Expression)
sem_Expression_Case (range_) (expression_) (alternatives_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionIkindErrors :: ([Error])
            _expressionImiscerrors :: ([Error])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIwarnings :: ([Warning])
            _expressionOallTypeConstructors :: (Names)
            _expressionOallValueConstructors :: (Names)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionOkindErrors :: ([Error])
            _expressionOmiscerrors :: ([Error])
            _expressionOnamesInScope :: (Names)
            _expressionOoptions :: ([Option])
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOtypeConstructors :: (M.Map Name Int)
            _expressionOvalueConstructors :: (M.Map Name TpScheme)
            _expressionOwarnings :: ([Warning])
            _alternativesIcollectInstances :: ([(Name, Instance)])
            _alternativesIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _alternativesIkindErrors :: ([Error])
            _alternativesImiscerrors :: ([Error])
            _alternativesIself :: (Alternatives)
            _alternativesIunboundNames :: (Names)
            _alternativesIwarnings :: ([Warning])
            _alternativesOallTypeConstructors :: (Names)
            _alternativesOallValueConstructors :: (Names)
            _alternativesOclassEnvironment :: (ClassEnvironment)
            _alternativesOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _alternativesOkindErrors :: ([Error])
            _alternativesOmiscerrors :: ([Error])
            _alternativesOnamesInScope :: (Names)
            _alternativesOoptions :: ([Option])
            _alternativesOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _alternativesOtypeConstructors :: (M.Map Name Int)
            _alternativesOvalueConstructors :: (M.Map Name TpScheme)
            _alternativesOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _expressionIcollectInstances,_expressionIcollectScopeInfos,_expressionIkindErrors,_expressionImiscerrors,_expressionIself,_expressionIunboundNames,_expressionIwarnings) =
                (expression_ (_expressionOallTypeConstructors) (_expressionOallValueConstructors) (_expressionOclassEnvironment) (_expressionOcollectScopeInfos) (_expressionOkindErrors) (_expressionOmiscerrors) (_expressionOnamesInScope) (_expressionOoptions) (_expressionOorderedTypeSynonyms) (_expressionOtypeConstructors) (_expressionOvalueConstructors) (_expressionOwarnings))
            ( _alternativesIcollectInstances,_alternativesIcollectScopeInfos,_alternativesIkindErrors,_alternativesImiscerrors,_alternativesIself,_alternativesIunboundNames,_alternativesIwarnings) =
                (alternatives_ (_alternativesOallTypeConstructors) (_alternativesOallValueConstructors) (_alternativesOclassEnvironment) (_alternativesOcollectScopeInfos) (_alternativesOkindErrors) (_alternativesOmiscerrors) (_alternativesOnamesInScope) (_alternativesOoptions) (_alternativesOorderedTypeSynonyms) (_alternativesOtypeConstructors) (_alternativesOvalueConstructors) (_alternativesOwarnings))
            (_lhsOcollectInstances@_) =
                _expressionIcollectInstances  ++  _alternativesIcollectInstances
            (_lhsOunboundNames@_) =
                _expressionIunboundNames ++ _alternativesIunboundNames
            (_self@_) =
                Expression_Case _rangeIself _expressionIself _alternativesIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _alternativesIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _alternativesIkindErrors
            (_lhsOmiscerrors@_) =
                _alternativesImiscerrors
            (_lhsOwarnings@_) =
                _alternativesIwarnings
            (_expressionOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_expressionOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_expressionOkindErrors@_) =
                _lhsIkindErrors
            (_expressionOmiscerrors@_) =
                _lhsImiscerrors
            (_expressionOnamesInScope@_) =
                _lhsInamesInScope
            (_expressionOoptions@_) =
                _lhsIoptions
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOtypeConstructors@_) =
                _lhsItypeConstructors
            (_expressionOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_expressionOwarnings@_) =
                _lhsIwarnings
            (_alternativesOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_alternativesOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_alternativesOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_alternativesOcollectScopeInfos@_) =
                _expressionIcollectScopeInfos
            (_alternativesOkindErrors@_) =
                _expressionIkindErrors
            (_alternativesOmiscerrors@_) =
                _expressionImiscerrors
            (_alternativesOnamesInScope@_) =
                _lhsInamesInScope
            (_alternativesOoptions@_) =
                _lhsIoptions
            (_alternativesOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_alternativesOtypeConstructors@_) =
                _lhsItypeConstructors
            (_alternativesOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_alternativesOwarnings@_) =
                _expressionIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Expression_Comprehension :: (T_Range) ->
                                (T_Expression) ->
                                (T_Qualifiers) ->
                                (T_Expression)
sem_Expression_Comprehension (range_) (expression_) (qualifiers_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionIkindErrors :: ([Error])
            _expressionImiscerrors :: ([Error])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIwarnings :: ([Warning])
            _expressionOallTypeConstructors :: (Names)
            _expressionOallValueConstructors :: (Names)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionOkindErrors :: ([Error])
            _expressionOmiscerrors :: ([Error])
            _expressionOnamesInScope :: (Names)
            _expressionOoptions :: ([Option])
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOtypeConstructors :: (M.Map Name Int)
            _expressionOvalueConstructors :: (M.Map Name TpScheme)
            _expressionOwarnings :: ([Warning])
            _qualifiersIcollectInstances :: ([(Name, Instance)])
            _qualifiersIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _qualifiersIkindErrors :: ([Error])
            _qualifiersImiscerrors :: ([Error])
            _qualifiersInamesInScope :: (Names)
            _qualifiersIself :: (Qualifiers)
            _qualifiersIunboundNames :: (Names)
            _qualifiersIwarnings :: ([Warning])
            _qualifiersOallTypeConstructors :: (Names)
            _qualifiersOallValueConstructors :: (Names)
            _qualifiersOclassEnvironment :: (ClassEnvironment)
            _qualifiersOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _qualifiersOkindErrors :: ([Error])
            _qualifiersOmiscerrors :: ([Error])
            _qualifiersOnamesInScope :: (Names)
            _qualifiersOoptions :: ([Option])
            _qualifiersOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _qualifiersOtypeConstructors :: (M.Map Name Int)
            _qualifiersOunboundNames :: (Names)
            _qualifiersOvalueConstructors :: (M.Map Name TpScheme)
            _qualifiersOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _expressionIcollectInstances,_expressionIcollectScopeInfos,_expressionIkindErrors,_expressionImiscerrors,_expressionIself,_expressionIunboundNames,_expressionIwarnings) =
                (expression_ (_expressionOallTypeConstructors) (_expressionOallValueConstructors) (_expressionOclassEnvironment) (_expressionOcollectScopeInfos) (_expressionOkindErrors) (_expressionOmiscerrors) (_expressionOnamesInScope) (_expressionOoptions) (_expressionOorderedTypeSynonyms) (_expressionOtypeConstructors) (_expressionOvalueConstructors) (_expressionOwarnings))
            ( _qualifiersIcollectInstances,_qualifiersIcollectScopeInfos,_qualifiersIkindErrors,_qualifiersImiscerrors,_qualifiersInamesInScope,_qualifiersIself,_qualifiersIunboundNames,_qualifiersIwarnings) =
                (qualifiers_ (_qualifiersOallTypeConstructors) (_qualifiersOallValueConstructors) (_qualifiersOclassEnvironment) (_qualifiersOcollectScopeInfos) (_qualifiersOkindErrors) (_qualifiersOmiscerrors) (_qualifiersOnamesInScope) (_qualifiersOoptions) (_qualifiersOorderedTypeSynonyms) (_qualifiersOtypeConstructors) (_qualifiersOunboundNames) (_qualifiersOvalueConstructors) (_qualifiersOwarnings))
            (_qualifiersOunboundNames@_) =
                _expressionIunboundNames
            (_qualifiersOnamesInScope@_) =
                _lhsInamesInScope
            (_expressionOnamesInScope@_) =
                _qualifiersInamesInScope
            (_lhsOunboundNames@_) =
                _qualifiersIunboundNames
            (_lhsOcollectInstances@_) =
                _expressionIcollectInstances  ++  _qualifiersIcollectInstances
            (_self@_) =
                Expression_Comprehension _rangeIself _expressionIself _qualifiersIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _qualifiersIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _qualifiersIkindErrors
            (_lhsOmiscerrors@_) =
                _qualifiersImiscerrors
            (_lhsOwarnings@_) =
                _qualifiersIwarnings
            (_expressionOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_expressionOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_expressionOkindErrors@_) =
                _lhsIkindErrors
            (_expressionOmiscerrors@_) =
                _lhsImiscerrors
            (_expressionOoptions@_) =
                _lhsIoptions
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOtypeConstructors@_) =
                _lhsItypeConstructors
            (_expressionOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_expressionOwarnings@_) =
                _lhsIwarnings
            (_qualifiersOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_qualifiersOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_qualifiersOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_qualifiersOcollectScopeInfos@_) =
                _expressionIcollectScopeInfos
            (_qualifiersOkindErrors@_) =
                _expressionIkindErrors
            (_qualifiersOmiscerrors@_) =
                _expressionImiscerrors
            (_qualifiersOoptions@_) =
                _lhsIoptions
            (_qualifiersOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_qualifiersOtypeConstructors@_) =
                _lhsItypeConstructors
            (_qualifiersOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_qualifiersOwarnings@_) =
                _expressionIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Expression_Constructor :: (T_Range) ->
                              (T_Name) ->
                              (T_Expression)
sem_Expression_Constructor (range_) (name_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _nameIself :: (Name)
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            (_undefinedConstructorErrors@_) =
                case M.lookup _nameIself _lhsIvalueConstructors of
                   Nothing -> [ undefinedConstructorInExpr _nameIself (_lhsInamesInScope ++ _lhsIallValueConstructors) _lhsIallTypeConstructors ]
                   Just _  -> []
            (_lhsOmiscerrors@_) =
                _undefinedConstructorErrors ++ _lhsImiscerrors
            (_lhsOcollectInstances@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                Expression_Constructor _rangeIself _nameIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _lhsIkindErrors
            (_lhsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Expression_Do :: (T_Range) ->
                     (T_Statements) ->
                     (T_Expression)
sem_Expression_Do (range_) (statements_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _statementsIcollectInstances :: ([(Name, Instance)])
            _statementsIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _statementsIkindErrors :: ([Error])
            _statementsIlastStatementIsExpr :: (Bool)
            _statementsImiscerrors :: ([Error])
            _statementsInamesInScope :: (Names)
            _statementsIself :: (Statements)
            _statementsIunboundNames :: (Names)
            _statementsIwarnings :: ([Warning])
            _statementsOallTypeConstructors :: (Names)
            _statementsOallValueConstructors :: (Names)
            _statementsOclassEnvironment :: (ClassEnvironment)
            _statementsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _statementsOkindErrors :: ([Error])
            _statementsOlastStatementIsExpr :: (Bool)
            _statementsOmiscerrors :: ([Error])
            _statementsOnamesInScope :: (Names)
            _statementsOoptions :: ([Option])
            _statementsOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _statementsOtypeConstructors :: (M.Map Name Int)
            _statementsOunboundNames :: (Names)
            _statementsOvalueConstructors :: (M.Map Name TpScheme)
            _statementsOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _statementsIcollectInstances,_statementsIcollectScopeInfos,_statementsIkindErrors,_statementsIlastStatementIsExpr,_statementsImiscerrors,_statementsInamesInScope,_statementsIself,_statementsIunboundNames,_statementsIwarnings) =
                (statements_ (_statementsOallTypeConstructors) (_statementsOallValueConstructors) (_statementsOclassEnvironment) (_statementsOcollectScopeInfos) (_statementsOkindErrors) (_statementsOlastStatementIsExpr) (_statementsOmiscerrors) (_statementsOnamesInScope) (_statementsOoptions) (_statementsOorderedTypeSynonyms) (_statementsOtypeConstructors) (_statementsOunboundNames) (_statementsOvalueConstructors) (_statementsOwarnings))
            (_statementsOunboundNames@_) =
                []
            (_statementsOlastStatementIsExpr@_) =
                False
            (_lastStatementErrors@_) =
                if _statementsIlastStatementIsExpr
                  then []
                  else let range = getStatementRange (last _statementsIself)
                       in [ LastStatementNotExpr range ]
            (_lhsOmiscerrors@_) =
                _lastStatementErrors ++ _statementsImiscerrors
            (_lhsOcollectInstances@_) =
                _statementsIcollectInstances
            (_lhsOunboundNames@_) =
                _statementsIunboundNames
            (_self@_) =
                Expression_Do _rangeIself _statementsIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _statementsIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _statementsIkindErrors
            (_lhsOwarnings@_) =
                _statementsIwarnings
            (_statementsOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_statementsOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_statementsOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_statementsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_statementsOkindErrors@_) =
                _lhsIkindErrors
            (_statementsOmiscerrors@_) =
                _lhsImiscerrors
            (_statementsOnamesInScope@_) =
                _lhsInamesInScope
            (_statementsOoptions@_) =
                _lhsIoptions
            (_statementsOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_statementsOtypeConstructors@_) =
                _lhsItypeConstructors
            (_statementsOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_statementsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Expression_Enum :: (T_Range) ->
                       (T_Expression) ->
                       (T_MaybeExpression) ->
                       (T_MaybeExpression) ->
                       (T_Expression)
sem_Expression_Enum (range_) (from_) (then_) (to_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _fromIcollectInstances :: ([(Name, Instance)])
            _fromIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _fromIkindErrors :: ([Error])
            _fromImiscerrors :: ([Error])
            _fromIself :: (Expression)
            _fromIunboundNames :: (Names)
            _fromIwarnings :: ([Warning])
            _fromOallTypeConstructors :: (Names)
            _fromOallValueConstructors :: (Names)
            _fromOclassEnvironment :: (ClassEnvironment)
            _fromOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _fromOkindErrors :: ([Error])
            _fromOmiscerrors :: ([Error])
            _fromOnamesInScope :: (Names)
            _fromOoptions :: ([Option])
            _fromOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _fromOtypeConstructors :: (M.Map Name Int)
            _fromOvalueConstructors :: (M.Map Name TpScheme)
            _fromOwarnings :: ([Warning])
            _thenIcollectInstances :: ([(Name, Instance)])
            _thenIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _thenIkindErrors :: ([Error])
            _thenImiscerrors :: ([Error])
            _thenIself :: (MaybeExpression)
            _thenIunboundNames :: (Names)
            _thenIwarnings :: ([Warning])
            _thenOallTypeConstructors :: (Names)
            _thenOallValueConstructors :: (Names)
            _thenOclassEnvironment :: (ClassEnvironment)
            _thenOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _thenOkindErrors :: ([Error])
            _thenOmiscerrors :: ([Error])
            _thenOnamesInScope :: (Names)
            _thenOoptions :: ([Option])
            _thenOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _thenOtypeConstructors :: (M.Map Name Int)
            _thenOvalueConstructors :: (M.Map Name TpScheme)
            _thenOwarnings :: ([Warning])
            _toIcollectInstances :: ([(Name, Instance)])
            _toIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _toIkindErrors :: ([Error])
            _toImiscerrors :: ([Error])
            _toIself :: (MaybeExpression)
            _toIunboundNames :: (Names)
            _toIwarnings :: ([Warning])
            _toOallTypeConstructors :: (Names)
            _toOallValueConstructors :: (Names)
            _toOclassEnvironment :: (ClassEnvironment)
            _toOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _toOkindErrors :: ([Error])
            _toOmiscerrors :: ([Error])
            _toOnamesInScope :: (Names)
            _toOoptions :: ([Option])
            _toOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _toOtypeConstructors :: (M.Map Name Int)
            _toOvalueConstructors :: (M.Map Name TpScheme)
            _toOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _fromIcollectInstances,_fromIcollectScopeInfos,_fromIkindErrors,_fromImiscerrors,_fromIself,_fromIunboundNames,_fromIwarnings) =
                (from_ (_fromOallTypeConstructors) (_fromOallValueConstructors) (_fromOclassEnvironment) (_fromOcollectScopeInfos) (_fromOkindErrors) (_fromOmiscerrors) (_fromOnamesInScope) (_fromOoptions) (_fromOorderedTypeSynonyms) (_fromOtypeConstructors) (_fromOvalueConstructors) (_fromOwarnings))
            ( _thenIcollectInstances,_thenIcollectScopeInfos,_thenIkindErrors,_thenImiscerrors,_thenIself,_thenIunboundNames,_thenIwarnings) =
                (then_ (_thenOallTypeConstructors) (_thenOallValueConstructors) (_thenOclassEnvironment) (_thenOcollectScopeInfos) (_thenOkindErrors) (_thenOmiscerrors) (_thenOnamesInScope) (_thenOoptions) (_thenOorderedTypeSynonyms) (_thenOtypeConstructors) (_thenOvalueConstructors) (_thenOwarnings))
            ( _toIcollectInstances,_toIcollectScopeInfos,_toIkindErrors,_toImiscerrors,_toIself,_toIunboundNames,_toIwarnings) =
                (to_ (_toOallTypeConstructors) (_toOallValueConstructors) (_toOclassEnvironment) (_toOcollectScopeInfos) (_toOkindErrors) (_toOmiscerrors) (_toOnamesInScope) (_toOoptions) (_toOorderedTypeSynonyms) (_toOtypeConstructors) (_toOvalueConstructors) (_toOwarnings))
            (_lhsOcollectInstances@_) =
                _fromIcollectInstances  ++  _thenIcollectInstances  ++  _toIcollectInstances
            (_lhsOunboundNames@_) =
                _fromIunboundNames ++ _thenIunboundNames ++ _toIunboundNames
            (_self@_) =
                Expression_Enum _rangeIself _fromIself _thenIself _toIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _toIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _toIkindErrors
            (_lhsOmiscerrors@_) =
                _toImiscerrors
            (_lhsOwarnings@_) =
                _toIwarnings
            (_fromOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_fromOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_fromOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_fromOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_fromOkindErrors@_) =
                _lhsIkindErrors
            (_fromOmiscerrors@_) =
                _lhsImiscerrors
            (_fromOnamesInScope@_) =
                _lhsInamesInScope
            (_fromOoptions@_) =
                _lhsIoptions
            (_fromOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_fromOtypeConstructors@_) =
                _lhsItypeConstructors
            (_fromOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_fromOwarnings@_) =
                _lhsIwarnings
            (_thenOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_thenOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_thenOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_thenOcollectScopeInfos@_) =
                _fromIcollectScopeInfos
            (_thenOkindErrors@_) =
                _fromIkindErrors
            (_thenOmiscerrors@_) =
                _fromImiscerrors
            (_thenOnamesInScope@_) =
                _lhsInamesInScope
            (_thenOoptions@_) =
                _lhsIoptions
            (_thenOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_thenOtypeConstructors@_) =
                _lhsItypeConstructors
            (_thenOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_thenOwarnings@_) =
                _fromIwarnings
            (_toOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_toOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_toOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_toOcollectScopeInfos@_) =
                _thenIcollectScopeInfos
            (_toOkindErrors@_) =
                _thenIkindErrors
            (_toOmiscerrors@_) =
                _thenImiscerrors
            (_toOnamesInScope@_) =
                _lhsInamesInScope
            (_toOoptions@_) =
                _lhsIoptions
            (_toOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_toOtypeConstructors@_) =
                _lhsItypeConstructors
            (_toOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_toOwarnings@_) =
                _thenIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Expression_If :: (T_Range) ->
                     (T_Expression) ->
                     (T_Expression) ->
                     (T_Expression) ->
                     (T_Expression)
sem_Expression_If (range_) (guardExpression_) (thenExpression_) (elseExpression_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _guardExpressionIcollectInstances :: ([(Name, Instance)])
            _guardExpressionIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _guardExpressionIkindErrors :: ([Error])
            _guardExpressionImiscerrors :: ([Error])
            _guardExpressionIself :: (Expression)
            _guardExpressionIunboundNames :: (Names)
            _guardExpressionIwarnings :: ([Warning])
            _guardExpressionOallTypeConstructors :: (Names)
            _guardExpressionOallValueConstructors :: (Names)
            _guardExpressionOclassEnvironment :: (ClassEnvironment)
            _guardExpressionOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _guardExpressionOkindErrors :: ([Error])
            _guardExpressionOmiscerrors :: ([Error])
            _guardExpressionOnamesInScope :: (Names)
            _guardExpressionOoptions :: ([Option])
            _guardExpressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _guardExpressionOtypeConstructors :: (M.Map Name Int)
            _guardExpressionOvalueConstructors :: (M.Map Name TpScheme)
            _guardExpressionOwarnings :: ([Warning])
            _thenExpressionIcollectInstances :: ([(Name, Instance)])
            _thenExpressionIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _thenExpressionIkindErrors :: ([Error])
            _thenExpressionImiscerrors :: ([Error])
            _thenExpressionIself :: (Expression)
            _thenExpressionIunboundNames :: (Names)
            _thenExpressionIwarnings :: ([Warning])
            _thenExpressionOallTypeConstructors :: (Names)
            _thenExpressionOallValueConstructors :: (Names)
            _thenExpressionOclassEnvironment :: (ClassEnvironment)
            _thenExpressionOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _thenExpressionOkindErrors :: ([Error])
            _thenExpressionOmiscerrors :: ([Error])
            _thenExpressionOnamesInScope :: (Names)
            _thenExpressionOoptions :: ([Option])
            _thenExpressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _thenExpressionOtypeConstructors :: (M.Map Name Int)
            _thenExpressionOvalueConstructors :: (M.Map Name TpScheme)
            _thenExpressionOwarnings :: ([Warning])
            _elseExpressionIcollectInstances :: ([(Name, Instance)])
            _elseExpressionIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _elseExpressionIkindErrors :: ([Error])
            _elseExpressionImiscerrors :: ([Error])
            _elseExpressionIself :: (Expression)
            _elseExpressionIunboundNames :: (Names)
            _elseExpressionIwarnings :: ([Warning])
            _elseExpressionOallTypeConstructors :: (Names)
            _elseExpressionOallValueConstructors :: (Names)
            _elseExpressionOclassEnvironment :: (ClassEnvironment)
            _elseExpressionOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _elseExpressionOkindErrors :: ([Error])
            _elseExpressionOmiscerrors :: ([Error])
            _elseExpressionOnamesInScope :: (Names)
            _elseExpressionOoptions :: ([Option])
            _elseExpressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _elseExpressionOtypeConstructors :: (M.Map Name Int)
            _elseExpressionOvalueConstructors :: (M.Map Name TpScheme)
            _elseExpressionOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _guardExpressionIcollectInstances,_guardExpressionIcollectScopeInfos,_guardExpressionIkindErrors,_guardExpressionImiscerrors,_guardExpressionIself,_guardExpressionIunboundNames,_guardExpressionIwarnings) =
                (guardExpression_ (_guardExpressionOallTypeConstructors) (_guardExpressionOallValueConstructors) (_guardExpressionOclassEnvironment) (_guardExpressionOcollectScopeInfos) (_guardExpressionOkindErrors) (_guardExpressionOmiscerrors) (_guardExpressionOnamesInScope) (_guardExpressionOoptions) (_guardExpressionOorderedTypeSynonyms) (_guardExpressionOtypeConstructors) (_guardExpressionOvalueConstructors) (_guardExpressionOwarnings))
            ( _thenExpressionIcollectInstances,_thenExpressionIcollectScopeInfos,_thenExpressionIkindErrors,_thenExpressionImiscerrors,_thenExpressionIself,_thenExpressionIunboundNames,_thenExpressionIwarnings) =
                (thenExpression_ (_thenExpressionOallTypeConstructors) (_thenExpressionOallValueConstructors) (_thenExpressionOclassEnvironment) (_thenExpressionOcollectScopeInfos) (_thenExpressionOkindErrors) (_thenExpressionOmiscerrors) (_thenExpressionOnamesInScope) (_thenExpressionOoptions) (_thenExpressionOorderedTypeSynonyms) (_thenExpressionOtypeConstructors) (_thenExpressionOvalueConstructors) (_thenExpressionOwarnings))
            ( _elseExpressionIcollectInstances,_elseExpressionIcollectScopeInfos,_elseExpressionIkindErrors,_elseExpressionImiscerrors,_elseExpressionIself,_elseExpressionIunboundNames,_elseExpressionIwarnings) =
                (elseExpression_ (_elseExpressionOallTypeConstructors) (_elseExpressionOallValueConstructors) (_elseExpressionOclassEnvironment) (_elseExpressionOcollectScopeInfos) (_elseExpressionOkindErrors) (_elseExpressionOmiscerrors) (_elseExpressionOnamesInScope) (_elseExpressionOoptions) (_elseExpressionOorderedTypeSynonyms) (_elseExpressionOtypeConstructors) (_elseExpressionOvalueConstructors) (_elseExpressionOwarnings))
            (_lhsOcollectInstances@_) =
                _guardExpressionIcollectInstances  ++  _thenExpressionIcollectInstances  ++  _elseExpressionIcollectInstances
            (_lhsOunboundNames@_) =
                _guardExpressionIunboundNames ++ _thenExpressionIunboundNames ++ _elseExpressionIunboundNames
            (_self@_) =
                Expression_If _rangeIself _guardExpressionIself _thenExpressionIself _elseExpressionIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _elseExpressionIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _elseExpressionIkindErrors
            (_lhsOmiscerrors@_) =
                _elseExpressionImiscerrors
            (_lhsOwarnings@_) =
                _elseExpressionIwarnings
            (_guardExpressionOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_guardExpressionOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_guardExpressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_guardExpressionOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_guardExpressionOkindErrors@_) =
                _lhsIkindErrors
            (_guardExpressionOmiscerrors@_) =
                _lhsImiscerrors
            (_guardExpressionOnamesInScope@_) =
                _lhsInamesInScope
            (_guardExpressionOoptions@_) =
                _lhsIoptions
            (_guardExpressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_guardExpressionOtypeConstructors@_) =
                _lhsItypeConstructors
            (_guardExpressionOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_guardExpressionOwarnings@_) =
                _lhsIwarnings
            (_thenExpressionOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_thenExpressionOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_thenExpressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_thenExpressionOcollectScopeInfos@_) =
                _guardExpressionIcollectScopeInfos
            (_thenExpressionOkindErrors@_) =
                _guardExpressionIkindErrors
            (_thenExpressionOmiscerrors@_) =
                _guardExpressionImiscerrors
            (_thenExpressionOnamesInScope@_) =
                _lhsInamesInScope
            (_thenExpressionOoptions@_) =
                _lhsIoptions
            (_thenExpressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_thenExpressionOtypeConstructors@_) =
                _lhsItypeConstructors
            (_thenExpressionOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_thenExpressionOwarnings@_) =
                _guardExpressionIwarnings
            (_elseExpressionOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_elseExpressionOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_elseExpressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_elseExpressionOcollectScopeInfos@_) =
                _thenExpressionIcollectScopeInfos
            (_elseExpressionOkindErrors@_) =
                _thenExpressionIkindErrors
            (_elseExpressionOmiscerrors@_) =
                _thenExpressionImiscerrors
            (_elseExpressionOnamesInScope@_) =
                _lhsInamesInScope
            (_elseExpressionOoptions@_) =
                _lhsIoptions
            (_elseExpressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_elseExpressionOtypeConstructors@_) =
                _lhsItypeConstructors
            (_elseExpressionOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_elseExpressionOwarnings@_) =
                _thenExpressionIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Expression_InfixApplication :: (T_Range) ->
                                   (T_MaybeExpression) ->
                                   (T_Expression) ->
                                   (T_MaybeExpression) ->
                                   (T_Expression)
sem_Expression_InfixApplication (range_) (leftExpression_) (operator_) (rightExpression_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _leftExpressionIcollectInstances :: ([(Name, Instance)])
            _leftExpressionIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _leftExpressionIkindErrors :: ([Error])
            _leftExpressionImiscerrors :: ([Error])
            _leftExpressionIself :: (MaybeExpression)
            _leftExpressionIunboundNames :: (Names)
            _leftExpressionIwarnings :: ([Warning])
            _leftExpressionOallTypeConstructors :: (Names)
            _leftExpressionOallValueConstructors :: (Names)
            _leftExpressionOclassEnvironment :: (ClassEnvironment)
            _leftExpressionOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _leftExpressionOkindErrors :: ([Error])
            _leftExpressionOmiscerrors :: ([Error])
            _leftExpressionOnamesInScope :: (Names)
            _leftExpressionOoptions :: ([Option])
            _leftExpressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _leftExpressionOtypeConstructors :: (M.Map Name Int)
            _leftExpressionOvalueConstructors :: (M.Map Name TpScheme)
            _leftExpressionOwarnings :: ([Warning])
            _operatorIcollectInstances :: ([(Name, Instance)])
            _operatorIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _operatorIkindErrors :: ([Error])
            _operatorImiscerrors :: ([Error])
            _operatorIself :: (Expression)
            _operatorIunboundNames :: (Names)
            _operatorIwarnings :: ([Warning])
            _operatorOallTypeConstructors :: (Names)
            _operatorOallValueConstructors :: (Names)
            _operatorOclassEnvironment :: (ClassEnvironment)
            _operatorOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _operatorOkindErrors :: ([Error])
            _operatorOmiscerrors :: ([Error])
            _operatorOnamesInScope :: (Names)
            _operatorOoptions :: ([Option])
            _operatorOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _operatorOtypeConstructors :: (M.Map Name Int)
            _operatorOvalueConstructors :: (M.Map Name TpScheme)
            _operatorOwarnings :: ([Warning])
            _rightExpressionIcollectInstances :: ([(Name, Instance)])
            _rightExpressionIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _rightExpressionIkindErrors :: ([Error])
            _rightExpressionImiscerrors :: ([Error])
            _rightExpressionIself :: (MaybeExpression)
            _rightExpressionIunboundNames :: (Names)
            _rightExpressionIwarnings :: ([Warning])
            _rightExpressionOallTypeConstructors :: (Names)
            _rightExpressionOallValueConstructors :: (Names)
            _rightExpressionOclassEnvironment :: (ClassEnvironment)
            _rightExpressionOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _rightExpressionOkindErrors :: ([Error])
            _rightExpressionOmiscerrors :: ([Error])
            _rightExpressionOnamesInScope :: (Names)
            _rightExpressionOoptions :: ([Option])
            _rightExpressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _rightExpressionOtypeConstructors :: (M.Map Name Int)
            _rightExpressionOvalueConstructors :: (M.Map Name TpScheme)
            _rightExpressionOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _leftExpressionIcollectInstances,_leftExpressionIcollectScopeInfos,_leftExpressionIkindErrors,_leftExpressionImiscerrors,_leftExpressionIself,_leftExpressionIunboundNames,_leftExpressionIwarnings) =
                (leftExpression_ (_leftExpressionOallTypeConstructors) (_leftExpressionOallValueConstructors) (_leftExpressionOclassEnvironment) (_leftExpressionOcollectScopeInfos) (_leftExpressionOkindErrors) (_leftExpressionOmiscerrors) (_leftExpressionOnamesInScope) (_leftExpressionOoptions) (_leftExpressionOorderedTypeSynonyms) (_leftExpressionOtypeConstructors) (_leftExpressionOvalueConstructors) (_leftExpressionOwarnings))
            ( _operatorIcollectInstances,_operatorIcollectScopeInfos,_operatorIkindErrors,_operatorImiscerrors,_operatorIself,_operatorIunboundNames,_operatorIwarnings) =
                (operator_ (_operatorOallTypeConstructors) (_operatorOallValueConstructors) (_operatorOclassEnvironment) (_operatorOcollectScopeInfos) (_operatorOkindErrors) (_operatorOmiscerrors) (_operatorOnamesInScope) (_operatorOoptions) (_operatorOorderedTypeSynonyms) (_operatorOtypeConstructors) (_operatorOvalueConstructors) (_operatorOwarnings))
            ( _rightExpressionIcollectInstances,_rightExpressionIcollectScopeInfos,_rightExpressionIkindErrors,_rightExpressionImiscerrors,_rightExpressionIself,_rightExpressionIunboundNames,_rightExpressionIwarnings) =
                (rightExpression_ (_rightExpressionOallTypeConstructors) (_rightExpressionOallValueConstructors) (_rightExpressionOclassEnvironment) (_rightExpressionOcollectScopeInfos) (_rightExpressionOkindErrors) (_rightExpressionOmiscerrors) (_rightExpressionOnamesInScope) (_rightExpressionOoptions) (_rightExpressionOorderedTypeSynonyms) (_rightExpressionOtypeConstructors) (_rightExpressionOvalueConstructors) (_rightExpressionOwarnings))
            (_lhsOcollectInstances@_) =
                _leftExpressionIcollectInstances  ++  _operatorIcollectInstances  ++  _rightExpressionIcollectInstances
            (_lhsOunboundNames@_) =
                _leftExpressionIunboundNames ++ _operatorIunboundNames ++ _rightExpressionIunboundNames
            (_self@_) =
                Expression_InfixApplication _rangeIself _leftExpressionIself _operatorIself _rightExpressionIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _rightExpressionIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _rightExpressionIkindErrors
            (_lhsOmiscerrors@_) =
                _rightExpressionImiscerrors
            (_lhsOwarnings@_) =
                _rightExpressionIwarnings
            (_leftExpressionOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_leftExpressionOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_leftExpressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_leftExpressionOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_leftExpressionOkindErrors@_) =
                _lhsIkindErrors
            (_leftExpressionOmiscerrors@_) =
                _lhsImiscerrors
            (_leftExpressionOnamesInScope@_) =
                _lhsInamesInScope
            (_leftExpressionOoptions@_) =
                _lhsIoptions
            (_leftExpressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_leftExpressionOtypeConstructors@_) =
                _lhsItypeConstructors
            (_leftExpressionOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_leftExpressionOwarnings@_) =
                _lhsIwarnings
            (_operatorOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_operatorOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_operatorOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_operatorOcollectScopeInfos@_) =
                _leftExpressionIcollectScopeInfos
            (_operatorOkindErrors@_) =
                _leftExpressionIkindErrors
            (_operatorOmiscerrors@_) =
                _leftExpressionImiscerrors
            (_operatorOnamesInScope@_) =
                _lhsInamesInScope
            (_operatorOoptions@_) =
                _lhsIoptions
            (_operatorOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_operatorOtypeConstructors@_) =
                _lhsItypeConstructors
            (_operatorOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_operatorOwarnings@_) =
                _leftExpressionIwarnings
            (_rightExpressionOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_rightExpressionOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_rightExpressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_rightExpressionOcollectScopeInfos@_) =
                _operatorIcollectScopeInfos
            (_rightExpressionOkindErrors@_) =
                _operatorIkindErrors
            (_rightExpressionOmiscerrors@_) =
                _operatorImiscerrors
            (_rightExpressionOnamesInScope@_) =
                _lhsInamesInScope
            (_rightExpressionOoptions@_) =
                _lhsIoptions
            (_rightExpressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_rightExpressionOtypeConstructors@_) =
                _lhsItypeConstructors
            (_rightExpressionOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_rightExpressionOwarnings@_) =
                _operatorIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Expression_Lambda :: (T_Range) ->
                         (T_Patterns) ->
                         (T_Expression) ->
                         (T_Expression)
sem_Expression_Lambda (range_) (patterns_) (expression_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _patternsIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _patternsImiscerrors :: ([Error])
            _patternsInumberOfPatterns :: (Int)
            _patternsIpatVarNames :: (Names)
            _patternsIself :: (Patterns)
            _patternsIunboundNames :: (Names)
            _patternsIwarnings :: ([Warning])
            _patternsOallTypeConstructors :: (Names)
            _patternsOallValueConstructors :: (Names)
            _patternsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _patternsOlhsPattern :: (Bool)
            _patternsOmiscerrors :: ([Error])
            _patternsOnamesInScope :: (Names)
            _patternsOtypeConstructors :: (M.Map Name Int)
            _patternsOvalueConstructors :: (M.Map Name TpScheme)
            _patternsOwarnings :: ([Warning])
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionIkindErrors :: ([Error])
            _expressionImiscerrors :: ([Error])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIwarnings :: ([Warning])
            _expressionOallTypeConstructors :: (Names)
            _expressionOallValueConstructors :: (Names)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionOkindErrors :: ([Error])
            _expressionOmiscerrors :: ([Error])
            _expressionOnamesInScope :: (Names)
            _expressionOoptions :: ([Option])
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOtypeConstructors :: (M.Map Name Int)
            _expressionOvalueConstructors :: (M.Map Name TpScheme)
            _expressionOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _patternsIcollectScopeInfos,_patternsImiscerrors,_patternsInumberOfPatterns,_patternsIpatVarNames,_patternsIself,_patternsIunboundNames,_patternsIwarnings) =
                (patterns_ (_patternsOallTypeConstructors) (_patternsOallValueConstructors) (_patternsOcollectScopeInfos) (_patternsOlhsPattern) (_patternsOmiscerrors) (_patternsOnamesInScope) (_patternsOtypeConstructors) (_patternsOvalueConstructors) (_patternsOwarnings))
            ( _expressionIcollectInstances,_expressionIcollectScopeInfos,_expressionIkindErrors,_expressionImiscerrors,_expressionIself,_expressionIunboundNames,_expressionIwarnings) =
                (expression_ (_expressionOallTypeConstructors) (_expressionOallValueConstructors) (_expressionOclassEnvironment) (_expressionOcollectScopeInfos) (_expressionOkindErrors) (_expressionOmiscerrors) (_expressionOnamesInScope) (_expressionOoptions) (_expressionOorderedTypeSynonyms) (_expressionOtypeConstructors) (_expressionOvalueConstructors) (_expressionOwarnings))
            (_lhsOunboundNames@_) =
                _unboundNames
            ((_namesInScope@_,_unboundNames@_,_scopeInfo@_)) =
                changeOfScope _patternsIpatVarNames _expressionIunboundNames _lhsInamesInScope
            (_patternsOlhsPattern@_) =
                False
            (_lhsOcollectScopeInfos@_) =
                (_scopeInfo, Variable)   : _expressionIcollectScopeInfos
            (_lhsOcollectInstances@_) =
                _expressionIcollectInstances
            (_self@_) =
                Expression_Lambda _rangeIself _patternsIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsOkindErrors@_) =
                _expressionIkindErrors
            (_lhsOmiscerrors@_) =
                _expressionImiscerrors
            (_lhsOwarnings@_) =
                _expressionIwarnings
            (_patternsOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_patternsOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_patternsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_patternsOmiscerrors@_) =
                _lhsImiscerrors
            (_patternsOnamesInScope@_) =
                _namesInScope
            (_patternsOtypeConstructors@_) =
                _lhsItypeConstructors
            (_patternsOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_patternsOwarnings@_) =
                _lhsIwarnings
            (_expressionOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_expressionOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectScopeInfos@_) =
                _patternsIcollectScopeInfos
            (_expressionOkindErrors@_) =
                _lhsIkindErrors
            (_expressionOmiscerrors@_) =
                _patternsImiscerrors
            (_expressionOnamesInScope@_) =
                _namesInScope
            (_expressionOoptions@_) =
                _lhsIoptions
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOtypeConstructors@_) =
                _lhsItypeConstructors
            (_expressionOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_expressionOwarnings@_) =
                _patternsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Expression_Let :: (T_Range) ->
                      (T_Declarations) ->
                      (T_Expression) ->
                      (T_Expression)
sem_Expression_Let (range_) (declarations_) (expression_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _declarationsIcollectInstances :: ([(Name, Instance)])
            _declarationsIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _declarationsIcollectTypeConstructors :: ([(Name,Int)])
            _declarationsIcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _declarationsIcollectValueConstructors :: ([(Name,TpScheme)])
            _declarationsIdeclVarNames :: (Names)
            _declarationsIkindErrors :: ([Error])
            _declarationsImiscerrors :: ([Error])
            _declarationsIoperatorFixities :: ([(Name,(Int,Assoc))])
            _declarationsIpreviousWasAlsoFB :: (Maybe Name)
            _declarationsIrestrictedNames :: (Names)
            _declarationsIself :: (Declarations)
            _declarationsIsuspiciousFBs :: ([(Name,Name)])
            _declarationsItypeSignatures :: ([(Name,TpScheme)])
            _declarationsIunboundNames :: (Names)
            _declarationsIwarnings :: ([Warning])
            _declarationsOallTypeConstructors :: (Names)
            _declarationsOallValueConstructors :: (Names)
            _declarationsOclassEnvironment :: (ClassEnvironment)
            _declarationsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _declarationsOcollectTypeConstructors :: ([(Name,Int)])
            _declarationsOcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _declarationsOcollectValueConstructors :: ([(Name,TpScheme)])
            _declarationsOkindErrors :: ([Error])
            _declarationsOmiscerrors :: ([Error])
            _declarationsOnamesInScope :: (Names)
            _declarationsOoperatorFixities :: ([(Name,(Int,Assoc))])
            _declarationsOoptions :: ([Option])
            _declarationsOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _declarationsOpreviousWasAlsoFB :: (Maybe Name)
            _declarationsOsuspiciousFBs :: ([(Name,Name)])
            _declarationsOtypeConstructors :: (M.Map Name Int)
            _declarationsOtypeSignatures :: ([(Name,TpScheme)])
            _declarationsOvalueConstructors :: (M.Map Name TpScheme)
            _declarationsOwarnings :: ([Warning])
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionIkindErrors :: ([Error])
            _expressionImiscerrors :: ([Error])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIwarnings :: ([Warning])
            _expressionOallTypeConstructors :: (Names)
            _expressionOallValueConstructors :: (Names)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionOkindErrors :: ([Error])
            _expressionOmiscerrors :: ([Error])
            _expressionOnamesInScope :: (Names)
            _expressionOoptions :: ([Option])
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOtypeConstructors :: (M.Map Name Int)
            _expressionOvalueConstructors :: (M.Map Name TpScheme)
            _expressionOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _declarationsIcollectInstances
             ,_declarationsIcollectScopeInfos
             ,_declarationsIcollectTypeConstructors
             ,_declarationsIcollectTypeSynonyms
             ,_declarationsIcollectValueConstructors
             ,_declarationsIdeclVarNames
             ,_declarationsIkindErrors
             ,_declarationsImiscerrors
             ,_declarationsIoperatorFixities
             ,_declarationsIpreviousWasAlsoFB
             ,_declarationsIrestrictedNames
             ,_declarationsIself
             ,_declarationsIsuspiciousFBs
             ,_declarationsItypeSignatures
             ,_declarationsIunboundNames
             ,_declarationsIwarnings
             ) =
                (declarations_ (_declarationsOallTypeConstructors)
                               (_declarationsOallValueConstructors)
                               (_declarationsOclassEnvironment)
                               (_declarationsOcollectScopeInfos)
                               (_declarationsOcollectTypeConstructors)
                               (_declarationsOcollectTypeSynonyms)
                               (_declarationsOcollectValueConstructors)
                               (_declarationsOkindErrors)
                               (_declarationsOmiscerrors)
                               (_declarationsOnamesInScope)
                               (_declarationsOoperatorFixities)
                               (_declarationsOoptions)
                               (_declarationsOorderedTypeSynonyms)
                               (_declarationsOpreviousWasAlsoFB)
                               (_declarationsOsuspiciousFBs)
                               (_declarationsOtypeConstructors)
                               (_declarationsOtypeSignatures)
                               (_declarationsOvalueConstructors)
                               (_declarationsOwarnings))
            ( _expressionIcollectInstances,_expressionIcollectScopeInfos,_expressionIkindErrors,_expressionImiscerrors,_expressionIself,_expressionIunboundNames,_expressionIwarnings) =
                (expression_ (_expressionOallTypeConstructors) (_expressionOallValueConstructors) (_expressionOclassEnvironment) (_expressionOcollectScopeInfos) (_expressionOkindErrors) (_expressionOmiscerrors) (_expressionOnamesInScope) (_expressionOoptions) (_expressionOorderedTypeSynonyms) (_expressionOtypeConstructors) (_expressionOvalueConstructors) (_expressionOwarnings))
            (_declarationsOtypeSignatures@_) =
                []
            (_lhsOunboundNames@_) =
                _unboundNames
            ((_namesInScope@_,_unboundNames@_,_scopeInfo@_)) =
                changeOfScope _declarationsIdeclVarNames (_declarationsIunboundNames ++ _expressionIunboundNames) _lhsInamesInScope
            (_lhsOwarnings@_) =
                _expressionIwarnings ++
                _suspiciousErrors
            (_suspiciousErrors@_) =
                findSimilarFunctionBindings _declarationsItypeSignatures _declarationsIsuspiciousFBs
            (_declarationsOsuspiciousFBs@_) =
                []
            (_declarationsOpreviousWasAlsoFB@_) =
                Nothing
            (_typeSignatureErrors@_) =
                checkTypeSignatures _declarationsIdeclVarNames _declarationsIrestrictedNames _declarationsItypeSignatures
            ((_,_doubles@_)) =
                uniqueAppearance (map fst _declarationsItypeSignatures)
            (_lhsOmiscerrors@_) =
                _typeSignatureErrors ++ _expressionImiscerrors
            ((_collectTypeConstructors@_,_collectValueConstructors@_,_collectTypeSynonyms@_,_collectConstructorEnv@_,_derivedFunctions@_,_operatorFixities@_)) =
                internalError "PartialSyntax.ag" "n/a" "toplevel Expression"
            (_lhsOcollectScopeInfos@_) =
                (_scopeInfo, Definition) : _expressionIcollectScopeInfos
            (_lhsOcollectInstances@_) =
                _declarationsIcollectInstances  ++  _expressionIcollectInstances
            (_self@_) =
                Expression_Let _rangeIself _declarationsIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsOkindErrors@_) =
                _expressionIkindErrors
            (_declarationsOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_declarationsOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_declarationsOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_declarationsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_declarationsOcollectTypeConstructors@_) =
                _collectTypeConstructors
            (_declarationsOcollectTypeSynonyms@_) =
                _collectTypeSynonyms
            (_declarationsOcollectValueConstructors@_) =
                _collectValueConstructors
            (_declarationsOkindErrors@_) =
                _lhsIkindErrors
            (_declarationsOmiscerrors@_) =
                _lhsImiscerrors
            (_declarationsOnamesInScope@_) =
                _namesInScope
            (_declarationsOoperatorFixities@_) =
                _operatorFixities
            (_declarationsOoptions@_) =
                _lhsIoptions
            (_declarationsOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_declarationsOtypeConstructors@_) =
                _lhsItypeConstructors
            (_declarationsOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_declarationsOwarnings@_) =
                _lhsIwarnings
            (_expressionOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_expressionOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectScopeInfos@_) =
                _declarationsIcollectScopeInfos
            (_expressionOkindErrors@_) =
                _declarationsIkindErrors
            (_expressionOmiscerrors@_) =
                _declarationsImiscerrors
            (_expressionOnamesInScope@_) =
                _namesInScope
            (_expressionOoptions@_) =
                _lhsIoptions
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOtypeConstructors@_) =
                _lhsItypeConstructors
            (_expressionOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_expressionOwarnings@_) =
                _declarationsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Expression_List :: (T_Range) ->
                       (T_Expressions) ->
                       (T_Expression)
sem_Expression_List (range_) (expressions_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _expressionsIcollectInstances :: ([(Name, Instance)])
            _expressionsIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionsIkindErrors :: ([Error])
            _expressionsImiscerrors :: ([Error])
            _expressionsIself :: (Expressions)
            _expressionsIunboundNames :: (Names)
            _expressionsIwarnings :: ([Warning])
            _expressionsOallTypeConstructors :: (Names)
            _expressionsOallValueConstructors :: (Names)
            _expressionsOclassEnvironment :: (ClassEnvironment)
            _expressionsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionsOkindErrors :: ([Error])
            _expressionsOmiscerrors :: ([Error])
            _expressionsOnamesInScope :: (Names)
            _expressionsOoptions :: ([Option])
            _expressionsOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionsOtypeConstructors :: (M.Map Name Int)
            _expressionsOvalueConstructors :: (M.Map Name TpScheme)
            _expressionsOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _expressionsIcollectInstances,_expressionsIcollectScopeInfos,_expressionsIkindErrors,_expressionsImiscerrors,_expressionsIself,_expressionsIunboundNames,_expressionsIwarnings) =
                (expressions_ (_expressionsOallTypeConstructors) (_expressionsOallValueConstructors) (_expressionsOclassEnvironment) (_expressionsOcollectScopeInfos) (_expressionsOkindErrors) (_expressionsOmiscerrors) (_expressionsOnamesInScope) (_expressionsOoptions) (_expressionsOorderedTypeSynonyms) (_expressionsOtypeConstructors) (_expressionsOvalueConstructors) (_expressionsOwarnings))
            (_lhsOcollectInstances@_) =
                _expressionsIcollectInstances
            (_lhsOunboundNames@_) =
                _expressionsIunboundNames
            (_self@_) =
                Expression_List _rangeIself _expressionsIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _expressionsIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _expressionsIkindErrors
            (_lhsOmiscerrors@_) =
                _expressionsImiscerrors
            (_lhsOwarnings@_) =
                _expressionsIwarnings
            (_expressionsOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_expressionsOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_expressionsOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_expressionsOkindErrors@_) =
                _lhsIkindErrors
            (_expressionsOmiscerrors@_) =
                _lhsImiscerrors
            (_expressionsOnamesInScope@_) =
                _lhsInamesInScope
            (_expressionsOoptions@_) =
                _lhsIoptions
            (_expressionsOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionsOtypeConstructors@_) =
                _lhsItypeConstructors
            (_expressionsOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_expressionsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Expression_Literal :: (T_Range) ->
                          (T_Literal) ->
                          (T_Expression)
sem_Expression_Literal (range_) (literal_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _literalIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _literalImiscerrors :: ([Error])
            _literalIself :: (Literal)
            _literalOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _literalOmiscerrors :: ([Error])
            ( _rangeIself) =
                (range_ )
            ( _literalIcollectScopeInfos,_literalImiscerrors,_literalIself) =
                (literal_ (_literalOcollectScopeInfos) (_literalOmiscerrors))
            (_lhsOcollectInstances@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                Expression_Literal _rangeIself _literalIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _literalIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _lhsIkindErrors
            (_lhsOmiscerrors@_) =
                _literalImiscerrors
            (_lhsOwarnings@_) =
                _lhsIwarnings
            (_literalOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_literalOmiscerrors@_) =
                _lhsImiscerrors
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Expression_Negate :: (T_Range) ->
                         (T_Expression) ->
                         (T_Expression)
sem_Expression_Negate (range_) (expression_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionIkindErrors :: ([Error])
            _expressionImiscerrors :: ([Error])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIwarnings :: ([Warning])
            _expressionOallTypeConstructors :: (Names)
            _expressionOallValueConstructors :: (Names)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionOkindErrors :: ([Error])
            _expressionOmiscerrors :: ([Error])
            _expressionOnamesInScope :: (Names)
            _expressionOoptions :: ([Option])
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOtypeConstructors :: (M.Map Name Int)
            _expressionOvalueConstructors :: (M.Map Name TpScheme)
            _expressionOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _expressionIcollectInstances,_expressionIcollectScopeInfos,_expressionIkindErrors,_expressionImiscerrors,_expressionIself,_expressionIunboundNames,_expressionIwarnings) =
                (expression_ (_expressionOallTypeConstructors) (_expressionOallValueConstructors) (_expressionOclassEnvironment) (_expressionOcollectScopeInfos) (_expressionOkindErrors) (_expressionOmiscerrors) (_expressionOnamesInScope) (_expressionOoptions) (_expressionOorderedTypeSynonyms) (_expressionOtypeConstructors) (_expressionOvalueConstructors) (_expressionOwarnings))
            (_lhsOcollectInstances@_) =
                _expressionIcollectInstances
            (_lhsOunboundNames@_) =
                _expressionIunboundNames
            (_self@_) =
                Expression_Negate _rangeIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _expressionIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _expressionIkindErrors
            (_lhsOmiscerrors@_) =
                _expressionImiscerrors
            (_lhsOwarnings@_) =
                _expressionIwarnings
            (_expressionOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_expressionOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_expressionOkindErrors@_) =
                _lhsIkindErrors
            (_expressionOmiscerrors@_) =
                _lhsImiscerrors
            (_expressionOnamesInScope@_) =
                _lhsInamesInScope
            (_expressionOoptions@_) =
                _lhsIoptions
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOtypeConstructors@_) =
                _lhsItypeConstructors
            (_expressionOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_expressionOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Expression_NegateFloat :: (T_Range) ->
                              (T_Expression) ->
                              (T_Expression)
sem_Expression_NegateFloat (range_) (expression_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionIkindErrors :: ([Error])
            _expressionImiscerrors :: ([Error])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIwarnings :: ([Warning])
            _expressionOallTypeConstructors :: (Names)
            _expressionOallValueConstructors :: (Names)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionOkindErrors :: ([Error])
            _expressionOmiscerrors :: ([Error])
            _expressionOnamesInScope :: (Names)
            _expressionOoptions :: ([Option])
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOtypeConstructors :: (M.Map Name Int)
            _expressionOvalueConstructors :: (M.Map Name TpScheme)
            _expressionOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _expressionIcollectInstances,_expressionIcollectScopeInfos,_expressionIkindErrors,_expressionImiscerrors,_expressionIself,_expressionIunboundNames,_expressionIwarnings) =
                (expression_ (_expressionOallTypeConstructors) (_expressionOallValueConstructors) (_expressionOclassEnvironment) (_expressionOcollectScopeInfos) (_expressionOkindErrors) (_expressionOmiscerrors) (_expressionOnamesInScope) (_expressionOoptions) (_expressionOorderedTypeSynonyms) (_expressionOtypeConstructors) (_expressionOvalueConstructors) (_expressionOwarnings))
            (_lhsOcollectInstances@_) =
                _expressionIcollectInstances
            (_lhsOunboundNames@_) =
                _expressionIunboundNames
            (_self@_) =
                Expression_NegateFloat _rangeIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _expressionIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _expressionIkindErrors
            (_lhsOmiscerrors@_) =
                _expressionImiscerrors
            (_lhsOwarnings@_) =
                _expressionIwarnings
            (_expressionOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_expressionOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_expressionOkindErrors@_) =
                _lhsIkindErrors
            (_expressionOmiscerrors@_) =
                _lhsImiscerrors
            (_expressionOnamesInScope@_) =
                _lhsInamesInScope
            (_expressionOoptions@_) =
                _lhsIoptions
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOtypeConstructors@_) =
                _lhsItypeConstructors
            (_expressionOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_expressionOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Expression_NormalApplication :: (T_Range) ->
                                    (T_Expression) ->
                                    (T_Expressions) ->
                                    (T_Expression)
sem_Expression_NormalApplication (range_) (function_) (arguments_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _functionIcollectInstances :: ([(Name, Instance)])
            _functionIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _functionIkindErrors :: ([Error])
            _functionImiscerrors :: ([Error])
            _functionIself :: (Expression)
            _functionIunboundNames :: (Names)
            _functionIwarnings :: ([Warning])
            _functionOallTypeConstructors :: (Names)
            _functionOallValueConstructors :: (Names)
            _functionOclassEnvironment :: (ClassEnvironment)
            _functionOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _functionOkindErrors :: ([Error])
            _functionOmiscerrors :: ([Error])
            _functionOnamesInScope :: (Names)
            _functionOoptions :: ([Option])
            _functionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _functionOtypeConstructors :: (M.Map Name Int)
            _functionOvalueConstructors :: (M.Map Name TpScheme)
            _functionOwarnings :: ([Warning])
            _argumentsIcollectInstances :: ([(Name, Instance)])
            _argumentsIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _argumentsIkindErrors :: ([Error])
            _argumentsImiscerrors :: ([Error])
            _argumentsIself :: (Expressions)
            _argumentsIunboundNames :: (Names)
            _argumentsIwarnings :: ([Warning])
            _argumentsOallTypeConstructors :: (Names)
            _argumentsOallValueConstructors :: (Names)
            _argumentsOclassEnvironment :: (ClassEnvironment)
            _argumentsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _argumentsOkindErrors :: ([Error])
            _argumentsOmiscerrors :: ([Error])
            _argumentsOnamesInScope :: (Names)
            _argumentsOoptions :: ([Option])
            _argumentsOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _argumentsOtypeConstructors :: (M.Map Name Int)
            _argumentsOvalueConstructors :: (M.Map Name TpScheme)
            _argumentsOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _functionIcollectInstances,_functionIcollectScopeInfos,_functionIkindErrors,_functionImiscerrors,_functionIself,_functionIunboundNames,_functionIwarnings) =
                (function_ (_functionOallTypeConstructors) (_functionOallValueConstructors) (_functionOclassEnvironment) (_functionOcollectScopeInfos) (_functionOkindErrors) (_functionOmiscerrors) (_functionOnamesInScope) (_functionOoptions) (_functionOorderedTypeSynonyms) (_functionOtypeConstructors) (_functionOvalueConstructors) (_functionOwarnings))
            ( _argumentsIcollectInstances,_argumentsIcollectScopeInfos,_argumentsIkindErrors,_argumentsImiscerrors,_argumentsIself,_argumentsIunboundNames,_argumentsIwarnings) =
                (arguments_ (_argumentsOallTypeConstructors) (_argumentsOallValueConstructors) (_argumentsOclassEnvironment) (_argumentsOcollectScopeInfos) (_argumentsOkindErrors) (_argumentsOmiscerrors) (_argumentsOnamesInScope) (_argumentsOoptions) (_argumentsOorderedTypeSynonyms) (_argumentsOtypeConstructors) (_argumentsOvalueConstructors) (_argumentsOwarnings))
            (_lhsOcollectInstances@_) =
                _functionIcollectInstances  ++  _argumentsIcollectInstances
            (_lhsOunboundNames@_) =
                _functionIunboundNames ++ _argumentsIunboundNames
            (_self@_) =
                Expression_NormalApplication _rangeIself _functionIself _argumentsIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _argumentsIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _argumentsIkindErrors
            (_lhsOmiscerrors@_) =
                _argumentsImiscerrors
            (_lhsOwarnings@_) =
                _argumentsIwarnings
            (_functionOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_functionOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_functionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_functionOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_functionOkindErrors@_) =
                _lhsIkindErrors
            (_functionOmiscerrors@_) =
                _lhsImiscerrors
            (_functionOnamesInScope@_) =
                _lhsInamesInScope
            (_functionOoptions@_) =
                _lhsIoptions
            (_functionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_functionOtypeConstructors@_) =
                _lhsItypeConstructors
            (_functionOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_functionOwarnings@_) =
                _lhsIwarnings
            (_argumentsOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_argumentsOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_argumentsOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_argumentsOcollectScopeInfos@_) =
                _functionIcollectScopeInfos
            (_argumentsOkindErrors@_) =
                _functionIkindErrors
            (_argumentsOmiscerrors@_) =
                _functionImiscerrors
            (_argumentsOnamesInScope@_) =
                _lhsInamesInScope
            (_argumentsOoptions@_) =
                _lhsIoptions
            (_argumentsOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_argumentsOtypeConstructors@_) =
                _lhsItypeConstructors
            (_argumentsOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_argumentsOwarnings@_) =
                _functionIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Expression_Parenthesized :: (T_Range) ->
                                (T_Expression) ->
                                (T_Expression)
sem_Expression_Parenthesized (range_) (expression_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionIkindErrors :: ([Error])
            _expressionImiscerrors :: ([Error])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIwarnings :: ([Warning])
            _expressionOallTypeConstructors :: (Names)
            _expressionOallValueConstructors :: (Names)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionOkindErrors :: ([Error])
            _expressionOmiscerrors :: ([Error])
            _expressionOnamesInScope :: (Names)
            _expressionOoptions :: ([Option])
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOtypeConstructors :: (M.Map Name Int)
            _expressionOvalueConstructors :: (M.Map Name TpScheme)
            _expressionOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _expressionIcollectInstances,_expressionIcollectScopeInfos,_expressionIkindErrors,_expressionImiscerrors,_expressionIself,_expressionIunboundNames,_expressionIwarnings) =
                (expression_ (_expressionOallTypeConstructors) (_expressionOallValueConstructors) (_expressionOclassEnvironment) (_expressionOcollectScopeInfos) (_expressionOkindErrors) (_expressionOmiscerrors) (_expressionOnamesInScope) (_expressionOoptions) (_expressionOorderedTypeSynonyms) (_expressionOtypeConstructors) (_expressionOvalueConstructors) (_expressionOwarnings))
            (_lhsOcollectInstances@_) =
                _expressionIcollectInstances
            (_lhsOunboundNames@_) =
                _expressionIunboundNames
            (_self@_) =
                Expression_Parenthesized _rangeIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _expressionIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _expressionIkindErrors
            (_lhsOmiscerrors@_) =
                _expressionImiscerrors
            (_lhsOwarnings@_) =
                _expressionIwarnings
            (_expressionOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_expressionOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_expressionOkindErrors@_) =
                _lhsIkindErrors
            (_expressionOmiscerrors@_) =
                _lhsImiscerrors
            (_expressionOnamesInScope@_) =
                _lhsInamesInScope
            (_expressionOoptions@_) =
                _lhsIoptions
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOtypeConstructors@_) =
                _lhsItypeConstructors
            (_expressionOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_expressionOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Expression_RecordConstruction :: (T_Range) ->
                                     (T_Name) ->
                                     (T_RecordExpressionBindings) ->
                                     (T_Expression)
sem_Expression_RecordConstruction (range_) (name_) (recordExpressionBindings_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _nameIself :: (Name)
            _recordExpressionBindingsIcollectInstances :: ([(Name, Instance)])
            _recordExpressionBindingsIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _recordExpressionBindingsIself :: (RecordExpressionBindings)
            _recordExpressionBindingsIunboundNames :: (Names)
            _recordExpressionBindingsOclassEnvironment :: (ClassEnvironment)
            _recordExpressionBindingsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _recordExpressionBindingsOnamesInScope :: (Names)
            _recordExpressionBindingsOoptions :: ([Option])
            _recordExpressionBindingsOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            ( _recordExpressionBindingsIcollectInstances,_recordExpressionBindingsIcollectScopeInfos,_recordExpressionBindingsIself,_recordExpressionBindingsIunboundNames) =
                (recordExpressionBindings_ (_recordExpressionBindingsOclassEnvironment) (_recordExpressionBindingsOcollectScopeInfos) (_recordExpressionBindingsOnamesInScope) (_recordExpressionBindingsOoptions) (_recordExpressionBindingsOorderedTypeSynonyms))
            ((_assumptions@_,_constraints@_,_beta@_)) =
                internalError "PartialSyntax.ag" "n/a" "Expression.RecordConstruction"
            (_lhsOcollectInstances@_) =
                _recordExpressionBindingsIcollectInstances
            (_lhsOunboundNames@_) =
                _recordExpressionBindingsIunboundNames
            (_self@_) =
                Expression_RecordConstruction _rangeIself _nameIself _recordExpressionBindingsIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _recordExpressionBindingsIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _lhsIkindErrors
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
            (_lhsOwarnings@_) =
                _lhsIwarnings
            (_recordExpressionBindingsOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_recordExpressionBindingsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_recordExpressionBindingsOnamesInScope@_) =
                _lhsInamesInScope
            (_recordExpressionBindingsOoptions@_) =
                _lhsIoptions
            (_recordExpressionBindingsOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Expression_RecordUpdate :: (T_Range) ->
                               (T_Expression) ->
                               (T_RecordExpressionBindings) ->
                               (T_Expression)
sem_Expression_RecordUpdate (range_) (expression_) (recordExpressionBindings_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionIkindErrors :: ([Error])
            _expressionImiscerrors :: ([Error])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIwarnings :: ([Warning])
            _expressionOallTypeConstructors :: (Names)
            _expressionOallValueConstructors :: (Names)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionOkindErrors :: ([Error])
            _expressionOmiscerrors :: ([Error])
            _expressionOnamesInScope :: (Names)
            _expressionOoptions :: ([Option])
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOtypeConstructors :: (M.Map Name Int)
            _expressionOvalueConstructors :: (M.Map Name TpScheme)
            _expressionOwarnings :: ([Warning])
            _recordExpressionBindingsIcollectInstances :: ([(Name, Instance)])
            _recordExpressionBindingsIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _recordExpressionBindingsIself :: (RecordExpressionBindings)
            _recordExpressionBindingsIunboundNames :: (Names)
            _recordExpressionBindingsOclassEnvironment :: (ClassEnvironment)
            _recordExpressionBindingsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _recordExpressionBindingsOnamesInScope :: (Names)
            _recordExpressionBindingsOoptions :: ([Option])
            _recordExpressionBindingsOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            ( _rangeIself) =
                (range_ )
            ( _expressionIcollectInstances,_expressionIcollectScopeInfos,_expressionIkindErrors,_expressionImiscerrors,_expressionIself,_expressionIunboundNames,_expressionIwarnings) =
                (expression_ (_expressionOallTypeConstructors) (_expressionOallValueConstructors) (_expressionOclassEnvironment) (_expressionOcollectScopeInfos) (_expressionOkindErrors) (_expressionOmiscerrors) (_expressionOnamesInScope) (_expressionOoptions) (_expressionOorderedTypeSynonyms) (_expressionOtypeConstructors) (_expressionOvalueConstructors) (_expressionOwarnings))
            ( _recordExpressionBindingsIcollectInstances,_recordExpressionBindingsIcollectScopeInfos,_recordExpressionBindingsIself,_recordExpressionBindingsIunboundNames) =
                (recordExpressionBindings_ (_recordExpressionBindingsOclassEnvironment) (_recordExpressionBindingsOcollectScopeInfos) (_recordExpressionBindingsOnamesInScope) (_recordExpressionBindingsOoptions) (_recordExpressionBindingsOorderedTypeSynonyms))
            (_lhsOcollectInstances@_) =
                _expressionIcollectInstances  ++  _recordExpressionBindingsIcollectInstances
            (_lhsOunboundNames@_) =
                _expressionIunboundNames ++ _recordExpressionBindingsIunboundNames
            (_self@_) =
                Expression_RecordUpdate _rangeIself _expressionIself _recordExpressionBindingsIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _recordExpressionBindingsIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _expressionIkindErrors
            (_lhsOmiscerrors@_) =
                _expressionImiscerrors
            (_lhsOwarnings@_) =
                _expressionIwarnings
            (_expressionOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_expressionOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_expressionOkindErrors@_) =
                _lhsIkindErrors
            (_expressionOmiscerrors@_) =
                _lhsImiscerrors
            (_expressionOnamesInScope@_) =
                _lhsInamesInScope
            (_expressionOoptions@_) =
                _lhsIoptions
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOtypeConstructors@_) =
                _lhsItypeConstructors
            (_expressionOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_expressionOwarnings@_) =
                _lhsIwarnings
            (_recordExpressionBindingsOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_recordExpressionBindingsOcollectScopeInfos@_) =
                _expressionIcollectScopeInfos
            (_recordExpressionBindingsOnamesInScope@_) =
                _lhsInamesInScope
            (_recordExpressionBindingsOoptions@_) =
                _lhsIoptions
            (_recordExpressionBindingsOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Expression_Tuple :: (T_Range) ->
                        (T_Expressions) ->
                        (T_Expression)
sem_Expression_Tuple (range_) (expressions_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _expressionsIcollectInstances :: ([(Name, Instance)])
            _expressionsIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionsIkindErrors :: ([Error])
            _expressionsImiscerrors :: ([Error])
            _expressionsIself :: (Expressions)
            _expressionsIunboundNames :: (Names)
            _expressionsIwarnings :: ([Warning])
            _expressionsOallTypeConstructors :: (Names)
            _expressionsOallValueConstructors :: (Names)
            _expressionsOclassEnvironment :: (ClassEnvironment)
            _expressionsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionsOkindErrors :: ([Error])
            _expressionsOmiscerrors :: ([Error])
            _expressionsOnamesInScope :: (Names)
            _expressionsOoptions :: ([Option])
            _expressionsOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionsOtypeConstructors :: (M.Map Name Int)
            _expressionsOvalueConstructors :: (M.Map Name TpScheme)
            _expressionsOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _expressionsIcollectInstances,_expressionsIcollectScopeInfos,_expressionsIkindErrors,_expressionsImiscerrors,_expressionsIself,_expressionsIunboundNames,_expressionsIwarnings) =
                (expressions_ (_expressionsOallTypeConstructors) (_expressionsOallValueConstructors) (_expressionsOclassEnvironment) (_expressionsOcollectScopeInfos) (_expressionsOkindErrors) (_expressionsOmiscerrors) (_expressionsOnamesInScope) (_expressionsOoptions) (_expressionsOorderedTypeSynonyms) (_expressionsOtypeConstructors) (_expressionsOvalueConstructors) (_expressionsOwarnings))
            (_tupleTooBigErrors@_) =
                [ TupleTooBig _rangeIself
                | length _expressionsIself > 10
                ]
            (_lhsOmiscerrors@_) =
                _tupleTooBigErrors ++ _expressionsImiscerrors
            (_lhsOcollectInstances@_) =
                _expressionsIcollectInstances
            (_lhsOunboundNames@_) =
                _expressionsIunboundNames
            (_self@_) =
                Expression_Tuple _rangeIself _expressionsIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _expressionsIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _expressionsIkindErrors
            (_lhsOwarnings@_) =
                _expressionsIwarnings
            (_expressionsOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_expressionsOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_expressionsOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_expressionsOkindErrors@_) =
                _lhsIkindErrors
            (_expressionsOmiscerrors@_) =
                _lhsImiscerrors
            (_expressionsOnamesInScope@_) =
                _lhsInamesInScope
            (_expressionsOoptions@_) =
                _lhsIoptions
            (_expressionsOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionsOtypeConstructors@_) =
                _lhsItypeConstructors
            (_expressionsOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_expressionsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Expression_Typed :: (T_Range) ->
                        (T_Expression) ->
                        (T_Type) ->
                        (T_Expression)
sem_Expression_Typed (range_) (expression_) (type_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionIkindErrors :: ([Error])
            _expressionImiscerrors :: ([Error])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIwarnings :: ([Warning])
            _expressionOallTypeConstructors :: (Names)
            _expressionOallValueConstructors :: (Names)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionOkindErrors :: ([Error])
            _expressionOmiscerrors :: ([Error])
            _expressionOnamesInScope :: (Names)
            _expressionOoptions :: ([Option])
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOtypeConstructors :: (M.Map Name Int)
            _expressionOvalueConstructors :: (M.Map Name TpScheme)
            _expressionOwarnings :: ([Warning])
            _typeIcontextRange :: (Range)
            _typeImiscerrors :: ([Error])
            _typeIself :: (Type)
            _typeItypevariables :: (Names)
            _typeIwarnings :: ([Warning])
            _typeOallTypeConstructors :: (Names)
            _typeOmiscerrors :: ([Error])
            _typeOoptions :: ([Option])
            _typeOtypeConstructors :: (M.Map Name Int)
            _typeOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _expressionIcollectInstances,_expressionIcollectScopeInfos,_expressionIkindErrors,_expressionImiscerrors,_expressionIself,_expressionIunboundNames,_expressionIwarnings) =
                (expression_ (_expressionOallTypeConstructors) (_expressionOallValueConstructors) (_expressionOclassEnvironment) (_expressionOcollectScopeInfos) (_expressionOkindErrors) (_expressionOmiscerrors) (_expressionOnamesInScope) (_expressionOoptions) (_expressionOorderedTypeSynonyms) (_expressionOtypeConstructors) (_expressionOvalueConstructors) (_expressionOwarnings))
            ( _typeIcontextRange,_typeImiscerrors,_typeIself,_typeItypevariables,_typeIwarnings) =
                (type_ (_typeOallTypeConstructors) (_typeOmiscerrors) (_typeOoptions) (_typeOtypeConstructors) (_typeOwarnings))
            (_newErrors@_) =
                checkType _lhsItypeConstructors (_lhsInamesInScope ++ _lhsIallValueConstructors) _typeIself
            (_lhsOkindErrors@_) =
                _newErrors ++ _expressionIkindErrors
            (_lhsOcollectInstances@_) =
                _expressionIcollectInstances
            (_lhsOunboundNames@_) =
                _expressionIunboundNames
            (_self@_) =
                Expression_Typed _rangeIself _expressionIself _typeIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _expressionIcollectScopeInfos
            (_lhsOmiscerrors@_) =
                _typeImiscerrors
            (_lhsOwarnings@_) =
                _typeIwarnings
            (_expressionOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_expressionOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_expressionOkindErrors@_) =
                _lhsIkindErrors
            (_expressionOmiscerrors@_) =
                _lhsImiscerrors
            (_expressionOnamesInScope@_) =
                _lhsInamesInScope
            (_expressionOoptions@_) =
                _lhsIoptions
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOtypeConstructors@_) =
                _lhsItypeConstructors
            (_expressionOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_expressionOwarnings@_) =
                _lhsIwarnings
            (_typeOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_typeOmiscerrors@_) =
                _expressionImiscerrors
            (_typeOoptions@_) =
                _lhsIoptions
            (_typeOtypeConstructors@_) =
                _lhsItypeConstructors
            (_typeOwarnings@_) =
                _expressionIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Expression_Variable :: (T_Range) ->
                           (T_Name) ->
                           (T_Expression)
sem_Expression_Variable (range_) (name_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _nameIself :: (Name)
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            (_lhsOunboundNames@_) =
                [ _nameIself ]
            (_undefinedErrors@_) =
                if _nameIself `elem` _lhsInamesInScope
                  then []
                  else [ Undefined Variable _nameIself _lhsInamesInScope [] ]
            (_lhsOmiscerrors@_) =
                _undefinedErrors ++ _lhsImiscerrors
            (_lhsOcollectInstances@_) =
                []
            (_self@_) =
                Expression_Variable _rangeIself _nameIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _lhsIkindErrors
            (_lhsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
-- Expressions -------------------------------------------------
-- semantic domain
type T_Expressions = (Names) ->
                     (Names) ->
                     (ClassEnvironment) ->
                     ([(ScopeInfo, Entity)]) ->
                     ([Error]) ->
                     ([Error]) ->
                     (Names) ->
                     ([Option]) ->
                     (OrderedTypeSynonyms) ->
                     (M.Map Name Int) ->
                     (M.Map Name TpScheme) ->
                     ([Warning]) ->
                     ( ([(Name, Instance)]),([(ScopeInfo, Entity)]),([Error]),([Error]),(Expressions),(Names),([Warning]))
-- cata
sem_Expressions :: (Expressions) ->
                   (T_Expressions)
sem_Expressions (list) =
    (Prelude.foldr (sem_Expressions_Cons) (sem_Expressions_Nil) ((Prelude.map sem_Expression list)))
sem_Expressions_Cons :: (T_Expression) ->
                        (T_Expressions) ->
                        (T_Expressions)
sem_Expressions_Cons (hd_) (tl_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Expressions)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _hdIcollectInstances :: ([(Name, Instance)])
            _hdIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _hdIkindErrors :: ([Error])
            _hdImiscerrors :: ([Error])
            _hdIself :: (Expression)
            _hdIunboundNames :: (Names)
            _hdIwarnings :: ([Warning])
            _hdOallTypeConstructors :: (Names)
            _hdOallValueConstructors :: (Names)
            _hdOclassEnvironment :: (ClassEnvironment)
            _hdOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _hdOkindErrors :: ([Error])
            _hdOmiscerrors :: ([Error])
            _hdOnamesInScope :: (Names)
            _hdOoptions :: ([Option])
            _hdOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _hdOtypeConstructors :: (M.Map Name Int)
            _hdOvalueConstructors :: (M.Map Name TpScheme)
            _hdOwarnings :: ([Warning])
            _tlIcollectInstances :: ([(Name, Instance)])
            _tlIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _tlIkindErrors :: ([Error])
            _tlImiscerrors :: ([Error])
            _tlIself :: (Expressions)
            _tlIunboundNames :: (Names)
            _tlIwarnings :: ([Warning])
            _tlOallTypeConstructors :: (Names)
            _tlOallValueConstructors :: (Names)
            _tlOclassEnvironment :: (ClassEnvironment)
            _tlOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _tlOkindErrors :: ([Error])
            _tlOmiscerrors :: ([Error])
            _tlOnamesInScope :: (Names)
            _tlOoptions :: ([Option])
            _tlOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _tlOtypeConstructors :: (M.Map Name Int)
            _tlOvalueConstructors :: (M.Map Name TpScheme)
            _tlOwarnings :: ([Warning])
            ( _hdIcollectInstances,_hdIcollectScopeInfos,_hdIkindErrors,_hdImiscerrors,_hdIself,_hdIunboundNames,_hdIwarnings) =
                (hd_ (_hdOallTypeConstructors) (_hdOallValueConstructors) (_hdOclassEnvironment) (_hdOcollectScopeInfos) (_hdOkindErrors) (_hdOmiscerrors) (_hdOnamesInScope) (_hdOoptions) (_hdOorderedTypeSynonyms) (_hdOtypeConstructors) (_hdOvalueConstructors) (_hdOwarnings))
            ( _tlIcollectInstances,_tlIcollectScopeInfos,_tlIkindErrors,_tlImiscerrors,_tlIself,_tlIunboundNames,_tlIwarnings) =
                (tl_ (_tlOallTypeConstructors) (_tlOallValueConstructors) (_tlOclassEnvironment) (_tlOcollectScopeInfos) (_tlOkindErrors) (_tlOmiscerrors) (_tlOnamesInScope) (_tlOoptions) (_tlOorderedTypeSynonyms) (_tlOtypeConstructors) (_tlOvalueConstructors) (_tlOwarnings))
            (_lhsOcollectInstances@_) =
                _hdIcollectInstances  ++  _tlIcollectInstances
            (_lhsOunboundNames@_) =
                _hdIunboundNames ++ _tlIunboundNames
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _tlIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _tlIkindErrors
            (_lhsOmiscerrors@_) =
                _tlImiscerrors
            (_lhsOwarnings@_) =
                _tlIwarnings
            (_hdOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_hdOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_hdOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_hdOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_hdOkindErrors@_) =
                _lhsIkindErrors
            (_hdOmiscerrors@_) =
                _lhsImiscerrors
            (_hdOnamesInScope@_) =
                _lhsInamesInScope
            (_hdOoptions@_) =
                _lhsIoptions
            (_hdOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_hdOtypeConstructors@_) =
                _lhsItypeConstructors
            (_hdOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_hdOwarnings@_) =
                _lhsIwarnings
            (_tlOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_tlOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_tlOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_tlOcollectScopeInfos@_) =
                _hdIcollectScopeInfos
            (_tlOkindErrors@_) =
                _hdIkindErrors
            (_tlOmiscerrors@_) =
                _hdImiscerrors
            (_tlOnamesInScope@_) =
                _lhsInamesInScope
            (_tlOoptions@_) =
                _lhsIoptions
            (_tlOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_tlOtypeConstructors@_) =
                _lhsItypeConstructors
            (_tlOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_tlOwarnings@_) =
                _hdIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Expressions_Nil :: (T_Expressions)
sem_Expressions_Nil  =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Expressions)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            (_lhsOcollectInstances@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _lhsIkindErrors
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
            (_lhsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
-- FieldDeclaration --------------------------------------------
-- semantic domain
type T_FieldDeclaration = ([Error]) ->
                          (Names) ->
                          ([Option]) ->
                          ( ([Error]),(FieldDeclaration),(Names))
-- cata
sem_FieldDeclaration :: (FieldDeclaration) ->
                        (T_FieldDeclaration)
sem_FieldDeclaration ((FieldDeclaration_FieldDeclaration (_range) (_names) (_type))) =
    (sem_FieldDeclaration_FieldDeclaration ((sem_Range (_range))) ((sem_Names (_names))) ((sem_AnnotatedType (_type))))
sem_FieldDeclaration_FieldDeclaration :: (T_Range) ->
                                         (T_Names) ->
                                         (T_AnnotatedType) ->
                                         (T_FieldDeclaration)
sem_FieldDeclaration_FieldDeclaration (range_) (names_) (type_) =
    \ _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions ->
        let _lhsOmiscerrors :: ([Error])
            _lhsOself :: (FieldDeclaration)
            _lhsOunboundNames :: (Names)
            _rangeIself :: (Range)
            _namesIself :: (Names)
            _typeIkindErrors :: ([Error])
            _typeImiscerrors :: ([Error])
            _typeIself :: (AnnotatedType)
            _typeItype :: (Type)
            _typeItypevariables :: (Names)
            _typeIunboundNames :: (Names)
            _typeIwarnings :: ([Warning])
            _typeOallTypeConstructors :: (Names)
            _typeOallValueConstructors :: (Names)
            _typeOkindErrors :: ([Error])
            _typeOmiscerrors :: ([Error])
            _typeOnamesInScope :: (Names)
            _typeOoptions :: ([Option])
            _typeOtypeConstructors :: (M.Map Name Int)
            _typeOvalueConstructors :: (M.Map Name TpScheme)
            _typeOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _namesIself) =
                (names_ )
            ( _typeIkindErrors,_typeImiscerrors,_typeIself,_typeItype,_typeItypevariables,_typeIunboundNames,_typeIwarnings) =
                (type_ (_typeOallTypeConstructors) (_typeOallValueConstructors) (_typeOkindErrors) (_typeOmiscerrors) (_typeOnamesInScope) (_typeOoptions) (_typeOtypeConstructors) (_typeOvalueConstructors) (_typeOwarnings))
            ((_kindErrors@_,_tyconEnv@_,_constructorenv@_,_importEnvironment@_,_valueConstructors@_,_allValueConstructors@_,_typeConstructors@_,_allTypeConstructors@_,_warnings@_)) =
                internalError "PartialSyntax.ag" "n/a" "FieldDeclaration.FieldDeclaration"
            (_lhsOunboundNames@_) =
                _typeIunboundNames
            (_self@_) =
                FieldDeclaration_FieldDeclaration _rangeIself _namesIself _typeIself
            (_lhsOself@_) =
                _self
            (_lhsOmiscerrors@_) =
                _typeImiscerrors
            (_typeOallTypeConstructors@_) =
                _allTypeConstructors
            (_typeOallValueConstructors@_) =
                _allValueConstructors
            (_typeOkindErrors@_) =
                _kindErrors
            (_typeOmiscerrors@_) =
                _lhsImiscerrors
            (_typeOnamesInScope@_) =
                _lhsInamesInScope
            (_typeOoptions@_) =
                _lhsIoptions
            (_typeOtypeConstructors@_) =
                _typeConstructors
            (_typeOvalueConstructors@_) =
                _valueConstructors
            (_typeOwarnings@_) =
                _warnings
        in  ( _lhsOmiscerrors,_lhsOself,_lhsOunboundNames)
-- FieldDeclarations -------------------------------------------
-- semantic domain
type T_FieldDeclarations = ([Error]) ->
                           (Names) ->
                           ([Option]) ->
                           ( ([Error]),(FieldDeclarations),(Names))
-- cata
sem_FieldDeclarations :: (FieldDeclarations) ->
                         (T_FieldDeclarations)
sem_FieldDeclarations (list) =
    (Prelude.foldr (sem_FieldDeclarations_Cons) (sem_FieldDeclarations_Nil) ((Prelude.map sem_FieldDeclaration list)))
sem_FieldDeclarations_Cons :: (T_FieldDeclaration) ->
                              (T_FieldDeclarations) ->
                              (T_FieldDeclarations)
sem_FieldDeclarations_Cons (hd_) (tl_) =
    \ _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions ->
        let _lhsOmiscerrors :: ([Error])
            _lhsOself :: (FieldDeclarations)
            _lhsOunboundNames :: (Names)
            _hdImiscerrors :: ([Error])
            _hdIself :: (FieldDeclaration)
            _hdIunboundNames :: (Names)
            _hdOmiscerrors :: ([Error])
            _hdOnamesInScope :: (Names)
            _hdOoptions :: ([Option])
            _tlImiscerrors :: ([Error])
            _tlIself :: (FieldDeclarations)
            _tlIunboundNames :: (Names)
            _tlOmiscerrors :: ([Error])
            _tlOnamesInScope :: (Names)
            _tlOoptions :: ([Option])
            ( _hdImiscerrors,_hdIself,_hdIunboundNames) =
                (hd_ (_hdOmiscerrors) (_hdOnamesInScope) (_hdOoptions))
            ( _tlImiscerrors,_tlIself,_tlIunboundNames) =
                (tl_ (_tlOmiscerrors) (_tlOnamesInScope) (_tlOoptions))
            (_lhsOunboundNames@_) =
                _hdIunboundNames ++ _tlIunboundNames
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsOmiscerrors@_) =
                _tlImiscerrors
            (_hdOmiscerrors@_) =
                _lhsImiscerrors
            (_hdOnamesInScope@_) =
                _lhsInamesInScope
            (_hdOoptions@_) =
                _lhsIoptions
            (_tlOmiscerrors@_) =
                _hdImiscerrors
            (_tlOnamesInScope@_) =
                _lhsInamesInScope
            (_tlOoptions@_) =
                _lhsIoptions
        in  ( _lhsOmiscerrors,_lhsOself,_lhsOunboundNames)
sem_FieldDeclarations_Nil :: (T_FieldDeclarations)
sem_FieldDeclarations_Nil  =
    \ _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions ->
        let _lhsOmiscerrors :: ([Error])
            _lhsOself :: (FieldDeclarations)
            _lhsOunboundNames :: (Names)
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
        in  ( _lhsOmiscerrors,_lhsOself,_lhsOunboundNames)
-- Fixity ------------------------------------------------------
-- semantic domain
type T_Fixity = ( (Fixity))
-- cata
sem_Fixity :: (Fixity) ->
              (T_Fixity)
sem_Fixity ((Fixity_Infix (_range))) =
    (sem_Fixity_Infix ((sem_Range (_range))))
sem_Fixity ((Fixity_Infixl (_range))) =
    (sem_Fixity_Infixl ((sem_Range (_range))))
sem_Fixity ((Fixity_Infixr (_range))) =
    (sem_Fixity_Infixr ((sem_Range (_range))))
sem_Fixity_Infix :: (T_Range) ->
                    (T_Fixity)
sem_Fixity_Infix (range_) =
    let _lhsOself :: (Fixity)
        _rangeIself :: (Range)
        ( _rangeIself) =
            (range_ )
        (_self@_) =
            Fixity_Infix _rangeIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Fixity_Infixl :: (T_Range) ->
                     (T_Fixity)
sem_Fixity_Infixl (range_) =
    let _lhsOself :: (Fixity)
        _rangeIself :: (Range)
        ( _rangeIself) =
            (range_ )
        (_self@_) =
            Fixity_Infixl _rangeIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Fixity_Infixr :: (T_Range) ->
                     (T_Fixity)
sem_Fixity_Infixr (range_) =
    let _lhsOself :: (Fixity)
        _rangeIself :: (Range)
        ( _rangeIself) =
            (range_ )
        (_self@_) =
            Fixity_Infixr _rangeIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- FunctionBinding ---------------------------------------------
-- semantic domain
type T_FunctionBinding = (Names) ->
                         (Names) ->
                         (ClassEnvironment) ->
                         ([(ScopeInfo, Entity)]) ->
                         ([Error]) ->
                         ([Error]) ->
                         (Names) ->
                         ([Option]) ->
                         (OrderedTypeSynonyms) ->
                         (M.Map Name Int) ->
                         (M.Map Name TpScheme) ->
                         ([Warning]) ->
                         ( (Int),([(Name, Instance)]),([(ScopeInfo, Entity)]),([Error]),([Error]),(Name),(FunctionBinding),(Names),([Warning]))
-- cata
sem_FunctionBinding :: (FunctionBinding) ->
                       (T_FunctionBinding)
sem_FunctionBinding ((FunctionBinding_FunctionBinding (_range) (_lefthandside) (_righthandside))) =
    (sem_FunctionBinding_FunctionBinding ((sem_Range (_range))) ((sem_LeftHandSide (_lefthandside))) ((sem_RightHandSide (_righthandside))))
sem_FunctionBinding_FunctionBinding :: (T_Range) ->
                                       (T_LeftHandSide) ->
                                       (T_RightHandSide) ->
                                       (T_FunctionBinding)
sem_FunctionBinding_FunctionBinding (range_) (lefthandside_) (righthandside_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOarity :: (Int)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOname :: (Name)
            _lhsOself :: (FunctionBinding)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _lefthandsideIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lefthandsideImiscerrors :: ([Error])
            _lefthandsideIname :: (Name)
            _lefthandsideInumberOfPatterns :: (Int)
            _lefthandsideIpatVarNames :: (Names)
            _lefthandsideIself :: (LeftHandSide)
            _lefthandsideIunboundNames :: (Names)
            _lefthandsideIwarnings :: ([Warning])
            _lefthandsideOallTypeConstructors :: (Names)
            _lefthandsideOallValueConstructors :: (Names)
            _lefthandsideOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lefthandsideOmiscerrors :: ([Error])
            _lefthandsideOnamesInScope :: (Names)
            _lefthandsideOtypeConstructors :: (M.Map Name Int)
            _lefthandsideOvalueConstructors :: (M.Map Name TpScheme)
            _lefthandsideOwarnings :: ([Warning])
            _righthandsideIcollectInstances :: ([(Name, Instance)])
            _righthandsideIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _righthandsideIkindErrors :: ([Error])
            _righthandsideImiscerrors :: ([Error])
            _righthandsideIself :: (RightHandSide)
            _righthandsideIunboundNames :: (Names)
            _righthandsideIwarnings :: ([Warning])
            _righthandsideOallTypeConstructors :: (Names)
            _righthandsideOallValueConstructors :: (Names)
            _righthandsideOclassEnvironment :: (ClassEnvironment)
            _righthandsideOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _righthandsideOkindErrors :: ([Error])
            _righthandsideOmiscerrors :: ([Error])
            _righthandsideOnamesInScope :: (Names)
            _righthandsideOoptions :: ([Option])
            _righthandsideOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _righthandsideOtypeConstructors :: (M.Map Name Int)
            _righthandsideOvalueConstructors :: (M.Map Name TpScheme)
            _righthandsideOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _lefthandsideIcollectScopeInfos,_lefthandsideImiscerrors,_lefthandsideIname,_lefthandsideInumberOfPatterns,_lefthandsideIpatVarNames,_lefthandsideIself,_lefthandsideIunboundNames,_lefthandsideIwarnings) =
                (lefthandside_ (_lefthandsideOallTypeConstructors) (_lefthandsideOallValueConstructors) (_lefthandsideOcollectScopeInfos) (_lefthandsideOmiscerrors) (_lefthandsideOnamesInScope) (_lefthandsideOtypeConstructors) (_lefthandsideOvalueConstructors) (_lefthandsideOwarnings))
            ( _righthandsideIcollectInstances,_righthandsideIcollectScopeInfos,_righthandsideIkindErrors,_righthandsideImiscerrors,_righthandsideIself,_righthandsideIunboundNames,_righthandsideIwarnings) =
                (righthandside_ (_righthandsideOallTypeConstructors) (_righthandsideOallValueConstructors) (_righthandsideOclassEnvironment) (_righthandsideOcollectScopeInfos) (_righthandsideOkindErrors) (_righthandsideOmiscerrors) (_righthandsideOnamesInScope) (_righthandsideOoptions) (_righthandsideOorderedTypeSynonyms) (_righthandsideOtypeConstructors) (_righthandsideOvalueConstructors) (_righthandsideOwarnings))
            (_lhsOunboundNames@_) =
                _unboundNames
            ((_namesInScope@_,_unboundNames@_,_scopeInfo@_)) =
                changeOfScope _lefthandsideIpatVarNames _righthandsideIunboundNames _lhsInamesInScope
            (_lhsOarity@_) =
                _lefthandsideInumberOfPatterns
            (_lhsOcollectScopeInfos@_) =
                (_scopeInfo, Variable)   : _righthandsideIcollectScopeInfos
            (_lhsOcollectInstances@_) =
                _righthandsideIcollectInstances
            (_self@_) =
                FunctionBinding_FunctionBinding _rangeIself _lefthandsideIself _righthandsideIself
            (_lhsOself@_) =
                _self
            (_lhsOkindErrors@_) =
                _righthandsideIkindErrors
            (_lhsOmiscerrors@_) =
                _righthandsideImiscerrors
            (_lhsOname@_) =
                _lefthandsideIname
            (_lhsOwarnings@_) =
                _righthandsideIwarnings
            (_lefthandsideOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_lefthandsideOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_lefthandsideOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lefthandsideOmiscerrors@_) =
                _lhsImiscerrors
            (_lefthandsideOnamesInScope@_) =
                _namesInScope
            (_lefthandsideOtypeConstructors@_) =
                _lhsItypeConstructors
            (_lefthandsideOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_lefthandsideOwarnings@_) =
                _lhsIwarnings
            (_righthandsideOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_righthandsideOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_righthandsideOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_righthandsideOcollectScopeInfos@_) =
                _lefthandsideIcollectScopeInfos
            (_righthandsideOkindErrors@_) =
                _lhsIkindErrors
            (_righthandsideOmiscerrors@_) =
                _lefthandsideImiscerrors
            (_righthandsideOnamesInScope@_) =
                _namesInScope
            (_righthandsideOoptions@_) =
                _lhsIoptions
            (_righthandsideOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_righthandsideOtypeConstructors@_) =
                _lhsItypeConstructors
            (_righthandsideOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_righthandsideOwarnings@_) =
                _lefthandsideIwarnings
        in  ( _lhsOarity,_lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOname,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
-- FunctionBindings --------------------------------------------
-- semantic domain
type T_FunctionBindings = (Names) ->
                          (Names) ->
                          (ClassEnvironment) ->
                          ([(ScopeInfo, Entity)]) ->
                          ([Error]) ->
                          ([Error]) ->
                          (Names) ->
                          ([Option]) ->
                          (OrderedTypeSynonyms) ->
                          (M.Map Name Int) ->
                          (M.Map Name TpScheme) ->
                          ([Warning]) ->
                          ( ( [Int] ),([(Name, Instance)]),([(ScopeInfo, Entity)]),([Error]),([Error]),(Name),(FunctionBindings),(Names),([Warning]))
-- cata
sem_FunctionBindings :: (FunctionBindings) ->
                        (T_FunctionBindings)
sem_FunctionBindings (list) =
    (Prelude.foldr (sem_FunctionBindings_Cons) (sem_FunctionBindings_Nil) ((Prelude.map sem_FunctionBinding list)))
sem_FunctionBindings_Cons :: (T_FunctionBinding) ->
                             (T_FunctionBindings) ->
                             (T_FunctionBindings)
sem_FunctionBindings_Cons (hd_) (tl_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOarities :: ( [Int] )
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOname :: (Name)
            _lhsOself :: (FunctionBindings)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _hdIarity :: (Int)
            _hdIcollectInstances :: ([(Name, Instance)])
            _hdIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _hdIkindErrors :: ([Error])
            _hdImiscerrors :: ([Error])
            _hdIname :: (Name)
            _hdIself :: (FunctionBinding)
            _hdIunboundNames :: (Names)
            _hdIwarnings :: ([Warning])
            _hdOallTypeConstructors :: (Names)
            _hdOallValueConstructors :: (Names)
            _hdOclassEnvironment :: (ClassEnvironment)
            _hdOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _hdOkindErrors :: ([Error])
            _hdOmiscerrors :: ([Error])
            _hdOnamesInScope :: (Names)
            _hdOoptions :: ([Option])
            _hdOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _hdOtypeConstructors :: (M.Map Name Int)
            _hdOvalueConstructors :: (M.Map Name TpScheme)
            _hdOwarnings :: ([Warning])
            _tlIarities :: ( [Int] )
            _tlIcollectInstances :: ([(Name, Instance)])
            _tlIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _tlIkindErrors :: ([Error])
            _tlImiscerrors :: ([Error])
            _tlIname :: (Name)
            _tlIself :: (FunctionBindings)
            _tlIunboundNames :: (Names)
            _tlIwarnings :: ([Warning])
            _tlOallTypeConstructors :: (Names)
            _tlOallValueConstructors :: (Names)
            _tlOclassEnvironment :: (ClassEnvironment)
            _tlOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _tlOkindErrors :: ([Error])
            _tlOmiscerrors :: ([Error])
            _tlOnamesInScope :: (Names)
            _tlOoptions :: ([Option])
            _tlOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _tlOtypeConstructors :: (M.Map Name Int)
            _tlOvalueConstructors :: (M.Map Name TpScheme)
            _tlOwarnings :: ([Warning])
            ( _hdIarity,_hdIcollectInstances,_hdIcollectScopeInfos,_hdIkindErrors,_hdImiscerrors,_hdIname,_hdIself,_hdIunboundNames,_hdIwarnings) =
                (hd_ (_hdOallTypeConstructors) (_hdOallValueConstructors) (_hdOclassEnvironment) (_hdOcollectScopeInfos) (_hdOkindErrors) (_hdOmiscerrors) (_hdOnamesInScope) (_hdOoptions) (_hdOorderedTypeSynonyms) (_hdOtypeConstructors) (_hdOvalueConstructors) (_hdOwarnings))
            ( _tlIarities,_tlIcollectInstances,_tlIcollectScopeInfos,_tlIkindErrors,_tlImiscerrors,_tlIname,_tlIself,_tlIunboundNames,_tlIwarnings) =
                (tl_ (_tlOallTypeConstructors) (_tlOallValueConstructors) (_tlOclassEnvironment) (_tlOcollectScopeInfos) (_tlOkindErrors) (_tlOmiscerrors) (_tlOnamesInScope) (_tlOoptions) (_tlOorderedTypeSynonyms) (_tlOtypeConstructors) (_tlOvalueConstructors) (_tlOwarnings))
            (_lhsOname@_) =
                _hdIname
            (_lhsOarities@_) =
                _hdIarity : _tlIarities
            (_lhsOcollectInstances@_) =
                _hdIcollectInstances  ++  _tlIcollectInstances
            (_lhsOunboundNames@_) =
                _hdIunboundNames ++ _tlIunboundNames
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _tlIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _tlIkindErrors
            (_lhsOmiscerrors@_) =
                _tlImiscerrors
            (_lhsOwarnings@_) =
                _tlIwarnings
            (_hdOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_hdOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_hdOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_hdOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_hdOkindErrors@_) =
                _lhsIkindErrors
            (_hdOmiscerrors@_) =
                _lhsImiscerrors
            (_hdOnamesInScope@_) =
                _lhsInamesInScope
            (_hdOoptions@_) =
                _lhsIoptions
            (_hdOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_hdOtypeConstructors@_) =
                _lhsItypeConstructors
            (_hdOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_hdOwarnings@_) =
                _lhsIwarnings
            (_tlOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_tlOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_tlOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_tlOcollectScopeInfos@_) =
                _hdIcollectScopeInfos
            (_tlOkindErrors@_) =
                _hdIkindErrors
            (_tlOmiscerrors@_) =
                _hdImiscerrors
            (_tlOnamesInScope@_) =
                _lhsInamesInScope
            (_tlOoptions@_) =
                _lhsIoptions
            (_tlOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_tlOtypeConstructors@_) =
                _lhsItypeConstructors
            (_tlOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_tlOwarnings@_) =
                _hdIwarnings
        in  ( _lhsOarities,_lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOname,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_FunctionBindings_Nil :: (T_FunctionBindings)
sem_FunctionBindings_Nil  =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOarities :: ( [Int] )
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOname :: (Name)
            _lhsOself :: (FunctionBindings)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            (_lhsOname@_) =
                internalError "StaticChecks.ag" "n/a" "empty FunctionBindings"
            (_lhsOarities@_) =
                []
            (_lhsOcollectInstances@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _lhsIkindErrors
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
            (_lhsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOarities,_lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOname,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
-- GuardedExpression -------------------------------------------
-- semantic domain
type T_GuardedExpression = (Names) ->
                           (Names) ->
                           (ClassEnvironment) ->
                           ([(ScopeInfo, Entity)]) ->
                           ([Error]) ->
                           ([Error]) ->
                           (Names) ->
                           ([Option]) ->
                           (OrderedTypeSynonyms) ->
                           (M.Map Name Int) ->
                           (M.Map Name TpScheme) ->
                           ([Warning]) ->
                           ( ([(Name, Instance)]),([(ScopeInfo, Entity)]),([Error]),([Error]),(GuardedExpression),(Names),([Warning]))
-- cata
sem_GuardedExpression :: (GuardedExpression) ->
                         (T_GuardedExpression)
sem_GuardedExpression ((GuardedExpression_GuardedExpression (_range) (_guard) (_expression))) =
    (sem_GuardedExpression_GuardedExpression ((sem_Range (_range))) ((sem_Expression (_guard))) ((sem_Expression (_expression))))
sem_GuardedExpression_GuardedExpression :: (T_Range) ->
                                           (T_Expression) ->
                                           (T_Expression) ->
                                           (T_GuardedExpression)
sem_GuardedExpression_GuardedExpression (range_) (guard_) (expression_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (GuardedExpression)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _guardIcollectInstances :: ([(Name, Instance)])
            _guardIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _guardIkindErrors :: ([Error])
            _guardImiscerrors :: ([Error])
            _guardIself :: (Expression)
            _guardIunboundNames :: (Names)
            _guardIwarnings :: ([Warning])
            _guardOallTypeConstructors :: (Names)
            _guardOallValueConstructors :: (Names)
            _guardOclassEnvironment :: (ClassEnvironment)
            _guardOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _guardOkindErrors :: ([Error])
            _guardOmiscerrors :: ([Error])
            _guardOnamesInScope :: (Names)
            _guardOoptions :: ([Option])
            _guardOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _guardOtypeConstructors :: (M.Map Name Int)
            _guardOvalueConstructors :: (M.Map Name TpScheme)
            _guardOwarnings :: ([Warning])
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionIkindErrors :: ([Error])
            _expressionImiscerrors :: ([Error])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIwarnings :: ([Warning])
            _expressionOallTypeConstructors :: (Names)
            _expressionOallValueConstructors :: (Names)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionOkindErrors :: ([Error])
            _expressionOmiscerrors :: ([Error])
            _expressionOnamesInScope :: (Names)
            _expressionOoptions :: ([Option])
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOtypeConstructors :: (M.Map Name Int)
            _expressionOvalueConstructors :: (M.Map Name TpScheme)
            _expressionOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _guardIcollectInstances,_guardIcollectScopeInfos,_guardIkindErrors,_guardImiscerrors,_guardIself,_guardIunboundNames,_guardIwarnings) =
                (guard_ (_guardOallTypeConstructors) (_guardOallValueConstructors) (_guardOclassEnvironment) (_guardOcollectScopeInfos) (_guardOkindErrors) (_guardOmiscerrors) (_guardOnamesInScope) (_guardOoptions) (_guardOorderedTypeSynonyms) (_guardOtypeConstructors) (_guardOvalueConstructors) (_guardOwarnings))
            ( _expressionIcollectInstances,_expressionIcollectScopeInfos,_expressionIkindErrors,_expressionImiscerrors,_expressionIself,_expressionIunboundNames,_expressionIwarnings) =
                (expression_ (_expressionOallTypeConstructors) (_expressionOallValueConstructors) (_expressionOclassEnvironment) (_expressionOcollectScopeInfos) (_expressionOkindErrors) (_expressionOmiscerrors) (_expressionOnamesInScope) (_expressionOoptions) (_expressionOorderedTypeSynonyms) (_expressionOtypeConstructors) (_expressionOvalueConstructors) (_expressionOwarnings))
            (_lhsOcollectInstances@_) =
                _guardIcollectInstances  ++  _expressionIcollectInstances
            (_lhsOunboundNames@_) =
                _guardIunboundNames ++ _expressionIunboundNames
            (_self@_) =
                GuardedExpression_GuardedExpression _rangeIself _guardIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _expressionIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _expressionIkindErrors
            (_lhsOmiscerrors@_) =
                _expressionImiscerrors
            (_lhsOwarnings@_) =
                _expressionIwarnings
            (_guardOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_guardOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_guardOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_guardOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_guardOkindErrors@_) =
                _lhsIkindErrors
            (_guardOmiscerrors@_) =
                _lhsImiscerrors
            (_guardOnamesInScope@_) =
                _lhsInamesInScope
            (_guardOoptions@_) =
                _lhsIoptions
            (_guardOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_guardOtypeConstructors@_) =
                _lhsItypeConstructors
            (_guardOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_guardOwarnings@_) =
                _lhsIwarnings
            (_expressionOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_expressionOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectScopeInfos@_) =
                _guardIcollectScopeInfos
            (_expressionOkindErrors@_) =
                _guardIkindErrors
            (_expressionOmiscerrors@_) =
                _guardImiscerrors
            (_expressionOnamesInScope@_) =
                _lhsInamesInScope
            (_expressionOoptions@_) =
                _lhsIoptions
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOtypeConstructors@_) =
                _lhsItypeConstructors
            (_expressionOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_expressionOwarnings@_) =
                _guardIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
-- GuardedExpressions ------------------------------------------
-- semantic domain
type T_GuardedExpressions = (Names) ->
                            (Names) ->
                            (ClassEnvironment) ->
                            ([(ScopeInfo, Entity)]) ->
                            ([Error]) ->
                            ([Error]) ->
                            (Names) ->
                            ([Option]) ->
                            (OrderedTypeSynonyms) ->
                            (M.Map Name Int) ->
                            (M.Map Name TpScheme) ->
                            ([Warning]) ->
                            ( ([(Name, Instance)]),([(ScopeInfo, Entity)]),([Error]),([Error]),(GuardedExpressions),(Names),([Warning]))
-- cata
sem_GuardedExpressions :: (GuardedExpressions) ->
                          (T_GuardedExpressions)
sem_GuardedExpressions (list) =
    (Prelude.foldr (sem_GuardedExpressions_Cons) (sem_GuardedExpressions_Nil) ((Prelude.map sem_GuardedExpression list)))
sem_GuardedExpressions_Cons :: (T_GuardedExpression) ->
                               (T_GuardedExpressions) ->
                               (T_GuardedExpressions)
sem_GuardedExpressions_Cons (hd_) (tl_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (GuardedExpressions)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _hdIcollectInstances :: ([(Name, Instance)])
            _hdIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _hdIkindErrors :: ([Error])
            _hdImiscerrors :: ([Error])
            _hdIself :: (GuardedExpression)
            _hdIunboundNames :: (Names)
            _hdIwarnings :: ([Warning])
            _hdOallTypeConstructors :: (Names)
            _hdOallValueConstructors :: (Names)
            _hdOclassEnvironment :: (ClassEnvironment)
            _hdOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _hdOkindErrors :: ([Error])
            _hdOmiscerrors :: ([Error])
            _hdOnamesInScope :: (Names)
            _hdOoptions :: ([Option])
            _hdOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _hdOtypeConstructors :: (M.Map Name Int)
            _hdOvalueConstructors :: (M.Map Name TpScheme)
            _hdOwarnings :: ([Warning])
            _tlIcollectInstances :: ([(Name, Instance)])
            _tlIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _tlIkindErrors :: ([Error])
            _tlImiscerrors :: ([Error])
            _tlIself :: (GuardedExpressions)
            _tlIunboundNames :: (Names)
            _tlIwarnings :: ([Warning])
            _tlOallTypeConstructors :: (Names)
            _tlOallValueConstructors :: (Names)
            _tlOclassEnvironment :: (ClassEnvironment)
            _tlOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _tlOkindErrors :: ([Error])
            _tlOmiscerrors :: ([Error])
            _tlOnamesInScope :: (Names)
            _tlOoptions :: ([Option])
            _tlOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _tlOtypeConstructors :: (M.Map Name Int)
            _tlOvalueConstructors :: (M.Map Name TpScheme)
            _tlOwarnings :: ([Warning])
            ( _hdIcollectInstances,_hdIcollectScopeInfos,_hdIkindErrors,_hdImiscerrors,_hdIself,_hdIunboundNames,_hdIwarnings) =
                (hd_ (_hdOallTypeConstructors) (_hdOallValueConstructors) (_hdOclassEnvironment) (_hdOcollectScopeInfos) (_hdOkindErrors) (_hdOmiscerrors) (_hdOnamesInScope) (_hdOoptions) (_hdOorderedTypeSynonyms) (_hdOtypeConstructors) (_hdOvalueConstructors) (_hdOwarnings))
            ( _tlIcollectInstances,_tlIcollectScopeInfos,_tlIkindErrors,_tlImiscerrors,_tlIself,_tlIunboundNames,_tlIwarnings) =
                (tl_ (_tlOallTypeConstructors) (_tlOallValueConstructors) (_tlOclassEnvironment) (_tlOcollectScopeInfos) (_tlOkindErrors) (_tlOmiscerrors) (_tlOnamesInScope) (_tlOoptions) (_tlOorderedTypeSynonyms) (_tlOtypeConstructors) (_tlOvalueConstructors) (_tlOwarnings))
            (_lhsOcollectInstances@_) =
                _hdIcollectInstances  ++  _tlIcollectInstances
            (_lhsOunboundNames@_) =
                _hdIunboundNames ++ _tlIunboundNames
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _tlIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _tlIkindErrors
            (_lhsOmiscerrors@_) =
                _tlImiscerrors
            (_lhsOwarnings@_) =
                _tlIwarnings
            (_hdOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_hdOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_hdOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_hdOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_hdOkindErrors@_) =
                _lhsIkindErrors
            (_hdOmiscerrors@_) =
                _lhsImiscerrors
            (_hdOnamesInScope@_) =
                _lhsInamesInScope
            (_hdOoptions@_) =
                _lhsIoptions
            (_hdOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_hdOtypeConstructors@_) =
                _lhsItypeConstructors
            (_hdOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_hdOwarnings@_) =
                _lhsIwarnings
            (_tlOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_tlOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_tlOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_tlOcollectScopeInfos@_) =
                _hdIcollectScopeInfos
            (_tlOkindErrors@_) =
                _hdIkindErrors
            (_tlOmiscerrors@_) =
                _hdImiscerrors
            (_tlOnamesInScope@_) =
                _lhsInamesInScope
            (_tlOoptions@_) =
                _lhsIoptions
            (_tlOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_tlOtypeConstructors@_) =
                _lhsItypeConstructors
            (_tlOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_tlOwarnings@_) =
                _hdIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_GuardedExpressions_Nil :: (T_GuardedExpressions)
sem_GuardedExpressions_Nil  =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (GuardedExpressions)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            (_lhsOcollectInstances@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _lhsIkindErrors
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
            (_lhsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
-- Import ------------------------------------------------------
-- semantic domain
type T_Import = ( (Import))
-- cata
sem_Import :: (Import) ->
              (T_Import)
sem_Import ((Import_TypeOrClass (_range) (_name) (_names))) =
    (sem_Import_TypeOrClass ((sem_Range (_range))) ((sem_Name (_name))) ((sem_MaybeNames (_names))))
sem_Import ((Import_TypeOrClassComplete (_range) (_name))) =
    (sem_Import_TypeOrClassComplete ((sem_Range (_range))) ((sem_Name (_name))))
sem_Import ((Import_Variable (_range) (_name))) =
    (sem_Import_Variable ((sem_Range (_range))) ((sem_Name (_name))))
sem_Import_TypeOrClass :: (T_Range) ->
                          (T_Name) ->
                          (T_MaybeNames) ->
                          (T_Import)
sem_Import_TypeOrClass (range_) (name_) (names_) =
    let _lhsOself :: (Import)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        _namesIself :: (MaybeNames)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        ( _namesIself) =
            (names_ )
        (_self@_) =
            Import_TypeOrClass _rangeIself _nameIself _namesIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Import_TypeOrClassComplete :: (T_Range) ->
                                  (T_Name) ->
                                  (T_Import)
sem_Import_TypeOrClassComplete (range_) (name_) =
    let _lhsOself :: (Import)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        (_self@_) =
            Import_TypeOrClassComplete _rangeIself _nameIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Import_Variable :: (T_Range) ->
                       (T_Name) ->
                       (T_Import)
sem_Import_Variable (range_) (name_) =
    let _lhsOself :: (Import)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        (_self@_) =
            Import_Variable _rangeIself _nameIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- ImportDeclaration -------------------------------------------
-- semantic domain
type T_ImportDeclaration = (Names) ->
                           ( (Names),(ImportDeclaration))
-- cata
sem_ImportDeclaration :: (ImportDeclaration) ->
                         (T_ImportDeclaration)
sem_ImportDeclaration ((ImportDeclaration_Empty (_range))) =
    (sem_ImportDeclaration_Empty ((sem_Range (_range))))
sem_ImportDeclaration ((ImportDeclaration_Import (_range) (_qualified) (_name) (_asname) (_importspecification))) =
    (sem_ImportDeclaration_Import ((sem_Range (_range))) (_qualified) ((sem_Name (_name))) ((sem_MaybeName (_asname))) ((sem_MaybeImportSpecification (_importspecification))))
sem_ImportDeclaration_Empty :: (T_Range) ->
                               (T_ImportDeclaration)
sem_ImportDeclaration_Empty (range_) =
    \ _lhsIimportedModules ->
        let _lhsOimportedModules :: (Names)
            _lhsOself :: (ImportDeclaration)
            _rangeIself :: (Range)
            ( _rangeIself) =
                (range_ )
            (_self@_) =
                ImportDeclaration_Empty _rangeIself
            (_lhsOself@_) =
                _self
            (_lhsOimportedModules@_) =
                _lhsIimportedModules
        in  ( _lhsOimportedModules,_lhsOself)
sem_ImportDeclaration_Import :: (T_Range) ->
                                (Bool) ->
                                (T_Name) ->
                                (T_MaybeName) ->
                                (T_MaybeImportSpecification) ->
                                (T_ImportDeclaration)
sem_ImportDeclaration_Import (range_) (qualified_) (name_) (asname_) (importspecification_) =
    \ _lhsIimportedModules ->
        let _lhsOimportedModules :: (Names)
            _lhsOself :: (ImportDeclaration)
            _rangeIself :: (Range)
            _nameIself :: (Name)
            _asnameIself :: (MaybeName)
            _importspecificationIself :: (MaybeImportSpecification)
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            ( _asnameIself) =
                (asname_ )
            ( _importspecificationIself) =
                (importspecification_ )
            (_lhsOimportedModules@_) =
                _nameIself : _lhsIimportedModules
            (_self@_) =
                ImportDeclaration_Import _rangeIself qualified_ _nameIself _asnameIself _importspecificationIself
            (_lhsOself@_) =
                _self
        in  ( _lhsOimportedModules,_lhsOself)
-- ImportDeclarations ------------------------------------------
-- semantic domain
type T_ImportDeclarations = (Names) ->
                            ( (Names),(ImportDeclarations))
-- cata
sem_ImportDeclarations :: (ImportDeclarations) ->
                          (T_ImportDeclarations)
sem_ImportDeclarations (list) =
    (Prelude.foldr (sem_ImportDeclarations_Cons) (sem_ImportDeclarations_Nil) ((Prelude.map sem_ImportDeclaration list)))
sem_ImportDeclarations_Cons :: (T_ImportDeclaration) ->
                               (T_ImportDeclarations) ->
                               (T_ImportDeclarations)
sem_ImportDeclarations_Cons (hd_) (tl_) =
    \ _lhsIimportedModules ->
        let _lhsOimportedModules :: (Names)
            _lhsOself :: (ImportDeclarations)
            _hdIimportedModules :: (Names)
            _hdIself :: (ImportDeclaration)
            _hdOimportedModules :: (Names)
            _tlIimportedModules :: (Names)
            _tlIself :: (ImportDeclarations)
            _tlOimportedModules :: (Names)
            ( _hdIimportedModules,_hdIself) =
                (hd_ (_hdOimportedModules))
            ( _tlIimportedModules,_tlIself) =
                (tl_ (_tlOimportedModules))
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsOimportedModules@_) =
                _tlIimportedModules
            (_hdOimportedModules@_) =
                _lhsIimportedModules
            (_tlOimportedModules@_) =
                _hdIimportedModules
        in  ( _lhsOimportedModules,_lhsOself)
sem_ImportDeclarations_Nil :: (T_ImportDeclarations)
sem_ImportDeclarations_Nil  =
    \ _lhsIimportedModules ->
        let _lhsOimportedModules :: (Names)
            _lhsOself :: (ImportDeclarations)
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsOimportedModules@_) =
                _lhsIimportedModules
        in  ( _lhsOimportedModules,_lhsOself)
-- ImportSpecification -----------------------------------------
-- semantic domain
type T_ImportSpecification = ( (ImportSpecification))
-- cata
sem_ImportSpecification :: (ImportSpecification) ->
                           (T_ImportSpecification)
sem_ImportSpecification ((ImportSpecification_Import (_range) (_hiding) (_imports))) =
    (sem_ImportSpecification_Import ((sem_Range (_range))) (_hiding) ((sem_Imports (_imports))))
sem_ImportSpecification_Import :: (T_Range) ->
                                  (Bool) ->
                                  (T_Imports) ->
                                  (T_ImportSpecification)
sem_ImportSpecification_Import (range_) (hiding_) (imports_) =
    let _lhsOself :: (ImportSpecification)
        _rangeIself :: (Range)
        _importsIself :: (Imports)
        ( _rangeIself) =
            (range_ )
        ( _importsIself) =
            (imports_ )
        (_self@_) =
            ImportSpecification_Import _rangeIself hiding_ _importsIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- Imports -----------------------------------------------------
-- semantic domain
type T_Imports = ( (Imports))
-- cata
sem_Imports :: (Imports) ->
               (T_Imports)
sem_Imports (list) =
    (Prelude.foldr (sem_Imports_Cons) (sem_Imports_Nil) ((Prelude.map sem_Import list)))
sem_Imports_Cons :: (T_Import) ->
                    (T_Imports) ->
                    (T_Imports)
sem_Imports_Cons (hd_) (tl_) =
    let _lhsOself :: (Imports)
        _hdIself :: (Import)
        _tlIself :: (Imports)
        ( _hdIself) =
            (hd_ )
        ( _tlIself) =
            (tl_ )
        (_self@_) =
            (:) _hdIself _tlIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Imports_Nil :: (T_Imports)
sem_Imports_Nil  =
    let _lhsOself :: (Imports)
        (_self@_) =
            []
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- LeftHandSide ------------------------------------------------
-- semantic domain
type T_LeftHandSide = (Names) ->
                      (Names) ->
                      ([(ScopeInfo, Entity)]) ->
                      ([Error]) ->
                      (Names) ->
                      (M.Map Name Int) ->
                      (M.Map Name TpScheme) ->
                      ([Warning]) ->
                      ( ([(ScopeInfo, Entity)]),([Error]),(Name),(Int),(Names),(LeftHandSide),(Names),([Warning]))
-- cata
sem_LeftHandSide :: (LeftHandSide) ->
                    (T_LeftHandSide)
sem_LeftHandSide ((LeftHandSide_Function (_range) (_name) (_patterns))) =
    (sem_LeftHandSide_Function ((sem_Range (_range))) ((sem_Name (_name))) ((sem_Patterns (_patterns))))
sem_LeftHandSide ((LeftHandSide_Infix (_range) (_leftPattern) (_operator) (_rightPattern))) =
    (sem_LeftHandSide_Infix ((sem_Range (_range))) ((sem_Pattern (_leftPattern))) ((sem_Name (_operator))) ((sem_Pattern (_rightPattern))))
sem_LeftHandSide ((LeftHandSide_Parenthesized (_range) (_lefthandside) (_patterns))) =
    (sem_LeftHandSide_Parenthesized ((sem_Range (_range))) ((sem_LeftHandSide (_lefthandside))) ((sem_Patterns (_patterns))))
sem_LeftHandSide_Function :: (T_Range) ->
                             (T_Name) ->
                             (T_Patterns) ->
                             (T_LeftHandSide)
sem_LeftHandSide_Function (range_) (name_) (patterns_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIcollectScopeInfos
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOmiscerrors :: ([Error])
            _lhsOname :: (Name)
            _lhsOnumberOfPatterns :: (Int)
            _lhsOpatVarNames :: (Names)
            _lhsOself :: (LeftHandSide)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _nameIself :: (Name)
            _patternsIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _patternsImiscerrors :: ([Error])
            _patternsInumberOfPatterns :: (Int)
            _patternsIpatVarNames :: (Names)
            _patternsIself :: (Patterns)
            _patternsIunboundNames :: (Names)
            _patternsIwarnings :: ([Warning])
            _patternsOallTypeConstructors :: (Names)
            _patternsOallValueConstructors :: (Names)
            _patternsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _patternsOlhsPattern :: (Bool)
            _patternsOmiscerrors :: ([Error])
            _patternsOnamesInScope :: (Names)
            _patternsOtypeConstructors :: (M.Map Name Int)
            _patternsOvalueConstructors :: (M.Map Name TpScheme)
            _patternsOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            ( _patternsIcollectScopeInfos,_patternsImiscerrors,_patternsInumberOfPatterns,_patternsIpatVarNames,_patternsIself,_patternsIunboundNames,_patternsIwarnings) =
                (patterns_ (_patternsOallTypeConstructors) (_patternsOallValueConstructors) (_patternsOcollectScopeInfos) (_patternsOlhsPattern) (_patternsOmiscerrors) (_patternsOnamesInScope) (_patternsOtypeConstructors) (_patternsOvalueConstructors) (_patternsOwarnings))
            (_lhsOname@_) =
                _nameIself
            (_patternsOlhsPattern@_) =
                False
            (_lhsOpatVarNames@_) =
                _patternsIpatVarNames
            (_lhsOunboundNames@_) =
                _patternsIunboundNames
            (_self@_) =
                LeftHandSide_Function _rangeIself _nameIself _patternsIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _patternsIcollectScopeInfos
            (_lhsOmiscerrors@_) =
                _patternsImiscerrors
            (_lhsOnumberOfPatterns@_) =
                _patternsInumberOfPatterns
            (_lhsOwarnings@_) =
                _patternsIwarnings
            (_patternsOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_patternsOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_patternsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_patternsOmiscerrors@_) =
                _lhsImiscerrors
            (_patternsOnamesInScope@_) =
                _lhsInamesInScope
            (_patternsOtypeConstructors@_) =
                _lhsItypeConstructors
            (_patternsOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_patternsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectScopeInfos,_lhsOmiscerrors,_lhsOname,_lhsOnumberOfPatterns,_lhsOpatVarNames,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_LeftHandSide_Infix :: (T_Range) ->
                          (T_Pattern) ->
                          (T_Name) ->
                          (T_Pattern) ->
                          (T_LeftHandSide)
sem_LeftHandSide_Infix (range_) (leftPattern_) (operator_) (rightPattern_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIcollectScopeInfos
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOmiscerrors :: ([Error])
            _lhsOname :: (Name)
            _lhsOnumberOfPatterns :: (Int)
            _lhsOpatVarNames :: (Names)
            _lhsOself :: (LeftHandSide)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _leftPatternIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _leftPatternImiscerrors :: ([Error])
            _leftPatternIpatVarNames :: (Names)
            _leftPatternIself :: (Pattern)
            _leftPatternIunboundNames :: (Names)
            _leftPatternIwarnings :: ([Warning])
            _leftPatternOallTypeConstructors :: (Names)
            _leftPatternOallValueConstructors :: (Names)
            _leftPatternOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _leftPatternOlhsPattern :: (Bool)
            _leftPatternOmiscerrors :: ([Error])
            _leftPatternOnamesInScope :: (Names)
            _leftPatternOtypeConstructors :: (M.Map Name Int)
            _leftPatternOvalueConstructors :: (M.Map Name TpScheme)
            _leftPatternOwarnings :: ([Warning])
            _operatorIself :: (Name)
            _rightPatternIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _rightPatternImiscerrors :: ([Error])
            _rightPatternIpatVarNames :: (Names)
            _rightPatternIself :: (Pattern)
            _rightPatternIunboundNames :: (Names)
            _rightPatternIwarnings :: ([Warning])
            _rightPatternOallTypeConstructors :: (Names)
            _rightPatternOallValueConstructors :: (Names)
            _rightPatternOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _rightPatternOlhsPattern :: (Bool)
            _rightPatternOmiscerrors :: ([Error])
            _rightPatternOnamesInScope :: (Names)
            _rightPatternOtypeConstructors :: (M.Map Name Int)
            _rightPatternOvalueConstructors :: (M.Map Name TpScheme)
            _rightPatternOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _leftPatternIcollectScopeInfos,_leftPatternImiscerrors,_leftPatternIpatVarNames,_leftPatternIself,_leftPatternIunboundNames,_leftPatternIwarnings) =
                (leftPattern_ (_leftPatternOallTypeConstructors) (_leftPatternOallValueConstructors) (_leftPatternOcollectScopeInfos) (_leftPatternOlhsPattern) (_leftPatternOmiscerrors) (_leftPatternOnamesInScope) (_leftPatternOtypeConstructors) (_leftPatternOvalueConstructors) (_leftPatternOwarnings))
            ( _operatorIself) =
                (operator_ )
            ( _rightPatternIcollectScopeInfos,_rightPatternImiscerrors,_rightPatternIpatVarNames,_rightPatternIself,_rightPatternIunboundNames,_rightPatternIwarnings) =
                (rightPattern_ (_rightPatternOallTypeConstructors) (_rightPatternOallValueConstructors) (_rightPatternOcollectScopeInfos) (_rightPatternOlhsPattern) (_rightPatternOmiscerrors) (_rightPatternOnamesInScope) (_rightPatternOtypeConstructors) (_rightPatternOvalueConstructors) (_rightPatternOwarnings))
            (_lhsOnumberOfPatterns@_) =
                2
            (_lhsOname@_) =
                _operatorIself
            (_rightPatternOlhsPattern@_) =
                False
            (_leftPatternOlhsPattern@_) =
                False
            (_lhsOpatVarNames@_) =
                _leftPatternIpatVarNames ++ _rightPatternIpatVarNames
            (_lhsOunboundNames@_) =
                _leftPatternIunboundNames ++ _rightPatternIunboundNames
            (_self@_) =
                LeftHandSide_Infix _rangeIself _leftPatternIself _operatorIself _rightPatternIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _rightPatternIcollectScopeInfos
            (_lhsOmiscerrors@_) =
                _rightPatternImiscerrors
            (_lhsOwarnings@_) =
                _rightPatternIwarnings
            (_leftPatternOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_leftPatternOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_leftPatternOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_leftPatternOmiscerrors@_) =
                _lhsImiscerrors
            (_leftPatternOnamesInScope@_) =
                _lhsInamesInScope
            (_leftPatternOtypeConstructors@_) =
                _lhsItypeConstructors
            (_leftPatternOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_leftPatternOwarnings@_) =
                _lhsIwarnings
            (_rightPatternOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_rightPatternOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_rightPatternOcollectScopeInfos@_) =
                _leftPatternIcollectScopeInfos
            (_rightPatternOmiscerrors@_) =
                _leftPatternImiscerrors
            (_rightPatternOnamesInScope@_) =
                _lhsInamesInScope
            (_rightPatternOtypeConstructors@_) =
                _lhsItypeConstructors
            (_rightPatternOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_rightPatternOwarnings@_) =
                _leftPatternIwarnings
        in  ( _lhsOcollectScopeInfos,_lhsOmiscerrors,_lhsOname,_lhsOnumberOfPatterns,_lhsOpatVarNames,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_LeftHandSide_Parenthesized :: (T_Range) ->
                                  (T_LeftHandSide) ->
                                  (T_Patterns) ->
                                  (T_LeftHandSide)
sem_LeftHandSide_Parenthesized (range_) (lefthandside_) (patterns_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIcollectScopeInfos
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOmiscerrors :: ([Error])
            _lhsOname :: (Name)
            _lhsOnumberOfPatterns :: (Int)
            _lhsOpatVarNames :: (Names)
            _lhsOself :: (LeftHandSide)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _lefthandsideIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lefthandsideImiscerrors :: ([Error])
            _lefthandsideIname :: (Name)
            _lefthandsideInumberOfPatterns :: (Int)
            _lefthandsideIpatVarNames :: (Names)
            _lefthandsideIself :: (LeftHandSide)
            _lefthandsideIunboundNames :: (Names)
            _lefthandsideIwarnings :: ([Warning])
            _lefthandsideOallTypeConstructors :: (Names)
            _lefthandsideOallValueConstructors :: (Names)
            _lefthandsideOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lefthandsideOmiscerrors :: ([Error])
            _lefthandsideOnamesInScope :: (Names)
            _lefthandsideOtypeConstructors :: (M.Map Name Int)
            _lefthandsideOvalueConstructors :: (M.Map Name TpScheme)
            _lefthandsideOwarnings :: ([Warning])
            _patternsIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _patternsImiscerrors :: ([Error])
            _patternsInumberOfPatterns :: (Int)
            _patternsIpatVarNames :: (Names)
            _patternsIself :: (Patterns)
            _patternsIunboundNames :: (Names)
            _patternsIwarnings :: ([Warning])
            _patternsOallTypeConstructors :: (Names)
            _patternsOallValueConstructors :: (Names)
            _patternsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _patternsOlhsPattern :: (Bool)
            _patternsOmiscerrors :: ([Error])
            _patternsOnamesInScope :: (Names)
            _patternsOtypeConstructors :: (M.Map Name Int)
            _patternsOvalueConstructors :: (M.Map Name TpScheme)
            _patternsOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _lefthandsideIcollectScopeInfos,_lefthandsideImiscerrors,_lefthandsideIname,_lefthandsideInumberOfPatterns,_lefthandsideIpatVarNames,_lefthandsideIself,_lefthandsideIunboundNames,_lefthandsideIwarnings) =
                (lefthandside_ (_lefthandsideOallTypeConstructors) (_lefthandsideOallValueConstructors) (_lefthandsideOcollectScopeInfos) (_lefthandsideOmiscerrors) (_lefthandsideOnamesInScope) (_lefthandsideOtypeConstructors) (_lefthandsideOvalueConstructors) (_lefthandsideOwarnings))
            ( _patternsIcollectScopeInfos,_patternsImiscerrors,_patternsInumberOfPatterns,_patternsIpatVarNames,_patternsIself,_patternsIunboundNames,_patternsIwarnings) =
                (patterns_ (_patternsOallTypeConstructors) (_patternsOallValueConstructors) (_patternsOcollectScopeInfos) (_patternsOlhsPattern) (_patternsOmiscerrors) (_patternsOnamesInScope) (_patternsOtypeConstructors) (_patternsOvalueConstructors) (_patternsOwarnings))
            (_lhsOnumberOfPatterns@_) =
                _lefthandsideInumberOfPatterns + _patternsInumberOfPatterns
            (_patternsOlhsPattern@_) =
                False
            (_lhsOpatVarNames@_) =
                _lefthandsideIpatVarNames ++ _patternsIpatVarNames
            (_lhsOunboundNames@_) =
                _lefthandsideIunboundNames ++ _patternsIunboundNames
            (_self@_) =
                LeftHandSide_Parenthesized _rangeIself _lefthandsideIself _patternsIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _patternsIcollectScopeInfos
            (_lhsOmiscerrors@_) =
                _patternsImiscerrors
            (_lhsOname@_) =
                _lefthandsideIname
            (_lhsOwarnings@_) =
                _patternsIwarnings
            (_lefthandsideOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_lefthandsideOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_lefthandsideOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lefthandsideOmiscerrors@_) =
                _lhsImiscerrors
            (_lefthandsideOnamesInScope@_) =
                _lhsInamesInScope
            (_lefthandsideOtypeConstructors@_) =
                _lhsItypeConstructors
            (_lefthandsideOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_lefthandsideOwarnings@_) =
                _lhsIwarnings
            (_patternsOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_patternsOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_patternsOcollectScopeInfos@_) =
                _lefthandsideIcollectScopeInfos
            (_patternsOmiscerrors@_) =
                _lefthandsideImiscerrors
            (_patternsOnamesInScope@_) =
                _lhsInamesInScope
            (_patternsOtypeConstructors@_) =
                _lhsItypeConstructors
            (_patternsOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_patternsOwarnings@_) =
                _lefthandsideIwarnings
        in  ( _lhsOcollectScopeInfos,_lhsOmiscerrors,_lhsOname,_lhsOnumberOfPatterns,_lhsOpatVarNames,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
-- Literal -----------------------------------------------------
-- semantic domain
type T_Literal = ([(ScopeInfo, Entity)]) ->
                 ([Error]) ->
                 ( ([(ScopeInfo, Entity)]),([Error]),(Literal))
-- cata
sem_Literal :: (Literal) ->
               (T_Literal)
sem_Literal ((Literal_Char (_range) (_value))) =
    (sem_Literal_Char ((sem_Range (_range))) (_value))
sem_Literal ((Literal_Float (_range) (_value))) =
    (sem_Literal_Float ((sem_Range (_range))) (_value))
sem_Literal ((Literal_Int (_range) (_value))) =
    (sem_Literal_Int ((sem_Range (_range))) (_value))
sem_Literal ((Literal_String (_range) (_value))) =
    (sem_Literal_String ((sem_Range (_range))) (_value))
sem_Literal_Char :: (T_Range) ->
                    (String) ->
                    (T_Literal)
sem_Literal_Char (range_) (value_) =
    \ _lhsIcollectScopeInfos
      _lhsImiscerrors ->
        let _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Literal)
            _rangeIself :: (Range)
            ( _rangeIself) =
                (range_ )
            (_self@_) =
                Literal_Char _rangeIself value_
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
        in  ( _lhsOcollectScopeInfos,_lhsOmiscerrors,_lhsOself)
sem_Literal_Float :: (T_Range) ->
                     (String) ->
                     (T_Literal)
sem_Literal_Float (range_) (value_) =
    \ _lhsIcollectScopeInfos
      _lhsImiscerrors ->
        let _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Literal)
            _rangeIself :: (Range)
            ( _rangeIself) =
                (range_ )
            (_self@_) =
                Literal_Float _rangeIself value_
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
        in  ( _lhsOcollectScopeInfos,_lhsOmiscerrors,_lhsOself)
sem_Literal_Int :: (T_Range) ->
                   (String) ->
                   (T_Literal)
sem_Literal_Int (range_) (value_) =
    \ _lhsIcollectScopeInfos
      _lhsImiscerrors ->
        let _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Literal)
            _rangeIself :: (Range)
            ( _rangeIself) =
                (range_ )
            (_lhsOmiscerrors@_) =
                _intLiteralTooBigErrors ++ _lhsImiscerrors
            (_intLiteralTooBigErrors@_) =
                let val = read value_ :: Integer in
                if length value_ > 9 && (val > maxInt || val < minInt)  then
                   [ IntLiteralTooBig range_ value_ ]
                else
                   []
            (_self@_) =
                Literal_Int _rangeIself value_
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
        in  ( _lhsOcollectScopeInfos,_lhsOmiscerrors,_lhsOself)
sem_Literal_String :: (T_Range) ->
                      (String) ->
                      (T_Literal)
sem_Literal_String (range_) (value_) =
    \ _lhsIcollectScopeInfos
      _lhsImiscerrors ->
        let _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Literal)
            _rangeIself :: (Range)
            ( _rangeIself) =
                (range_ )
            (_self@_) =
                Literal_String _rangeIself value_
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
        in  ( _lhsOcollectScopeInfos,_lhsOmiscerrors,_lhsOself)
-- MaybeDeclarations -------------------------------------------
-- semantic domain
type T_MaybeDeclarations = (Names) ->
                           (Names) ->
                           (ClassEnvironment) ->
                           ([(ScopeInfo, Entity)]) ->
                           ([Error]) ->
                           ([Error]) ->
                           (Names) ->
                           ([Option]) ->
                           (OrderedTypeSynonyms) ->
                           (M.Map Name Int) ->
                           (Names) ->
                           (M.Map Name TpScheme) ->
                           ([Warning]) ->
                           ( ([(Name, Instance)]),([(ScopeInfo, Entity)]),([Error]),([Error]),(Names),(MaybeDeclarations),(Names),([Warning]))
-- cata
sem_MaybeDeclarations :: (MaybeDeclarations) ->
                         (T_MaybeDeclarations)
sem_MaybeDeclarations ((MaybeDeclarations_Just (_declarations))) =
    (sem_MaybeDeclarations_Just ((sem_Declarations (_declarations))))
sem_MaybeDeclarations ((MaybeDeclarations_Nothing )) =
    (sem_MaybeDeclarations_Nothing )
sem_MaybeDeclarations_Just :: (T_Declarations) ->
                              (T_MaybeDeclarations)
sem_MaybeDeclarations_Just (declarations_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIunboundNames
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOnamesInScope :: (Names)
            _lhsOself :: (MaybeDeclarations)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _declarationsIcollectInstances :: ([(Name, Instance)])
            _declarationsIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _declarationsIcollectTypeConstructors :: ([(Name,Int)])
            _declarationsIcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _declarationsIcollectValueConstructors :: ([(Name,TpScheme)])
            _declarationsIdeclVarNames :: (Names)
            _declarationsIkindErrors :: ([Error])
            _declarationsImiscerrors :: ([Error])
            _declarationsIoperatorFixities :: ([(Name,(Int,Assoc))])
            _declarationsIpreviousWasAlsoFB :: (Maybe Name)
            _declarationsIrestrictedNames :: (Names)
            _declarationsIself :: (Declarations)
            _declarationsIsuspiciousFBs :: ([(Name,Name)])
            _declarationsItypeSignatures :: ([(Name,TpScheme)])
            _declarationsIunboundNames :: (Names)
            _declarationsIwarnings :: ([Warning])
            _declarationsOallTypeConstructors :: (Names)
            _declarationsOallValueConstructors :: (Names)
            _declarationsOclassEnvironment :: (ClassEnvironment)
            _declarationsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _declarationsOcollectTypeConstructors :: ([(Name,Int)])
            _declarationsOcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _declarationsOcollectValueConstructors :: ([(Name,TpScheme)])
            _declarationsOkindErrors :: ([Error])
            _declarationsOmiscerrors :: ([Error])
            _declarationsOnamesInScope :: (Names)
            _declarationsOoperatorFixities :: ([(Name,(Int,Assoc))])
            _declarationsOoptions :: ([Option])
            _declarationsOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _declarationsOpreviousWasAlsoFB :: (Maybe Name)
            _declarationsOsuspiciousFBs :: ([(Name,Name)])
            _declarationsOtypeConstructors :: (M.Map Name Int)
            _declarationsOtypeSignatures :: ([(Name,TpScheme)])
            _declarationsOvalueConstructors :: (M.Map Name TpScheme)
            _declarationsOwarnings :: ([Warning])
            ( _declarationsIcollectInstances
             ,_declarationsIcollectScopeInfos
             ,_declarationsIcollectTypeConstructors
             ,_declarationsIcollectTypeSynonyms
             ,_declarationsIcollectValueConstructors
             ,_declarationsIdeclVarNames
             ,_declarationsIkindErrors
             ,_declarationsImiscerrors
             ,_declarationsIoperatorFixities
             ,_declarationsIpreviousWasAlsoFB
             ,_declarationsIrestrictedNames
             ,_declarationsIself
             ,_declarationsIsuspiciousFBs
             ,_declarationsItypeSignatures
             ,_declarationsIunboundNames
             ,_declarationsIwarnings
             ) =
                (declarations_ (_declarationsOallTypeConstructors)
                               (_declarationsOallValueConstructors)
                               (_declarationsOclassEnvironment)
                               (_declarationsOcollectScopeInfos)
                               (_declarationsOcollectTypeConstructors)
                               (_declarationsOcollectTypeSynonyms)
                               (_declarationsOcollectValueConstructors)
                               (_declarationsOkindErrors)
                               (_declarationsOmiscerrors)
                               (_declarationsOnamesInScope)
                               (_declarationsOoperatorFixities)
                               (_declarationsOoptions)
                               (_declarationsOorderedTypeSynonyms)
                               (_declarationsOpreviousWasAlsoFB)
                               (_declarationsOsuspiciousFBs)
                               (_declarationsOtypeConstructors)
                               (_declarationsOtypeSignatures)
                               (_declarationsOvalueConstructors)
                               (_declarationsOwarnings))
            (_declarationsOtypeSignatures@_) =
                []
            (_lhsOunboundNames@_) =
                _unboundNames
            ((_namesInScope@_,_unboundNames@_,_scopeInfo@_)) =
                changeOfScope _declarationsIdeclVarNames (_declarationsIunboundNames ++ _lhsIunboundNames) _lhsInamesInScope
            (_lhsOwarnings@_) =
                _declarationsIwarnings ++
                _suspiciousErrors
            (_suspiciousErrors@_) =
                findSimilarFunctionBindings _declarationsItypeSignatures _declarationsIsuspiciousFBs
            (_declarationsOsuspiciousFBs@_) =
                []
            (_declarationsOpreviousWasAlsoFB@_) =
                Nothing
            (_typeSignatureErrors@_) =
                checkTypeSignatures _declarationsIdeclVarNames _declarationsIrestrictedNames _declarationsItypeSignatures
            ((_,_doubles@_)) =
                uniqueAppearance (map fst _declarationsItypeSignatures)
            (_lhsOmiscerrors@_) =
                _typeSignatureErrors ++ _declarationsImiscerrors
            ((_collectTypeConstructors@_,_collectValueConstructors@_,_collectTypeSynonyms@_,_collectConstructorEnv@_,_derivedFunctions@_,_operatorFixities@_)) =
                internalError "PartialSyntax.ag" "n/a" "toplevel MaybeDeclaration"
            (_lhsOcollectScopeInfos@_) =
                (_scopeInfo, Definition) : _declarationsIcollectScopeInfos
            (_lhsOcollectInstances@_) =
                _declarationsIcollectInstances
            (_self@_) =
                MaybeDeclarations_Just _declarationsIself
            (_lhsOself@_) =
                _self
            (_lhsOkindErrors@_) =
                _declarationsIkindErrors
            (_lhsOnamesInScope@_) =
                _namesInScope
            (_declarationsOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_declarationsOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_declarationsOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_declarationsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_declarationsOcollectTypeConstructors@_) =
                _collectTypeConstructors
            (_declarationsOcollectTypeSynonyms@_) =
                _collectTypeSynonyms
            (_declarationsOcollectValueConstructors@_) =
                _collectValueConstructors
            (_declarationsOkindErrors@_) =
                _lhsIkindErrors
            (_declarationsOmiscerrors@_) =
                _lhsImiscerrors
            (_declarationsOnamesInScope@_) =
                _namesInScope
            (_declarationsOoperatorFixities@_) =
                _operatorFixities
            (_declarationsOoptions@_) =
                _lhsIoptions
            (_declarationsOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_declarationsOtypeConstructors@_) =
                _lhsItypeConstructors
            (_declarationsOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_declarationsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOnamesInScope,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_MaybeDeclarations_Nothing :: (T_MaybeDeclarations)
sem_MaybeDeclarations_Nothing  =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIunboundNames
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOnamesInScope :: (Names)
            _lhsOself :: (MaybeDeclarations)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            (_lhsOcollectInstances@_) =
                []
            (_self@_) =
                MaybeDeclarations_Nothing
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _lhsIkindErrors
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
            (_lhsOnamesInScope@_) =
                _lhsInamesInScope
            (_lhsOunboundNames@_) =
                _lhsIunboundNames
            (_lhsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOnamesInScope,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
-- MaybeExports ------------------------------------------------
-- semantic domain
type T_MaybeExports = (Names) ->
                      (Names) ->
                      (Names) ->
                      (Names) ->
                      ( ([Error]),(MaybeExports))
-- cata
sem_MaybeExports :: (MaybeExports) ->
                    (T_MaybeExports)
sem_MaybeExports ((MaybeExports_Just (_exports))) =
    (sem_MaybeExports_Just ((sem_Exports (_exports))))
sem_MaybeExports ((MaybeExports_Nothing )) =
    (sem_MaybeExports_Nothing )
sem_MaybeExports_Just :: (T_Exports) ->
                         (T_MaybeExports)
sem_MaybeExports_Just (exports_) =
    \ _lhsIconsInScope
      _lhsImodulesInScope
      _lhsInamesInScop
      _lhsItyconsInScope ->
        let _lhsOexportErrors :: ([Error])
            _lhsOself :: (MaybeExports)
            _exportsIexportErrors :: ([Error])
            _exportsIself :: (Exports)
            _exportsOconsInScope :: (Names)
            _exportsOmodulesInScope :: (Names)
            _exportsOnamesInScop :: (Names)
            _exportsOtyconsInScope :: (Names)
            ( _exportsIexportErrors,_exportsIself) =
                (exports_ (_exportsOconsInScope) (_exportsOmodulesInScope) (_exportsOnamesInScop) (_exportsOtyconsInScope))
            (_lhsOexportErrors@_) =
                _exportsIexportErrors
            (_self@_) =
                MaybeExports_Just _exportsIself
            (_lhsOself@_) =
                _self
            (_exportsOconsInScope@_) =
                _lhsIconsInScope
            (_exportsOmodulesInScope@_) =
                _lhsImodulesInScope
            (_exportsOnamesInScop@_) =
                _lhsInamesInScop
            (_exportsOtyconsInScope@_) =
                _lhsItyconsInScope
        in  ( _lhsOexportErrors,_lhsOself)
sem_MaybeExports_Nothing :: (T_MaybeExports)
sem_MaybeExports_Nothing  =
    \ _lhsIconsInScope
      _lhsImodulesInScope
      _lhsInamesInScop
      _lhsItyconsInScope ->
        let _lhsOexportErrors :: ([Error])
            _lhsOself :: (MaybeExports)
            (_lhsOexportErrors@_) =
                []
            (_self@_) =
                MaybeExports_Nothing
            (_lhsOself@_) =
                _self
        in  ( _lhsOexportErrors,_lhsOself)
-- MaybeExpression ---------------------------------------------
-- semantic domain
type T_MaybeExpression = (Names) ->
                         (Names) ->
                         (ClassEnvironment) ->
                         ([(ScopeInfo, Entity)]) ->
                         ([Error]) ->
                         ([Error]) ->
                         (Names) ->
                         ([Option]) ->
                         (OrderedTypeSynonyms) ->
                         (M.Map Name Int) ->
                         (M.Map Name TpScheme) ->
                         ([Warning]) ->
                         ( ([(Name, Instance)]),([(ScopeInfo, Entity)]),([Error]),([Error]),(MaybeExpression),(Names),([Warning]))
-- cata
sem_MaybeExpression :: (MaybeExpression) ->
                       (T_MaybeExpression)
sem_MaybeExpression ((MaybeExpression_Just (_expression))) =
    (sem_MaybeExpression_Just ((sem_Expression (_expression))))
sem_MaybeExpression ((MaybeExpression_Nothing )) =
    (sem_MaybeExpression_Nothing )
sem_MaybeExpression_Just :: (T_Expression) ->
                            (T_MaybeExpression)
sem_MaybeExpression_Just (expression_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (MaybeExpression)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionIkindErrors :: ([Error])
            _expressionImiscerrors :: ([Error])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIwarnings :: ([Warning])
            _expressionOallTypeConstructors :: (Names)
            _expressionOallValueConstructors :: (Names)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionOkindErrors :: ([Error])
            _expressionOmiscerrors :: ([Error])
            _expressionOnamesInScope :: (Names)
            _expressionOoptions :: ([Option])
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOtypeConstructors :: (M.Map Name Int)
            _expressionOvalueConstructors :: (M.Map Name TpScheme)
            _expressionOwarnings :: ([Warning])
            ( _expressionIcollectInstances,_expressionIcollectScopeInfos,_expressionIkindErrors,_expressionImiscerrors,_expressionIself,_expressionIunboundNames,_expressionIwarnings) =
                (expression_ (_expressionOallTypeConstructors) (_expressionOallValueConstructors) (_expressionOclassEnvironment) (_expressionOcollectScopeInfos) (_expressionOkindErrors) (_expressionOmiscerrors) (_expressionOnamesInScope) (_expressionOoptions) (_expressionOorderedTypeSynonyms) (_expressionOtypeConstructors) (_expressionOvalueConstructors) (_expressionOwarnings))
            (_lhsOcollectInstances@_) =
                _expressionIcollectInstances
            (_lhsOunboundNames@_) =
                _expressionIunboundNames
            (_self@_) =
                MaybeExpression_Just _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _expressionIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _expressionIkindErrors
            (_lhsOmiscerrors@_) =
                _expressionImiscerrors
            (_lhsOwarnings@_) =
                _expressionIwarnings
            (_expressionOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_expressionOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_expressionOkindErrors@_) =
                _lhsIkindErrors
            (_expressionOmiscerrors@_) =
                _lhsImiscerrors
            (_expressionOnamesInScope@_) =
                _lhsInamesInScope
            (_expressionOoptions@_) =
                _lhsIoptions
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOtypeConstructors@_) =
                _lhsItypeConstructors
            (_expressionOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_expressionOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_MaybeExpression_Nothing :: (T_MaybeExpression)
sem_MaybeExpression_Nothing  =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (MaybeExpression)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            (_lhsOcollectInstances@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                MaybeExpression_Nothing
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _lhsIkindErrors
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
            (_lhsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
-- MaybeImportSpecification ------------------------------------
-- semantic domain
type T_MaybeImportSpecification = ( (MaybeImportSpecification))
-- cata
sem_MaybeImportSpecification :: (MaybeImportSpecification) ->
                                (T_MaybeImportSpecification)
sem_MaybeImportSpecification ((MaybeImportSpecification_Just (_importspecification))) =
    (sem_MaybeImportSpecification_Just ((sem_ImportSpecification (_importspecification))))
sem_MaybeImportSpecification ((MaybeImportSpecification_Nothing )) =
    (sem_MaybeImportSpecification_Nothing )
sem_MaybeImportSpecification_Just :: (T_ImportSpecification) ->
                                     (T_MaybeImportSpecification)
sem_MaybeImportSpecification_Just (importspecification_) =
    let _lhsOself :: (MaybeImportSpecification)
        _importspecificationIself :: (ImportSpecification)
        ( _importspecificationIself) =
            (importspecification_ )
        (_self@_) =
            MaybeImportSpecification_Just _importspecificationIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_MaybeImportSpecification_Nothing :: (T_MaybeImportSpecification)
sem_MaybeImportSpecification_Nothing  =
    let _lhsOself :: (MaybeImportSpecification)
        (_self@_) =
            MaybeImportSpecification_Nothing
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- MaybeInt ----------------------------------------------------
-- semantic domain
type T_MaybeInt = ( (MaybeInt))
-- cata
sem_MaybeInt :: (MaybeInt) ->
                (T_MaybeInt)
sem_MaybeInt ((MaybeInt_Just (_int))) =
    (sem_MaybeInt_Just (_int))
sem_MaybeInt ((MaybeInt_Nothing )) =
    (sem_MaybeInt_Nothing )
sem_MaybeInt_Just :: (Int) ->
                     (T_MaybeInt)
sem_MaybeInt_Just (int_) =
    let _lhsOself :: (MaybeInt)
        (_self@_) =
            MaybeInt_Just int_
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_MaybeInt_Nothing :: (T_MaybeInt)
sem_MaybeInt_Nothing  =
    let _lhsOself :: (MaybeInt)
        (_self@_) =
            MaybeInt_Nothing
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- MaybeName ---------------------------------------------------
-- semantic domain
type T_MaybeName = ( (MaybeName))
-- cata
sem_MaybeName :: (MaybeName) ->
                 (T_MaybeName)
sem_MaybeName ((MaybeName_Just (_name))) =
    (sem_MaybeName_Just ((sem_Name (_name))))
sem_MaybeName ((MaybeName_Nothing )) =
    (sem_MaybeName_Nothing )
sem_MaybeName_Just :: (T_Name) ->
                      (T_MaybeName)
sem_MaybeName_Just (name_) =
    let _lhsOself :: (MaybeName)
        _nameIself :: (Name)
        ( _nameIself) =
            (name_ )
        (_self@_) =
            MaybeName_Just _nameIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_MaybeName_Nothing :: (T_MaybeName)
sem_MaybeName_Nothing  =
    let _lhsOself :: (MaybeName)
        (_self@_) =
            MaybeName_Nothing
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- MaybeNames --------------------------------------------------
-- semantic domain
type T_MaybeNames = ( (MaybeNames))
-- cata
sem_MaybeNames :: (MaybeNames) ->
                  (T_MaybeNames)
sem_MaybeNames ((MaybeNames_Just (_names))) =
    (sem_MaybeNames_Just ((sem_Names (_names))))
sem_MaybeNames ((MaybeNames_Nothing )) =
    (sem_MaybeNames_Nothing )
sem_MaybeNames_Just :: (T_Names) ->
                       (T_MaybeNames)
sem_MaybeNames_Just (names_) =
    let _lhsOself :: (MaybeNames)
        _namesIself :: (Names)
        ( _namesIself) =
            (names_ )
        (_self@_) =
            MaybeNames_Just _namesIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_MaybeNames_Nothing :: (T_MaybeNames)
sem_MaybeNames_Nothing  =
    let _lhsOself :: (MaybeNames)
        (_self@_) =
            MaybeNames_Nothing
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- Module ------------------------------------------------------
-- semantic domain
type T_Module = (String) ->
                (ImportEnvironments) ->
                ([Option]) ->
                ( (ImportEnvironment),(Errors),(Module),([(Name,TpScheme)]),(Warnings))
-- cata
sem_Module :: (Module) ->
              (T_Module)
sem_Module ((Module_Module (_range) (_name) (_exports) (_body))) =
    (sem_Module_Module ((sem_Range (_range))) ((sem_MaybeName (_name))) ((sem_MaybeExports (_exports))) ((sem_Body (_body))))
sem_Module_Module :: (T_Range) ->
                     (T_MaybeName) ->
                     (T_MaybeExports) ->
                     (T_Body) ->
                     (T_Module)
sem_Module_Module (range_) (name_) (exports_) (body_) =
    \ _lhsIbaseName
      _lhsIimportEnvironments
      _lhsIoptions ->
        let _lhsOcollectEnvironment :: (ImportEnvironment)
            _lhsOerrors :: (Errors)
            _lhsOself :: (Module)
            _lhsOtypeSignatures :: ([(Name,TpScheme)])
            _lhsOwarnings :: (Warnings)
            _rangeIself :: (Range)
            _nameIself :: (MaybeName)
            _exportsIexportErrors :: ([Error])
            _exportsIself :: (MaybeExports)
            _exportsOconsInScope :: (Names)
            _exportsOmodulesInScope :: (Names)
            _exportsOnamesInScop :: (Names)
            _exportsOtyconsInScope :: (Names)
            _bodyIcollectInstances :: ([(Name, Instance)])
            _bodyIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _bodyIcollectTypeConstructors :: ([(Name,Int)])
            _bodyIcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _bodyIcollectValueConstructors :: ([(Name,TpScheme)])
            _bodyIdeclVarNames :: (Names)
            _bodyIimportedModules :: (Names)
            _bodyIkindErrors :: ([Error])
            _bodyImiscerrors :: ([Error])
            _bodyIoperatorFixities :: ([(Name,(Int,Assoc))])
            _bodyIself :: (Body)
            _bodyItypeSignatures :: ([(Name,TpScheme)])
            _bodyIunboundNames :: (Names)
            _bodyIwarnings :: ([Warning])
            _bodyOallTypeConstructors :: (Names)
            _bodyOallValueConstructors :: (Names)
            _bodyOclassEnvironment :: (ClassEnvironment)
            _bodyOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _bodyOcollectTypeConstructors :: ([(Name,Int)])
            _bodyOcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _bodyOcollectValueConstructors :: ([(Name,TpScheme)])
            _bodyOkindErrors :: ([Error])
            _bodyOmiscerrors :: ([Error])
            _bodyOnamesInScope :: (Names)
            _bodyOoperatorFixities :: ([(Name,(Int,Assoc))])
            _bodyOoptions :: ([Option])
            _bodyOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _bodyOtypeConstructors :: (M.Map Name Int)
            _bodyOvalueConstructors :: (M.Map Name TpScheme)
            _bodyOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            ( _exportsIexportErrors,_exportsIself) =
                (exports_ (_exportsOconsInScope) (_exportsOmodulesInScope) (_exportsOnamesInScop) (_exportsOtyconsInScope))
            ( _bodyIcollectInstances,_bodyIcollectScopeInfos,_bodyIcollectTypeConstructors,_bodyIcollectTypeSynonyms,_bodyIcollectValueConstructors,_bodyIdeclVarNames,_bodyIimportedModules,_bodyIkindErrors,_bodyImiscerrors,_bodyIoperatorFixities,_bodyIself,_bodyItypeSignatures,_bodyIunboundNames,_bodyIwarnings) =
                (body_ (_bodyOallTypeConstructors) (_bodyOallValueConstructors) (_bodyOclassEnvironment) (_bodyOcollectScopeInfos) (_bodyOcollectTypeConstructors) (_bodyOcollectTypeSynonyms) (_bodyOcollectValueConstructors) (_bodyOkindErrors) (_bodyOmiscerrors) (_bodyOnamesInScope) (_bodyOoperatorFixities) (_bodyOoptions) (_bodyOorderedTypeSynonyms) (_bodyOtypeConstructors) (_bodyOvalueConstructors) (_bodyOwarnings))
            (_initialScope@_) =
                map fst _derivedFunctions ++
                concatMap (M.keys . typeEnvironment) _lhsIimportEnvironments
            (_derivedRanges@_) =
                map getNameRange (map fst _derivedFunctions)
            (_removedEntities@_) =
                [ (name,TypeConstructor) | name:_ <- _duplicatedTypeConstructors  ] ++
                [ (name,Constructor    ) | name:_ <- _duplicatedValueConstructors ]
            (_allErrors@_) =
                concat [ _exportErrors
                       , _scopeErrors
                       , _miscerrors
                       , if KindInferencing `elem` _lhsIoptions then [] else _kindErrors
                       , _topLevelErrors
                       ]
            (_lhsOwarnings@_) =
                _scopeWarnings ++ _warnings
            (_lhsOerrors@_) =
                filter (\err -> filterRemovedNames _removedEntities err
                             && filterDerivedNames _derivedRanges err) _allErrors
            (_derivedFunctions@_) =
                let f (n,i) = ( nameOfShowFunction n
                              , typeOfShowFunction n (take i [ nameFromString s | s <- variableList])
                              )
                    g (n,(i,_)) = f (n,i)
                in map f _bodyIcollectTypeConstructors ++
                   map g _bodyIcollectTypeSynonyms
            (_collectEnvironment@_) =
                setValueConstructors   (M.fromList _bodyIcollectValueConstructors)
                . setTypeConstructors  (M.fromList _bodyIcollectTypeConstructors)
                . setTypeSynonyms      (M.fromList _bodyIcollectTypeSynonyms)
                . setOperatorTable     (M.fromList _bodyIoperatorFixities)
                . addToTypeEnvironment (M.fromList _derivedFunctions)
                $ emptyEnvironment
            (_bodyOcollectTypeConstructors@_) =
                []
            (_bodyOcollectValueConstructors@_) =
                []
            (_bodyOcollectTypeSynonyms@_) =
                []
            (_bodyOoperatorFixities@_) =
                []
            (_valueConstructors@_) =
                M.fromList _uniqueValueConstructors
            (_allValueConstructors@_) =
                map fst _uniqueValueConstructors ++ map head _duplicatedValueConstructors
            ((_uniqueValueConstructors@_,_duplicatedValueConstructors@_)) =
                uniqueKeys (  _bodyIcollectValueConstructors
                           ++ concatMap (M.assocs . valueConstructors) _lhsIimportEnvironments
                           )
            (_typeConstructors@_) =
                M.fromList _uniqueTypeConstructors
            (_allTypeConstructors@_) =
                map fst _uniqueTypeConstructors ++ map head _duplicatedTypeConstructors
            ((_uniqueTypeConstructors@_,_duplicatedTypeConstructors@_)) =
                uniqueKeys (  _bodyIcollectTypeConstructors
                           ++ concatMap (M.assocs . typeConstructors) _lhsIimportEnvironments
                           ++ [ (n,i) | (n,(i,f)) <- _bodyIcollectTypeSynonyms ]
                           )
            (_bodyOorderedTypeSynonyms@_) =
                let list     = concatMap (M.assocs . typeSynonyms) _lhsIimportEnvironments ++
                               _bodyIcollectTypeSynonyms
                    newmap   = M.fromList [ (show name, t) | (name, t) <- list ]
                    ordering = fst (getTypeSynonymOrdering newmap)
                in (ordering, newmap)
            (_bodyOclassEnvironment@_) =
                let importEnv = foldr combineImportEnvironments emptyEnvironment _lhsIimportEnvironments
                in foldr (\(n, i) -> insertInstance (show n) i)
                         (createClassEnvironment importEnv)
                         _bodyIcollectInstances
            ((_namesInScope@_,_unboundNames@_,_scopeInfo@_)) =
                changeOfScope (_initialScope ++ _bodyIdeclVarNames) _bodyIunboundNames []
            (_kindErrors@_) =
                _bodyIkindErrors
            (_bodyOkindErrors@_) =
                []
            (_warnings@_) =
                _bodyIwarnings
            (_bodyOwarnings@_) =
                []
            (_topLevelErrors@_) =
                concat [ _typeConstructorErrors
                       , _valueConstructorErrors
                       , _fixityErrors
                       , _fixityButNoFunDefErrors
                       , _wrongFlagErrors
                       , _recursiveTypeSynonymErrors
                       , _wrongFileNameErrors
                       ]
            (_typeConstructorErrors@_) =
                makeDuplicated TypeConstructor _duplicatedTypeConstructors
            (_valueConstructorErrors@_) =
                makeDuplicated Constructor _duplicatedValueConstructors
            ((_duplicatedFixities@_,_correctFixities@_)) =
                let (xs,ys) = partition ((>1) . length) . group . sort $ (map fst _bodyIoperatorFixities)
                in (xs,map head ys)
            (_fixityErrors@_) =
                makeDuplicated Fixity _duplicatedFixities
            (_fixityButNoFunDefErrors@_) =
                let list = nub (_bodyIdeclVarNames ++ _allValueConstructors)
                in makeNoFunDef Fixity (filter (`notElem` list) _correctFixities) list
            (_wrongFlagErrors@_) =
                [ WrongOverloadingFlag flag
                | let flag = Overloading `elem` _lhsIoptions
                      imp  = any isOverloaded (concatMap (M.elems . typeEnvironment) _lhsIimportEnvironments)
                , flag /= imp
                ]
            (_recursiveTypeSynonymErrors@_) =
                let converted  = map (\(name, tuple) -> (show name, tuple)) _bodyIcollectTypeSynonyms
                    recursives = snd . getTypeSynonymOrdering . M.fromList $ converted
                    makeError = let f = foldr add (Just [])
                                    add s ml = case (g s, ml) of
                                                  ([n], Just ns) -> Just (n:ns)
                                                  _              -> Nothing
                                    g s = [ n | n <- map fst _bodyIcollectTypeSynonyms, show n == s ]
                                in maybe [] (\x -> [RecursiveTypeSynonyms x]) . f
                in concatMap makeError recursives
            (_fileName@_) =
                Name_Identifier noRange [] _lhsIbaseName
            (_moduleName@_) =
                case _nameIself of
                   MaybeName_Just name -> name
                   MaybeName_Nothing   -> Name_Identifier noRange [] ""
            (_wrongFileNameErrors@_) =
                let moduleString = getNameName  _moduleName
                    moduleRange  = getNameRange _moduleName
                in if moduleString == "" || _lhsIbaseName == moduleString
                  then []
                  else [ WrongFileName _lhsIbaseName moduleString moduleRange ]
            (_miscerrors@_) =
                _bodyImiscerrors
            (_bodyOmiscerrors@_) =
                []
            (_exportsOconsInScope@_) =
                _allValueConstructors
            (_exportsOtyconsInScope@_) =
                _allTypeConstructors
            (_exportsOmodulesInScope@_) =
                (_moduleName : _fileName : _bodyIimportedModules)
            (_exportsOnamesInScop@_) =
                concat [ _bodyIdeclVarNames
                        , concatMap (M.keys . typeEnvironment) _lhsIimportEnvironments
                        , map fst _derivedFunctions
                        ]
            (_exportErrors@_) =
                _exportsIexportErrors
            (_scopeWarnings@_) =
                makeWarnings _collectScopeInfos
            (_scopeErrors@_) =
                makeErrors   _collectScopeInfos
            (_bodyOcollectScopeInfos@_) =
                []
            (_collectScopeInfos@_) =
                (topLevelScopeInfo _scopeInfo, Definition) : _bodyIcollectScopeInfos
            (_self@_) =
                Module_Module _rangeIself _nameIself _exportsIself _bodyIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectEnvironment@_) =
                _collectEnvironment
            (_lhsOtypeSignatures@_) =
                _bodyItypeSignatures
            (_bodyOallTypeConstructors@_) =
                _allTypeConstructors
            (_bodyOallValueConstructors@_) =
                _allValueConstructors
            (_bodyOnamesInScope@_) =
                _namesInScope
            (_bodyOoptions@_) =
                _lhsIoptions
            (_bodyOtypeConstructors@_) =
                _typeConstructors
            (_bodyOvalueConstructors@_) =
                _valueConstructors
        in  ( _lhsOcollectEnvironment,_lhsOerrors,_lhsOself,_lhsOtypeSignatures,_lhsOwarnings)
-- Name --------------------------------------------------------
-- semantic domain
type T_Name = ( (Name))
-- cata
sem_Name :: (Name) ->
            (T_Name)
sem_Name ((Name_Identifier (_range) (_module) (_name))) =
    (sem_Name_Identifier ((sem_Range (_range))) ((sem_Strings (_module))) (_name))
sem_Name ((Name_Operator (_range) (_module) (_name))) =
    (sem_Name_Operator ((sem_Range (_range))) ((sem_Strings (_module))) (_name))
sem_Name ((Name_Special (_range) (_module) (_name))) =
    (sem_Name_Special ((sem_Range (_range))) ((sem_Strings (_module))) (_name))
sem_Name_Identifier :: (T_Range) ->
                       (T_Strings) ->
                       (String) ->
                       (T_Name)
sem_Name_Identifier (range_) (module_) (name_) =
    let _lhsOself :: (Name)
        _rangeIself :: (Range)
        _moduleIself :: (Strings)
        ( _rangeIself) =
            (range_ )
        ( _moduleIself) =
            (module_ )
        (_self@_) =
            Name_Identifier _rangeIself _moduleIself name_
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Name_Operator :: (T_Range) ->
                     (T_Strings) ->
                     (String) ->
                     (T_Name)
sem_Name_Operator (range_) (module_) (name_) =
    let _lhsOself :: (Name)
        _rangeIself :: (Range)
        _moduleIself :: (Strings)
        ( _rangeIself) =
            (range_ )
        ( _moduleIself) =
            (module_ )
        (_self@_) =
            Name_Operator _rangeIself _moduleIself name_
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Name_Special :: (T_Range) ->
                    (T_Strings) ->
                    (String) ->
                    (T_Name)
sem_Name_Special (range_) (module_) (name_) =
    let _lhsOself :: (Name)
        _rangeIself :: (Range)
        _moduleIself :: (Strings)
        ( _rangeIself) =
            (range_ )
        ( _moduleIself) =
            (module_ )
        (_self@_) =
            Name_Special _rangeIself _moduleIself name_
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- Names -------------------------------------------------------
-- semantic domain
type T_Names = ( (Names))
-- cata
sem_Names :: (Names) ->
             (T_Names)
sem_Names (list) =
    (Prelude.foldr (sem_Names_Cons) (sem_Names_Nil) ((Prelude.map sem_Name list)))
sem_Names_Cons :: (T_Name) ->
                  (T_Names) ->
                  (T_Names)
sem_Names_Cons (hd_) (tl_) =
    let _lhsOself :: (Names)
        _hdIself :: (Name)
        _tlIself :: (Names)
        ( _hdIself) =
            (hd_ )
        ( _tlIself) =
            (tl_ )
        (_self@_) =
            (:) _hdIself _tlIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Names_Nil :: (T_Names)
sem_Names_Nil  =
    let _lhsOself :: (Names)
        (_self@_) =
            []
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- Pattern -----------------------------------------------------
-- semantic domain
type T_Pattern = (Names) ->
                 (Names) ->
                 ([(ScopeInfo, Entity)]) ->
                 (Bool) ->
                 ([Error]) ->
                 (Names) ->
                 (M.Map Name Int) ->
                 (M.Map Name TpScheme) ->
                 ([Warning]) ->
                 ( ([(ScopeInfo, Entity)]),([Error]),(Names),(Pattern),(Names),([Warning]))
-- cata
sem_Pattern :: (Pattern) ->
               (T_Pattern)
sem_Pattern ((Pattern_As (_range) (_name) (_pattern))) =
    (sem_Pattern_As ((sem_Range (_range))) ((sem_Name (_name))) ((sem_Pattern (_pattern))))
sem_Pattern ((Pattern_Constructor (_range) (_name) (_patterns))) =
    (sem_Pattern_Constructor ((sem_Range (_range))) ((sem_Name (_name))) ((sem_Patterns (_patterns))))
sem_Pattern ((Pattern_InfixConstructor (_range) (_leftPattern) (_constructorOperator) (_rightPattern))) =
    (sem_Pattern_InfixConstructor ((sem_Range (_range))) ((sem_Pattern (_leftPattern))) ((sem_Name (_constructorOperator))) ((sem_Pattern (_rightPattern))))
sem_Pattern ((Pattern_Irrefutable (_range) (_pattern))) =
    (sem_Pattern_Irrefutable ((sem_Range (_range))) ((sem_Pattern (_pattern))))
sem_Pattern ((Pattern_List (_range) (_patterns))) =
    (sem_Pattern_List ((sem_Range (_range))) ((sem_Patterns (_patterns))))
sem_Pattern ((Pattern_Literal (_range) (_literal))) =
    (sem_Pattern_Literal ((sem_Range (_range))) ((sem_Literal (_literal))))
sem_Pattern ((Pattern_Negate (_range) (_literal))) =
    (sem_Pattern_Negate ((sem_Range (_range))) ((sem_Literal (_literal))))
sem_Pattern ((Pattern_NegateFloat (_range) (_literal))) =
    (sem_Pattern_NegateFloat ((sem_Range (_range))) ((sem_Literal (_literal))))
sem_Pattern ((Pattern_Parenthesized (_range) (_pattern))) =
    (sem_Pattern_Parenthesized ((sem_Range (_range))) ((sem_Pattern (_pattern))))
sem_Pattern ((Pattern_Record (_range) (_name) (_recordPatternBindings))) =
    (sem_Pattern_Record ((sem_Range (_range))) ((sem_Name (_name))) ((sem_RecordPatternBindings (_recordPatternBindings))))
sem_Pattern ((Pattern_Successor (_range) (_name) (_literal))) =
    (sem_Pattern_Successor ((sem_Range (_range))) ((sem_Name (_name))) ((sem_Literal (_literal))))
sem_Pattern ((Pattern_Tuple (_range) (_patterns))) =
    (sem_Pattern_Tuple ((sem_Range (_range))) ((sem_Patterns (_patterns))))
sem_Pattern ((Pattern_Variable (_range) (_name))) =
    (sem_Pattern_Variable ((sem_Range (_range))) ((sem_Name (_name))))
sem_Pattern ((Pattern_Wildcard (_range))) =
    (sem_Pattern_Wildcard ((sem_Range (_range))))
sem_Pattern_As :: (T_Range) ->
                  (T_Name) ->
                  (T_Pattern) ->
                  (T_Pattern)
sem_Pattern_As (range_) (name_) (pattern_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIcollectScopeInfos
      _lhsIlhsPattern
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOmiscerrors :: ([Error])
            _lhsOpatVarNames :: (Names)
            _lhsOself :: (Pattern)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _nameIself :: (Name)
            _patternIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _patternImiscerrors :: ([Error])
            _patternIpatVarNames :: (Names)
            _patternIself :: (Pattern)
            _patternIunboundNames :: (Names)
            _patternIwarnings :: ([Warning])
            _patternOallTypeConstructors :: (Names)
            _patternOallValueConstructors :: (Names)
            _patternOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _patternOlhsPattern :: (Bool)
            _patternOmiscerrors :: ([Error])
            _patternOnamesInScope :: (Names)
            _patternOtypeConstructors :: (M.Map Name Int)
            _patternOvalueConstructors :: (M.Map Name TpScheme)
            _patternOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            ( _patternIcollectScopeInfos,_patternImiscerrors,_patternIpatVarNames,_patternIself,_patternIunboundNames,_patternIwarnings) =
                (pattern_ (_patternOallTypeConstructors) (_patternOallValueConstructors) (_patternOcollectScopeInfos) (_patternOlhsPattern) (_patternOmiscerrors) (_patternOnamesInScope) (_patternOtypeConstructors) (_patternOvalueConstructors) (_patternOwarnings))
            (_lhsOpatVarNames@_) =
                _nameIself : _patternIpatVarNames
            (_lhsOunboundNames@_) =
                _patternIunboundNames
            (_self@_) =
                Pattern_As _rangeIself _nameIself _patternIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _patternIcollectScopeInfos
            (_lhsOmiscerrors@_) =
                _patternImiscerrors
            (_lhsOwarnings@_) =
                _patternIwarnings
            (_patternOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_patternOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_patternOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_patternOlhsPattern@_) =
                _lhsIlhsPattern
            (_patternOmiscerrors@_) =
                _lhsImiscerrors
            (_patternOnamesInScope@_) =
                _lhsInamesInScope
            (_patternOtypeConstructors@_) =
                _lhsItypeConstructors
            (_patternOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_patternOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectScopeInfos,_lhsOmiscerrors,_lhsOpatVarNames,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Pattern_Constructor :: (T_Range) ->
                           (T_Name) ->
                           (T_Patterns) ->
                           (T_Pattern)
sem_Pattern_Constructor (range_) (name_) (patterns_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIcollectScopeInfos
      _lhsIlhsPattern
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOmiscerrors :: ([Error])
            _lhsOpatVarNames :: (Names)
            _lhsOself :: (Pattern)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _nameIself :: (Name)
            _patternsIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _patternsImiscerrors :: ([Error])
            _patternsInumberOfPatterns :: (Int)
            _patternsIpatVarNames :: (Names)
            _patternsIself :: (Patterns)
            _patternsIunboundNames :: (Names)
            _patternsIwarnings :: ([Warning])
            _patternsOallTypeConstructors :: (Names)
            _patternsOallValueConstructors :: (Names)
            _patternsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _patternsOlhsPattern :: (Bool)
            _patternsOmiscerrors :: ([Error])
            _patternsOnamesInScope :: (Names)
            _patternsOtypeConstructors :: (M.Map Name Int)
            _patternsOvalueConstructors :: (M.Map Name TpScheme)
            _patternsOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            ( _patternsIcollectScopeInfos,_patternsImiscerrors,_patternsInumberOfPatterns,_patternsIpatVarNames,_patternsIself,_patternsIunboundNames,_patternsIwarnings) =
                (patterns_ (_patternsOallTypeConstructors) (_patternsOallValueConstructors) (_patternsOcollectScopeInfos) (_patternsOlhsPattern) (_patternsOmiscerrors) (_patternsOnamesInScope) (_patternsOtypeConstructors) (_patternsOvalueConstructors) (_patternsOwarnings))
            (_maybetp@_) =
                M.lookup _nameIself _lhsIvalueConstructors
            (_patConstructorErrors@_) =
                patternConstructorErrors _maybetp _nameIself _lhsIallValueConstructors _patternsInumberOfPatterns _lhsIlhsPattern _lhsIallTypeConstructors
            (_lhsOmiscerrors@_) =
                _patConstructorErrors ++ _patternsImiscerrors
            (_patternsOlhsPattern@_) =
                False
            (_lhsOpatVarNames@_) =
                _patternsIpatVarNames
            (_lhsOunboundNames@_) =
                _patternsIunboundNames
            (_self@_) =
                Pattern_Constructor _rangeIself _nameIself _patternsIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _patternsIcollectScopeInfos
            (_lhsOwarnings@_) =
                _patternsIwarnings
            (_patternsOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_patternsOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_patternsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_patternsOmiscerrors@_) =
                _lhsImiscerrors
            (_patternsOnamesInScope@_) =
                _lhsInamesInScope
            (_patternsOtypeConstructors@_) =
                _lhsItypeConstructors
            (_patternsOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_patternsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectScopeInfos,_lhsOmiscerrors,_lhsOpatVarNames,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Pattern_InfixConstructor :: (T_Range) ->
                                (T_Pattern) ->
                                (T_Name) ->
                                (T_Pattern) ->
                                (T_Pattern)
sem_Pattern_InfixConstructor (range_) (leftPattern_) (constructorOperator_) (rightPattern_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIcollectScopeInfos
      _lhsIlhsPattern
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOmiscerrors :: ([Error])
            _lhsOpatVarNames :: (Names)
            _lhsOself :: (Pattern)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _leftPatternIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _leftPatternImiscerrors :: ([Error])
            _leftPatternIpatVarNames :: (Names)
            _leftPatternIself :: (Pattern)
            _leftPatternIunboundNames :: (Names)
            _leftPatternIwarnings :: ([Warning])
            _leftPatternOallTypeConstructors :: (Names)
            _leftPatternOallValueConstructors :: (Names)
            _leftPatternOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _leftPatternOlhsPattern :: (Bool)
            _leftPatternOmiscerrors :: ([Error])
            _leftPatternOnamesInScope :: (Names)
            _leftPatternOtypeConstructors :: (M.Map Name Int)
            _leftPatternOvalueConstructors :: (M.Map Name TpScheme)
            _leftPatternOwarnings :: ([Warning])
            _constructorOperatorIself :: (Name)
            _rightPatternIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _rightPatternImiscerrors :: ([Error])
            _rightPatternIpatVarNames :: (Names)
            _rightPatternIself :: (Pattern)
            _rightPatternIunboundNames :: (Names)
            _rightPatternIwarnings :: ([Warning])
            _rightPatternOallTypeConstructors :: (Names)
            _rightPatternOallValueConstructors :: (Names)
            _rightPatternOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _rightPatternOlhsPattern :: (Bool)
            _rightPatternOmiscerrors :: ([Error])
            _rightPatternOnamesInScope :: (Names)
            _rightPatternOtypeConstructors :: (M.Map Name Int)
            _rightPatternOvalueConstructors :: (M.Map Name TpScheme)
            _rightPatternOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _leftPatternIcollectScopeInfos,_leftPatternImiscerrors,_leftPatternIpatVarNames,_leftPatternIself,_leftPatternIunboundNames,_leftPatternIwarnings) =
                (leftPattern_ (_leftPatternOallTypeConstructors) (_leftPatternOallValueConstructors) (_leftPatternOcollectScopeInfos) (_leftPatternOlhsPattern) (_leftPatternOmiscerrors) (_leftPatternOnamesInScope) (_leftPatternOtypeConstructors) (_leftPatternOvalueConstructors) (_leftPatternOwarnings))
            ( _constructorOperatorIself) =
                (constructorOperator_ )
            ( _rightPatternIcollectScopeInfos,_rightPatternImiscerrors,_rightPatternIpatVarNames,_rightPatternIself,_rightPatternIunboundNames,_rightPatternIwarnings) =
                (rightPattern_ (_rightPatternOallTypeConstructors) (_rightPatternOallValueConstructors) (_rightPatternOcollectScopeInfos) (_rightPatternOlhsPattern) (_rightPatternOmiscerrors) (_rightPatternOnamesInScope) (_rightPatternOtypeConstructors) (_rightPatternOvalueConstructors) (_rightPatternOwarnings))
            (_maybetp@_) =
                M.lookup _constructorOperatorIself _lhsIvalueConstructors
            (_patConstructorErrors@_) =
                patternConstructorErrors _maybetp _constructorOperatorIself _lhsIallValueConstructors 2 False _lhsIallTypeConstructors
            (_lhsOmiscerrors@_) =
                _patConstructorErrors ++ _rightPatternImiscerrors
            (_lhsOpatVarNames@_) =
                _leftPatternIpatVarNames ++ _rightPatternIpatVarNames
            (_lhsOunboundNames@_) =
                _leftPatternIunboundNames ++ _rightPatternIunboundNames
            (_self@_) =
                Pattern_InfixConstructor _rangeIself _leftPatternIself _constructorOperatorIself _rightPatternIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _rightPatternIcollectScopeInfos
            (_lhsOwarnings@_) =
                _rightPatternIwarnings
            (_leftPatternOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_leftPatternOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_leftPatternOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_leftPatternOlhsPattern@_) =
                _lhsIlhsPattern
            (_leftPatternOmiscerrors@_) =
                _lhsImiscerrors
            (_leftPatternOnamesInScope@_) =
                _lhsInamesInScope
            (_leftPatternOtypeConstructors@_) =
                _lhsItypeConstructors
            (_leftPatternOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_leftPatternOwarnings@_) =
                _lhsIwarnings
            (_rightPatternOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_rightPatternOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_rightPatternOcollectScopeInfos@_) =
                _leftPatternIcollectScopeInfos
            (_rightPatternOlhsPattern@_) =
                _lhsIlhsPattern
            (_rightPatternOmiscerrors@_) =
                _leftPatternImiscerrors
            (_rightPatternOnamesInScope@_) =
                _lhsInamesInScope
            (_rightPatternOtypeConstructors@_) =
                _lhsItypeConstructors
            (_rightPatternOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_rightPatternOwarnings@_) =
                _leftPatternIwarnings
        in  ( _lhsOcollectScopeInfos,_lhsOmiscerrors,_lhsOpatVarNames,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Pattern_Irrefutable :: (T_Range) ->
                           (T_Pattern) ->
                           (T_Pattern)
sem_Pattern_Irrefutable (range_) (pattern_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIcollectScopeInfos
      _lhsIlhsPattern
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOmiscerrors :: ([Error])
            _lhsOpatVarNames :: (Names)
            _lhsOself :: (Pattern)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _patternIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _patternImiscerrors :: ([Error])
            _patternIpatVarNames :: (Names)
            _patternIself :: (Pattern)
            _patternIunboundNames :: (Names)
            _patternIwarnings :: ([Warning])
            _patternOallTypeConstructors :: (Names)
            _patternOallValueConstructors :: (Names)
            _patternOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _patternOlhsPattern :: (Bool)
            _patternOmiscerrors :: ([Error])
            _patternOnamesInScope :: (Names)
            _patternOtypeConstructors :: (M.Map Name Int)
            _patternOvalueConstructors :: (M.Map Name TpScheme)
            _patternOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _patternIcollectScopeInfos,_patternImiscerrors,_patternIpatVarNames,_patternIself,_patternIunboundNames,_patternIwarnings) =
                (pattern_ (_patternOallTypeConstructors) (_patternOallValueConstructors) (_patternOcollectScopeInfos) (_patternOlhsPattern) (_patternOmiscerrors) (_patternOnamesInScope) (_patternOtypeConstructors) (_patternOvalueConstructors) (_patternOwarnings))
            (_lhsOpatVarNames@_) =
                _patternIpatVarNames
            (_lhsOunboundNames@_) =
                _patternIunboundNames
            (_self@_) =
                Pattern_Irrefutable _rangeIself _patternIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _patternIcollectScopeInfos
            (_lhsOmiscerrors@_) =
                _patternImiscerrors
            (_lhsOwarnings@_) =
                _patternIwarnings
            (_patternOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_patternOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_patternOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_patternOlhsPattern@_) =
                _lhsIlhsPattern
            (_patternOmiscerrors@_) =
                _lhsImiscerrors
            (_patternOnamesInScope@_) =
                _lhsInamesInScope
            (_patternOtypeConstructors@_) =
                _lhsItypeConstructors
            (_patternOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_patternOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectScopeInfos,_lhsOmiscerrors,_lhsOpatVarNames,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Pattern_List :: (T_Range) ->
                    (T_Patterns) ->
                    (T_Pattern)
sem_Pattern_List (range_) (patterns_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIcollectScopeInfos
      _lhsIlhsPattern
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOmiscerrors :: ([Error])
            _lhsOpatVarNames :: (Names)
            _lhsOself :: (Pattern)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _patternsIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _patternsImiscerrors :: ([Error])
            _patternsInumberOfPatterns :: (Int)
            _patternsIpatVarNames :: (Names)
            _patternsIself :: (Patterns)
            _patternsIunboundNames :: (Names)
            _patternsIwarnings :: ([Warning])
            _patternsOallTypeConstructors :: (Names)
            _patternsOallValueConstructors :: (Names)
            _patternsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _patternsOlhsPattern :: (Bool)
            _patternsOmiscerrors :: ([Error])
            _patternsOnamesInScope :: (Names)
            _patternsOtypeConstructors :: (M.Map Name Int)
            _patternsOvalueConstructors :: (M.Map Name TpScheme)
            _patternsOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _patternsIcollectScopeInfos,_patternsImiscerrors,_patternsInumberOfPatterns,_patternsIpatVarNames,_patternsIself,_patternsIunboundNames,_patternsIwarnings) =
                (patterns_ (_patternsOallTypeConstructors) (_patternsOallValueConstructors) (_patternsOcollectScopeInfos) (_patternsOlhsPattern) (_patternsOmiscerrors) (_patternsOnamesInScope) (_patternsOtypeConstructors) (_patternsOvalueConstructors) (_patternsOwarnings))
            (_lhsOpatVarNames@_) =
                _patternsIpatVarNames
            (_lhsOunboundNames@_) =
                _patternsIunboundNames
            (_self@_) =
                Pattern_List _rangeIself _patternsIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _patternsIcollectScopeInfos
            (_lhsOmiscerrors@_) =
                _patternsImiscerrors
            (_lhsOwarnings@_) =
                _patternsIwarnings
            (_patternsOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_patternsOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_patternsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_patternsOlhsPattern@_) =
                _lhsIlhsPattern
            (_patternsOmiscerrors@_) =
                _lhsImiscerrors
            (_patternsOnamesInScope@_) =
                _lhsInamesInScope
            (_patternsOtypeConstructors@_) =
                _lhsItypeConstructors
            (_patternsOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_patternsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectScopeInfos,_lhsOmiscerrors,_lhsOpatVarNames,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Pattern_Literal :: (T_Range) ->
                       (T_Literal) ->
                       (T_Pattern)
sem_Pattern_Literal (range_) (literal_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIcollectScopeInfos
      _lhsIlhsPattern
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOmiscerrors :: ([Error])
            _lhsOpatVarNames :: (Names)
            _lhsOself :: (Pattern)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _literalIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _literalImiscerrors :: ([Error])
            _literalIself :: (Literal)
            _literalOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _literalOmiscerrors :: ([Error])
            ( _rangeIself) =
                (range_ )
            ( _literalIcollectScopeInfos,_literalImiscerrors,_literalIself) =
                (literal_ (_literalOcollectScopeInfos) (_literalOmiscerrors))
            (_lhsOpatVarNames@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                Pattern_Literal _rangeIself _literalIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _literalIcollectScopeInfos
            (_lhsOmiscerrors@_) =
                _literalImiscerrors
            (_lhsOwarnings@_) =
                _lhsIwarnings
            (_literalOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_literalOmiscerrors@_) =
                _lhsImiscerrors
        in  ( _lhsOcollectScopeInfos,_lhsOmiscerrors,_lhsOpatVarNames,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Pattern_Negate :: (T_Range) ->
                      (T_Literal) ->
                      (T_Pattern)
sem_Pattern_Negate (range_) (literal_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIcollectScopeInfos
      _lhsIlhsPattern
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOmiscerrors :: ([Error])
            _lhsOpatVarNames :: (Names)
            _lhsOself :: (Pattern)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _literalIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _literalImiscerrors :: ([Error])
            _literalIself :: (Literal)
            _literalOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _literalOmiscerrors :: ([Error])
            ( _rangeIself) =
                (range_ )
            ( _literalIcollectScopeInfos,_literalImiscerrors,_literalIself) =
                (literal_ (_literalOcollectScopeInfos) (_literalOmiscerrors))
            (_lhsOpatVarNames@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                Pattern_Negate _rangeIself _literalIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _literalIcollectScopeInfos
            (_lhsOmiscerrors@_) =
                _literalImiscerrors
            (_lhsOwarnings@_) =
                _lhsIwarnings
            (_literalOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_literalOmiscerrors@_) =
                _lhsImiscerrors
        in  ( _lhsOcollectScopeInfos,_lhsOmiscerrors,_lhsOpatVarNames,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Pattern_NegateFloat :: (T_Range) ->
                           (T_Literal) ->
                           (T_Pattern)
sem_Pattern_NegateFloat (range_) (literal_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIcollectScopeInfos
      _lhsIlhsPattern
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOmiscerrors :: ([Error])
            _lhsOpatVarNames :: (Names)
            _lhsOself :: (Pattern)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _literalIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _literalImiscerrors :: ([Error])
            _literalIself :: (Literal)
            _literalOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _literalOmiscerrors :: ([Error])
            ( _rangeIself) =
                (range_ )
            ( _literalIcollectScopeInfos,_literalImiscerrors,_literalIself) =
                (literal_ (_literalOcollectScopeInfos) (_literalOmiscerrors))
            (_lhsOpatVarNames@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                Pattern_NegateFloat _rangeIself _literalIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _literalIcollectScopeInfos
            (_lhsOmiscerrors@_) =
                _literalImiscerrors
            (_lhsOwarnings@_) =
                _lhsIwarnings
            (_literalOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_literalOmiscerrors@_) =
                _lhsImiscerrors
        in  ( _lhsOcollectScopeInfos,_lhsOmiscerrors,_lhsOpatVarNames,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Pattern_Parenthesized :: (T_Range) ->
                             (T_Pattern) ->
                             (T_Pattern)
sem_Pattern_Parenthesized (range_) (pattern_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIcollectScopeInfos
      _lhsIlhsPattern
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOmiscerrors :: ([Error])
            _lhsOpatVarNames :: (Names)
            _lhsOself :: (Pattern)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _patternIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _patternImiscerrors :: ([Error])
            _patternIpatVarNames :: (Names)
            _patternIself :: (Pattern)
            _patternIunboundNames :: (Names)
            _patternIwarnings :: ([Warning])
            _patternOallTypeConstructors :: (Names)
            _patternOallValueConstructors :: (Names)
            _patternOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _patternOlhsPattern :: (Bool)
            _patternOmiscerrors :: ([Error])
            _patternOnamesInScope :: (Names)
            _patternOtypeConstructors :: (M.Map Name Int)
            _patternOvalueConstructors :: (M.Map Name TpScheme)
            _patternOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _patternIcollectScopeInfos,_patternImiscerrors,_patternIpatVarNames,_patternIself,_patternIunboundNames,_patternIwarnings) =
                (pattern_ (_patternOallTypeConstructors) (_patternOallValueConstructors) (_patternOcollectScopeInfos) (_patternOlhsPattern) (_patternOmiscerrors) (_patternOnamesInScope) (_patternOtypeConstructors) (_patternOvalueConstructors) (_patternOwarnings))
            (_lhsOpatVarNames@_) =
                _patternIpatVarNames
            (_lhsOunboundNames@_) =
                _patternIunboundNames
            (_self@_) =
                Pattern_Parenthesized _rangeIself _patternIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _patternIcollectScopeInfos
            (_lhsOmiscerrors@_) =
                _patternImiscerrors
            (_lhsOwarnings@_) =
                _patternIwarnings
            (_patternOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_patternOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_patternOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_patternOlhsPattern@_) =
                _lhsIlhsPattern
            (_patternOmiscerrors@_) =
                _lhsImiscerrors
            (_patternOnamesInScope@_) =
                _lhsInamesInScope
            (_patternOtypeConstructors@_) =
                _lhsItypeConstructors
            (_patternOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_patternOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectScopeInfos,_lhsOmiscerrors,_lhsOpatVarNames,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Pattern_Record :: (T_Range) ->
                      (T_Name) ->
                      (T_RecordPatternBindings) ->
                      (T_Pattern)
sem_Pattern_Record (range_) (name_) (recordPatternBindings_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIcollectScopeInfos
      _lhsIlhsPattern
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOmiscerrors :: ([Error])
            _lhsOpatVarNames :: (Names)
            _lhsOself :: (Pattern)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _nameIself :: (Name)
            _recordPatternBindingsIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _recordPatternBindingsIself :: (RecordPatternBindings)
            _recordPatternBindingsIunboundNames :: (Names)
            _recordPatternBindingsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _recordPatternBindingsOnamesInScope :: (Names)
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            ( _recordPatternBindingsIcollectScopeInfos,_recordPatternBindingsIself,_recordPatternBindingsIunboundNames) =
                (recordPatternBindings_ (_recordPatternBindingsOcollectScopeInfos) (_recordPatternBindingsOnamesInScope))
            ((_beta@_,_constraints@_,_environment@_)) =
                internalError "PartialSyntax.ag" "n/a" "Pattern.Record"
            (_lhsOpatVarNames@_) =
                []
            (_lhsOunboundNames@_) =
                _recordPatternBindingsIunboundNames
            (_self@_) =
                Pattern_Record _rangeIself _nameIself _recordPatternBindingsIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _recordPatternBindingsIcollectScopeInfos
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
            (_lhsOwarnings@_) =
                _lhsIwarnings
            (_recordPatternBindingsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_recordPatternBindingsOnamesInScope@_) =
                _lhsInamesInScope
        in  ( _lhsOcollectScopeInfos,_lhsOmiscerrors,_lhsOpatVarNames,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Pattern_Successor :: (T_Range) ->
                         (T_Name) ->
                         (T_Literal) ->
                         (T_Pattern)
sem_Pattern_Successor (range_) (name_) (literal_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIcollectScopeInfos
      _lhsIlhsPattern
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOmiscerrors :: ([Error])
            _lhsOpatVarNames :: (Names)
            _lhsOself :: (Pattern)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _nameIself :: (Name)
            _literalIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _literalImiscerrors :: ([Error])
            _literalIself :: (Literal)
            _literalOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _literalOmiscerrors :: ([Error])
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            ( _literalIcollectScopeInfos,_literalImiscerrors,_literalIself) =
                (literal_ (_literalOcollectScopeInfos) (_literalOmiscerrors))
            ((_beta@_,_constraints@_,_environment@_)) =
                internalError "PartialSyntax.ag" "n/a" "Pattern.Successor"
            (_lhsOpatVarNames@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                Pattern_Successor _rangeIself _nameIself _literalIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _literalIcollectScopeInfos
            (_lhsOmiscerrors@_) =
                _literalImiscerrors
            (_lhsOwarnings@_) =
                _lhsIwarnings
            (_literalOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_literalOmiscerrors@_) =
                _lhsImiscerrors
        in  ( _lhsOcollectScopeInfos,_lhsOmiscerrors,_lhsOpatVarNames,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Pattern_Tuple :: (T_Range) ->
                     (T_Patterns) ->
                     (T_Pattern)
sem_Pattern_Tuple (range_) (patterns_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIcollectScopeInfos
      _lhsIlhsPattern
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOmiscerrors :: ([Error])
            _lhsOpatVarNames :: (Names)
            _lhsOself :: (Pattern)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _patternsIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _patternsImiscerrors :: ([Error])
            _patternsInumberOfPatterns :: (Int)
            _patternsIpatVarNames :: (Names)
            _patternsIself :: (Patterns)
            _patternsIunboundNames :: (Names)
            _patternsIwarnings :: ([Warning])
            _patternsOallTypeConstructors :: (Names)
            _patternsOallValueConstructors :: (Names)
            _patternsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _patternsOlhsPattern :: (Bool)
            _patternsOmiscerrors :: ([Error])
            _patternsOnamesInScope :: (Names)
            _patternsOtypeConstructors :: (M.Map Name Int)
            _patternsOvalueConstructors :: (M.Map Name TpScheme)
            _patternsOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _patternsIcollectScopeInfos,_patternsImiscerrors,_patternsInumberOfPatterns,_patternsIpatVarNames,_patternsIself,_patternsIunboundNames,_patternsIwarnings) =
                (patterns_ (_patternsOallTypeConstructors) (_patternsOallValueConstructors) (_patternsOcollectScopeInfos) (_patternsOlhsPattern) (_patternsOmiscerrors) (_patternsOnamesInScope) (_patternsOtypeConstructors) (_patternsOvalueConstructors) (_patternsOwarnings))
            (_lhsOpatVarNames@_) =
                _patternsIpatVarNames
            (_lhsOunboundNames@_) =
                _patternsIunboundNames
            (_self@_) =
                Pattern_Tuple _rangeIself _patternsIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _patternsIcollectScopeInfos
            (_lhsOmiscerrors@_) =
                _patternsImiscerrors
            (_lhsOwarnings@_) =
                _patternsIwarnings
            (_patternsOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_patternsOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_patternsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_patternsOlhsPattern@_) =
                _lhsIlhsPattern
            (_patternsOmiscerrors@_) =
                _lhsImiscerrors
            (_patternsOnamesInScope@_) =
                _lhsInamesInScope
            (_patternsOtypeConstructors@_) =
                _lhsItypeConstructors
            (_patternsOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_patternsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectScopeInfos,_lhsOmiscerrors,_lhsOpatVarNames,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Pattern_Variable :: (T_Range) ->
                        (T_Name) ->
                        (T_Pattern)
sem_Pattern_Variable (range_) (name_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIcollectScopeInfos
      _lhsIlhsPattern
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOmiscerrors :: ([Error])
            _lhsOpatVarNames :: (Names)
            _lhsOself :: (Pattern)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _nameIself :: (Name)
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            (_lhsOpatVarNames@_) =
                [ _nameIself ]
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                Pattern_Variable _rangeIself _nameIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
            (_lhsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectScopeInfos,_lhsOmiscerrors,_lhsOpatVarNames,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Pattern_Wildcard :: (T_Range) ->
                        (T_Pattern)
sem_Pattern_Wildcard (range_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIcollectScopeInfos
      _lhsIlhsPattern
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOmiscerrors :: ([Error])
            _lhsOpatVarNames :: (Names)
            _lhsOself :: (Pattern)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            ( _rangeIself) =
                (range_ )
            (_lhsOpatVarNames@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                Pattern_Wildcard _rangeIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
            (_lhsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectScopeInfos,_lhsOmiscerrors,_lhsOpatVarNames,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
-- Patterns ----------------------------------------------------
-- semantic domain
type T_Patterns = (Names) ->
                  (Names) ->
                  ([(ScopeInfo, Entity)]) ->
                  (Bool) ->
                  ([Error]) ->
                  (Names) ->
                  (M.Map Name Int) ->
                  (M.Map Name TpScheme) ->
                  ([Warning]) ->
                  ( ([(ScopeInfo, Entity)]),([Error]),(Int),(Names),(Patterns),(Names),([Warning]))
-- cata
sem_Patterns :: (Patterns) ->
                (T_Patterns)
sem_Patterns (list) =
    (Prelude.foldr (sem_Patterns_Cons) (sem_Patterns_Nil) ((Prelude.map sem_Pattern list)))
sem_Patterns_Cons :: (T_Pattern) ->
                     (T_Patterns) ->
                     (T_Patterns)
sem_Patterns_Cons (hd_) (tl_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIcollectScopeInfos
      _lhsIlhsPattern
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOmiscerrors :: ([Error])
            _lhsOnumberOfPatterns :: (Int)
            _lhsOpatVarNames :: (Names)
            _lhsOself :: (Patterns)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _hdIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _hdImiscerrors :: ([Error])
            _hdIpatVarNames :: (Names)
            _hdIself :: (Pattern)
            _hdIunboundNames :: (Names)
            _hdIwarnings :: ([Warning])
            _hdOallTypeConstructors :: (Names)
            _hdOallValueConstructors :: (Names)
            _hdOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _hdOlhsPattern :: (Bool)
            _hdOmiscerrors :: ([Error])
            _hdOnamesInScope :: (Names)
            _hdOtypeConstructors :: (M.Map Name Int)
            _hdOvalueConstructors :: (M.Map Name TpScheme)
            _hdOwarnings :: ([Warning])
            _tlIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _tlImiscerrors :: ([Error])
            _tlInumberOfPatterns :: (Int)
            _tlIpatVarNames :: (Names)
            _tlIself :: (Patterns)
            _tlIunboundNames :: (Names)
            _tlIwarnings :: ([Warning])
            _tlOallTypeConstructors :: (Names)
            _tlOallValueConstructors :: (Names)
            _tlOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _tlOlhsPattern :: (Bool)
            _tlOmiscerrors :: ([Error])
            _tlOnamesInScope :: (Names)
            _tlOtypeConstructors :: (M.Map Name Int)
            _tlOvalueConstructors :: (M.Map Name TpScheme)
            _tlOwarnings :: ([Warning])
            ( _hdIcollectScopeInfos,_hdImiscerrors,_hdIpatVarNames,_hdIself,_hdIunboundNames,_hdIwarnings) =
                (hd_ (_hdOallTypeConstructors) (_hdOallValueConstructors) (_hdOcollectScopeInfos) (_hdOlhsPattern) (_hdOmiscerrors) (_hdOnamesInScope) (_hdOtypeConstructors) (_hdOvalueConstructors) (_hdOwarnings))
            ( _tlIcollectScopeInfos,_tlImiscerrors,_tlInumberOfPatterns,_tlIpatVarNames,_tlIself,_tlIunboundNames,_tlIwarnings) =
                (tl_ (_tlOallTypeConstructors) (_tlOallValueConstructors) (_tlOcollectScopeInfos) (_tlOlhsPattern) (_tlOmiscerrors) (_tlOnamesInScope) (_tlOtypeConstructors) (_tlOvalueConstructors) (_tlOwarnings))
            (_lhsOnumberOfPatterns@_) =
                1 + _tlInumberOfPatterns
            (_lhsOpatVarNames@_) =
                _hdIpatVarNames ++ _tlIpatVarNames
            (_lhsOunboundNames@_) =
                _hdIunboundNames ++ _tlIunboundNames
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _tlIcollectScopeInfos
            (_lhsOmiscerrors@_) =
                _tlImiscerrors
            (_lhsOwarnings@_) =
                _tlIwarnings
            (_hdOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_hdOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_hdOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_hdOlhsPattern@_) =
                _lhsIlhsPattern
            (_hdOmiscerrors@_) =
                _lhsImiscerrors
            (_hdOnamesInScope@_) =
                _lhsInamesInScope
            (_hdOtypeConstructors@_) =
                _lhsItypeConstructors
            (_hdOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_hdOwarnings@_) =
                _lhsIwarnings
            (_tlOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_tlOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_tlOcollectScopeInfos@_) =
                _hdIcollectScopeInfos
            (_tlOlhsPattern@_) =
                _lhsIlhsPattern
            (_tlOmiscerrors@_) =
                _hdImiscerrors
            (_tlOnamesInScope@_) =
                _lhsInamesInScope
            (_tlOtypeConstructors@_) =
                _lhsItypeConstructors
            (_tlOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_tlOwarnings@_) =
                _hdIwarnings
        in  ( _lhsOcollectScopeInfos,_lhsOmiscerrors,_lhsOnumberOfPatterns,_lhsOpatVarNames,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Patterns_Nil :: (T_Patterns)
sem_Patterns_Nil  =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIcollectScopeInfos
      _lhsIlhsPattern
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOmiscerrors :: ([Error])
            _lhsOnumberOfPatterns :: (Int)
            _lhsOpatVarNames :: (Names)
            _lhsOself :: (Patterns)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            (_lhsOnumberOfPatterns@_) =
                0
            (_lhsOpatVarNames@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
            (_lhsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectScopeInfos,_lhsOmiscerrors,_lhsOnumberOfPatterns,_lhsOpatVarNames,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
-- Position ----------------------------------------------------
-- semantic domain
type T_Position = ( (Position))
-- cata
sem_Position :: (Position) ->
                (T_Position)
sem_Position ((Position_Position (_filename) (_line) (_column))) =
    (sem_Position_Position (_filename) (_line) (_column))
sem_Position ((Position_Unknown )) =
    (sem_Position_Unknown )
sem_Position_Position :: (String) ->
                         (Int) ->
                         (Int) ->
                         (T_Position)
sem_Position_Position (filename_) (line_) (column_) =
    let _lhsOself :: (Position)
        (_self@_) =
            Position_Position filename_ line_ column_
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Position_Unknown :: (T_Position)
sem_Position_Unknown  =
    let _lhsOself :: (Position)
        (_self@_) =
            Position_Unknown
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- Qualifier ---------------------------------------------------
-- semantic domain
type T_Qualifier = (Names) ->
                   (Names) ->
                   (ClassEnvironment) ->
                   ([(ScopeInfo, Entity)]) ->
                   ([Error]) ->
                   ([Error]) ->
                   (Names) ->
                   ([Option]) ->
                   (OrderedTypeSynonyms) ->
                   (M.Map Name Int) ->
                   (Names) ->
                   (M.Map Name TpScheme) ->
                   ([Warning]) ->
                   ( ([(Name, Instance)]),([(ScopeInfo, Entity)]),([Error]),([Error]),(Names),(Qualifier),(Names),([Warning]))
-- cata
sem_Qualifier :: (Qualifier) ->
                 (T_Qualifier)
sem_Qualifier ((Qualifier_Empty (_range))) =
    (sem_Qualifier_Empty ((sem_Range (_range))))
sem_Qualifier ((Qualifier_Generator (_range) (_pattern) (_expression))) =
    (sem_Qualifier_Generator ((sem_Range (_range))) ((sem_Pattern (_pattern))) ((sem_Expression (_expression))))
sem_Qualifier ((Qualifier_Guard (_range) (_guard))) =
    (sem_Qualifier_Guard ((sem_Range (_range))) ((sem_Expression (_guard))))
sem_Qualifier ((Qualifier_Let (_range) (_declarations))) =
    (sem_Qualifier_Let ((sem_Range (_range))) ((sem_Declarations (_declarations))))
sem_Qualifier_Empty :: (T_Range) ->
                       (T_Qualifier)
sem_Qualifier_Empty (range_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIunboundNames
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOnamesInScope :: (Names)
            _lhsOself :: (Qualifier)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            ( _rangeIself) =
                (range_ )
            (_lhsOcollectInstances@_) =
                []
            (_self@_) =
                Qualifier_Empty _rangeIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _lhsIkindErrors
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
            (_lhsOnamesInScope@_) =
                _lhsInamesInScope
            (_lhsOunboundNames@_) =
                _lhsIunboundNames
            (_lhsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOnamesInScope,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Qualifier_Generator :: (T_Range) ->
                           (T_Pattern) ->
                           (T_Expression) ->
                           (T_Qualifier)
sem_Qualifier_Generator (range_) (pattern_) (expression_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIunboundNames
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOnamesInScope :: (Names)
            _lhsOself :: (Qualifier)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _patternIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _patternImiscerrors :: ([Error])
            _patternIpatVarNames :: (Names)
            _patternIself :: (Pattern)
            _patternIunboundNames :: (Names)
            _patternIwarnings :: ([Warning])
            _patternOallTypeConstructors :: (Names)
            _patternOallValueConstructors :: (Names)
            _patternOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _patternOlhsPattern :: (Bool)
            _patternOmiscerrors :: ([Error])
            _patternOnamesInScope :: (Names)
            _patternOtypeConstructors :: (M.Map Name Int)
            _patternOvalueConstructors :: (M.Map Name TpScheme)
            _patternOwarnings :: ([Warning])
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionIkindErrors :: ([Error])
            _expressionImiscerrors :: ([Error])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIwarnings :: ([Warning])
            _expressionOallTypeConstructors :: (Names)
            _expressionOallValueConstructors :: (Names)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionOkindErrors :: ([Error])
            _expressionOmiscerrors :: ([Error])
            _expressionOnamesInScope :: (Names)
            _expressionOoptions :: ([Option])
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOtypeConstructors :: (M.Map Name Int)
            _expressionOvalueConstructors :: (M.Map Name TpScheme)
            _expressionOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _patternIcollectScopeInfos,_patternImiscerrors,_patternIpatVarNames,_patternIself,_patternIunboundNames,_patternIwarnings) =
                (pattern_ (_patternOallTypeConstructors) (_patternOallValueConstructors) (_patternOcollectScopeInfos) (_patternOlhsPattern) (_patternOmiscerrors) (_patternOnamesInScope) (_patternOtypeConstructors) (_patternOvalueConstructors) (_patternOwarnings))
            ( _expressionIcollectInstances,_expressionIcollectScopeInfos,_expressionIkindErrors,_expressionImiscerrors,_expressionIself,_expressionIunboundNames,_expressionIwarnings) =
                (expression_ (_expressionOallTypeConstructors) (_expressionOallValueConstructors) (_expressionOclassEnvironment) (_expressionOcollectScopeInfos) (_expressionOkindErrors) (_expressionOmiscerrors) (_expressionOnamesInScope) (_expressionOoptions) (_expressionOorderedTypeSynonyms) (_expressionOtypeConstructors) (_expressionOvalueConstructors) (_expressionOwarnings))
            ((_namesInScope@_,_unboundNames@_,_scopeInfo@_)) =
                changeOfScope _patternIpatVarNames (_expressionIunboundNames  ++ _lhsIunboundNames)  _lhsInamesInScope
            (_expressionOnamesInScope@_) =
                _lhsInamesInScope
            (_lhsOunboundNames@_) =
                _unboundNames
            (_lhsOnamesInScope@_) =
                _namesInScope
            (_patternOlhsPattern@_) =
                False
            (_lhsOcollectScopeInfos@_) =
                (_scopeInfo, Variable)   : _expressionIcollectScopeInfos
            (_lhsOcollectInstances@_) =
                _expressionIcollectInstances
            (_self@_) =
                Qualifier_Generator _rangeIself _patternIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsOkindErrors@_) =
                _expressionIkindErrors
            (_lhsOmiscerrors@_) =
                _expressionImiscerrors
            (_lhsOwarnings@_) =
                _expressionIwarnings
            (_patternOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_patternOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_patternOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_patternOmiscerrors@_) =
                _lhsImiscerrors
            (_patternOnamesInScope@_) =
                _namesInScope
            (_patternOtypeConstructors@_) =
                _lhsItypeConstructors
            (_patternOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_patternOwarnings@_) =
                _lhsIwarnings
            (_expressionOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_expressionOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectScopeInfos@_) =
                _patternIcollectScopeInfos
            (_expressionOkindErrors@_) =
                _lhsIkindErrors
            (_expressionOmiscerrors@_) =
                _patternImiscerrors
            (_expressionOoptions@_) =
                _lhsIoptions
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOtypeConstructors@_) =
                _lhsItypeConstructors
            (_expressionOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_expressionOwarnings@_) =
                _patternIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOnamesInScope,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Qualifier_Guard :: (T_Range) ->
                       (T_Expression) ->
                       (T_Qualifier)
sem_Qualifier_Guard (range_) (guard_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIunboundNames
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOnamesInScope :: (Names)
            _lhsOself :: (Qualifier)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _guardIcollectInstances :: ([(Name, Instance)])
            _guardIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _guardIkindErrors :: ([Error])
            _guardImiscerrors :: ([Error])
            _guardIself :: (Expression)
            _guardIunboundNames :: (Names)
            _guardIwarnings :: ([Warning])
            _guardOallTypeConstructors :: (Names)
            _guardOallValueConstructors :: (Names)
            _guardOclassEnvironment :: (ClassEnvironment)
            _guardOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _guardOkindErrors :: ([Error])
            _guardOmiscerrors :: ([Error])
            _guardOnamesInScope :: (Names)
            _guardOoptions :: ([Option])
            _guardOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _guardOtypeConstructors :: (M.Map Name Int)
            _guardOvalueConstructors :: (M.Map Name TpScheme)
            _guardOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _guardIcollectInstances,_guardIcollectScopeInfos,_guardIkindErrors,_guardImiscerrors,_guardIself,_guardIunboundNames,_guardIwarnings) =
                (guard_ (_guardOallTypeConstructors) (_guardOallValueConstructors) (_guardOclassEnvironment) (_guardOcollectScopeInfos) (_guardOkindErrors) (_guardOmiscerrors) (_guardOnamesInScope) (_guardOoptions) (_guardOorderedTypeSynonyms) (_guardOtypeConstructors) (_guardOvalueConstructors) (_guardOwarnings))
            (_lhsOunboundNames@_) =
                _guardIunboundNames ++ _lhsIunboundNames
            (_lhsOcollectInstances@_) =
                _guardIcollectInstances
            (_self@_) =
                Qualifier_Guard _rangeIself _guardIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _guardIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _guardIkindErrors
            (_lhsOmiscerrors@_) =
                _guardImiscerrors
            (_lhsOnamesInScope@_) =
                _lhsInamesInScope
            (_lhsOwarnings@_) =
                _guardIwarnings
            (_guardOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_guardOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_guardOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_guardOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_guardOkindErrors@_) =
                _lhsIkindErrors
            (_guardOmiscerrors@_) =
                _lhsImiscerrors
            (_guardOnamesInScope@_) =
                _lhsInamesInScope
            (_guardOoptions@_) =
                _lhsIoptions
            (_guardOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_guardOtypeConstructors@_) =
                _lhsItypeConstructors
            (_guardOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_guardOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOnamesInScope,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Qualifier_Let :: (T_Range) ->
                     (T_Declarations) ->
                     (T_Qualifier)
sem_Qualifier_Let (range_) (declarations_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIunboundNames
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOnamesInScope :: (Names)
            _lhsOself :: (Qualifier)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _declarationsIcollectInstances :: ([(Name, Instance)])
            _declarationsIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _declarationsIcollectTypeConstructors :: ([(Name,Int)])
            _declarationsIcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _declarationsIcollectValueConstructors :: ([(Name,TpScheme)])
            _declarationsIdeclVarNames :: (Names)
            _declarationsIkindErrors :: ([Error])
            _declarationsImiscerrors :: ([Error])
            _declarationsIoperatorFixities :: ([(Name,(Int,Assoc))])
            _declarationsIpreviousWasAlsoFB :: (Maybe Name)
            _declarationsIrestrictedNames :: (Names)
            _declarationsIself :: (Declarations)
            _declarationsIsuspiciousFBs :: ([(Name,Name)])
            _declarationsItypeSignatures :: ([(Name,TpScheme)])
            _declarationsIunboundNames :: (Names)
            _declarationsIwarnings :: ([Warning])
            _declarationsOallTypeConstructors :: (Names)
            _declarationsOallValueConstructors :: (Names)
            _declarationsOclassEnvironment :: (ClassEnvironment)
            _declarationsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _declarationsOcollectTypeConstructors :: ([(Name,Int)])
            _declarationsOcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _declarationsOcollectValueConstructors :: ([(Name,TpScheme)])
            _declarationsOkindErrors :: ([Error])
            _declarationsOmiscerrors :: ([Error])
            _declarationsOnamesInScope :: (Names)
            _declarationsOoperatorFixities :: ([(Name,(Int,Assoc))])
            _declarationsOoptions :: ([Option])
            _declarationsOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _declarationsOpreviousWasAlsoFB :: (Maybe Name)
            _declarationsOsuspiciousFBs :: ([(Name,Name)])
            _declarationsOtypeConstructors :: (M.Map Name Int)
            _declarationsOtypeSignatures :: ([(Name,TpScheme)])
            _declarationsOvalueConstructors :: (M.Map Name TpScheme)
            _declarationsOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _declarationsIcollectInstances
             ,_declarationsIcollectScopeInfos
             ,_declarationsIcollectTypeConstructors
             ,_declarationsIcollectTypeSynonyms
             ,_declarationsIcollectValueConstructors
             ,_declarationsIdeclVarNames
             ,_declarationsIkindErrors
             ,_declarationsImiscerrors
             ,_declarationsIoperatorFixities
             ,_declarationsIpreviousWasAlsoFB
             ,_declarationsIrestrictedNames
             ,_declarationsIself
             ,_declarationsIsuspiciousFBs
             ,_declarationsItypeSignatures
             ,_declarationsIunboundNames
             ,_declarationsIwarnings
             ) =
                (declarations_ (_declarationsOallTypeConstructors)
                               (_declarationsOallValueConstructors)
                               (_declarationsOclassEnvironment)
                               (_declarationsOcollectScopeInfos)
                               (_declarationsOcollectTypeConstructors)
                               (_declarationsOcollectTypeSynonyms)
                               (_declarationsOcollectValueConstructors)
                               (_declarationsOkindErrors)
                               (_declarationsOmiscerrors)
                               (_declarationsOnamesInScope)
                               (_declarationsOoperatorFixities)
                               (_declarationsOoptions)
                               (_declarationsOorderedTypeSynonyms)
                               (_declarationsOpreviousWasAlsoFB)
                               (_declarationsOsuspiciousFBs)
                               (_declarationsOtypeConstructors)
                               (_declarationsOtypeSignatures)
                               (_declarationsOvalueConstructors)
                               (_declarationsOwarnings))
            (_declarationsOtypeSignatures@_) =
                []
            ((_namesInScope@_,_unboundNames@_,_scopeInfo@_)) =
                changeOfScope _declarationsIdeclVarNames (_declarationsIunboundNames ++ _lhsIunboundNames) _lhsInamesInScope
            (_lhsOunboundNames@_) =
                _unboundNames
            (_lhsOwarnings@_) =
                _declarationsIwarnings ++
                _suspiciousErrors
            (_suspiciousErrors@_) =
                findSimilarFunctionBindings _declarationsItypeSignatures _declarationsIsuspiciousFBs
            (_declarationsOsuspiciousFBs@_) =
                []
            (_declarationsOpreviousWasAlsoFB@_) =
                Nothing
            (_typeSignatureErrors@_) =
                checkTypeSignatures _declarationsIdeclVarNames _declarationsIrestrictedNames _declarationsItypeSignatures
            ((_,_doubles@_)) =
                uniqueAppearance (map fst _declarationsItypeSignatures)
            (_lhsOmiscerrors@_) =
                _typeSignatureErrors ++ _declarationsImiscerrors
            ((_collectTypeConstructors@_,_collectValueConstructors@_,_collectTypeSynonyms@_,_collectConstructorEnv@_,_derivedFunctions@_,_operatorFixities@_)) =
                internalError "PartialSyntax.ag" "n/a" "toplevel Qualifier"
            (_lhsOcollectScopeInfos@_) =
                (_scopeInfo, Definition) : _declarationsIcollectScopeInfos
            (_lhsOcollectInstances@_) =
                _declarationsIcollectInstances
            (_self@_) =
                Qualifier_Let _rangeIself _declarationsIself
            (_lhsOself@_) =
                _self
            (_lhsOkindErrors@_) =
                _declarationsIkindErrors
            (_lhsOnamesInScope@_) =
                _namesInScope
            (_declarationsOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_declarationsOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_declarationsOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_declarationsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_declarationsOcollectTypeConstructors@_) =
                _collectTypeConstructors
            (_declarationsOcollectTypeSynonyms@_) =
                _collectTypeSynonyms
            (_declarationsOcollectValueConstructors@_) =
                _collectValueConstructors
            (_declarationsOkindErrors@_) =
                _lhsIkindErrors
            (_declarationsOmiscerrors@_) =
                _lhsImiscerrors
            (_declarationsOnamesInScope@_) =
                _namesInScope
            (_declarationsOoperatorFixities@_) =
                _operatorFixities
            (_declarationsOoptions@_) =
                _lhsIoptions
            (_declarationsOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_declarationsOtypeConstructors@_) =
                _lhsItypeConstructors
            (_declarationsOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_declarationsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOnamesInScope,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
-- Qualifiers --------------------------------------------------
-- semantic domain
type T_Qualifiers = (Names) ->
                    (Names) ->
                    (ClassEnvironment) ->
                    ([(ScopeInfo, Entity)]) ->
                    ([Error]) ->
                    ([Error]) ->
                    (Names) ->
                    ([Option]) ->
                    (OrderedTypeSynonyms) ->
                    (M.Map Name Int) ->
                    (Names) ->
                    (M.Map Name TpScheme) ->
                    ([Warning]) ->
                    ( ([(Name, Instance)]),([(ScopeInfo, Entity)]),([Error]),([Error]),(Names),(Qualifiers),(Names),([Warning]))
-- cata
sem_Qualifiers :: (Qualifiers) ->
                  (T_Qualifiers)
sem_Qualifiers (list) =
    (Prelude.foldr (sem_Qualifiers_Cons) (sem_Qualifiers_Nil) ((Prelude.map sem_Qualifier list)))
sem_Qualifiers_Cons :: (T_Qualifier) ->
                       (T_Qualifiers) ->
                       (T_Qualifiers)
sem_Qualifiers_Cons (hd_) (tl_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIunboundNames
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOnamesInScope :: (Names)
            _lhsOself :: (Qualifiers)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _hdIcollectInstances :: ([(Name, Instance)])
            _hdIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _hdIkindErrors :: ([Error])
            _hdImiscerrors :: ([Error])
            _hdInamesInScope :: (Names)
            _hdIself :: (Qualifier)
            _hdIunboundNames :: (Names)
            _hdIwarnings :: ([Warning])
            _hdOallTypeConstructors :: (Names)
            _hdOallValueConstructors :: (Names)
            _hdOclassEnvironment :: (ClassEnvironment)
            _hdOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _hdOkindErrors :: ([Error])
            _hdOmiscerrors :: ([Error])
            _hdOnamesInScope :: (Names)
            _hdOoptions :: ([Option])
            _hdOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _hdOtypeConstructors :: (M.Map Name Int)
            _hdOunboundNames :: (Names)
            _hdOvalueConstructors :: (M.Map Name TpScheme)
            _hdOwarnings :: ([Warning])
            _tlIcollectInstances :: ([(Name, Instance)])
            _tlIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _tlIkindErrors :: ([Error])
            _tlImiscerrors :: ([Error])
            _tlInamesInScope :: (Names)
            _tlIself :: (Qualifiers)
            _tlIunboundNames :: (Names)
            _tlIwarnings :: ([Warning])
            _tlOallTypeConstructors :: (Names)
            _tlOallValueConstructors :: (Names)
            _tlOclassEnvironment :: (ClassEnvironment)
            _tlOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _tlOkindErrors :: ([Error])
            _tlOmiscerrors :: ([Error])
            _tlOnamesInScope :: (Names)
            _tlOoptions :: ([Option])
            _tlOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _tlOtypeConstructors :: (M.Map Name Int)
            _tlOunboundNames :: (Names)
            _tlOvalueConstructors :: (M.Map Name TpScheme)
            _tlOwarnings :: ([Warning])
            ( _hdIcollectInstances,_hdIcollectScopeInfos,_hdIkindErrors,_hdImiscerrors,_hdInamesInScope,_hdIself,_hdIunboundNames,_hdIwarnings) =
                (hd_ (_hdOallTypeConstructors) (_hdOallValueConstructors) (_hdOclassEnvironment) (_hdOcollectScopeInfos) (_hdOkindErrors) (_hdOmiscerrors) (_hdOnamesInScope) (_hdOoptions) (_hdOorderedTypeSynonyms) (_hdOtypeConstructors) (_hdOunboundNames) (_hdOvalueConstructors) (_hdOwarnings))
            ( _tlIcollectInstances,_tlIcollectScopeInfos,_tlIkindErrors,_tlImiscerrors,_tlInamesInScope,_tlIself,_tlIunboundNames,_tlIwarnings) =
                (tl_ (_tlOallTypeConstructors) (_tlOallValueConstructors) (_tlOclassEnvironment) (_tlOcollectScopeInfos) (_tlOkindErrors) (_tlOmiscerrors) (_tlOnamesInScope) (_tlOoptions) (_tlOorderedTypeSynonyms) (_tlOtypeConstructors) (_tlOunboundNames) (_tlOvalueConstructors) (_tlOwarnings))
            (_hdOunboundNames@_) =
                _tlIunboundNames
            (_tlOunboundNames@_) =
                _lhsIunboundNames
            (_lhsOunboundNames@_) =
                _hdIunboundNames
            (_lhsOcollectInstances@_) =
                _hdIcollectInstances  ++  _tlIcollectInstances
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _tlIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _tlIkindErrors
            (_lhsOmiscerrors@_) =
                _tlImiscerrors
            (_lhsOnamesInScope@_) =
                _tlInamesInScope
            (_lhsOwarnings@_) =
                _tlIwarnings
            (_hdOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_hdOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_hdOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_hdOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_hdOkindErrors@_) =
                _lhsIkindErrors
            (_hdOmiscerrors@_) =
                _lhsImiscerrors
            (_hdOnamesInScope@_) =
                _lhsInamesInScope
            (_hdOoptions@_) =
                _lhsIoptions
            (_hdOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_hdOtypeConstructors@_) =
                _lhsItypeConstructors
            (_hdOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_hdOwarnings@_) =
                _lhsIwarnings
            (_tlOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_tlOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_tlOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_tlOcollectScopeInfos@_) =
                _hdIcollectScopeInfos
            (_tlOkindErrors@_) =
                _hdIkindErrors
            (_tlOmiscerrors@_) =
                _hdImiscerrors
            (_tlOnamesInScope@_) =
                _hdInamesInScope
            (_tlOoptions@_) =
                _lhsIoptions
            (_tlOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_tlOtypeConstructors@_) =
                _lhsItypeConstructors
            (_tlOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_tlOwarnings@_) =
                _hdIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOnamesInScope,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Qualifiers_Nil :: (T_Qualifiers)
sem_Qualifiers_Nil  =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIunboundNames
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOnamesInScope :: (Names)
            _lhsOself :: (Qualifiers)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            (_lhsOunboundNames@_) =
                _lhsIunboundNames
            (_lhsOcollectInstances@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _lhsIkindErrors
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
            (_lhsOnamesInScope@_) =
                _lhsInamesInScope
            (_lhsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOnamesInScope,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
-- Range -------------------------------------------------------
-- semantic domain
type T_Range = ( (Range))
-- cata
sem_Range :: (Range) ->
             (T_Range)
sem_Range ((Range_Range (_start) (_stop))) =
    (sem_Range_Range ((sem_Position (_start))) ((sem_Position (_stop))))
sem_Range_Range :: (T_Position) ->
                   (T_Position) ->
                   (T_Range)
sem_Range_Range (start_) (stop_) =
    let _lhsOself :: (Range)
        _startIself :: (Position)
        _stopIself :: (Position)
        ( _startIself) =
            (start_ )
        ( _stopIself) =
            (stop_ )
        (_self@_) =
            Range_Range _startIself _stopIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- RecordExpressionBinding -------------------------------------
-- semantic domain
type T_RecordExpressionBinding = (ClassEnvironment) ->
                                 ([(ScopeInfo, Entity)]) ->
                                 (Names) ->
                                 ([Option]) ->
                                 (OrderedTypeSynonyms) ->
                                 ( ([(Name, Instance)]),([(ScopeInfo, Entity)]),(RecordExpressionBinding),(Names))
-- cata
sem_RecordExpressionBinding :: (RecordExpressionBinding) ->
                               (T_RecordExpressionBinding)
sem_RecordExpressionBinding ((RecordExpressionBinding_RecordExpressionBinding (_range) (_name) (_expression))) =
    (sem_RecordExpressionBinding_RecordExpressionBinding ((sem_Range (_range))) ((sem_Name (_name))) ((sem_Expression (_expression))))
sem_RecordExpressionBinding_RecordExpressionBinding :: (T_Range) ->
                                                       (T_Name) ->
                                                       (T_Expression) ->
                                                       (T_RecordExpressionBinding)
sem_RecordExpressionBinding_RecordExpressionBinding (range_) (name_) (expression_) =
    \ _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOself :: (RecordExpressionBinding)
            _lhsOunboundNames :: (Names)
            _rangeIself :: (Range)
            _nameIself :: (Name)
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionIkindErrors :: ([Error])
            _expressionImiscerrors :: ([Error])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIwarnings :: ([Warning])
            _expressionOallTypeConstructors :: (Names)
            _expressionOallValueConstructors :: (Names)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionOkindErrors :: ([Error])
            _expressionOmiscerrors :: ([Error])
            _expressionOnamesInScope :: (Names)
            _expressionOoptions :: ([Option])
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOtypeConstructors :: (M.Map Name Int)
            _expressionOvalueConstructors :: (M.Map Name TpScheme)
            _expressionOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            ( _expressionIcollectInstances,_expressionIcollectScopeInfos,_expressionIkindErrors,_expressionImiscerrors,_expressionIself,_expressionIunboundNames,_expressionIwarnings) =
                (expression_ (_expressionOallTypeConstructors) (_expressionOallValueConstructors) (_expressionOclassEnvironment) (_expressionOcollectScopeInfos) (_expressionOkindErrors) (_expressionOmiscerrors) (_expressionOnamesInScope) (_expressionOoptions) (_expressionOorderedTypeSynonyms) (_expressionOtypeConstructors) (_expressionOvalueConstructors) (_expressionOwarnings))
            ((_monos@_,_constructorenv@_,_betaUnique@_,_miscerrors@_,_warnings@_,_kindErrors@_,_valueConstructors@_,_allValueConstructors@_,_typeConstructors@_,_allTypeConstructors@_,_importEnvironment@_)) =
                internalError "PartialSyntax.ag" "n/a" "RecordExpressionBinding.RecordExpressionBinding"
            (_lhsOcollectInstances@_) =
                _expressionIcollectInstances
            (_lhsOunboundNames@_) =
                _expressionIunboundNames
            (_self@_) =
                RecordExpressionBinding_RecordExpressionBinding _rangeIself _nameIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _expressionIcollectScopeInfos
            (_expressionOallTypeConstructors@_) =
                _allTypeConstructors
            (_expressionOallValueConstructors@_) =
                _allValueConstructors
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_expressionOkindErrors@_) =
                _kindErrors
            (_expressionOmiscerrors@_) =
                _miscerrors
            (_expressionOnamesInScope@_) =
                _lhsInamesInScope
            (_expressionOoptions@_) =
                _lhsIoptions
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOtypeConstructors@_) =
                _typeConstructors
            (_expressionOvalueConstructors@_) =
                _valueConstructors
            (_expressionOwarnings@_) =
                _warnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOself,_lhsOunboundNames)
-- RecordExpressionBindings ------------------------------------
-- semantic domain
type T_RecordExpressionBindings = (ClassEnvironment) ->
                                  ([(ScopeInfo, Entity)]) ->
                                  (Names) ->
                                  ([Option]) ->
                                  (OrderedTypeSynonyms) ->
                                  ( ([(Name, Instance)]),([(ScopeInfo, Entity)]),(RecordExpressionBindings),(Names))
-- cata
sem_RecordExpressionBindings :: (RecordExpressionBindings) ->
                                (T_RecordExpressionBindings)
sem_RecordExpressionBindings (list) =
    (Prelude.foldr (sem_RecordExpressionBindings_Cons) (sem_RecordExpressionBindings_Nil) ((Prelude.map sem_RecordExpressionBinding list)))
sem_RecordExpressionBindings_Cons :: (T_RecordExpressionBinding) ->
                                     (T_RecordExpressionBindings) ->
                                     (T_RecordExpressionBindings)
sem_RecordExpressionBindings_Cons (hd_) (tl_) =
    \ _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOself :: (RecordExpressionBindings)
            _lhsOunboundNames :: (Names)
            _hdIcollectInstances :: ([(Name, Instance)])
            _hdIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _hdIself :: (RecordExpressionBinding)
            _hdIunboundNames :: (Names)
            _hdOclassEnvironment :: (ClassEnvironment)
            _hdOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _hdOnamesInScope :: (Names)
            _hdOoptions :: ([Option])
            _hdOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _tlIcollectInstances :: ([(Name, Instance)])
            _tlIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _tlIself :: (RecordExpressionBindings)
            _tlIunboundNames :: (Names)
            _tlOclassEnvironment :: (ClassEnvironment)
            _tlOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _tlOnamesInScope :: (Names)
            _tlOoptions :: ([Option])
            _tlOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            ( _hdIcollectInstances,_hdIcollectScopeInfos,_hdIself,_hdIunboundNames) =
                (hd_ (_hdOclassEnvironment) (_hdOcollectScopeInfos) (_hdOnamesInScope) (_hdOoptions) (_hdOorderedTypeSynonyms))
            ( _tlIcollectInstances,_tlIcollectScopeInfos,_tlIself,_tlIunboundNames) =
                (tl_ (_tlOclassEnvironment) (_tlOcollectScopeInfos) (_tlOnamesInScope) (_tlOoptions) (_tlOorderedTypeSynonyms))
            (_lhsOcollectInstances@_) =
                _hdIcollectInstances  ++  _tlIcollectInstances
            (_lhsOunboundNames@_) =
                _hdIunboundNames ++ _tlIunboundNames
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _tlIcollectScopeInfos
            (_hdOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_hdOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_hdOnamesInScope@_) =
                _lhsInamesInScope
            (_hdOoptions@_) =
                _lhsIoptions
            (_hdOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_tlOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_tlOcollectScopeInfos@_) =
                _hdIcollectScopeInfos
            (_tlOnamesInScope@_) =
                _lhsInamesInScope
            (_tlOoptions@_) =
                _lhsIoptions
            (_tlOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOself,_lhsOunboundNames)
sem_RecordExpressionBindings_Nil :: (T_RecordExpressionBindings)
sem_RecordExpressionBindings_Nil  =
    \ _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOself :: (RecordExpressionBindings)
            _lhsOunboundNames :: (Names)
            (_lhsOcollectInstances@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOself,_lhsOunboundNames)
-- RecordPatternBinding ----------------------------------------
-- semantic domain
type T_RecordPatternBinding = ([(ScopeInfo, Entity)]) ->
                              (Names) ->
                              ( ([(ScopeInfo, Entity)]),(RecordPatternBinding),(Names))
-- cata
sem_RecordPatternBinding :: (RecordPatternBinding) ->
                            (T_RecordPatternBinding)
sem_RecordPatternBinding ((RecordPatternBinding_RecordPatternBinding (_range) (_name) (_pattern))) =
    (sem_RecordPatternBinding_RecordPatternBinding ((sem_Range (_range))) ((sem_Name (_name))) ((sem_Pattern (_pattern))))
sem_RecordPatternBinding_RecordPatternBinding :: (T_Range) ->
                                                 (T_Name) ->
                                                 (T_Pattern) ->
                                                 (T_RecordPatternBinding)
sem_RecordPatternBinding_RecordPatternBinding (range_) (name_) (pattern_) =
    \ _lhsIcollectScopeInfos
      _lhsInamesInScope ->
        let _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOself :: (RecordPatternBinding)
            _lhsOunboundNames :: (Names)
            _rangeIself :: (Range)
            _nameIself :: (Name)
            _patternIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _patternImiscerrors :: ([Error])
            _patternIpatVarNames :: (Names)
            _patternIself :: (Pattern)
            _patternIunboundNames :: (Names)
            _patternIwarnings :: ([Warning])
            _patternOallTypeConstructors :: (Names)
            _patternOallValueConstructors :: (Names)
            _patternOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _patternOlhsPattern :: (Bool)
            _patternOmiscerrors :: ([Error])
            _patternOnamesInScope :: (Names)
            _patternOtypeConstructors :: (M.Map Name Int)
            _patternOvalueConstructors :: (M.Map Name TpScheme)
            _patternOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            ( _patternIcollectScopeInfos,_patternImiscerrors,_patternIpatVarNames,_patternIself,_patternIunboundNames,_patternIwarnings) =
                (pattern_ (_patternOallTypeConstructors) (_patternOallValueConstructors) (_patternOcollectScopeInfos) (_patternOlhsPattern) (_patternOmiscerrors) (_patternOnamesInScope) (_patternOtypeConstructors) (_patternOvalueConstructors) (_patternOwarnings))
            (_patternOlhsPattern@_) =
                False
            ((_monos@_,_constructorenv@_,_betaUnique@_,_miscerrors@_,_warnings@_,_valueConstructors@_,_allValueConstructors@_,_typeConstructors@_,_allTypeConstructors@_,_importEnvironment@_)) =
                internalError "PartialSyntax.ag" "n/a" "RecordPatternBinding.RecordPatternBinding"
            (_lhsOunboundNames@_) =
                _patternIunboundNames
            (_self@_) =
                RecordPatternBinding_RecordPatternBinding _rangeIself _nameIself _patternIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _patternIcollectScopeInfos
            (_patternOallTypeConstructors@_) =
                _allTypeConstructors
            (_patternOallValueConstructors@_) =
                _allValueConstructors
            (_patternOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_patternOmiscerrors@_) =
                _miscerrors
            (_patternOnamesInScope@_) =
                _lhsInamesInScope
            (_patternOtypeConstructors@_) =
                _typeConstructors
            (_patternOvalueConstructors@_) =
                _valueConstructors
            (_patternOwarnings@_) =
                _warnings
        in  ( _lhsOcollectScopeInfos,_lhsOself,_lhsOunboundNames)
-- RecordPatternBindings ---------------------------------------
-- semantic domain
type T_RecordPatternBindings = ([(ScopeInfo, Entity)]) ->
                               (Names) ->
                               ( ([(ScopeInfo, Entity)]),(RecordPatternBindings),(Names))
-- cata
sem_RecordPatternBindings :: (RecordPatternBindings) ->
                             (T_RecordPatternBindings)
sem_RecordPatternBindings (list) =
    (Prelude.foldr (sem_RecordPatternBindings_Cons) (sem_RecordPatternBindings_Nil) ((Prelude.map sem_RecordPatternBinding list)))
sem_RecordPatternBindings_Cons :: (T_RecordPatternBinding) ->
                                  (T_RecordPatternBindings) ->
                                  (T_RecordPatternBindings)
sem_RecordPatternBindings_Cons (hd_) (tl_) =
    \ _lhsIcollectScopeInfos
      _lhsInamesInScope ->
        let _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOself :: (RecordPatternBindings)
            _lhsOunboundNames :: (Names)
            _hdIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _hdIself :: (RecordPatternBinding)
            _hdIunboundNames :: (Names)
            _hdOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _hdOnamesInScope :: (Names)
            _tlIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _tlIself :: (RecordPatternBindings)
            _tlIunboundNames :: (Names)
            _tlOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _tlOnamesInScope :: (Names)
            ( _hdIcollectScopeInfos,_hdIself,_hdIunboundNames) =
                (hd_ (_hdOcollectScopeInfos) (_hdOnamesInScope))
            ( _tlIcollectScopeInfos,_tlIself,_tlIunboundNames) =
                (tl_ (_tlOcollectScopeInfos) (_tlOnamesInScope))
            (_lhsOunboundNames@_) =
                _hdIunboundNames ++ _tlIunboundNames
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _tlIcollectScopeInfos
            (_hdOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_hdOnamesInScope@_) =
                _lhsInamesInScope
            (_tlOcollectScopeInfos@_) =
                _hdIcollectScopeInfos
            (_tlOnamesInScope@_) =
                _lhsInamesInScope
        in  ( _lhsOcollectScopeInfos,_lhsOself,_lhsOunboundNames)
sem_RecordPatternBindings_Nil :: (T_RecordPatternBindings)
sem_RecordPatternBindings_Nil  =
    \ _lhsIcollectScopeInfos
      _lhsInamesInScope ->
        let _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOself :: (RecordPatternBindings)
            _lhsOunboundNames :: (Names)
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
        in  ( _lhsOcollectScopeInfos,_lhsOself,_lhsOunboundNames)
-- RightHandSide -----------------------------------------------
-- semantic domain
type T_RightHandSide = (Names) ->
                       (Names) ->
                       (ClassEnvironment) ->
                       ([(ScopeInfo, Entity)]) ->
                       ([Error]) ->
                       ([Error]) ->
                       (Names) ->
                       ([Option]) ->
                       (OrderedTypeSynonyms) ->
                       (M.Map Name Int) ->
                       (M.Map Name TpScheme) ->
                       ([Warning]) ->
                       ( ([(Name, Instance)]),([(ScopeInfo, Entity)]),([Error]),([Error]),(RightHandSide),(Names),([Warning]))
-- cata
sem_RightHandSide :: (RightHandSide) ->
                     (T_RightHandSide)
sem_RightHandSide ((RightHandSide_Expression (_range) (_expression) (_where))) =
    (sem_RightHandSide_Expression ((sem_Range (_range))) ((sem_Expression (_expression))) ((sem_MaybeDeclarations (_where))))
sem_RightHandSide ((RightHandSide_Guarded (_range) (_guardedexpressions) (_where))) =
    (sem_RightHandSide_Guarded ((sem_Range (_range))) ((sem_GuardedExpressions (_guardedexpressions))) ((sem_MaybeDeclarations (_where))))
sem_RightHandSide_Expression :: (T_Range) ->
                                (T_Expression) ->
                                (T_MaybeDeclarations) ->
                                (T_RightHandSide)
sem_RightHandSide_Expression (range_) (expression_) (where_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (RightHandSide)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionIkindErrors :: ([Error])
            _expressionImiscerrors :: ([Error])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIwarnings :: ([Warning])
            _expressionOallTypeConstructors :: (Names)
            _expressionOallValueConstructors :: (Names)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionOkindErrors :: ([Error])
            _expressionOmiscerrors :: ([Error])
            _expressionOnamesInScope :: (Names)
            _expressionOoptions :: ([Option])
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOtypeConstructors :: (M.Map Name Int)
            _expressionOvalueConstructors :: (M.Map Name TpScheme)
            _expressionOwarnings :: ([Warning])
            _whereIcollectInstances :: ([(Name, Instance)])
            _whereIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _whereIkindErrors :: ([Error])
            _whereImiscerrors :: ([Error])
            _whereInamesInScope :: (Names)
            _whereIself :: (MaybeDeclarations)
            _whereIunboundNames :: (Names)
            _whereIwarnings :: ([Warning])
            _whereOallTypeConstructors :: (Names)
            _whereOallValueConstructors :: (Names)
            _whereOclassEnvironment :: (ClassEnvironment)
            _whereOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _whereOkindErrors :: ([Error])
            _whereOmiscerrors :: ([Error])
            _whereOnamesInScope :: (Names)
            _whereOoptions :: ([Option])
            _whereOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _whereOtypeConstructors :: (M.Map Name Int)
            _whereOunboundNames :: (Names)
            _whereOvalueConstructors :: (M.Map Name TpScheme)
            _whereOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _expressionIcollectInstances,_expressionIcollectScopeInfos,_expressionIkindErrors,_expressionImiscerrors,_expressionIself,_expressionIunboundNames,_expressionIwarnings) =
                (expression_ (_expressionOallTypeConstructors) (_expressionOallValueConstructors) (_expressionOclassEnvironment) (_expressionOcollectScopeInfos) (_expressionOkindErrors) (_expressionOmiscerrors) (_expressionOnamesInScope) (_expressionOoptions) (_expressionOorderedTypeSynonyms) (_expressionOtypeConstructors) (_expressionOvalueConstructors) (_expressionOwarnings))
            ( _whereIcollectInstances,_whereIcollectScopeInfos,_whereIkindErrors,_whereImiscerrors,_whereInamesInScope,_whereIself,_whereIunboundNames,_whereIwarnings) =
                (where_ (_whereOallTypeConstructors) (_whereOallValueConstructors) (_whereOclassEnvironment) (_whereOcollectScopeInfos) (_whereOkindErrors) (_whereOmiscerrors) (_whereOnamesInScope) (_whereOoptions) (_whereOorderedTypeSynonyms) (_whereOtypeConstructors) (_whereOunboundNames) (_whereOvalueConstructors) (_whereOwarnings))
            (_whereOunboundNames@_) =
                _expressionIunboundNames
            (_expressionOnamesInScope@_) =
                _whereInamesInScope
            (_lhsOunboundNames@_) =
                _whereIunboundNames
            (_lhsOcollectInstances@_) =
                _expressionIcollectInstances  ++  _whereIcollectInstances
            (_self@_) =
                RightHandSide_Expression _rangeIself _expressionIself _whereIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _whereIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _whereIkindErrors
            (_lhsOmiscerrors@_) =
                _whereImiscerrors
            (_lhsOwarnings@_) =
                _whereIwarnings
            (_expressionOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_expressionOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_expressionOkindErrors@_) =
                _lhsIkindErrors
            (_expressionOmiscerrors@_) =
                _lhsImiscerrors
            (_expressionOoptions@_) =
                _lhsIoptions
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOtypeConstructors@_) =
                _lhsItypeConstructors
            (_expressionOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_expressionOwarnings@_) =
                _lhsIwarnings
            (_whereOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_whereOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_whereOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_whereOcollectScopeInfos@_) =
                _expressionIcollectScopeInfos
            (_whereOkindErrors@_) =
                _expressionIkindErrors
            (_whereOmiscerrors@_) =
                _expressionImiscerrors
            (_whereOnamesInScope@_) =
                _lhsInamesInScope
            (_whereOoptions@_) =
                _lhsIoptions
            (_whereOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_whereOtypeConstructors@_) =
                _lhsItypeConstructors
            (_whereOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_whereOwarnings@_) =
                _expressionIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_RightHandSide_Guarded :: (T_Range) ->
                             (T_GuardedExpressions) ->
                             (T_MaybeDeclarations) ->
                             (T_RightHandSide)
sem_RightHandSide_Guarded (range_) (guardedexpressions_) (where_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (RightHandSide)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _guardedexpressionsIcollectInstances :: ([(Name, Instance)])
            _guardedexpressionsIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _guardedexpressionsIkindErrors :: ([Error])
            _guardedexpressionsImiscerrors :: ([Error])
            _guardedexpressionsIself :: (GuardedExpressions)
            _guardedexpressionsIunboundNames :: (Names)
            _guardedexpressionsIwarnings :: ([Warning])
            _guardedexpressionsOallTypeConstructors :: (Names)
            _guardedexpressionsOallValueConstructors :: (Names)
            _guardedexpressionsOclassEnvironment :: (ClassEnvironment)
            _guardedexpressionsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _guardedexpressionsOkindErrors :: ([Error])
            _guardedexpressionsOmiscerrors :: ([Error])
            _guardedexpressionsOnamesInScope :: (Names)
            _guardedexpressionsOoptions :: ([Option])
            _guardedexpressionsOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _guardedexpressionsOtypeConstructors :: (M.Map Name Int)
            _guardedexpressionsOvalueConstructors :: (M.Map Name TpScheme)
            _guardedexpressionsOwarnings :: ([Warning])
            _whereIcollectInstances :: ([(Name, Instance)])
            _whereIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _whereIkindErrors :: ([Error])
            _whereImiscerrors :: ([Error])
            _whereInamesInScope :: (Names)
            _whereIself :: (MaybeDeclarations)
            _whereIunboundNames :: (Names)
            _whereIwarnings :: ([Warning])
            _whereOallTypeConstructors :: (Names)
            _whereOallValueConstructors :: (Names)
            _whereOclassEnvironment :: (ClassEnvironment)
            _whereOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _whereOkindErrors :: ([Error])
            _whereOmiscerrors :: ([Error])
            _whereOnamesInScope :: (Names)
            _whereOoptions :: ([Option])
            _whereOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _whereOtypeConstructors :: (M.Map Name Int)
            _whereOunboundNames :: (Names)
            _whereOvalueConstructors :: (M.Map Name TpScheme)
            _whereOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _guardedexpressionsIcollectInstances,_guardedexpressionsIcollectScopeInfos,_guardedexpressionsIkindErrors,_guardedexpressionsImiscerrors,_guardedexpressionsIself,_guardedexpressionsIunboundNames,_guardedexpressionsIwarnings) =
                (guardedexpressions_ (_guardedexpressionsOallTypeConstructors)
                                     (_guardedexpressionsOallValueConstructors)
                                     (_guardedexpressionsOclassEnvironment)
                                     (_guardedexpressionsOcollectScopeInfos)
                                     (_guardedexpressionsOkindErrors)
                                     (_guardedexpressionsOmiscerrors)
                                     (_guardedexpressionsOnamesInScope)
                                     (_guardedexpressionsOoptions)
                                     (_guardedexpressionsOorderedTypeSynonyms)
                                     (_guardedexpressionsOtypeConstructors)
                                     (_guardedexpressionsOvalueConstructors)
                                     (_guardedexpressionsOwarnings))
            ( _whereIcollectInstances,_whereIcollectScopeInfos,_whereIkindErrors,_whereImiscerrors,_whereInamesInScope,_whereIself,_whereIunboundNames,_whereIwarnings) =
                (where_ (_whereOallTypeConstructors) (_whereOallValueConstructors) (_whereOclassEnvironment) (_whereOcollectScopeInfos) (_whereOkindErrors) (_whereOmiscerrors) (_whereOnamesInScope) (_whereOoptions) (_whereOorderedTypeSynonyms) (_whereOtypeConstructors) (_whereOunboundNames) (_whereOvalueConstructors) (_whereOwarnings))
            (_whereOunboundNames@_) =
                _guardedexpressionsIunboundNames
            (_guardedexpressionsOnamesInScope@_) =
                _whereInamesInScope
            (_lhsOunboundNames@_) =
                _whereIunboundNames
            (_lhsOcollectInstances@_) =
                _guardedexpressionsIcollectInstances  ++  _whereIcollectInstances
            (_self@_) =
                RightHandSide_Guarded _rangeIself _guardedexpressionsIself _whereIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _whereIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _whereIkindErrors
            (_lhsOmiscerrors@_) =
                _whereImiscerrors
            (_lhsOwarnings@_) =
                _whereIwarnings
            (_guardedexpressionsOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_guardedexpressionsOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_guardedexpressionsOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_guardedexpressionsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_guardedexpressionsOkindErrors@_) =
                _lhsIkindErrors
            (_guardedexpressionsOmiscerrors@_) =
                _lhsImiscerrors
            (_guardedexpressionsOoptions@_) =
                _lhsIoptions
            (_guardedexpressionsOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_guardedexpressionsOtypeConstructors@_) =
                _lhsItypeConstructors
            (_guardedexpressionsOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_guardedexpressionsOwarnings@_) =
                _lhsIwarnings
            (_whereOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_whereOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_whereOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_whereOcollectScopeInfos@_) =
                _guardedexpressionsIcollectScopeInfos
            (_whereOkindErrors@_) =
                _guardedexpressionsIkindErrors
            (_whereOmiscerrors@_) =
                _guardedexpressionsImiscerrors
            (_whereOnamesInScope@_) =
                _lhsInamesInScope
            (_whereOoptions@_) =
                _lhsIoptions
            (_whereOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_whereOtypeConstructors@_) =
                _lhsItypeConstructors
            (_whereOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_whereOwarnings@_) =
                _guardedexpressionsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOmiscerrors,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
-- SimpleType --------------------------------------------------
-- semantic domain
type T_SimpleType = ( (Name),(SimpleType),(Names))
-- cata
sem_SimpleType :: (SimpleType) ->
                  (T_SimpleType)
sem_SimpleType ((SimpleType_SimpleType (_range) (_name) (_typevariables))) =
    (sem_SimpleType_SimpleType ((sem_Range (_range))) ((sem_Name (_name))) ((sem_Names (_typevariables))))
sem_SimpleType_SimpleType :: (T_Range) ->
                             (T_Name) ->
                             (T_Names) ->
                             (T_SimpleType)
sem_SimpleType_SimpleType (range_) (name_) (typevariables_) =
    let _lhsOname :: (Name)
        _lhsOself :: (SimpleType)
        _lhsOtypevariables :: (Names)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        _typevariablesIself :: (Names)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        ( _typevariablesIself) =
            (typevariables_ )
        (_lhsOtypevariables@_) =
            _typevariablesIself
        (_lhsOname@_) =
            _nameIself
        (_self@_) =
            SimpleType_SimpleType _rangeIself _nameIself _typevariablesIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOname,_lhsOself,_lhsOtypevariables)
-- Statement ---------------------------------------------------
-- semantic domain
type T_Statement = (Names) ->
                   (Names) ->
                   (ClassEnvironment) ->
                   ([(ScopeInfo, Entity)]) ->
                   ([Error]) ->
                   (Bool) ->
                   ([Error]) ->
                   (Names) ->
                   ([Option]) ->
                   (OrderedTypeSynonyms) ->
                   (M.Map Name Int) ->
                   (Names) ->
                   (M.Map Name TpScheme) ->
                   ([Warning]) ->
                   ( ([(Name, Instance)]),([(ScopeInfo, Entity)]),([Error]),(Bool),([Error]),(Names),(Statement),(Names),([Warning]))
-- cata
sem_Statement :: (Statement) ->
                 (T_Statement)
sem_Statement ((Statement_Empty (_range))) =
    (sem_Statement_Empty ((sem_Range (_range))))
sem_Statement ((Statement_Expression (_range) (_expression))) =
    (sem_Statement_Expression ((sem_Range (_range))) ((sem_Expression (_expression))))
sem_Statement ((Statement_Generator (_range) (_pattern) (_expression))) =
    (sem_Statement_Generator ((sem_Range (_range))) ((sem_Pattern (_pattern))) ((sem_Expression (_expression))))
sem_Statement ((Statement_Let (_range) (_declarations))) =
    (sem_Statement_Let ((sem_Range (_range))) ((sem_Declarations (_declarations))))
sem_Statement_Empty :: (T_Range) ->
                       (T_Statement)
sem_Statement_Empty (range_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsIlastStatementIsExpr
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIunboundNames
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOlastStatementIsExpr :: (Bool)
            _lhsOmiscerrors :: ([Error])
            _lhsOnamesInScope :: (Names)
            _lhsOself :: (Statement)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            ( _rangeIself) =
                (range_ )
            (_lhsOcollectInstances@_) =
                []
            (_self@_) =
                Statement_Empty _rangeIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _lhsIkindErrors
            (_lhsOlastStatementIsExpr@_) =
                _lhsIlastStatementIsExpr
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
            (_lhsOnamesInScope@_) =
                _lhsInamesInScope
            (_lhsOunboundNames@_) =
                _lhsIunboundNames
            (_lhsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOlastStatementIsExpr,_lhsOmiscerrors,_lhsOnamesInScope,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Statement_Expression :: (T_Range) ->
                            (T_Expression) ->
                            (T_Statement)
sem_Statement_Expression (range_) (expression_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsIlastStatementIsExpr
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIunboundNames
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOlastStatementIsExpr :: (Bool)
            _lhsOmiscerrors :: ([Error])
            _lhsOnamesInScope :: (Names)
            _lhsOself :: (Statement)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionIkindErrors :: ([Error])
            _expressionImiscerrors :: ([Error])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIwarnings :: ([Warning])
            _expressionOallTypeConstructors :: (Names)
            _expressionOallValueConstructors :: (Names)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionOkindErrors :: ([Error])
            _expressionOmiscerrors :: ([Error])
            _expressionOnamesInScope :: (Names)
            _expressionOoptions :: ([Option])
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOtypeConstructors :: (M.Map Name Int)
            _expressionOvalueConstructors :: (M.Map Name TpScheme)
            _expressionOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _expressionIcollectInstances,_expressionIcollectScopeInfos,_expressionIkindErrors,_expressionImiscerrors,_expressionIself,_expressionIunboundNames,_expressionIwarnings) =
                (expression_ (_expressionOallTypeConstructors) (_expressionOallValueConstructors) (_expressionOclassEnvironment) (_expressionOcollectScopeInfos) (_expressionOkindErrors) (_expressionOmiscerrors) (_expressionOnamesInScope) (_expressionOoptions) (_expressionOorderedTypeSynonyms) (_expressionOtypeConstructors) (_expressionOvalueConstructors) (_expressionOwarnings))
            (_lhsOunboundNames@_) =
                _expressionIunboundNames ++ _lhsIunboundNames
            (_lhsOlastStatementIsExpr@_) =
                True
            (_lhsOcollectInstances@_) =
                _expressionIcollectInstances
            (_self@_) =
                Statement_Expression _rangeIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _expressionIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _expressionIkindErrors
            (_lhsOmiscerrors@_) =
                _expressionImiscerrors
            (_lhsOnamesInScope@_) =
                _lhsInamesInScope
            (_lhsOwarnings@_) =
                _expressionIwarnings
            (_expressionOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_expressionOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_expressionOkindErrors@_) =
                _lhsIkindErrors
            (_expressionOmiscerrors@_) =
                _lhsImiscerrors
            (_expressionOnamesInScope@_) =
                _lhsInamesInScope
            (_expressionOoptions@_) =
                _lhsIoptions
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOtypeConstructors@_) =
                _lhsItypeConstructors
            (_expressionOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_expressionOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOlastStatementIsExpr,_lhsOmiscerrors,_lhsOnamesInScope,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Statement_Generator :: (T_Range) ->
                           (T_Pattern) ->
                           (T_Expression) ->
                           (T_Statement)
sem_Statement_Generator (range_) (pattern_) (expression_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsIlastStatementIsExpr
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIunboundNames
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOlastStatementIsExpr :: (Bool)
            _lhsOmiscerrors :: ([Error])
            _lhsOnamesInScope :: (Names)
            _lhsOself :: (Statement)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _patternIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _patternImiscerrors :: ([Error])
            _patternIpatVarNames :: (Names)
            _patternIself :: (Pattern)
            _patternIunboundNames :: (Names)
            _patternIwarnings :: ([Warning])
            _patternOallTypeConstructors :: (Names)
            _patternOallValueConstructors :: (Names)
            _patternOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _patternOlhsPattern :: (Bool)
            _patternOmiscerrors :: ([Error])
            _patternOnamesInScope :: (Names)
            _patternOtypeConstructors :: (M.Map Name Int)
            _patternOvalueConstructors :: (M.Map Name TpScheme)
            _patternOwarnings :: ([Warning])
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionIkindErrors :: ([Error])
            _expressionImiscerrors :: ([Error])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIwarnings :: ([Warning])
            _expressionOallTypeConstructors :: (Names)
            _expressionOallValueConstructors :: (Names)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _expressionOkindErrors :: ([Error])
            _expressionOmiscerrors :: ([Error])
            _expressionOnamesInScope :: (Names)
            _expressionOoptions :: ([Option])
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOtypeConstructors :: (M.Map Name Int)
            _expressionOvalueConstructors :: (M.Map Name TpScheme)
            _expressionOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _patternIcollectScopeInfos,_patternImiscerrors,_patternIpatVarNames,_patternIself,_patternIunboundNames,_patternIwarnings) =
                (pattern_ (_patternOallTypeConstructors) (_patternOallValueConstructors) (_patternOcollectScopeInfos) (_patternOlhsPattern) (_patternOmiscerrors) (_patternOnamesInScope) (_patternOtypeConstructors) (_patternOvalueConstructors) (_patternOwarnings))
            ( _expressionIcollectInstances,_expressionIcollectScopeInfos,_expressionIkindErrors,_expressionImiscerrors,_expressionIself,_expressionIunboundNames,_expressionIwarnings) =
                (expression_ (_expressionOallTypeConstructors) (_expressionOallValueConstructors) (_expressionOclassEnvironment) (_expressionOcollectScopeInfos) (_expressionOkindErrors) (_expressionOmiscerrors) (_expressionOnamesInScope) (_expressionOoptions) (_expressionOorderedTypeSynonyms) (_expressionOtypeConstructors) (_expressionOvalueConstructors) (_expressionOwarnings))
            ((_namesInScope@_,_unboundNames@_,_scopeInfo@_)) =
                changeOfScope _patternIpatVarNames (_expressionIunboundNames ++ _lhsIunboundNames) _lhsInamesInScope
            (_expressionOnamesInScope@_) =
                _lhsInamesInScope
            (_lhsOunboundNames@_) =
                _unboundNames
            (_lhsOnamesInScope@_) =
                _namesInScope
            (_lhsOlastStatementIsExpr@_) =
                False
            (_patternOlhsPattern@_) =
                False
            (_lhsOcollectScopeInfos@_) =
                (_scopeInfo, Variable)   : _expressionIcollectScopeInfos
            (_lhsOcollectInstances@_) =
                _expressionIcollectInstances
            (_self@_) =
                Statement_Generator _rangeIself _patternIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsOkindErrors@_) =
                _expressionIkindErrors
            (_lhsOmiscerrors@_) =
                _expressionImiscerrors
            (_lhsOwarnings@_) =
                _expressionIwarnings
            (_patternOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_patternOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_patternOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_patternOmiscerrors@_) =
                _lhsImiscerrors
            (_patternOnamesInScope@_) =
                _namesInScope
            (_patternOtypeConstructors@_) =
                _lhsItypeConstructors
            (_patternOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_patternOwarnings@_) =
                _lhsIwarnings
            (_expressionOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_expressionOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectScopeInfos@_) =
                _patternIcollectScopeInfos
            (_expressionOkindErrors@_) =
                _lhsIkindErrors
            (_expressionOmiscerrors@_) =
                _patternImiscerrors
            (_expressionOoptions@_) =
                _lhsIoptions
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOtypeConstructors@_) =
                _lhsItypeConstructors
            (_expressionOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_expressionOwarnings@_) =
                _patternIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOlastStatementIsExpr,_lhsOmiscerrors,_lhsOnamesInScope,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Statement_Let :: (T_Range) ->
                     (T_Declarations) ->
                     (T_Statement)
sem_Statement_Let (range_) (declarations_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsIlastStatementIsExpr
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIunboundNames
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOlastStatementIsExpr :: (Bool)
            _lhsOmiscerrors :: ([Error])
            _lhsOnamesInScope :: (Names)
            _lhsOself :: (Statement)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _declarationsIcollectInstances :: ([(Name, Instance)])
            _declarationsIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _declarationsIcollectTypeConstructors :: ([(Name,Int)])
            _declarationsIcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _declarationsIcollectValueConstructors :: ([(Name,TpScheme)])
            _declarationsIdeclVarNames :: (Names)
            _declarationsIkindErrors :: ([Error])
            _declarationsImiscerrors :: ([Error])
            _declarationsIoperatorFixities :: ([(Name,(Int,Assoc))])
            _declarationsIpreviousWasAlsoFB :: (Maybe Name)
            _declarationsIrestrictedNames :: (Names)
            _declarationsIself :: (Declarations)
            _declarationsIsuspiciousFBs :: ([(Name,Name)])
            _declarationsItypeSignatures :: ([(Name,TpScheme)])
            _declarationsIunboundNames :: (Names)
            _declarationsIwarnings :: ([Warning])
            _declarationsOallTypeConstructors :: (Names)
            _declarationsOallValueConstructors :: (Names)
            _declarationsOclassEnvironment :: (ClassEnvironment)
            _declarationsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _declarationsOcollectTypeConstructors :: ([(Name,Int)])
            _declarationsOcollectTypeSynonyms :: ([(Name,(Int,Tps -> Tp))])
            _declarationsOcollectValueConstructors :: ([(Name,TpScheme)])
            _declarationsOkindErrors :: ([Error])
            _declarationsOmiscerrors :: ([Error])
            _declarationsOnamesInScope :: (Names)
            _declarationsOoperatorFixities :: ([(Name,(Int,Assoc))])
            _declarationsOoptions :: ([Option])
            _declarationsOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _declarationsOpreviousWasAlsoFB :: (Maybe Name)
            _declarationsOsuspiciousFBs :: ([(Name,Name)])
            _declarationsOtypeConstructors :: (M.Map Name Int)
            _declarationsOtypeSignatures :: ([(Name,TpScheme)])
            _declarationsOvalueConstructors :: (M.Map Name TpScheme)
            _declarationsOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _declarationsIcollectInstances
             ,_declarationsIcollectScopeInfos
             ,_declarationsIcollectTypeConstructors
             ,_declarationsIcollectTypeSynonyms
             ,_declarationsIcollectValueConstructors
             ,_declarationsIdeclVarNames
             ,_declarationsIkindErrors
             ,_declarationsImiscerrors
             ,_declarationsIoperatorFixities
             ,_declarationsIpreviousWasAlsoFB
             ,_declarationsIrestrictedNames
             ,_declarationsIself
             ,_declarationsIsuspiciousFBs
             ,_declarationsItypeSignatures
             ,_declarationsIunboundNames
             ,_declarationsIwarnings
             ) =
                (declarations_ (_declarationsOallTypeConstructors)
                               (_declarationsOallValueConstructors)
                               (_declarationsOclassEnvironment)
                               (_declarationsOcollectScopeInfos)
                               (_declarationsOcollectTypeConstructors)
                               (_declarationsOcollectTypeSynonyms)
                               (_declarationsOcollectValueConstructors)
                               (_declarationsOkindErrors)
                               (_declarationsOmiscerrors)
                               (_declarationsOnamesInScope)
                               (_declarationsOoperatorFixities)
                               (_declarationsOoptions)
                               (_declarationsOorderedTypeSynonyms)
                               (_declarationsOpreviousWasAlsoFB)
                               (_declarationsOsuspiciousFBs)
                               (_declarationsOtypeConstructors)
                               (_declarationsOtypeSignatures)
                               (_declarationsOvalueConstructors)
                               (_declarationsOwarnings))
            (_declarationsOtypeSignatures@_) =
                []
            ((_namesInScope@_,_unboundNames@_,_scopeInfo@_)) =
                changeOfScope _declarationsIdeclVarNames (_declarationsIunboundNames ++ _lhsIunboundNames) _lhsInamesInScope
            (_lhsOunboundNames@_) =
                _unboundNames
            (_lhsOwarnings@_) =
                _declarationsIwarnings ++
                _suspiciousErrors
            (_suspiciousErrors@_) =
                findSimilarFunctionBindings _declarationsItypeSignatures _declarationsIsuspiciousFBs
            (_declarationsOsuspiciousFBs@_) =
                []
            (_declarationsOpreviousWasAlsoFB@_) =
                Nothing
            (_lhsOlastStatementIsExpr@_) =
                False
            (_typeSignatureErrors@_) =
                checkTypeSignatures _declarationsIdeclVarNames _declarationsIrestrictedNames _declarationsItypeSignatures
            ((_,_doubles@_)) =
                uniqueAppearance (map fst _declarationsItypeSignatures)
            (_lhsOmiscerrors@_) =
                _typeSignatureErrors ++ _declarationsImiscerrors
            ((_collectTypeConstructors@_,_collectValueConstructors@_,_collectTypeSynonyms@_,_collectConstructorEnv@_,_derivedFunctions@_,_operatorFixities@_)) =
                internalError "PartialSyntax.ag" "n/a" "toplevel Statement"
            (_lhsOcollectScopeInfos@_) =
                (_scopeInfo, Definition) : _declarationsIcollectScopeInfos
            (_lhsOcollectInstances@_) =
                _declarationsIcollectInstances
            (_self@_) =
                Statement_Let _rangeIself _declarationsIself
            (_lhsOself@_) =
                _self
            (_lhsOkindErrors@_) =
                _declarationsIkindErrors
            (_lhsOnamesInScope@_) =
                _namesInScope
            (_declarationsOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_declarationsOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_declarationsOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_declarationsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_declarationsOcollectTypeConstructors@_) =
                _collectTypeConstructors
            (_declarationsOcollectTypeSynonyms@_) =
                _collectTypeSynonyms
            (_declarationsOcollectValueConstructors@_) =
                _collectValueConstructors
            (_declarationsOkindErrors@_) =
                _lhsIkindErrors
            (_declarationsOmiscerrors@_) =
                _lhsImiscerrors
            (_declarationsOnamesInScope@_) =
                _namesInScope
            (_declarationsOoperatorFixities@_) =
                _operatorFixities
            (_declarationsOoptions@_) =
                _lhsIoptions
            (_declarationsOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_declarationsOtypeConstructors@_) =
                _lhsItypeConstructors
            (_declarationsOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_declarationsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOlastStatementIsExpr,_lhsOmiscerrors,_lhsOnamesInScope,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
-- Statements --------------------------------------------------
-- semantic domain
type T_Statements = (Names) ->
                    (Names) ->
                    (ClassEnvironment) ->
                    ([(ScopeInfo, Entity)]) ->
                    ([Error]) ->
                    (Bool) ->
                    ([Error]) ->
                    (Names) ->
                    ([Option]) ->
                    (OrderedTypeSynonyms) ->
                    (M.Map Name Int) ->
                    (Names) ->
                    (M.Map Name TpScheme) ->
                    ([Warning]) ->
                    ( ([(Name, Instance)]),([(ScopeInfo, Entity)]),([Error]),(Bool),([Error]),(Names),(Statements),(Names),([Warning]))
-- cata
sem_Statements :: (Statements) ->
                  (T_Statements)
sem_Statements (list) =
    (Prelude.foldr (sem_Statements_Cons) (sem_Statements_Nil) ((Prelude.map sem_Statement list)))
sem_Statements_Cons :: (T_Statement) ->
                       (T_Statements) ->
                       (T_Statements)
sem_Statements_Cons (hd_) (tl_) =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsIlastStatementIsExpr
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIunboundNames
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOlastStatementIsExpr :: (Bool)
            _lhsOmiscerrors :: ([Error])
            _lhsOnamesInScope :: (Names)
            _lhsOself :: (Statements)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            _hdIcollectInstances :: ([(Name, Instance)])
            _hdIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _hdIkindErrors :: ([Error])
            _hdIlastStatementIsExpr :: (Bool)
            _hdImiscerrors :: ([Error])
            _hdInamesInScope :: (Names)
            _hdIself :: (Statement)
            _hdIunboundNames :: (Names)
            _hdIwarnings :: ([Warning])
            _hdOallTypeConstructors :: (Names)
            _hdOallValueConstructors :: (Names)
            _hdOclassEnvironment :: (ClassEnvironment)
            _hdOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _hdOkindErrors :: ([Error])
            _hdOlastStatementIsExpr :: (Bool)
            _hdOmiscerrors :: ([Error])
            _hdOnamesInScope :: (Names)
            _hdOoptions :: ([Option])
            _hdOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _hdOtypeConstructors :: (M.Map Name Int)
            _hdOunboundNames :: (Names)
            _hdOvalueConstructors :: (M.Map Name TpScheme)
            _hdOwarnings :: ([Warning])
            _tlIcollectInstances :: ([(Name, Instance)])
            _tlIcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _tlIkindErrors :: ([Error])
            _tlIlastStatementIsExpr :: (Bool)
            _tlImiscerrors :: ([Error])
            _tlInamesInScope :: (Names)
            _tlIself :: (Statements)
            _tlIunboundNames :: (Names)
            _tlIwarnings :: ([Warning])
            _tlOallTypeConstructors :: (Names)
            _tlOallValueConstructors :: (Names)
            _tlOclassEnvironment :: (ClassEnvironment)
            _tlOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _tlOkindErrors :: ([Error])
            _tlOlastStatementIsExpr :: (Bool)
            _tlOmiscerrors :: ([Error])
            _tlOnamesInScope :: (Names)
            _tlOoptions :: ([Option])
            _tlOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _tlOtypeConstructors :: (M.Map Name Int)
            _tlOunboundNames :: (Names)
            _tlOvalueConstructors :: (M.Map Name TpScheme)
            _tlOwarnings :: ([Warning])
            ( _hdIcollectInstances,_hdIcollectScopeInfos,_hdIkindErrors,_hdIlastStatementIsExpr,_hdImiscerrors,_hdInamesInScope,_hdIself,_hdIunboundNames,_hdIwarnings) =
                (hd_ (_hdOallTypeConstructors) (_hdOallValueConstructors) (_hdOclassEnvironment) (_hdOcollectScopeInfos) (_hdOkindErrors) (_hdOlastStatementIsExpr) (_hdOmiscerrors) (_hdOnamesInScope) (_hdOoptions) (_hdOorderedTypeSynonyms) (_hdOtypeConstructors) (_hdOunboundNames) (_hdOvalueConstructors) (_hdOwarnings))
            ( _tlIcollectInstances,_tlIcollectScopeInfos,_tlIkindErrors,_tlIlastStatementIsExpr,_tlImiscerrors,_tlInamesInScope,_tlIself,_tlIunboundNames,_tlIwarnings) =
                (tl_ (_tlOallTypeConstructors) (_tlOallValueConstructors) (_tlOclassEnvironment) (_tlOcollectScopeInfos) (_tlOkindErrors) (_tlOlastStatementIsExpr) (_tlOmiscerrors) (_tlOnamesInScope) (_tlOoptions) (_tlOorderedTypeSynonyms) (_tlOtypeConstructors) (_tlOunboundNames) (_tlOvalueConstructors) (_tlOwarnings))
            (_hdOunboundNames@_) =
                _tlIunboundNames
            (_tlOunboundNames@_) =
                _lhsIunboundNames
            (_lhsOunboundNames@_) =
                _hdIunboundNames
            (_lhsOcollectInstances@_) =
                _hdIcollectInstances  ++  _tlIcollectInstances
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _tlIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _tlIkindErrors
            (_lhsOlastStatementIsExpr@_) =
                _tlIlastStatementIsExpr
            (_lhsOmiscerrors@_) =
                _tlImiscerrors
            (_lhsOnamesInScope@_) =
                _tlInamesInScope
            (_lhsOwarnings@_) =
                _tlIwarnings
            (_hdOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_hdOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_hdOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_hdOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_hdOkindErrors@_) =
                _lhsIkindErrors
            (_hdOlastStatementIsExpr@_) =
                _lhsIlastStatementIsExpr
            (_hdOmiscerrors@_) =
                _lhsImiscerrors
            (_hdOnamesInScope@_) =
                _lhsInamesInScope
            (_hdOoptions@_) =
                _lhsIoptions
            (_hdOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_hdOtypeConstructors@_) =
                _lhsItypeConstructors
            (_hdOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_hdOwarnings@_) =
                _lhsIwarnings
            (_tlOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_tlOallValueConstructors@_) =
                _lhsIallValueConstructors
            (_tlOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_tlOcollectScopeInfos@_) =
                _hdIcollectScopeInfos
            (_tlOkindErrors@_) =
                _hdIkindErrors
            (_tlOlastStatementIsExpr@_) =
                _hdIlastStatementIsExpr
            (_tlOmiscerrors@_) =
                _hdImiscerrors
            (_tlOnamesInScope@_) =
                _hdInamesInScope
            (_tlOoptions@_) =
                _lhsIoptions
            (_tlOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_tlOtypeConstructors@_) =
                _lhsItypeConstructors
            (_tlOvalueConstructors@_) =
                _lhsIvalueConstructors
            (_tlOwarnings@_) =
                _hdIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOlastStatementIsExpr,_lhsOmiscerrors,_lhsOnamesInScope,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
sem_Statements_Nil :: (T_Statements)
sem_Statements_Nil  =
    \ _lhsIallTypeConstructors
      _lhsIallValueConstructors
      _lhsIclassEnvironment
      _lhsIcollectScopeInfos
      _lhsIkindErrors
      _lhsIlastStatementIsExpr
      _lhsImiscerrors
      _lhsInamesInScope
      _lhsIoptions
      _lhsIorderedTypeSynonyms
      _lhsItypeConstructors
      _lhsIunboundNames
      _lhsIvalueConstructors
      _lhsIwarnings ->
        let _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectScopeInfos :: ([(ScopeInfo, Entity)])
            _lhsOkindErrors :: ([Error])
            _lhsOlastStatementIsExpr :: (Bool)
            _lhsOmiscerrors :: ([Error])
            _lhsOnamesInScope :: (Names)
            _lhsOself :: (Statements)
            _lhsOunboundNames :: (Names)
            _lhsOwarnings :: ([Warning])
            (_lhsOunboundNames@_) =
                _lhsIunboundNames
            (_lhsOcollectInstances@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsOcollectScopeInfos@_) =
                _lhsIcollectScopeInfos
            (_lhsOkindErrors@_) =
                _lhsIkindErrors
            (_lhsOlastStatementIsExpr@_) =
                _lhsIlastStatementIsExpr
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
            (_lhsOnamesInScope@_) =
                _lhsInamesInScope
            (_lhsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcollectInstances,_lhsOcollectScopeInfos,_lhsOkindErrors,_lhsOlastStatementIsExpr,_lhsOmiscerrors,_lhsOnamesInScope,_lhsOself,_lhsOunboundNames,_lhsOwarnings)
-- Strings -----------------------------------------------------
-- semantic domain
type T_Strings = ( (Strings))
-- cata
sem_Strings :: (Strings) ->
               (T_Strings)
sem_Strings (list) =
    (Prelude.foldr (sem_Strings_Cons) (sem_Strings_Nil) (list))
sem_Strings_Cons :: (String) ->
                    (T_Strings) ->
                    (T_Strings)
sem_Strings_Cons (hd_) (tl_) =
    let _lhsOself :: (Strings)
        _tlIself :: (Strings)
        ( _tlIself) =
            (tl_ )
        (_self@_) =
            (:) hd_ _tlIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Strings_Nil :: (T_Strings)
sem_Strings_Nil  =
    let _lhsOself :: (Strings)
        (_self@_) =
            []
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- Type --------------------------------------------------------
-- semantic domain
type T_Type = (Names) ->
              ([Error]) ->
              ([Option]) ->
              (M.Map Name Int) ->
              ([Warning]) ->
              ( (Range),([Error]),(Type),(Names),([Warning]))
-- cata
sem_Type :: (Type) ->
            (T_Type)
sem_Type ((Type_Application (_range) (_prefix) (_function) (_arguments))) =
    (sem_Type_Application ((sem_Range (_range))) (_prefix) ((sem_Type (_function))) ((sem_Types (_arguments))))
sem_Type ((Type_Constructor (_range) (_name))) =
    (sem_Type_Constructor ((sem_Range (_range))) ((sem_Name (_name))))
sem_Type ((Type_Exists (_range) (_typevariables) (_type))) =
    (sem_Type_Exists ((sem_Range (_range))) ((sem_Names (_typevariables))) ((sem_Type (_type))))
sem_Type ((Type_Forall (_range) (_typevariables) (_type))) =
    (sem_Type_Forall ((sem_Range (_range))) ((sem_Names (_typevariables))) ((sem_Type (_type))))
sem_Type ((Type_Parenthesized (_range) (_type))) =
    (sem_Type_Parenthesized ((sem_Range (_range))) ((sem_Type (_type))))
sem_Type ((Type_Qualified (_range) (_context) (_type))) =
    (sem_Type_Qualified ((sem_Range (_range))) ((sem_ContextItems (_context))) ((sem_Type (_type))))
sem_Type ((Type_Variable (_range) (_name))) =
    (sem_Type_Variable ((sem_Range (_range))) ((sem_Name (_name))))
sem_Type_Application :: (T_Range) ->
                        (Bool) ->
                        (T_Type) ->
                        (T_Types) ->
                        (T_Type)
sem_Type_Application (range_) (prefix_) (function_) (arguments_) =
    \ _lhsIallTypeConstructors
      _lhsImiscerrors
      _lhsIoptions
      _lhsItypeConstructors
      _lhsIwarnings ->
        let _lhsOcontextRange :: (Range)
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Type)
            _lhsOtypevariables :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _functionIcontextRange :: (Range)
            _functionImiscerrors :: ([Error])
            _functionIself :: (Type)
            _functionItypevariables :: (Names)
            _functionIwarnings :: ([Warning])
            _functionOallTypeConstructors :: (Names)
            _functionOmiscerrors :: ([Error])
            _functionOoptions :: ([Option])
            _functionOtypeConstructors :: (M.Map Name Int)
            _functionOwarnings :: ([Warning])
            _argumentsImiscerrors :: ([Error])
            _argumentsIself :: (Types)
            _argumentsItypevariables :: (Names)
            _argumentsIwarnings :: ([Warning])
            _argumentsOallTypeConstructors :: (Names)
            _argumentsOmiscerrors :: ([Error])
            _argumentsOoptions :: ([Option])
            _argumentsOtypeConstructors :: (M.Map Name Int)
            _argumentsOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _functionIcontextRange,_functionImiscerrors,_functionIself,_functionItypevariables,_functionIwarnings) =
                (function_ (_functionOallTypeConstructors) (_functionOmiscerrors) (_functionOoptions) (_functionOtypeConstructors) (_functionOwarnings))
            ( _argumentsImiscerrors,_argumentsIself,_argumentsItypevariables,_argumentsIwarnings) =
                (arguments_ (_argumentsOallTypeConstructors) (_argumentsOmiscerrors) (_argumentsOoptions) (_argumentsOtypeConstructors) (_argumentsOwarnings))
            (_lhsOtypevariables@_) =
                _functionItypevariables  ++  _argumentsItypevariables
            (_self@_) =
                Type_Application _rangeIself prefix_ _functionIself _argumentsIself
            (_lhsOself@_) =
                _self
            (_lhsOcontextRange@_) =
                _functionIcontextRange
            (_lhsOmiscerrors@_) =
                _argumentsImiscerrors
            (_lhsOwarnings@_) =
                _argumentsIwarnings
            (_functionOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_functionOmiscerrors@_) =
                _lhsImiscerrors
            (_functionOoptions@_) =
                _lhsIoptions
            (_functionOtypeConstructors@_) =
                _lhsItypeConstructors
            (_functionOwarnings@_) =
                _lhsIwarnings
            (_argumentsOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_argumentsOmiscerrors@_) =
                _functionImiscerrors
            (_argumentsOoptions@_) =
                _lhsIoptions
            (_argumentsOtypeConstructors@_) =
                _lhsItypeConstructors
            (_argumentsOwarnings@_) =
                _functionIwarnings
        in  ( _lhsOcontextRange,_lhsOmiscerrors,_lhsOself,_lhsOtypevariables,_lhsOwarnings)
sem_Type_Constructor :: (T_Range) ->
                        (T_Name) ->
                        (T_Type)
sem_Type_Constructor (range_) (name_) =
    \ _lhsIallTypeConstructors
      _lhsImiscerrors
      _lhsIoptions
      _lhsItypeConstructors
      _lhsIwarnings ->
        let _lhsOcontextRange :: (Range)
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Type)
            _lhsOtypevariables :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _nameIself :: (Name)
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            (_lhsOcontextRange@_) =
                noRange
            (_lhsOtypevariables@_) =
                []
            (_self@_) =
                Type_Constructor _rangeIself _nameIself
            (_lhsOself@_) =
                _self
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
            (_lhsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcontextRange,_lhsOmiscerrors,_lhsOself,_lhsOtypevariables,_lhsOwarnings)
sem_Type_Exists :: (T_Range) ->
                   (T_Names) ->
                   (T_Type) ->
                   (T_Type)
sem_Type_Exists (range_) (typevariables_) (type_) =
    \ _lhsIallTypeConstructors
      _lhsImiscerrors
      _lhsIoptions
      _lhsItypeConstructors
      _lhsIwarnings ->
        let _lhsOcontextRange :: (Range)
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Type)
            _lhsOtypevariables :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _typevariablesIself :: (Names)
            _typeIcontextRange :: (Range)
            _typeImiscerrors :: ([Error])
            _typeIself :: (Type)
            _typeItypevariables :: (Names)
            _typeIwarnings :: ([Warning])
            _typeOallTypeConstructors :: (Names)
            _typeOmiscerrors :: ([Error])
            _typeOoptions :: ([Option])
            _typeOtypeConstructors :: (M.Map Name Int)
            _typeOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _typevariablesIself) =
                (typevariables_ )
            ( _typeIcontextRange,_typeImiscerrors,_typeIself,_typeItypevariables,_typeIwarnings) =
                (type_ (_typeOallTypeConstructors) (_typeOmiscerrors) (_typeOoptions) (_typeOtypeConstructors) (_typeOwarnings))
            (_lhsOtypevariables@_) =
                _typeItypevariables
            (_self@_) =
                Type_Exists _rangeIself _typevariablesIself _typeIself
            (_lhsOself@_) =
                _self
            (_lhsOcontextRange@_) =
                _typeIcontextRange
            (_lhsOmiscerrors@_) =
                _typeImiscerrors
            (_lhsOwarnings@_) =
                _typeIwarnings
            (_typeOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_typeOmiscerrors@_) =
                _lhsImiscerrors
            (_typeOoptions@_) =
                _lhsIoptions
            (_typeOtypeConstructors@_) =
                _lhsItypeConstructors
            (_typeOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcontextRange,_lhsOmiscerrors,_lhsOself,_lhsOtypevariables,_lhsOwarnings)
sem_Type_Forall :: (T_Range) ->
                   (T_Names) ->
                   (T_Type) ->
                   (T_Type)
sem_Type_Forall (range_) (typevariables_) (type_) =
    \ _lhsIallTypeConstructors
      _lhsImiscerrors
      _lhsIoptions
      _lhsItypeConstructors
      _lhsIwarnings ->
        let _lhsOcontextRange :: (Range)
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Type)
            _lhsOtypevariables :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _typevariablesIself :: (Names)
            _typeIcontextRange :: (Range)
            _typeImiscerrors :: ([Error])
            _typeIself :: (Type)
            _typeItypevariables :: (Names)
            _typeIwarnings :: ([Warning])
            _typeOallTypeConstructors :: (Names)
            _typeOmiscerrors :: ([Error])
            _typeOoptions :: ([Option])
            _typeOtypeConstructors :: (M.Map Name Int)
            _typeOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _typevariablesIself) =
                (typevariables_ )
            ( _typeIcontextRange,_typeImiscerrors,_typeIself,_typeItypevariables,_typeIwarnings) =
                (type_ (_typeOallTypeConstructors) (_typeOmiscerrors) (_typeOoptions) (_typeOtypeConstructors) (_typeOwarnings))
            (_lhsOtypevariables@_) =
                _typeItypevariables
            (_self@_) =
                Type_Forall _rangeIself _typevariablesIself _typeIself
            (_lhsOself@_) =
                _self
            (_lhsOcontextRange@_) =
                _typeIcontextRange
            (_lhsOmiscerrors@_) =
                _typeImiscerrors
            (_lhsOwarnings@_) =
                _typeIwarnings
            (_typeOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_typeOmiscerrors@_) =
                _lhsImiscerrors
            (_typeOoptions@_) =
                _lhsIoptions
            (_typeOtypeConstructors@_) =
                _lhsItypeConstructors
            (_typeOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcontextRange,_lhsOmiscerrors,_lhsOself,_lhsOtypevariables,_lhsOwarnings)
sem_Type_Parenthesized :: (T_Range) ->
                          (T_Type) ->
                          (T_Type)
sem_Type_Parenthesized (range_) (type_) =
    \ _lhsIallTypeConstructors
      _lhsImiscerrors
      _lhsIoptions
      _lhsItypeConstructors
      _lhsIwarnings ->
        let _lhsOcontextRange :: (Range)
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Type)
            _lhsOtypevariables :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _typeIcontextRange :: (Range)
            _typeImiscerrors :: ([Error])
            _typeIself :: (Type)
            _typeItypevariables :: (Names)
            _typeIwarnings :: ([Warning])
            _typeOallTypeConstructors :: (Names)
            _typeOmiscerrors :: ([Error])
            _typeOoptions :: ([Option])
            _typeOtypeConstructors :: (M.Map Name Int)
            _typeOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _typeIcontextRange,_typeImiscerrors,_typeIself,_typeItypevariables,_typeIwarnings) =
                (type_ (_typeOallTypeConstructors) (_typeOmiscerrors) (_typeOoptions) (_typeOtypeConstructors) (_typeOwarnings))
            (_lhsOtypevariables@_) =
                _typeItypevariables
            (_self@_) =
                Type_Parenthesized _rangeIself _typeIself
            (_lhsOself@_) =
                _self
            (_lhsOcontextRange@_) =
                _typeIcontextRange
            (_lhsOmiscerrors@_) =
                _typeImiscerrors
            (_lhsOwarnings@_) =
                _typeIwarnings
            (_typeOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_typeOmiscerrors@_) =
                _lhsImiscerrors
            (_typeOoptions@_) =
                _lhsIoptions
            (_typeOtypeConstructors@_) =
                _lhsItypeConstructors
            (_typeOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOcontextRange,_lhsOmiscerrors,_lhsOself,_lhsOtypevariables,_lhsOwarnings)
sem_Type_Qualified :: (T_Range) ->
                      (T_ContextItems) ->
                      (T_Type) ->
                      (T_Type)
sem_Type_Qualified (range_) (context_) (type_) =
    \ _lhsIallTypeConstructors
      _lhsImiscerrors
      _lhsIoptions
      _lhsItypeConstructors
      _lhsIwarnings ->
        let _lhsOcontextRange :: (Range)
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Type)
            _lhsOtypevariables :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _contextIcontextRanges :: ([Range])
            _contextIcontextVars :: ([Name])
            _contextImiscerrors :: ([Error])
            _contextIself :: (ContextItems)
            _contextIwarnings :: ([Warning])
            _contextOallTypeConstructors :: (Names)
            _contextOmiscerrors :: ([Error])
            _contextOoptions :: ([Option])
            _contextOtypeConstructors :: (M.Map Name Int)
            _contextOwarnings :: ([Warning])
            _typeIcontextRange :: (Range)
            _typeImiscerrors :: ([Error])
            _typeIself :: (Type)
            _typeItypevariables :: (Names)
            _typeIwarnings :: ([Warning])
            _typeOallTypeConstructors :: (Names)
            _typeOmiscerrors :: ([Error])
            _typeOoptions :: ([Option])
            _typeOtypeConstructors :: (M.Map Name Int)
            _typeOwarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _contextIcontextRanges,_contextIcontextVars,_contextImiscerrors,_contextIself,_contextIwarnings) =
                (context_ (_contextOallTypeConstructors) (_contextOmiscerrors) (_contextOoptions) (_contextOtypeConstructors) (_contextOwarnings))
            ( _typeIcontextRange,_typeImiscerrors,_typeIself,_typeItypevariables,_typeIwarnings) =
                (type_ (_typeOallTypeConstructors) (_typeOmiscerrors) (_typeOoptions) (_typeOtypeConstructors) (_typeOwarnings))
            (_lhsOcontextRange@_) =
                if null _contextIcontextRanges
                  then noRange
                  else foldr1 mergeRanges _contextIcontextRanges
            (_lhsOmiscerrors@_) =
                ( if Overloading `elem` _lhsIoptions then
                    [ AmbiguousContext v | v <-  _contextIcontextVars, v `notElem` _typeItypevariables ]
                  else
                    [ OverloadingDisabled range_ ]
                )
                ++
                _typeImiscerrors
            (_lhsOtypevariables@_) =
                _typeItypevariables
            (_self@_) =
                Type_Qualified _rangeIself _contextIself _typeIself
            (_lhsOself@_) =
                _self
            (_lhsOwarnings@_) =
                _typeIwarnings
            (_contextOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_contextOmiscerrors@_) =
                _lhsImiscerrors
            (_contextOoptions@_) =
                _lhsIoptions
            (_contextOtypeConstructors@_) =
                _lhsItypeConstructors
            (_contextOwarnings@_) =
                _lhsIwarnings
            (_typeOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_typeOmiscerrors@_) =
                _contextImiscerrors
            (_typeOoptions@_) =
                _lhsIoptions
            (_typeOtypeConstructors@_) =
                _lhsItypeConstructors
            (_typeOwarnings@_) =
                _contextIwarnings
        in  ( _lhsOcontextRange,_lhsOmiscerrors,_lhsOself,_lhsOtypevariables,_lhsOwarnings)
sem_Type_Variable :: (T_Range) ->
                     (T_Name) ->
                     (T_Type)
sem_Type_Variable (range_) (name_) =
    \ _lhsIallTypeConstructors
      _lhsImiscerrors
      _lhsIoptions
      _lhsItypeConstructors
      _lhsIwarnings ->
        let _lhsOcontextRange :: (Range)
            _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Type)
            _lhsOtypevariables :: (Names)
            _lhsOwarnings :: ([Warning])
            _rangeIself :: (Range)
            _nameIself :: (Name)
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            (_lhsOtypevariables@_) =
                [ _nameIself ]
            (_lhsOwarnings@_) =
                let xs = [ SuspiciousTypeVariable _nameIself tc
                         | length (show _nameIself) > 1
                         , tc <- _lhsIallTypeConstructors
                         , capitalize (show _nameIself) == (show tc)
                         ]
                in xs ++ _lhsIwarnings
            (_lhsOcontextRange@_) =
                noRange
            (_self@_) =
                Type_Variable _rangeIself _nameIself
            (_lhsOself@_) =
                _self
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
        in  ( _lhsOcontextRange,_lhsOmiscerrors,_lhsOself,_lhsOtypevariables,_lhsOwarnings)
-- Types -------------------------------------------------------
-- semantic domain
type T_Types = (Names) ->
               ([Error]) ->
               ([Option]) ->
               (M.Map Name Int) ->
               ([Warning]) ->
               ( ([Error]),(Types),(Names),([Warning]))
-- cata
sem_Types :: (Types) ->
             (T_Types)
sem_Types (list) =
    (Prelude.foldr (sem_Types_Cons) (sem_Types_Nil) ((Prelude.map sem_Type list)))
sem_Types_Cons :: (T_Type) ->
                  (T_Types) ->
                  (T_Types)
sem_Types_Cons (hd_) (tl_) =
    \ _lhsIallTypeConstructors
      _lhsImiscerrors
      _lhsIoptions
      _lhsItypeConstructors
      _lhsIwarnings ->
        let _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Types)
            _lhsOtypevariables :: (Names)
            _lhsOwarnings :: ([Warning])
            _hdIcontextRange :: (Range)
            _hdImiscerrors :: ([Error])
            _hdIself :: (Type)
            _hdItypevariables :: (Names)
            _hdIwarnings :: ([Warning])
            _hdOallTypeConstructors :: (Names)
            _hdOmiscerrors :: ([Error])
            _hdOoptions :: ([Option])
            _hdOtypeConstructors :: (M.Map Name Int)
            _hdOwarnings :: ([Warning])
            _tlImiscerrors :: ([Error])
            _tlIself :: (Types)
            _tlItypevariables :: (Names)
            _tlIwarnings :: ([Warning])
            _tlOallTypeConstructors :: (Names)
            _tlOmiscerrors :: ([Error])
            _tlOoptions :: ([Option])
            _tlOtypeConstructors :: (M.Map Name Int)
            _tlOwarnings :: ([Warning])
            ( _hdIcontextRange,_hdImiscerrors,_hdIself,_hdItypevariables,_hdIwarnings) =
                (hd_ (_hdOallTypeConstructors) (_hdOmiscerrors) (_hdOoptions) (_hdOtypeConstructors) (_hdOwarnings))
            ( _tlImiscerrors,_tlIself,_tlItypevariables,_tlIwarnings) =
                (tl_ (_tlOallTypeConstructors) (_tlOmiscerrors) (_tlOoptions) (_tlOtypeConstructors) (_tlOwarnings))
            (_lhsOtypevariables@_) =
                _hdItypevariables  ++  _tlItypevariables
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsOmiscerrors@_) =
                _tlImiscerrors
            (_lhsOwarnings@_) =
                _tlIwarnings
            (_hdOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_hdOmiscerrors@_) =
                _lhsImiscerrors
            (_hdOoptions@_) =
                _lhsIoptions
            (_hdOtypeConstructors@_) =
                _lhsItypeConstructors
            (_hdOwarnings@_) =
                _lhsIwarnings
            (_tlOallTypeConstructors@_) =
                _lhsIallTypeConstructors
            (_tlOmiscerrors@_) =
                _hdImiscerrors
            (_tlOoptions@_) =
                _lhsIoptions
            (_tlOtypeConstructors@_) =
                _lhsItypeConstructors
            (_tlOwarnings@_) =
                _hdIwarnings
        in  ( _lhsOmiscerrors,_lhsOself,_lhsOtypevariables,_lhsOwarnings)
sem_Types_Nil :: (T_Types)
sem_Types_Nil  =
    \ _lhsIallTypeConstructors
      _lhsImiscerrors
      _lhsIoptions
      _lhsItypeConstructors
      _lhsIwarnings ->
        let _lhsOmiscerrors :: ([Error])
            _lhsOself :: (Types)
            _lhsOtypevariables :: (Names)
            _lhsOwarnings :: ([Warning])
            (_lhsOtypevariables@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsOmiscerrors@_) =
                _lhsImiscerrors
            (_lhsOwarnings@_) =
                _lhsIwarnings
        in  ( _lhsOmiscerrors,_lhsOself,_lhsOtypevariables,_lhsOwarnings)


