/*****************************************************************************/

/*
 *      alsa.c  --  Linux sound I/O.
 *
 *      Copyright (C) 2004 Gnther Montag
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *  This is the Linux realtime sound output driver
 */

/*****************************************************************************/
      
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <asm/byteorder.h>
#include <sys/soundcard.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <stdlib.h> 
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <signal.h>
#include <endian.h>
#include <pthread.h>
#include <syslog.h>
//#include <alsa/asoundlib.h>

#include "fskl1.h"
#include "fskutil.h"
#include "msg.h"
#include "main.h"
#include "alsa.h"

/* --------------------------------------------------------------------- */
/*
 * Sample output
 */
/*
static int samples_remain = 0;
static int samples_count = 0;
static short *samples_ptr = NULL;
*/

/* --------------------------------------------------------------------- */

static int fd_ptt = -1;
static int fd_mixer = -1;

/* --------------------------------------------------------------------- */

#if __BYTE_ORDER == __BIG_ENDIAN
#define AUDIO_FMT AFMT_S16_BE
#else
#define AUDIO_FMT AFMT_S16_LE
#endif

/* --------------------------------------------------------------------- */

void *alsa_fdx_driver(void *name_audio)
{
// dummy
	errstr(SEV_FATAL, 
	    "alsa_fdx_driver: this function is being developed, "
	    "but not yet implemented. "
	    "Please look at the hftermhackers mailinglist!");
	exit (0);
}

/* --------------------------------------------------------------------- */

static void *alsa_nommap_hdx_driver(void *name_audio)
{
// dummy
	errstr(SEV_FATAL, 
	    "alsa_nommap_hdx_driver: this function is being developed, "
	    "but not yet implemented. "
	    "Please look at the hftermhackers mailinglist!");
	return(0);
}

/* --------------------------------------------------------------------- */
