{- This module was generated from data in the Kate syntax
   highlighting file coffeescript.xml, version 1.1, by Max Shawabkeh (max99x@gmail.com) -}

module Text.Highlighting.Kate.Syntax.Coffeescript
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert_indent
import qualified Text.Highlighting.Kate.Syntax.Javascript
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "CofeeScript"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "Cakefile;*.coffee;*.coco"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "CofeeScript" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("CofeeScript",["Normal"])], synStLanguage = "CofeeScript", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "Normal" -> return ()
    "Multiline Regex" -> return ()
    "Class" -> return ()
    "Comment" -> (popContext) >> pEndLine
    "Multiline Comment" -> return ()
    "String" -> return ()
    "Rich String" -> return ()
    "Heredoc" -> return ()
    "Rich Heredoc" -> return ()
    "Embedding" -> return ()
    "Javascript" -> return ()
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_value'5fkeywords = Set.fromList $ words $ "false true yes no on off undefined null NaN Infinity"
list_keywords = Set.fromList $ words $ "return break continue throw for while until loop if else unless switch when then and or in of by is isnt not typeof delete where super try catch finally try catch finally constructor"
list_class'5fkeywords = Set.fromList $ words $ "class extends new instanceof"
list_reserved = Set.fromList $ words $ "case default function var void with const let enum export import native __hasProp __extends __slice __bind __indexOf"
list_globals = Set.fromList $ words $ "Object Number Boolean Array String RegExp Function Date Math eval setInterval clearInterval setTimeout clearTimeout isFinite isNaN parseFloat parseInt escape unescape console encodeURI encodeURIComponent decodeURI decodeURIComponent"
list_browser'5fglobals = Set.fromList $ words $ "window document navigator location history screen alert prompt"
list_nodejs'5fglobals = Set.fromList $ words $ "process GLOBAL require exports"

regex_'28'40'5b'5f'24a'2dzA'2dZ'5d'5b'24'5cw'5d'2b'7c'5cbthis'29'5cb = compileRegex "(@[_$a-zA-Z][$\\w]+|\\bthis)\\b"
regex_'28'5c'28'28'5c'27'5b'5e'27'5d'2a'27'7c'22'5b'5e'22'5d'2a'22'7c'5b'5e'28'29'5d'29'2a'5c'29'29'3f'5cs'2a'28'2d'7c'3d'29'3e = compileRegex "(\\((\\'[^']*'|\"[^\"]*\"|[^()])*\\))?\\s*(-|=)>"
regex_'5b'5f'24a'2dz'5d'5b'24'5cw'5d'2b'5cb = compileRegex "[_$a-z][$\\w]+\\b"
regex_'2f'2f'2f = compileRegex "///"
regex_'2f'28'5b'5e'2f'5c'5c'5cr'5cn'5d'7c'5c'5c'2e'29'2a'2f'5bmig'5d'7b0'2c3'7d = compileRegex "/([^/\\\\\\r\\n]|\\\\.)*/[mig]{0,3}"
regex_'2f'2f'2f'5bmig'5d'7b0'2c3'7d = compileRegex "///[mig]{0,3}"
regex_'5b'40'24'3a'2e'5cw'5c'5b'5c'5d'5d'2b = compileRegex "[@$:.\\w\\[\\]]+"

defaultAttributes = [("Normal",NormalTok),("Multiline Regex",StringTok),("Class",NormalTok),("Comment",CommentTok),("Multiline Comment",CommentTok),("String",StringTok),("Rich String",StringTok),("Heredoc",StringTok),("Rich Heredoc",StringTok),("Embedding",NormalTok),("Javascript",AlertTok)]

parseRules "Normal" =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pFloat >>= withAttribute FloatTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pHlCOct >>= withAttribute BaseNTok))
   <|>
   ((pHlCHex >>= withAttribute BaseNTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_class'5fkeywords >>= withAttribute KeywordTok) >>~ pushContext "Class")
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_value'5fkeywords >>= withAttribute OtherTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_reserved >>= withAttribute AlertTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_globals >>= withAttribute OtherTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_browser'5fglobals >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_nodejs'5fglobals >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'28'40'5b'5f'24a'2dzA'2dZ'5d'5b'24'5cw'5d'2b'7c'5cbthis'29'5cb >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'28'5c'28'28'5c'27'5b'5e'27'5d'2a'27'7c'22'5b'5e'22'5d'2a'22'7c'5b'5e'28'29'5d'29'2a'5c'29'29'3f'5cs'2a'28'2d'7c'3d'29'3e >>= withAttribute FunctionTok))
   <|>
   ((pRegExpr regex_'5b'5f'24a'2dz'5d'5b'24'5cw'5d'2b'5cb >>= withAttribute NormalTok))
   <|>
   ((pString False "'''" >>= withAttribute StringTok) >>~ pushContext "Heredoc")
   <|>
   ((pString False "\"\"\"" >>= withAttribute StringTok) >>~ pushContext "Rich Heredoc")
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext "String")
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "Rich String")
   <|>
   ((pDetectChar False '`' >>= withAttribute AlertTok) >>~ pushContext "Javascript")
   <|>
   ((pString False "###" >>= withAttribute CommentTok) >>~ pushContext "Multiline Comment")
   <|>
   ((pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext "Comment")
   <|>
   ((pRegExpr regex_'2f'2f'2f >>= withAttribute StringTok) >>~ pushContext "Multiline Regex")
   <|>
   ((pRegExpr regex_'2f'28'5b'5e'2f'5c'5c'5cr'5cn'5d'7c'5c'5c'2e'29'2a'2f'5bmig'5d'7b0'2c3'7d >>= withAttribute StringTok))
   <|>
   ((pAnyChar "():!%&+,-/.*<=>?[]|~^;{}" >>= withAttribute KeywordTok)))

parseRules "Multiline Regex" =
  (((pHlCStringChar >>= withAttribute StringTok))
   <|>
   ((pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext "Comment")
   <|>
   ((pRegExpr regex_'2f'2f'2f'5bmig'5d'7b0'2c3'7d >>= withAttribute StringTok) >>~ (popContext)))

parseRules "Class" =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5b'40'24'3a'2e'5cw'5c'5b'5c'5d'5d'2b >>= withAttribute DataTypeTok) >>~ (popContext)))

parseRules "Comment" =
  ((Text.Highlighting.Kate.Syntax.Alert_indent.parseExpression >>= ((withAttribute CommentTok) . snd)))

parseRules "Multiline Comment" =
  (((pString False "###" >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert_indent.parseExpression >>= ((withAttribute CommentTok) . snd))))

parseRules "String" =
  (((pHlCStringChar >>= withAttribute StringTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext)))

parseRules "Rich String" =
  (((pHlCStringChar >>= withAttribute StringTok))
   <|>
   ((pDetect2Chars False '#' '{' >>= withAttribute CharTok) >>~ pushContext "Embedding")
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext)))

parseRules "Heredoc" =
  (((pHlCStringChar >>= withAttribute StringTok))
   <|>
   ((pString False "'''" >>= withAttribute StringTok) >>~ (popContext)))

parseRules "Rich Heredoc" =
  (((pHlCStringChar >>= withAttribute StringTok))
   <|>
   ((pDetect2Chars False '#' '{' >>= withAttribute CharTok) >>~ pushContext "Embedding")
   <|>
   ((pString False "\"\"\"" >>= withAttribute StringTok) >>~ (popContext)))

parseRules "Embedding" =
  ((pDetectChar False '}' >>= withAttribute CharTok) >>~ (popContext))

parseRules "Javascript" =
  (((pDetectChar False '`' >>= withAttribute AlertTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Javascript.parseExpression)))

parseRules "" = parseRules "Normal"

parseRules x = fail $ "Unknown context" ++ x
