{- This module was generated from data in the Kate syntax
   highlighting file eiffel.xml, version 1.02, by Sebastian Vuorinen -}

module Text.Highlighting.Kate.Syntax.Eiffel
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Eiffel"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.e"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Eiffel" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("Eiffel",["Normal"])], synStLanguage = "Eiffel", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "Normal" -> return ()
    "Quoted String" -> (popContext) >> pEndLine
    "Documentation" -> (popContext) >> pEndLine
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_keywords = Set.fromList $ words $ "agent alias all and as assign class convert create creation debug deferred do else elseif end expanded export external feature from frozen if implies indexing infix inherit inspect is like local loop not obsolete old once or prefix pure redefine reference rename rescue retry separate then undefine"
list_predefined'2dentities = Set.fromList $ words $ "Current False Precursor Result True TUPLE"
list_assertions = Set.fromList $ words $ "check ensure require variant invariant"


defaultAttributes = [("Normal",NormalTok),("Quoted String",StringTok),("Documentation",CommentTok)]

parseRules "Normal" =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_predefined'2dentities >>= withAttribute OtherTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_assertions >>= withAttribute OtherTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pFloat >>= withAttribute FloatTok))
   <|>
   ((pHlCChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "Quoted String")
   <|>
   ((pDetect2Chars False '-' '-' >>= withAttribute CommentTok) >>~ pushContext "Documentation"))

parseRules "Quoted String" =
  ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))

parseRules "Documentation" =
  pzero

parseRules "" = parseRules "Normal"

parseRules x = fail $ "Unknown context" ++ x
