{- This module was generated from data in the Kate syntax
   highlighting file javadoc.xml, version 1.04, by Alfredo Luiz Foltran Fialho (alfoltran@ig.com.br) -}

module Text.Highlighting.Kate.Syntax.Javadoc
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Html
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)

-- | Full name of language.
syntaxName :: String
syntaxName = "Javadoc"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = ""

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Javadoc" }
  context <- currentContext <|> (pushContext "Start" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("Javadoc",["Start"])], synStLanguage = "Javadoc", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "Start" -> return ()
    "FindJavadoc" -> return ()
    "JavadocFSar" -> return ()
    "Javadocar" -> return ()
    "JavadocParam" -> (popContext) >> pEndLine
    "InlineTagar" -> return ()
    "LiteralTagar" -> return ()
    "SeeTag" -> (popContext) >> pEndLine
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))


regex_'28'21'7c'5c'3f'29 = compileRegex "(!|\\?)"
regex_'28'5c'2e'5cs'2a'24'29 = compileRegex "(\\.\\s*$)"
regex_'28'5c'2e'5cs'29'28'3f'21'5b'5cda'2dz'5d'29 = compileRegex "(\\.\\s)(?![\\da-z])"
regex_'5c'2a'2a'5cs'2a'28'3f'3d'40'28author'7cdeprecated'7cexception'7cparam'7creturn'7csee'7cserial'7cserialData'7cserialField'7csince'7cthrows'7cversion'29'28'5cs'7c'24'29'29 = compileRegex "\\**\\s*(?=@(author|deprecated|exception|param|return|see|serial|serialData|serialField|since|throws|version)(\\s|$))"
regex_'5c'2a'2b'28'3f'21'2f'29 = compileRegex "\\*+(?!/)"
regex_'5cS'2a'28'3f'3d'5c'2a'2f'29 = compileRegex "\\S*(?=\\*/)"
regex_'5cS'2a'28'5cs'7c'24'29 = compileRegex "\\S*(\\s|$)"

defaultAttributes = [("Start",NormalTok),("FindJavadoc",NormalTok),("JavadocFSar",CommentTok),("Javadocar",CommentTok),("JavadocParam",CommentTok),("InlineTagar",KeywordTok),("LiteralTagar",KeywordTok),("SeeTag",KeywordTok)]

parseRules "Start" =
  ((parseRules "FindJavadoc"))

parseRules "FindJavadoc" =
  (((pString False "/**/" >>= withAttribute CommentTok))
   <|>
   ((pString False "/**" >>= withAttribute CommentTok) >>~ pushContext "JavadocFSar"))

parseRules "JavadocFSar" =
  (((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'28'21'7c'5c'3f'29 >>= withAttribute CommentTok) >>~ pushContext "Javadocar")
   <|>
   ((pRegExpr regex_'28'5c'2e'5cs'2a'24'29 >>= withAttribute CommentTok) >>~ pushContext "Javadocar")
   <|>
   ((pRegExpr regex_'28'5c'2e'5cs'29'28'3f'21'5b'5cda'2dz'5d'29 >>= withAttribute CommentTok) >>~ pushContext "Javadocar")
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'5c'2a'2a'5cs'2a'28'3f'3d'40'28author'7cdeprecated'7cexception'7cparam'7creturn'7csee'7cserial'7cserialData'7cserialField'7csince'7cthrows'7cversion'29'28'5cs'7c'24'29'29 >>= withAttribute CommentTok) >>~ pushContext "Javadocar")
   <|>
   ((pString False "{@code " >>= withAttribute KeywordTok) >>~ pushContext "LiteralTagar")
   <|>
   ((pString False "{@code " >>= withAttribute KeywordTok) >>~ pushContext "LiteralTagar")
   <|>
   ((pString False "{@docRoot}" >>= withAttribute KeywordTok))
   <|>
   ((pString False "{@inheritDoc}" >>= withAttribute KeywordTok))
   <|>
   ((pString False "{@link " >>= withAttribute KeywordTok) >>~ pushContext "InlineTagar")
   <|>
   ((pString False "{@link " >>= withAttribute KeywordTok) >>~ pushContext "InlineTagar")
   <|>
   ((pString False "{@linkplain " >>= withAttribute KeywordTok) >>~ pushContext "InlineTagar")
   <|>
   ((pString False "{@linkplain " >>= withAttribute KeywordTok) >>~ pushContext "InlineTagar")
   <|>
   ((pString False "{@literal " >>= withAttribute KeywordTok) >>~ pushContext "LiteralTagar")
   <|>
   ((pString False "{@literal " >>= withAttribute KeywordTok) >>~ pushContext "LiteralTagar")
   <|>
   ((pString False "{@value}" >>= withAttribute KeywordTok))
   <|>
   ((pString False "{@value " >>= withAttribute KeywordTok) >>~ pushContext "InlineTagar")
   <|>
   ((pString False "{@value " >>= withAttribute KeywordTok) >>~ pushContext "InlineTagar")
   <|>
   ((Text.Highlighting.Kate.Syntax.Html.parseExpression >>= ((withAttribute CommentTok) . snd))))

parseRules "Javadocar" =
  (((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext >> popContext))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'5c'2a'2b'28'3f'21'2f'29 >>= withAttribute CommentTok))
   <|>
   ((pString False "@author " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@deprecated " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@exception " >>= withAttribute KeywordTok) >>~ pushContext "JavadocParam")
   <|>
   ((pString False "@param " >>= withAttribute KeywordTok) >>~ pushContext "JavadocParam")
   <|>
   ((pString False "@return " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@see " >>= withAttribute KeywordTok) >>~ pushContext "SeeTag")
   <|>
   ((pString False "@serial " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@serialData " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@serialField " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@since " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@throws " >>= withAttribute KeywordTok) >>~ pushContext "JavadocParam")
   <|>
   ((pString False "@version " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@author " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@deprecated " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@exception " >>= withAttribute KeywordTok) >>~ pushContext "JavadocParam")
   <|>
   ((pString False "@param " >>= withAttribute KeywordTok) >>~ pushContext "JavadocParam")
   <|>
   ((pString False "@return " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@see " >>= withAttribute KeywordTok) >>~ pushContext "SeeTag")
   <|>
   ((pString False "@serial " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@serialData " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@serialField " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@since " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@throws " >>= withAttribute KeywordTok) >>~ pushContext "JavadocParam")
   <|>
   ((pString False "@version " >>= withAttribute KeywordTok))
   <|>
   ((pString False "{@code " >>= withAttribute KeywordTok) >>~ pushContext "LiteralTagar")
   <|>
   ((pString False "{@code " >>= withAttribute KeywordTok) >>~ pushContext "LiteralTagar")
   <|>
   ((pString False "{@docRoot}" >>= withAttribute KeywordTok))
   <|>
   ((pString False "{@inheritDoc}" >>= withAttribute KeywordTok))
   <|>
   ((pString False "{@link " >>= withAttribute KeywordTok) >>~ pushContext "InlineTagar")
   <|>
   ((pString False "{@link " >>= withAttribute KeywordTok) >>~ pushContext "InlineTagar")
   <|>
   ((pString False "{@linkplain " >>= withAttribute KeywordTok) >>~ pushContext "InlineTagar")
   <|>
   ((pString False "{@linkplain " >>= withAttribute KeywordTok) >>~ pushContext "InlineTagar")
   <|>
   ((pString False "{@literal " >>= withAttribute KeywordTok) >>~ pushContext "LiteralTagar")
   <|>
   ((pString False "{@literal " >>= withAttribute KeywordTok) >>~ pushContext "LiteralTagar")
   <|>
   ((pString False "{@value}" >>= withAttribute KeywordTok))
   <|>
   ((pString False "{@value " >>= withAttribute KeywordTok) >>~ pushContext "InlineTagar")
   <|>
   ((pString False "{@value " >>= withAttribute KeywordTok) >>~ pushContext "InlineTagar")
   <|>
   ((Text.Highlighting.Kate.Syntax.Html.parseExpression >>= ((withAttribute CommentTok) . snd))))

parseRules "JavadocParam" =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'5cS'2a'28'3f'3d'5c'2a'2f'29 >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((pRegExpr regex_'5cS'2a'28'5cs'7c'24'29 >>= withAttribute KeywordTok) >>~ (popContext)))

parseRules "InlineTagar" =
  (((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Html.parseExpression >>= ((withAttribute KeywordTok) . snd))))

parseRules "LiteralTagar" =
  (((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext >> popContext >> popContext)))

parseRules "SeeTag" =
  (((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Html.parseExpression >>= ((withAttribute KeywordTok) . snd))))

parseRules "" = parseRules "Start"

parseRules x = fail $ "Unknown context" ++ x
