{- This module was generated from data in the Kate syntax
   highlighting file pike.xml, version 1.07, by Paul Pogonyshev -}

module Text.Highlighting.Kate.Syntax.Pike
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Pike"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.pike"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Pike" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("Pike",["Normal"])], synStLanguage = "Pike", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "Normal" -> return ()
    "String" -> (popContext) >> pEndLine
    "Line Comment" -> (popContext) >> pEndLine
    "Block Comment" -> return ()
    "Preprocessor" -> (popContext) >> pEndLine
    "Outscoped" -> return ()
    "Outscoped intern" -> return ()
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_keywords = Set.fromList $ words $ "break case class continue default do else for foreach if return switch while"
list_types = Set.fromList $ words $ "array float function int mapping mixed multiset> object program static string void"
list_builtins = Set.fromList $ words $ "catch gauge sscanf typeof"

regex_'60'28'5b'5c'2b'5c'2d'5c'2a'2f'25'7e'26'5c'7c'5e'5d'7c'5b'21'3d'3c'3e'5d'3d'7c'3c'3c'3f'7c'3e'3e'3f'7c'28'5c'5b'5c'5d'7c'2d'3e'29'3d'3f'29 = compileRegex "`([\\+\\-\\*/%~&\\|^]|[!=<>]=|<<?|>>?|(\\[\\]|->)=?)"
regex_0'5bbB'5d'5b01'5d'2b = compileRegex "0[bB][01]+"
regex_'23'5cs'2aif'5cs'2b0 = compileRegex "#\\s*if\\s+0"
regex_'5c'5cd'5b0'2d9'5d'2b = compileRegex "\\\\d[0-9]+"
regex_'28FIXME'7cTODO'7cNOT'28IC'29'3fE'29'3a'3f = compileRegex "(FIXME|TODO|NOT(IC)?E):?"
regex_'23'5cs'2aif = compileRegex "#\\s*if"
regex_'23'5cs'2a'28endif'7celif'7celse'29 = compileRegex "#\\s*(endif|elif|else)"
regex_'23'5cs'2aendif = compileRegex "#\\s*endif"

defaultAttributes = [("Normal",NormalTok),("String",StringTok),("Line Comment",CommentTok),("Block Comment",CommentTok),("Preprocessor",OtherTok),("Outscoped",CommentTok),("Outscoped intern",CommentTok)]

parseRules "Normal" =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute DataTypeTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_builtins >>= withAttribute FunctionTok))
   <|>
   ((pRegExpr regex_'60'28'5b'5c'2b'5c'2d'5c'2a'2f'25'7e'26'5c'7c'5e'5d'7c'5b'21'3d'3c'3e'5d'3d'7c'3c'3c'3f'7c'3e'3e'3f'7c'28'5c'5b'5c'5d'7c'2d'3e'29'3d'3f'29 >>= withAttribute FunctionTok))
   <|>
   ((pFloat >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_0'5bbB'5d'5b01'5d'2b >>= withAttribute BaseNTok))
   <|>
   ((pHlCOct >>= withAttribute BaseNTok))
   <|>
   ((pHlCHex >>= withAttribute BaseNTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pHlCChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "String")
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext "Line Comment")
   <|>
   ((pDetect2Chars False '#' '!' >>= withAttribute CommentTok) >>~ pushContext "Line Comment")
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext "Block Comment")
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif'5cs'2b0 >>= withAttribute OtherTok) >>~ pushContext "Outscoped")
   <|>
   ((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute OtherTok) >>~ pushContext "Preprocessor"))

parseRules "String" =
  (((pRegExpr regex_'5c'5cd'5b0'2d9'5d'2b >>= withAttribute CharTok))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pLineContinue >>= withAttribute StringTok)))

parseRules "Line Comment" =
  ((pRegExpr regex_'28FIXME'7cTODO'7cNOT'28IC'29'3fE'29'3a'3f >>= withAttribute AlertTok))

parseRules "Block Comment" =
  (((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'28FIXME'7cTODO'7cNOT'28IC'29'3fE'29'3a'3f >>= withAttribute AlertTok)))

parseRules "Preprocessor" =
  (((pRangeDetect '"' '"' >>= withAttribute StringTok))
   <|>
   ((pRangeDetect '<' '>' >>= withAttribute StringTok))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext "Line Comment")
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext "Block Comment")
   <|>
   ((pLineContinue >>= withAttribute OtherTok)))

parseRules "Outscoped" =
  (((pRegExpr regex_'28FIXME'7cTODO'7cNOT'28IC'29'3fE'29'3a'3f >>= withAttribute AlertTok))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext "Block Comment")
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif >>= withAttribute CommentTok) >>~ pushContext "Outscoped intern")
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2a'28endif'7celif'7celse'29 >>= withAttribute OtherTok) >>~ (popContext)))

parseRules "Outscoped intern" =
  (((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext "Block Comment")
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif >>= withAttribute CommentTok) >>~ pushContext "Outscoped intern")
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aendif >>= withAttribute CommentTok) >>~ (popContext)))

parseRules "" = parseRules "Normal"

parseRules x = fail $ "Unknown context" ++ x
