{- This module was generated from data in the Kate syntax
   highlighting file xul.xml, version 0.11, by Wilbert Berendsen (wilbert@kde.nl), Anders Lund (anders@alweb.dk), Joseph Wenninger (jowenn@kde.org), Whitehawk Stormchaser (zerokode@gmx.net), Marc Dassonneville (marc.dassonneville@gmail.com) -}

module Text.Highlighting.Kate.Syntax.Xul
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "XUL"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.xul;*.xbl"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "XUL" }
  context <- currentContext <|> (pushContext "Start" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("XUL",["Start"])], synStLanguage = "XUL", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "Start" -> return ()
    "FindXML" -> return ()
    "FindEntityRefs" -> return ()
    "FindPEntityRefs" -> return ()
    "Comment" -> return ()
    "PI" -> return ()
    "Doctype" -> return ()
    "Doctype Internal Subset" -> return ()
    "Doctype Markupdecl" -> return ()
    "Doctype Markupdecl DQ" -> return ()
    "Doctype Markupdecl SQ" -> return ()
    "Element" -> return ()
    "El Content" -> return ()
    "El End" -> return ()
    "Attribute" -> return ()
    "Value" -> return ()
    "Value DQ" -> return ()
    "Value SQ" -> return ()
    "CDATA" -> return ()
    "String" -> (popContext) >> pEndLine
    "String 1" -> (popContext) >> pEndLine
    "JSComment" -> (popContext) >> pEndLine
    "Multi/inline Comment" -> return ()
    "Regular Expression" -> return ()
    "(Internal regex catch)" -> return ()
    "Regular Expression Character Class" -> return ()
    "(regex caret first check)" -> (popContext) >> pEndLine
    "(charclass caret first check)" -> (popContext) >> pEndLine
    "region_marker" -> (popContext) >> pEndLine
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_keywords = Set.fromList $ words $ "if else for in while do continue break with try catch finally switch case new var function return delete true false void throw typeof const default"
list_functions = Set.fromList $ words $ "escape isFinite isNaN Number parseFloat parseInt reload taint unescape untaint write"
list_objects = Set.fromList $ words $ "Anchor Applet Area Array Boolean Button Checkbox Date document window Image FileUpload Form Frame Function Hidden Link MimeType Math Max Min Layer navigator Object Password Plugin Radio RegExp Reset Screen Select String Text Textarea this Window"
list_math = Set.fromList $ words $ "abs acos asin atan atan2 ceil cos ctg E exp floor LN2 LN10 log LOG2E LOG10E PI pow round sin sqrt SQRT1_2 SQRT2 tan"
list_events = Set.fromList $ words $ "onAbort onBlur onChange onClick onError onFocus onLoad onMouseOut onMouseOver onReset onSelect onSubmit onUnload"
list_methods = Set.fromList $ words $ "above action alinkColor alert anchor anchors appCodeName applets apply appName appVersion argument arguments arity availHeight availWidth back background below bgColor border big blink blur bold border call caller charAt charCodeAt checked clearInterval clearTimeout click clip close closed colorDepth complete compile constructor confirm cookie current cursor data defaultChecked defaultSelected defaultStatus defaultValue description disableExternalCapture domain elements embeds enabledPlugin enableExternalCapture encoding eval exec fgColor filename find fixed focus fontcolor fontsize form forms formName forward frames fromCharCode getDate getDay getHours getMiliseconds getMinutes getMonth getSeconds getSelection getTime getTimezoneOffset getUTCDate getUTCDay getUTCFullYear getUTCHours getUTCMilliseconds getUTCMinutes getUTCMonth getUTCSeconds getYear global go hash height history home host hostname href hspace ignoreCase images index indexOf innerHeight innerWidth input italics javaEnabled join language lastIndex lastIndexOf lastModified lastParen layers layerX layerY left leftContext length link linkColor links location locationbar load lowsrc match MAX_VALUE menubar method mimeTypes MIN_VALUE modifiers moveAbove moveBelow moveBy moveTo moveToAbsolute multiline name NaN NEGATIVE_INFINITY negative_infinity next open opener options outerHeight outerWidth pageX pageY pageXoffset pageYoffset parent parse pathname personalbar pixelDepth platform plugins pop port POSITIVE_INFINITY positive_infinity preference previous print prompt protocol prototype push referrer refresh releaseEvents reload replace reset resizeBy resizeTo reverse rightContext screenX screenY scroll scrollbar scrollBy scrollTo search select selected selectedIndex self setDate setHours setMinutes setMonth setSeconds setTime setTimeout setUTCDate setUTCDay setUTCFullYear setUTCHours setUTCMilliseconds setUTCMinutes setUTCMonth setUTCSeconds setYear shift siblingAbove siblingBelow small sort source splice split src status statusbar strike sub submit substr substring suffixes sup taintEnabled target test text title toGMTString toLocaleString toLowerCase toolbar toSource toString top toUpperCase toUTCString type URL unshift unwatch userAgent UTC value valueOf visibility vlinkColor vspace width watch which width write writeln x y zIndex"

regex_'3c'21DOCTYPE'5cs'2b = compileRegex "<!DOCTYPE\\s+"
regex_'3c'5c'3f'5b'5cw'3a'5f'2d'5d'2a = compileRegex "<\\?[\\w:_-]*"
regex_'3c'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex "<[A-Za-z_:][\\w.:_-]*"
regex_'26'28'23'5b0'2d9'5d'2b'7c'23'5bxX'5d'5b0'2d9A'2dFa'2df'5d'2b'7c'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29'3b = compileRegex "&(#[0-9]+|#[xX][0-9A-Fa-f]+|[A-Za-z_:][\\w.:_-]*);"
regex_'25'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'3b = compileRegex "%[A-Za-z_:][\\w.:_-]*;"
regex_'2d'28'2d'28'3f'21'2d'3e'29'29'2b = compileRegex "-(-(?!->))+"
regex_'3c'21'28ELEMENT'7cENTITY'7cATTLIST'7cNOTATION'29'5cb = compileRegex "<!(ELEMENT|ENTITY|ATTLIST|NOTATION)\\b"
regex_'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex "[A-Za-z_:][\\w.:_-]*"
regex_'5cs'2b'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex "\\s+[A-Za-z_:][\\w.:_-]*"
regex_'5cS = compileRegex "\\S"
regex_'3c'2f'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex "</[A-Za-z_:][\\w.:_-]*"
regex_'5b'3d'3f'3a'5d = compileRegex "[=?:]"
regex_'5c'28 = compileRegex "\\("
regex_'2f'5big'5d'7b0'2c2'7d = compileRegex "/[ig]{0,2}"
regex_'5c'7b'5b'5cd'2c_'5d'2b'5c'7d = compileRegex "\\{[\\d, ]+\\}"
regex_'5c'5c'5bbB'5d = compileRegex "\\\\[bB]"
regex_'5c'5c'5bnrtvfDdSsWw'5d = compileRegex "\\\\[nrtvfDdSsWw]"
regex_'5c'5c'2e = compileRegex "\\\\."
regex_'5c'24'28'3f'3d'2f'29 = compileRegex "\\$(?=/)"
regex_'5cs'2a = compileRegex "\\s*"
regex_'2f'2f'28'3f'3d'3b'29 = compileRegex "//(?=;)"
regex_'5c'5c'5b'5c'5b'5c'5d'5d = compileRegex "\\\\[\\[\\]]"

defaultAttributes = [("Start",NormalTok),("FindXML",NormalTok),("FindEntityRefs",NormalTok),("FindPEntityRefs",NormalTok),("Comment",CommentTok),("PI",NormalTok),("Doctype",NormalTok),("Doctype Internal Subset",NormalTok),("Doctype Markupdecl",NormalTok),("Doctype Markupdecl DQ",StringTok),("Doctype Markupdecl SQ",StringTok),("Element",NormalTok),("El Content",NormalTok),("El End",NormalTok),("Attribute",NormalTok),("Value",NormalTok),("Value DQ",StringTok),("Value SQ",StringTok),("CDATA",NormalTok),("String",StringTok),("String 1",CharTok),("JSComment",CommentTok),("Multi/inline Comment",CommentTok),("Regular Expression",OtherTok),("(Internal regex catch)",NormalTok),("Regular Expression Character Class",BaseNTok),("(regex caret first check)",FloatTok),("(charclass caret first check)",FloatTok),("region_marker",RegionMarkerTok)]

parseRules "Start" =
  ((parseRules "FindXML"))

parseRules "FindXML" =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pString False "<!--" >>= withAttribute CommentTok) >>~ pushContext "Comment")
   <|>
   ((pString False "<![CDATA[" >>= withAttribute BaseNTok) >>~ pushContext "CDATA")
   <|>
   ((pRegExpr regex_'3c'21DOCTYPE'5cs'2b >>= withAttribute DataTypeTok) >>~ pushContext "Doctype")
   <|>
   ((pRegExpr regex_'3c'5c'3f'5b'5cw'3a'5f'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext "PI")
   <|>
   ((pRegExpr regex_'3c'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext "Element")
   <|>
   ((parseRules "FindEntityRefs"))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok)))

parseRules "FindEntityRefs" =
  (((pRegExpr regex_'26'28'23'5b0'2d9'5d'2b'7c'23'5bxX'5d'5b0'2d9A'2dFa'2df'5d'2b'7c'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29'3b >>= withAttribute DecValTok))
   <|>
   ((pAnyChar "&<" >>= withAttribute ErrorTok)))

parseRules "FindPEntityRefs" =
  (((pRegExpr regex_'26'28'23'5b0'2d9'5d'2b'7c'23'5bxX'5d'5b0'2d9A'2dFa'2df'5d'2b'7c'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29'3b >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'25'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'3b >>= withAttribute DecValTok))
   <|>
   ((pAnyChar "&%" >>= withAttribute ErrorTok)))

parseRules "Comment" =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pString False "-->" >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'2d'28'2d'28'3f'21'2d'3e'29'29'2b >>= withAttribute ErrorTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok)))

parseRules "PI" =
  ((pDetect2Chars False '?' '>' >>= withAttribute KeywordTok) >>~ (popContext))

parseRules "Doctype" =
  (((pDetectChar False '>' >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((pDetectChar False '[' >>= withAttribute DataTypeTok) >>~ pushContext "Doctype Internal Subset"))

parseRules "Doctype Internal Subset" =
  (((pDetectChar False ']' >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'3c'21'28ELEMENT'7cENTITY'7cATTLIST'7cNOTATION'29'5cb >>= withAttribute DataTypeTok) >>~ pushContext "Doctype Markupdecl")
   <|>
   ((pString False "<!--" >>= withAttribute CommentTok) >>~ pushContext "Comment")
   <|>
   ((pRegExpr regex_'3c'5c'3f'5b'5cw'3a'5f'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext "PI")
   <|>
   ((parseRules "FindPEntityRefs")))

parseRules "Doctype Markupdecl" =
  (((pDetectChar False '>' >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "Doctype Markupdecl DQ")
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext "Doctype Markupdecl SQ"))

parseRules "Doctype Markupdecl DQ" =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((parseRules "FindPEntityRefs")))

parseRules "Doctype Markupdecl SQ" =
  (((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((parseRules "FindPEntityRefs")))

parseRules "Element" =
  (((pDetect2Chars False '/' '>' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ pushContext "El Content")
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute OtherTok) >>~ pushContext "Attribute")
   <|>
   ((pRegExpr regex_'5cs'2b'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute OtherTok) >>~ pushContext "Attribute")
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok)))

parseRules "El Content" =
  (((pRegExpr regex_'3c'2f'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext "El End")
   <|>
   ((parseRules "FindXML")))

parseRules "El End" =
  (((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok)))

parseRules "Attribute" =
  (((pDetectChar False '=' >>= withAttribute OtherTok) >>~ pushContext "Value")
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok)))

parseRules "Value" =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "Value DQ")
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext "Value SQ")
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok)))

parseRules "Value DQ" =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((parseRules "FindEntityRefs")))

parseRules "Value SQ" =
  (((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((parseRules "FindEntityRefs")))

parseRules "CDATA" =
  (((pString False "]]>" >>= withAttribute BaseNTok) >>~ (popContext))
   <|>
   ((pString False "]]&gt;" >>= withAttribute DecValTok))
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pString False "//BEGIN" >>= withAttribute RegionMarkerTok) >>~ pushContext "region_marker")
   <|>
   ((pString False "//END" >>= withAttribute RegionMarkerTok) >>~ pushContext "region_marker")
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_functions >>= withAttribute FunctionTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_objects >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_math >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_events >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_methods >>= withAttribute DataTypeTok))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok))
   <|>
   ((pFloat >>= withAttribute FloatTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "String")
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext "String 1")
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext "JSComment")
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext "Multi/inline Comment")
   <|>
   ((pRegExpr regex_'5b'3d'3f'3a'5d >>= withAttribute NormalTok) >>~ pushContext "(Internal regex catch)")
   <|>
   ((pRegExpr regex_'5c'28 >>= withAttribute NormalTok) >>~ pushContext "(Internal regex catch)")
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok))
   <|>
   ((pAnyChar ":!%&+,-/.*<=>?[]|~^;" >>= withAttribute NormalTok)))

parseRules "String" =
  (((pDetectIdentifier >>= withAttribute StringTok))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext)))

parseRules "String 1" =
  (((pDetectIdentifier >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "String")
   <|>
   ((pDetectChar False '\'' >>= withAttribute CharTok) >>~ (popContext)))

parseRules "JSComment" =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok)))

parseRules "Multi/inline Comment" =
  (((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext)))

parseRules "Regular Expression" =
  (((pRegExpr regex_'2f'5big'5d'7b0'2c2'7d >>= withAttribute OtherTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((pRegExpr regex_'5c'7b'5b'5cd'2c_'5d'2b'5c'7d >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'5c'5c'5bbB'5d >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'5c'5c'5bnrtvfDdSsWw'5d >>= withAttribute BaseNTok))
   <|>
   ((pDetectChar False '[' >>= withAttribute BaseNTok) >>~ pushContext "(charclass caret first check)")
   <|>
   ((pRegExpr regex_'5c'5c'2e >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'5c'24'28'3f'3d'2f'29 >>= withAttribute FloatTok))
   <|>
   ((pAnyChar "?+*()|" >>= withAttribute FloatTok)))

parseRules "(Internal regex catch)" =
  (((pRegExpr regex_'5cs'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'2f'2f'28'3f'3d'3b'29 >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext "JSComment")
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext "Multi/inline Comment")
   <|>
   ((pDetectChar False '/' >>= withAttribute OtherTok) >>~ pushContext "(regex caret first check)")
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules "Regular Expression Character Class" =
  (((pRegExpr regex_'5c'5c'5b'5c'5b'5c'5d'5d >>= withAttribute BaseNTok))
   <|>
   ((pDetectChar False ']' >>= withAttribute BaseNTok) >>~ (popContext >> popContext)))

parseRules "(regex caret first check)" =
  (((pDetectChar False '^' >>= withAttribute FloatTok) >>~ pushContext "Regular Expression")
   <|>
   (pushContext "Regular Expression" >> currentContext >>= parseRules))

parseRules "(charclass caret first check)" =
  (((pDetectChar False '^' >>= withAttribute FloatTok) >>~ pushContext "Regular Expression Character Class")
   <|>
   (pushContext "Regular Expression Character Class" >> currentContext >>= parseRules))

parseRules "region_marker" =
  (((pDetectIdentifier >>= withAttribute RegionMarkerTok))
   <|>
   ((pDetectSpaces >>= withAttribute RegionMarkerTok)))

parseRules "" = parseRules "Start"

parseRules x = fail $ "Unknown context" ++ x
