;;; hnf-yotei.el --- major mode for HyperNikkiSystem yotei file

;; Copyright (C) 1999-2000 by Akihiro Arisawa <ari@nijino.com>

;; Author: Akihiro Arisawa <ari@nijino.com>
;; Version: $Id: hnf-yotei.el,v 3.3 2000/02/12 13:11:48 ari Exp $
;; Keywords: hns nikki yotei

;; This file is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This file is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; ħ
;; HNSNʬͽϤĤΥХåեǹԤޤ(Nϥǥե3)
;;
;; 
;; 1. hnf-mode.el, hnf-yotei.el load-path̤äȤ֤ޤ
;; 2. ~/.emacs ˰ʲεҤ򤷤ޤ
;;    (autoload 'yotei "hnf-yotei" nil t)
;;
;; ڻȤ
;; 1. M-x yotei *yotei*Хåե򳫤ޤ
;; 2. ŬԽޤ
;; 3. C-xC-s¸ޤ
;;
;; ڥХ or ͡
;; 1. hnf-yotei-diary-year-directoryptˤƤ硢¸ߤʤǥ쥯ȥ
;;    ˽񤭹ߤˤäƥ顼ˤʤǽޤ
;;
;; Emacsen
;; ȯemacs-20ǹԤäƤޤ
;; XEmacs-20/21mule-2.3@emacs-19.34ǤưȤϻפޤ
;;
;; ڼռ
;; all.el򤫤ʤ껲ͤˤƤޤԤǤ롢Per Abrahamsen
;; ¿˴դޤ

;;; Code:
(require 'hnf-mode)

(defvar hnf-yotei-range 3)
(defvar hnf-yotei-diary-year-directory-flag hnf-diary-year-directory-flag)

(defvar hnf-yotei-buffer nil)
(defvar hnf-yotei-mode-map nil)
(defvar hnf-yotei-hook nil)

(if hnf-yotei-mode-map nil
  (setq hnf-yotei-mode-map (make-sparse-keymap))
  (define-key hnf-yotei-mode-map "\C-x\C-s" 'hnf-yotei-save))

(defun hnf-yotei (&optional arg)
  "HNSͽ򵭽Ҥ⡼"
  (interactive "P")
  (let* ((this-year (nth 5 (decode-time)))
	 (this-month (nth 4 (decode-time)))
	 (year this-year)
	 (month this-month)
	 (range (cond ((null arg)
		       hnf-yotei-range)
		      ((listp arg)
		       (string-to-number (read-from-minibuffer
					  "ʬԽޤ?: "
					  (number-to-string hnf-yotei-range))))
		      ((integerp arg)
		       arg)))
	 (r 0))
    (if (<= range 0) (setq range hnf-yotei-range))
    
    (switch-to-buffer (setq hnf-yotei-buffer (get-buffer-create "*yotei*")))

    (if (buffer-modified-p) nil
      ; 
      (let ((inhibit-read-only t)) (erase-buffer))
      ; եɹ
      (while (< r range)
	(hnf-yotei-open-and-insert year month)
	(setq month (1+ month))
	(if (= month 13)
	    (setq year (1+ year)
		  month 1))
	(setq r (1+ r)))
      ; ųݤ
      (hnf-yotei-set-insert-behind-hooks)
      (setq buffer-undo-list nil)
      (set-buffer-modified-p nil))
    (use-local-map hnf-yotei-mode-map)
    (setq mode-name "YOTEI")
    (setq major-mode 'hnf-yotei)
    (run-hooks 'hnf-yotei-hook)
    ))

(defalias 'yotei 'hnf-yotei)

(defun hnf-yotei-open-and-insert (year month)
  (let ((file (concat hnf-diary-dir "/"
		      (and hnf-yotei-diary-year-directory-flag
			   (concat (number-to-string year) "/"))
		      (format "y%4d%02d" year month)))
	(beg (point))
	(marker (make-marker))
	overlay)
    ;; ǯɽ
    (insert (format "%4dǯ%02d\n" year month))
    (put-text-property beg (point) 'rear-nonsticky t)
    (put-text-property beg (point) 'face 'highlight)
    (put-text-property beg (point) 'intangible t)
    (put-text-property beg (1- (point)) 'read-only t)
    ;; *yotei*
    (setq beg (point))
    (if (file-exists-p file) (insert-file-contents file) (insert "\n"))
    (goto-char (point-max))
    (overlay-put (setq overlay (make-overlay beg (point))) 'file file)
    ))

(defun hnf-yotei-set-insert-behind-hooks ()
  (let ((overlays (overlays-in (point-min) (point-max)))
	overlay)
    (while (setq overlay (car overlays))
      (overlay-put overlay 'insert-behind-hooks '(hnf-yotei-extent-overlay))
      (setq overlays (cdr overlays)))))

(defun hnf-yotei-extent-overlay (overlay &rest junk)
  "overlay򥫡֤ޤǿФޤ"
  (move-overlay overlay (overlay-start overlay) (point)))

(defun hnf-yotei-save ()
  (interactive)
  (let ((require-final-newline t)
	(overlays (overlays-in (point-min) (point-max)))
	overlay file content)
    (while (setq overlay (car overlays))
      (if (setq file (overlay-get overlay 'file))
	  (write-region (overlay-start overlay) (overlay-end overlay) file))
      (setq overlays (cdr overlays)))
    (set-buffer-modified-p nil)))

(provide 'hnf-yotei)
;;; hnf-yotei.el ends here
