dnl  -*- coding: latin-2 -*-
dnl
dnl  hunglish.m4 - Dual English/Hungarian keyboard layout for Linux consoles.
dnl  
dnl  Author: Lorentey Karoly <lorentey@elte.hu>.
dnl  
dnl  Time-stamp: <2005-10-13 00:21:46 lorentey>
dnl
include(`keymap.m4')dnl
#
# This map lists keycode definitions as they appear on the keyboard.
# It uses the Windows keys for ModeShift and Print Screen for ModeLock.
# The Menu key is Compose.
#
# Source: keytables(5), latin1(7), rfc1345, `dumpkeys -l`, MS DOS User Manual(!)
#
# The following compositions can be used: (duplications are intentional)
#
#	'a 	'A 		'e 	'E 
#	:a 	:A 		:e 	:E 
#	;a 	;A 		;e 	;E 
#	~a 	~A 		~e 	~E 
#	^a 	^A 		,e     ,E 
#	,a 	,A 		
#	
#	'i 	'I 		~t 	~T 
#	^i     ^I 		,t 	,T 
#
#	'o 	'O 		'u 	'U 
#	:o     :O 		:u 	:U 
#	;o 	;O 		;u 	;U 
#	"o 	"O 		"u 	"U 
#	=o 	=O 		=u 	=U 
#	^o 	^O 		ou 	OU 
#	
#	's 	'S 		/l 	/L 
#	~s 	~S 		~l 	~L 
#	,s 	,S 		'l     'L 
#
#	'z 	'Z 		'c 	'C 
#	~z 	~Z 		~c 	~C 
#	.z 	.Z 		,c 	,C 
#
#	'r 	'R 		~d 	~D 
#	~r 	~R 		/d 	/D 
#
#	'n 	'N 		'y 	'Y 
#	~n 	~N 
#
#	ss 	os 	xx 	xo 	ox 
#	"" 	'' 	,, 	;; 	.. 
#	~~ 	oo 	::
#	:- 	-: 	:/ 	/: 	// 


# We want Latin-2 Characters
charset "iso-8859-2"

# Bitmap:
#	1 - Shift
#	2 - altgr 
#	4 - control
#	8 - alt
#      16 - shiftl (used for Mode Shift)
keymaps 0-31

# 0  - No modifiers            16 - ModeShift                  
# 1  - Shift		       17 - ModeShift+Shift            
# 2  - AltGr    	       18 - ModeShift+AltGr            
# 3  - Shift+AltGr	       19 - ModeShift+Shift+AltGr      
# 4  - Control		       20 - ModeShift+Control          
# 5  - Shift+Control	       21 - ModeShift+Shift+Control    
# 6  - Control+AltGr           22 - ModeShift+Control+AltGr
# 7  - Control+AltGr+Shift     23 - ModeShift+Control+AltGr+Shift
# 8  - Alt		       24 - ModeShift+Alt              
# 9  - Shift+Alt	       25 - ModeShift+Shift+Alt        
# 10 - Alt+AltGr               26 - ModeShift+Alt+AltGr
# 11 - Alt+AltGr+Shift         27 - ModeShift+Alt+AltGr+Shift
# 12 - Control+Alt	       28 - ModeShift+Control+Alt      
# 13 - Shift+Control+Alt       29 - ModeShift+Shift+Control+Alt
# 14 - Control+Alt+AltGr       30 - ModeShift+Control+Alt+AltGr
# 15 - Control+Alt+AltGr+Shift 31 - ModeShift+Control+Alt+AltGr+Shift


newsection(`Top row (Esc and function keys).')

simple_key(1, `Escape')
function_key(59,  1, 13, 25, 37)
function_key(60,  2, 14, 26, 38)
function_key(61,  3, 15, 27, 39)
function_key(62,  4, 16, 28, 40)
function_key(63,  5, 17, 29, 41)
function_key(64,  6, 18, 30, 42)
function_key(65,  7, 19, 31, 43)
function_key(66,  8, 20, 32, 44)
function_key(67,  9, 21, 33, 45)
function_key(68, 10, 22, 34, 46)
function_key(87, 11, 23, 35, 47)
function_key(88, 12, 24, 36, 48)

newsection(`First row.')

ifelse(layout, pc102, `complex_key(    41, grave, asciitilde,  zero,        section,     VoidSymbol)',
       layout, pc105, `complex_key(    41, grave, asciitilde,  zero,        section,     VoidSymbol)',
       layout, pc101, `accented_letter(41, grave, asciitilde,  iacute,      Iacute,      less)',
       layout, pc104, `accented_letter(41, grave, asciitilde,  iacute,      Iacute,      less)',
       `errprint(`Invalid layout: "'layout`"
')m4exit')
complex_key(    2,  one,   exclam,      one,         apostrophe,  asciitilde)
complex_key(    3,  two,   at,          two,         quotedbl,    0xb7)
bothdefkey(3, nul, control)
bothdefkey(3, nul, control, shift)
complex_key(    4,  three, numbersign,  three,       plus,        asciicircum)
bothdefkey(4, Escape, control)
bothdefkey(4, Escape, control, shift)
complex_key(    5,  four,  dollar,      four,        exclam,      0xa2)
bothdefkey(5, Control_backslash, control)
bothdefkey(5, Control_backslash, control, shift)
complex_key(    6,  five,  percent,     five,        percent,     degree)
complex_key(    7,  six,   asciicircum, six,         slash,       0xb2)
bothdefkey(7, Control_asciicircum, control)
bothdefkey(7, Control_asciicircum, control, shift)
complex_key(    8,  seven, ampersand,   seven,       equal,       grave)
bothdefkey(8, Control_underscore, control)
bothdefkey(8, Control_underscore, control, shift)
complex_key(    9,  eight, asterisk,    eight,       parenleft,   0xff)
bothdefkey(9, Delete, control)
bothdefkey(9, Delete, control, shift)
# FIXME:                                                          ??????????
complex_key(    10, nine,  parenleft,   nine,        parenright,  apostrophe)
# FIXME:                                                          ??????????
accented_letter(11, zero,  parenright,  odiaeresis,  Odiaeresis,  quotedbl)
accented_letter(12, minus, underscore,  udiaeresis,  Udiaeresis,  diaeresis)
bothdefkey(12, Control_underscore, control)
bothdefkey(12, Control_underscore, control, shift)
accented_letter(13, equal, plus,        oacute,      Oacute,      cedilla)
simple_key(14, Delete)

newsection(`Second row.')

simple_key(15, Tab)
letter(16, q, Q, q, Q, backslash)
defkey(16, Control_backslash, hun, control, altgr)
defkey(16, Meta_Control_backslash, hun, control, alt, altgr)
letter(17, w, W, w, W, bar)
letter(18, e, E, e, E)
letter(19, r, R, r, R)
letter(20, t, T, t, T)
ifelse(qwerty, yes, `letter(21, y, Y, y, Y)', `letter(21, y, Y, z, Z)')
dnl AltGr+U should be the euro symbol.
letter(22, u, U, u, U) 
letter(23, i, I, i, I, Iacute)
letter(24, o, O, o, O)
letter(25, p, P, p, P)
accented_letter(26, bracketleft, braceleft, odoubleacute, Odoubleacute, division)
accented_letter(27, bracketright, braceright, uacute, Uacute, multiply)
defkey(27, Control_bracketright, control)
defkey(27, Control_bracketright, control, shift)
defkey(27, Meta_Control_bracketright, alt, control)
defkey(27, Meta_Control_bracketright, alt, control, shift)
system_key(28, Return, Meta_Control_m)

newsection(`Third row.')

uniform_key(58, Caps_Lock)
letter(30, a, A, a, A)
letter(31, s, S, s, S, nometa, 0xf0)
letter(32, d, D, d, D, nometa, 0xd0)
letter(33, f, F, f, F, bracketleft)
letter(34, g, G, g, G, bracketright)
defkey(34, Control_bracketright, hun, altgr, control)
defkey(34, Meta_Control_bracketright, hun, altgr, alt, control)
letter(35, h, H, h, H)
letter(36, j, J, j, J, iacute)
letter(37, k, K, k, K, nometa, 0xb3)
letter(38, l, L, l, L, nometa, 0xa3)
accented_letter(39, semicolon, colon, eacute, Eacute, dollar)
defkey(39, Meta_dollar, hun, altgr, alt)
accented_letter(40, apostrophe, quotedbl, aacute, Aacute, ssharp)

newsection(`Fourth row.')

uniform_key(42, Shift)
accented_letter(86, less, greater, iacute, Iacute, less)
ifelse(qwerty, yes, `letter(44, z, Z, z, Z, greater)', `letter(44, z, Z, y, Y, greater)')
letter(45, x, X, x, X, numbersign)
letter(46, c, C, c, C, ampersand)
letter(47, v, V, v, V, at)
letter(48, b, B, b, B, braceleft)
letter(49, n, N, n, N, braceright)
letter(50, m, M, m, M)
complex_key(51, comma, less, comma, question, semicolon)
defkey(51, Meta_semicolon, hun, altgr, alt)
defkey(51, Delete, hun, control)
defkey(51, Delete, hun, control, shift)
complex_key(52, period, greater, period, colon, VoidSymbol)
bothdefkey(52, Compose, control)
bothdefkey(52, Compose, control, shift)
complex_key(53, slash, question, minus, underscore, asterisk)
defkey(53, Meta_asterisk, hun, altgr, alt)
defkey(53, Delete, control)
defkey(53, Delete, control, shift)
uniform_key(54, Shift)
accented_letter(43, backslash, bar, udoubleacute, Udoubleacute, 0xa4)
defkey(43, Control_backslash, control)
defkey(43, Control_backslash, control, shift)
defkey(43, Meta_Control_backslash, alt, control)
defkey(43, Meta_Control_backslash, alt, control, shift)

newsection(`Fifth row.')

uniform_key(29, Control)
uniform_key(125, ShiftL)
uniform_key(56, Alt)
simple_key(57, space)
bothdefkey(57, nul, control)
bothdefkey(57, nul, control, shift)
ifelse(altgr_is_modeshift, yes, 
	`uniform_key(100, ShiftL)', 
	`uniform_key(100, AltGr)')
uniform_key(126, ShiftL)
dnl Menu key is compose.
uniform_key(127, Compose)
uniform_key(97, Control)

newsection(`System keys')

# PrtScr is used to switch modes.  Alt-PrtScr(AKA SysReq) is handled
# directly by the kernel.
uniform_key(99, ShiftL_Lock)

uniform_key(70, Scroll_Lock)
# These overrides allow access to some misc. status info:
bothdefkey(70, Show_Memory, shift)
bothdefkey(70, Show_Registers, control)
bothdefkey(70, Show_State, alt)

# Pause/Break is split due to brain-damaged hardware design.
uniform_key(119, Pause)
uniform_key(101, Break)

uniform_key(110, Insert)
uniform_key(102, Home)
uniform_key(104, PageUp)
bothdefkey(104, Scroll_Backward, shift)
uniform_key(111, Remove)
# We keep the familiar reboot combination.
bothdefkey(111, Boot, control, alt)
bothdefkey(111, Boot, control, altgr)
uniform_key(107, End)
system_key(109, PageDown, Scroll_Forward)
bothdefkey(109, Scroll_Forward, shift)
system_key(103, Up, KeyboardSignal)
system_key(105, Left, Decr_Console)
system_key(108, Down, Last_Console)
system_key(106, Right, Incr_Console)

newsection(`Keypad.')

uniform_key(69, Num_Lock)
uniform_key(98, KP_Divide)
uniform_key(55, KP_Multiply)
uniform_key(74, KP_Subtract)
system_key(71, KP_7, Ascii_7)
system_key(72, KP_8, Ascii_8)
system_key(73, KP_9, Ascii_9)
uniform_key(78, KP_Add)
system_key(75, KP_4, Ascii_4)
system_key(76, KP_5, Ascii_5)
system_key(77, KP_6, Ascii_6)
system_key(79, KP_1, Ascii_1)
system_key(80, KP_2, Ascii_2)
system_key(81, KP_3, Ascii_3)
uniform_key(96, KP_Enter)
system_key(82, KP_0, Ascii_0)
uniform_key(83, KP_Period)
bothdefkey(83, Boot, control, alt)
bothdefkey(83, Boot, control, altgr)

newsection(`Miscellaneous keycodes.  These are normally not available.')

              keycode  84 = Last_Console
              keycode  85 =
              keycode  89 =
              keycode  90 =
              keycode  91 =
              keycode  92 =
              keycode  93 =
              keycode  94 =
              keycode  95 =
              keycode 112 = Macro
              keycode 113 = F13
              keycode 114 = F14
              keycode 115 = Help
              keycode 116 = Do
              keycode 117 = F17
              keycode 118 = KP_MinPlus
              keycode 120 =
              keycode 121 =
              keycode 122 =
              keycode 123 =
              keycode 124 =

newsection(`String definitions.')


string Find = "\033[1~"     # = Home
string Insert = "\033[2~"   
string Remove = "\033[3~"   # = Delete key
string Select = "\033[4~"   # = End
string Prior = "\033[5~"    # = Page Up
string Next = "\033[6~"     # = Page Down
string Macro = "\033[M"
string Pause = "\033[P"
	
string F1 = "\033[[A"
string F2 = "\033[[B"
string F3 = "\033[[C"
string F4 = "\033[[D"
string F5 = "\033[[E"
string F6 = "\033[17~"
string F7 = "\033[18~"
string F8 = "\033[19~"
string F9 = "\033[20~"
string F10 = "\033[21~"
string F11 = "\033[23~"
string F12 = "\033[24~"
string F13 = "\033[25~"
string F14 = "\033[26~"
string F15 = "\033[28~"
string F16 = "\033[29~"
string F17 = "\033[31~"
string F18 = "\033[32~"
string F19 = "\033[33~"
string F20 = "\033[34~"

newsection(`Compositions.')

compose ',' 'A' to ''
compose '/' 'L' to ''
compose 'x' 'o' to ''
compose 'o' 'x' to ''
compose '~' 'L' to ''
compose '\'' 'S' to ''
compose '|' 'S' to ''
compose ':' ':' to ''
compose '~' 'S' to ''
compose ',' 'S' to ''
compose '~' 'T' to ''
compose '\'' 'Z' to ''
compose '~' 'Z' to ''
compose '.' 'Z' to ''
compose 'o' 'o' to ''
compose ',' 'a' to ''
compose ';' ';' to ''
compose '/' 'l' to ''
compose '\'' '\'' to ''
compose '~' 'l' to ''
compose '\'' 's' to ''
compose '~' '~' to ''
compose ',' ',' to ''
compose '~' 's' to ''
compose ',' 's' to ''
compose '~' 't' to ''
compose '\'' 'z' to ''
compose '"' '"' to ''
compose '~' 'z' to ''
compose '.' 'z' to ''
compose '\'' 'R' to ''
compose '\'' 'A' to ''
compose '^' 'A' to ''
compose '~' 'A' to ''
compose ':' 'A' to ''
compose ';' 'A' to ''
compose '\'' 'L' to ''
compose '\'' 'C' to ''
compose ',' 'C' to ''
compose '~' 'C' to ''
compose '\'' 'E' to ''
compose ',' 'E' to ''
compose ':' 'E' to ''
compose ';' 'E' to ''
compose '~' 'E' to ''
compose '\'' 'I' to ''
compose '^' 'I' to ''
compose '~' 'D' to ''
compose '/' 'D' to ''
compose '\'' 'N' to ''
compose '~' 'N' to ''
compose '\'' 'O' to ''
compose '^' 'O' to ''
compose '"' 'O' to ''
compose '=' 'O' to ''
compose ':' 'O' to ''
compose ';' 'O' to ''
compose 'x' 'x' to ''
compose '~' 'R' to ''
compose 'O' 'U' to ''
compose '\'' 'U' to ''
compose '"' 'U' to ''
compose '=' 'U' to ''
compose ':' 'U' to ''
compose ';' 'U' to ''
compose '\'' 'Y' to ''
compose ',' 'T' to ''
compose 's' 's' to ''
compose '\'' 'r' to ''
compose '\'' 'a' to ''
compose '^' 'a' to ''
compose '~' 'a' to ''
compose ':' 'a' to ''
compose ';' 'a' to ''
compose '\'' 'l' to ''
compose '\'' 'c' to ''
compose ',' 'c' to ''
compose '~' 'c' to ''
compose '\'' 'e' to ''
compose ',' 'e' to ''
compose ':' 'e' to ''
compose ';' 'e' to ''
compose '~' 'e' to ''
compose '\'' 'i' to ''
compose '^' 'i' to ''
compose '~' 'd' to ''
compose '/' 'd' to ''
compose '\'' 'n' to ''
compose '~' 'n' to ''
compose '\'' 'o' to ''
compose '^' 'o' to ''
compose '"' 'o' to ''
compose '=' 'o' to ''
compose ':' 'o' to ''
compose ';' 'o' to ''
compose '/' '/' to ''
compose '/' ':' to ''
compose ':' '/' to ''
compose '-' ':' to ''
compose ':' '-' to ''
compose '~' 'r' to ''
compose 'o' 'u' to ''
compose '\'' 'u' to ''
compose '"' 'u' to ''
compose '=' 'u' to ''
compose ':' 'u' to ''
compose ';' 'u' to ''
compose '\'' 'y' to ''
compose ',' 't' to ''
compose '.' '.' to ''

dnl Local Variables:
dnl mode: m4
dnl End:
