#ifndef _AUTO_ARRAY_H
#define _AUTO_ARRAY_H 1

#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define auto_array(_str, _name, _siz) \
	char _name[_siz + 1]; memcpy(_name, _str, _siz); _name[_siz] = 0;
#define auto_free(_str)
#else
#define auto_array(_str, _name, _siz) \
	char *_name = xmalloc(_siz + 1); memcpy(_name, _str, _siz); _name[_siz] = 0;
#define auto_free(_str) xfree(_str);
#endif

#endif /* !_AUTO_ARRAY_H */
