#include "hx_types.h"
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <netdb.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include "hx.h"
#include "screen.h"
#include "hxlib.h"

struct sockaddr_in hx_sockaddr;

#ifdef NEED_HSTRERROR
#define hstrerror(x) "hstrerror"
#endif

#if defined(__BEOS__)
#define close(s) closesocket(s)
#endif

#ifndef HAVE_INET_ATON
extern int inet_aton (const char *, struct in_addr *ia);
#endif

int cmd_close (void);

int
cmd_close (void)
{
	hx_conn_close();

	return 0;
}

int str_to_inaddr (const char *str, struct in_addr *iap);

int
str_to_inaddr (const char *str, struct in_addr *iap)
{
	if (!inet_aton(str, iap)) {
		struct hostent *he;

		if ((he = gethostbyname(str))) {
			if ((unsigned)he->h_length > sizeof *iap)
				he->h_length = sizeof *iap;
			if (he->h_addr_list[1]) {
				int i;
				struct in_addr ia;

				curscr_printf("\n%s has multiple addresses:", str);
				for (i = 0; he->h_addr_list[i]; i++) {
					memcpy(&ia, he->h_addr_list[i], he->h_length);
					curscr_printf("\n[%d] %s", i, inet_ntoa(ia));
				}
			}
			memcpy(iap, he->h_addr, he->h_length);
		} else {
			curscr_printf("\nDNS lookup for %s failed: %s", str, hstrerror(h_errno));
			return -1;
		}
	}

	return 0;
}

void
hx_conn_close (void)
{
	if (hx_sock >= 0) {
		close(hx_sock);
		hx_sock = -1;
		curscr_printf("\n <\xa5> connection closed");
	}
	user_kill(&user_list);
	privchat_kill();
	news_kill();
	hx_reset();
	hx_trans = 1;
	curscr->draw(curscr);
}

int
hx_conn_open (const char *node, u_int16_t port)
{
	int s;
	struct sockaddr_in addr;
	u_int8_t buf[HTLS_MAGIC_LEN];

	addr.sin_family = AF_INET;
	addr.sin_port = htons(port);

	if (str_to_inaddr(node, &(addr.sin_addr)))
		return -1;

	curscr_printf(strcmp(node, inet_ntoa(addr.sin_addr)) ?
			"\ntrying port %u of %s (%s)..." :
			"\ntrying port %u of %s...", port, node, inet_ntoa(addr.sin_addr));

	if ((s = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
		return -1;

	if (connect(s, (struct sockaddr *)&addr, sizeof addr) < 0) {
		curscr_printf("\n <\xa5> connect failed: %s", strerror(errno));
		goto ret;
	}

	curscr_printf("\nconnected to %s:%u", inet_ntoa(addr.sin_addr), port);

	if (send(s, HTLC_MAGIC, HTLC_MAGIC_LEN, 0) != HTLC_MAGIC_LEN) {
		curscr_printf("\n <\xa5> send(%d, HTLC_MAGIC, %d, 0) failed: %s",
				s, HTLC_MAGIC_LEN, strerror(errno));
		goto ret;
	}

	if (recv(s, buf, HTLS_MAGIC_LEN, 0) != HTLS_MAGIC_LEN) {
		curscr_printf("\n <\xa5> recv(%d, HTLS_MAGIC, %d, 0) failed: %s",
				s, HTLS_MAGIC_LEN, strerror(errno));
		goto ret;
	}

	if (memcmp(buf, HTLS_MAGIC, HTLS_MAGIC_LEN))
		curscr_printf("\n <\xa5> warning: bad HTLS_MAGIC: %2x%2x%2x%2x%2x%2x%2x%2x",
				buf[0], buf[1], buf[2], buf[3], buf[4], buf[5], buf[6], buf[7]);
	memcpy(&hx_sockaddr, &addr, sizeof hx_sockaddr);
	curscr->draw(curscr);
	return (hx_sock = s);
ret:
	memset(&hx_sockaddr, 0, sizeof hx_sockaddr);
	close(s);
	return -1;
}

