#include "hx_types.h"
#include <ctype.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <unistd.h>
#include <signal.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "hx.h"
#include "hxlib.h"
#include "screen.h"

extern int CO;

int cmd_tracker (int argc, char *const *argv);

extern int str_to_inaddr (const char *, struct in_addr *);

static int
b_read (int fd, void *bufp, size_t len)
{
	register u_int8_t *buf = (u_int8_t *)bufp;
	register int r, pos = 0;

	while (len) {
		if ((r = recv(fd, &(buf[pos]), len, 0)) <= 0)
			return -1;
		pos += r;
		len -= r;
	}

	return pos;
}

static int tracker_break;

#ifndef RETSIGTYPE
#define RETSIGTYPE void
#endif

RETSIGTYPE sigint (void);

RETSIGTYPE
sigint (void)
{
	tracker_break = 1;
}

#ifdef __BEOS__
#define close(s) closesocket(s)
#endif

int
cmd_tracker (int argc, char *const *argv)
{
	struct sockaddr_in addr;
	u_int16_t port, nusers, nservers;
	char buf[16], name[512], desc[512], outbuf[1024];
	struct in_addr a;
	register int i, x, j, c, pos, s = 0;
	struct sigaction act;

	if (argc < 2) {
		curscr_printf("\nusage: %s <server> [port]", argv[0]);
		return 1;
	}

	memset(&act, 0, sizeof act);
	act.sa_handler = (RETSIGTYPE(*)(int))sigint;
	sigaction(SIGINT, &act, 0);

	for (i = 1; i < argc; i++) {
		if (s)
			close(s);
		if (str_to_inaddr(argv[i], &(addr.sin_addr)))
			continue;
		if (argv[i + 1] && isdigit(argv[i + 1][0]))
			port = atou32(argv[++i]);
		else
			port = HTRK_TCPPORT;

		if ((s = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
			continue;

		addr.sin_family = AF_INET;
		addr.sin_port = htons(port);

		if (connect(s, (struct sockaddr *)&addr, 16) < 0)
			continue;

		if (send(s, HTRK_MAGIC, HTRK_MAGIC_LEN, 0) != HTRK_MAGIC_LEN)
			continue;
		if (b_read(s, buf, 14) != 14)
			continue;
		curscr_printf("\n %u servers:", (nservers = ntohs(*((u_int16_t *)(&(buf[10]))))));
		tracker_break = 0;
		for (; nservers && !tracker_break; nservers--) {
			if (b_read(s, buf, 11) == -1)
				break;
			a.s_addr = *((u_int32_t *)buf);
			port = ntohs(*((u_int16_t *)(&(buf[4]))));
			nusers = ntohs(*((u_int16_t *)(&(buf[6]))));
			if (b_read(s, name, (size_t)buf[10]) == -1)
				break;
			name[(size_t)buf[10]] = 0;
			CR2LF(name, (size_t)buf[10]);
			if (b_read(s, buf, 1) == -1)
				break;
			memset(desc, 0, sizeof desc);
			if (b_read(s, desc, (size_t)buf[0]) == -1)
				break;
			desc[(size_t)buf[0]] = 0;
			CR2LF(desc, (size_t)buf[0]);
			pos = sprintf(outbuf, "\n%16s:%-5u | %5u | %s",
				inet_ntoa(a), port, nusers, name);
			for (j = x = 0;;) {
				j += CO - 33;
				c = desc[j];
				desc[j] = 0;
				pos += sprintf(&(outbuf[pos]),
					"\n                                 %s", &(desc[x]));
				if (!c)
					break;
				desc[j] = c;
				x = j;
			}
			curscr_puts(outbuf, pos);
		}
	}
	if (s)
		close(s);

	return 0;
}
