/*
 Czech (and other CP 1250 languages) library
 Convert Palm  <-> Unix:
 Palm : CP 1250
 Unix : ISO-8859-2
*/

#include "config.h"
#include <stdio.h>
#include "cp1250.h"

const unsigned char w2l[128] = {
   0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0xa9, 0x8b,
   0xa6, 0xab, 0xae, 0xac, 0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
   0x98, 0x99, 0xb9, 0x9b, 0xb6, 0xbb, 0xbe, 0xbc, 0xa0, 0xb7, 0xa2, 0xa3,
   0xa4, 0xa1, 0x8c, 0xa7, 0xa8, 0x8a, 0xaa, 0x8d, 0x8f, 0xad, 0x8e, 0xaf,
   0xb0, 0x9a, 0xb2, 0xb3, 0xb4, 0x9e, 0x9c, 0x9f, 0xb8, 0xb1, 0xba, 0x9d,
   0xa5, 0xbd, 0xb5, 0xbf, 0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
   0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf, 0xd0, 0xd1, 0xd2, 0xd3,
   0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
   0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb,
   0xec, 0xed, 0xee, 0xef, 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
   0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff
};

const unsigned char l2w[128] = {
   0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0xa9, 0x8b,
   0xa6, 0xab, 0xae, 0xac, 0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
   0x98, 0x99, 0xb1, 0x9b, 0xb6, 0xbb, 0xb5, 0xb7, 0xa0, 0xa5, 0xa2, 0xa3,
   0xa4, 0xbc, 0x8c, 0xa7, 0xa8, 0x8a, 0xaa, 0x8d, 0x8f, 0xad, 0x8e, 0xaf,
   0xb0, 0xb9, 0xb2, 0xb3, 0xb4, 0xbe, 0x9c, 0xa1, 0xb8, 0x9a, 0xba, 0x9d,
   0x9f, 0xbd, 0x9e, 0xbf, 0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
   0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf, 0xd0, 0xd1, 0xd2, 0xd3,
   0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
   0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb,
   0xec, 0xed, 0xee, 0xef, 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
   0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff
};

#define isCZ(c) ((c) & 0x80)

void Win2Lat(unsigned char *const buf, int buf_len)
{
   unsigned char *p;
   int i;

   if (buf == NULL) return;
   
   for (i=0, p = buf; *p && i < buf_len; p++, i++) {
      if (isCZ(*p)) {
	 *p = w2l[(*p) & 0x7f]; 
      } 
   }
}


void Lat2Win(unsigned char *const buf, int buf_len)
{
   unsigned char *p;
   int i;
   
   if (buf == NULL) return;
   
   for (i=0, p = buf; *p && i < buf_len; p++, i++) {
      if (isCZ(*p)) {
	 *p = l2w[(*p) & 0x7f];
      }
   }
}
