(**

**)

MODULE VO:DrawTest;

(*
    Implements a simple led with two states: on and off.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT D := VO:Base:Display,
       O := VO:Base:Object,

       G := VO:Object;

TYPE
  Prefs*        = POINTER TO PrefsDesc;

  (**
    In this class all preferences stuff of the button is stored.
  **)

  PrefsDesc*    = RECORD (G.PrefsDesc)
                  END;

  DrawTest*     = POINTER TO DrawTestDesc;
  DrawTestDesc* = RECORD (G.ImageDesc)
                  END;

VAR
  prefs : Prefs;

  PROCEDURE (d : DrawTest) Init*;

  BEGIN
    d.Init^;
  END Init;

  PROCEDURE (d : DrawTest) CalcSize*;

  BEGIN
    d.width:=120;
    d.height:=120;

    d.minWidth:=d.width;
    d.minHeight:=d.height;

    d.CalcSize^;
  END CalcSize;

  PROCEDURE (d : DrawTest) Draw*(x,y,w,h : LONGINT);

  VAR
    draw : D.DrawInfo;

  BEGIN
    d.Draw^(x,y,w,h);

    draw:=d.GetDrawInfo();

    (* Lines *)
    d.DrawBackground(d.x,d.y,d.width,d.height);

    draw.PushForeground(D.whiteColor);
    draw.DrawLine(d.x+5,d.y,d.x+d.width-5-1,d.y);
    draw.DrawLine(d.x+d.width-5-1,d.y+1,d.x+5,d.y+1);
    draw.DrawLine(d.x,d.y+5,d.x,d.y+d.height-5-1);
    draw.DrawLine(d.x+1,d.y+d.height-5-1,d.x+1,d.y+5);
    draw.PopForeground;

    draw.PushForeground(D.blackColor);
    draw.DrawPoint(d.x+5,d.y+2);
    draw.DrawPoint(d.x+d.width-5-1,d.y+2);
    draw.DrawPoint(d.x+2,d.y+5);
    draw.DrawPoint(d.x+2,d.y+d.height-5-1);
    draw.PopForeground;

    (* Rectangle *)
    draw.PushForeground(D.whiteColor);
    draw.FillRectangle(d.x+10,d.y+10,100,100);
    draw.PopForeground;

    draw.PushForeground(D.blackColor);
    draw.DrawPoint(d.x+9,d.y+9);
    draw.DrawPoint(d.x+110,d.y+9);
    draw.DrawPoint(d.x+9,d.y+110);
    draw.DrawPoint(d.x+110,d.y+110);
    draw.PopForeground;

    (* Arc *)
    draw.PushForeground(D.blackColor);
    draw.FillArc(d.x+10,d.y+10,100,100,0,360*64);
    draw.PopForeground;

    (* Filled rectangle *)
    draw.PushPattern(D.disablePattern,D.disableWidth,D.disableHeight,D.fgPattern);
    draw.PushForeground(D.backgroundColor);
    draw.PushBackground(D.blackColor);
    draw.FillRectangle(d.x+35,d.y+35,50,50);
    draw.PopBackground;
    draw.PopForeground;
    draw.PopPattern;

    draw.PushForeground(D.whiteColor);
    draw.DrawPoint(d.x+34,d.y+34);
    draw.DrawPoint(d.x+85,d.y+34);
    draw.DrawPoint(d.x+34,d.y+85);
    draw.DrawPoint(d.x+85,d.y+85);
    draw.PopForeground;

    (* Circle *)
    draw.PushForeground(D.whiteColor);
    draw.DrawArc(d.x+35,d.y+35,50,50,0,360*64);
    draw.PopForeground;
  END Draw;

BEGIN
  NEW(prefs);
  prefs.Init;
END VO:DrawTest.