#!/usr/bin/pike7

constant cvs_version="$Id: server.pike,v 1.2 2001/12/11 19:56:41 pit Exp $";

import Thread;
inherit Stdio.Port;
inherit "xmlrpc.pmod";

#define PORT 1905
#define THREADS 5

string test_s(string s) {
	return(s+" ok!\n");
}

mapping(string:function) methods=
([
	"test_s":test_s,
]);


class worker {
	inherit Stdio.FILE : socket;
	inherit Stdio.File : file;

	void create(function accept) {
		string cmd, path, tmp, data, fcall, xmlResult;
		function call;
		mapping rpc;
		mixed args, callResult;

		while(1) {
			// accept connection
			object o=accept();
			if(!o) continue;
			socket::assign(o);
			destruct(o);

			// read request
			sscanf(socket::read(199999,1),"%s %s %s",cmd, path, data);
			array raw_data=data/"\r\n";
			object xml_rpc=xmlRPC();

			if(stringp(raw_data[5]) && sizeof(raw_data[5]) && cmd=="PUT") {
				rpc = xml_rpc->parse(raw_data[5]);
				call=methods[rpc["methodName"]];
				if (functionp(call)) {
					callResult = call(@rpc["params"]);
					if ( callResult != 0 )
						xmlResult = xml_rpc->compose_response(callResult);
				} else xmlResult=xml_rpc->compose_fault();
			} else xmlResult=xml_rpc->compose_fault();
	
			// send answer	
			socket::write(sprintf(
				"HTTP/1.0 200 OK\r\n"+
				"Date: Tue, 01 Dec 2000 00:00:00 GMT\r\n"+
				"Content-Length: %d\r\n"+
				"Server: xmlrpc/0.1\r\n"+
				"Accept-Ranges: bytes\r\n"+
				"Content-Type: text/xml\r\n\r\n%s",
				sizeof(xmlResult), xmlResult));
	
			destruct(xml_rpc);
			socket::close();
		}
	}
};

int main(int argc, array(string) argv) {
	werror("Starting xmlrpc server\n");
	if(!bind(PORT)) {
		werror("Failed to open socket (already bound?)\n");
		return 17;
	}
	for(int e=1;e<THREADS;e++) thread_create(worker,accept);
		worker(accept);
}

// vi: set ts=3:
