#ifndef PAD_H
#define PAD_H


#include "synshm.h"
#include "synaptics.h"

namespace Synaptics
{
    class Pad
    {
    public:
        ~Pad();

        // is pad hardware present?
        // receive: whether a touch pad is present
        // TODO implement me (I don't know if it's even possible!)
        static bool hasHardware();

        // is a driver present?
        // receive: whether a usable driver has been detected
        static bool hasDriver();

        // is shared memory accessible?
        // receive: whether shared memory access is possible
        static bool hasShm();

        // returns kind of detected driver
        // receive: kind of detected driver
        static DriverVersion driverKind();

        // returns version number string of detected driver
        // receive: version number string of detected driver
        static std::string driverStr();

        // returns version number string of used library
        static std::string libraryStr();

        // returns version number ( 10000 * major + 100 * minor + 1 * rev )
        // receive: version number ( 10000 * major + 100 * minor + 1 * rev )
        static int driverVersion();

        // returns pad type
        // receive: pad type
        // TODO implement me ( I don't know if it's even possible!)
        static PadType getPadType();

        // returns whether a given parameter is available
        // give: parameter name
        // receive: whether the parameter is available
        static bool hasParam( std::string );

        // returns a given parameter, if the parameter is not available returns 0
        // give: name of parameter
        // receive: given parameter value, if it doesn't exist 0
        static double getParam( std::string );

        // sets a given parameter if available
        // give: a parameter's name and the correspondent value
        static void setParam( std::string, double ); 

        // gets max value of a parameter
        // give: name of parameter
        // receive: max value
        static double getParamMax( std::string );

        // gets min value of a parameter
        // give: name of parameter
        // receive: min value
        static double getParamMin( std::string );

        // gets type of a parameter
        // give: name of parameter
        // receive: type of parameter - PT_VOID if no parameter at all!
        static Synaptics::ParamType getParamType( std::string );

        // returns a string list containing all available parameters
        // receive: string list containing all available parameters
        static std::list<std::string> getAvailableParams();

        //
        // the following procedures are only neccessary for old versions
        //


        // is the system capable of running synclient?
        // receive: whether synclient is runnable
        // TODO: implement me
        static bool hasSynClient();

        // is the system capable of running syndaemon?
        // receive: whether syndaemon is runnable
        // TODO implement me
        static bool hasSynDaemon();

        // is syndaemon being run?
        // receive: whether syndaemon is being run
        // TODO implement me
        static bool isSynDaemonRunning();
        static bool killSynDaemonProcesses();

    protected:
        Pad();

        static Synaptics::Pad *mSelf;

        // this is a workaround for the missing constructor functionality in static classes
        static void INIT();

        // this is a workaround for the missing destructor functionality in static classes
        static void CLOSE();

        //   NOTE to make this class abstract
        //   NOTE must be implemented in "Pad"-class
        virtual void registerParameters();

        // detect driver version by reading "version" member from the SHM
        // receive: whether a driver could be detected
        static bool detectDriverVersion();

        // create a version string from an integer value
        // give: version (integer value)
        // receive: version string, if no driver is present it returns "None"
        static std::string intVerToStrVer( int );


        // whether shm access is possible
        static bool mHasShm;

        // store type of detected driver version
        static DriverVersion mDetectedDriver;


        static ::SynShm* mSynShm;

        typedef std::map<std::string, Synaptics::Param> Parameter;

        static std::map<std::string, Parameter> mSupportedDriver;
        static std::list<std::string> mSupportedDriverList;

    private:
    };
}

#endif
