/*
Magpie - reference librarian for Debian systems
Copyright (C) 2000  Bear Giles <bgiles@coyotesong.com>

This program is free software; you may redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the license, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

static const char rcsid[] = "$Id$";

/*****
This program generates a listing of the conffiles.
*****/
#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/wait.h>
#include "magpie.h"

#define	OUTPUT_FILE	"conffile.html"

extern FILE * md5sum (const char *);


/*+
+*/
static int conffiles_init (void)
{
	int i, j;
	FILE *fp, *fp1, *fp5;
	struct package_info *p;
	char pathname[256];
	char tmpname[256];
	char buffer[256];
	char *s1, *s2;

#	define MAX_VALUES	200
	int histogram[MAX_VALUES];

	memset (histogram, 0, sizeof histogram);

	/*
	 * Create a temporary file containing the conffile information.
	 */
	sprintf (tmpname, "/tmp/magic-XXXXXX");
	mkstemp (tmpname);
	fp = fopen (tmpname, "w");
	for (j = 0; j < cachecnt; j++) {
		p = cache[j];
		if (p->cfcnt == 0)
			continue;

		if (p->cfcnt < MAX_VALUES)
			histogram[p->cfcnt]++;

		for (i = 0; i < p->cfcnt; i++) {
			strcpy (buffer, p->conffiles[i]);
			s1 = strchr (buffer, ' ');
			assert (s1);
			*s1++ = '\0';
			fprintf (fp, "%s:%s:%s\n", buffer, s1, p->name);
		}
	}
	fclose (fp);

	/*
	 * Sort the previous file and read it.
	 */
	sprintf (pathname, "/usr/bin/sort %s", tmpname);
	fp1 = popen (pathname, "r");

	sprintf (pathname, "./%s", "md5sums.txt");
	fp5 = fopen (pathname, "w");

	sprintf (pathname, "./%s", "conffile.html");
	fp = fopen (pathname, "w");
	mp_doc_open (fp, "Indexed by Conffile (installed packages)");

	mp_abstract (fp, "\
This page lists all declared configuration files in installed\n\
packages.  It is not an exhaustive list of all configuration files\n\
in the system.");

	mp_title (fp, 2, "Installed Packages, List of Conffiles");

	mp_list_open (fp);
	while (fgets (buffer, sizeof buffer, fp1) != NULL) {
		/* buffer = conffile */
		/* s1 = MD5 checksum */
		/* s2 = package name */
		s1 = strchr (buffer, ':');
		assert (s1);
		*s1++ = '\0';
		s2 = strchr (s1, ':');
		assert (s2);
		*s2++ = '\0';
		mp_item_open (fp);
		mp_tt (fp, buffer);
		mp_nbsp (fp);
		mp_url (fp, "details/%1$1.1s/%1$s.html.gz", "(%1$s)", s2);
	/*	mp_tt (fp, s1);	*/
		mp_item_close (fp);
		if (strcmp (s1, "newconffile") == 0)
			continue;
		fprintf (fp5, "%2$s  %1$s\n", buffer, s1, s2);
	}
	mp_list_close (fp);
	fclose (fp5);
	fclose (fp1);

	mp_break (fp);

	mp_title (fp, 2, "Histogram");

	mp_histogram (fp, histogram, MAX_VALUES);

	mp_literal_open (fp);
	mp_literal_close (fp);

	mp_break (fp);

	mp_title (fp, 2, "Results of checking md5sums");
	fprintf (fp, "\
This histogram shows the distribution of conffiles in the installed\n\
distributions.");

	mp_literal_open (fp);
	fp5 = md5sum ("md5sums.txt");
	while (fgets (buffer, sizeof buffer, fp5)) {
		fputs (buffer, fp);
	}
	fclose (fp5);
	mp_literal_close (fp);

	mp_doc_close (fp);
	fclose (fp);

	unlink (tmpname);

	gzip (OUTPUT_FILE);

	return 0;
}


/*+
Index the packages by their conffiles.
+*/
static int conffiles_misc (FILE *fp)
{
	mp_item_open (fp);
	mp_url (fp, "%s.gz", "Installed packages: list of 'conffiles'", 
		OUTPUT_FILE);
	mp_item_close (fp);

	return 0;
}


struct magpie_module mod_conffiles = { 
	version           : MAGPIE_VERSION,
	description       : "list conffiles in all packages",
	init              : conffiles_init,
	miscellaneous     : conffiles_misc
};
