/*
Magpie - reference librarian for Debian systems
Copyright (C) 2000  Bear Giles <bgiles@coyotesong.com>

This program is free software; you may redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the license, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

static const char rcsid[] = "$Id$";

/*****
This module lists all packages, sorted by package name.
*****/
#include <assert.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include "magpie.h"

#define OUTPUT_FILE	"names.html"


/*+
Comparison function for sorting by package name, version (descending),
section, category.  It is used prior to creating the initial set of
HTML files.
+*/
static int cmp_package_name (const void *p, const void *q)
{
	struct package_info *pp = *((struct package_info **) p);
	struct package_info *qq = *((struct package_info **) q);
	int r;
	
	assert (pp->name);
	assert (qq->name);

	r = strcoll (pp->name, qq->name);
	if (r)
		return r;

	r = strcoll (pp->version, qq->version);
	if (r)
		return -r;

	r = pp->section - qq->section;
	if (r)
		return r;

	return pp->category - qq->category;
}


/*+
+*/
static int names_init (void)
{
	int i;
	FILE *fp;
	struct package_info *p;

	qsort (cache, cachecnt, sizeof (cache[0]), cmp_package_name);

	fp = fopen (OUTPUT_FILE, "w");
	mp_doc_open (fp, "Indexed by Package Name");

	mp_abstract (fp, "\
This page contains the descriptive summary of all packages.  It can be\n\
useful when you just want a quick look at everthing.\n");

	mp_list_open (fp);
	for (i = 0; i < cachecnt; i++) {
		p = cache[i];
		mp_package (fp, p, 2, 0);
	}
	mp_list_close (fp);
	mp_doc_close (fp);
	fclose (fp);

	gzip (OUTPUT_FILE);

	return 0;
}


/*+
Index the packages by name.
+*/
static int names_index (FILE *fp, int type)
{
	if (type != MAGPIE_ALL_PACKAGES)
		return 0;

	mp_item_open (fp);
	mp_url (fp, "%s.gz", "Ordered by package name", 
		OUTPUT_FILE);
	mp_item_close (fp);

	return 0;
}


struct magpie_module mod_names = { 
	version           : MAGPIE_VERSION,
	description       : "group packages by package name",
	init              : names_init,
	unannotated_index : names_index
};
