/*
Magpie - reference librarian for Debian systems
Copyright (C) 2000  Bear Giles <bgiles@coyotesong.com>

This program is free software; you may redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the license, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

static const char rcsid[] = "$Id$";

/*****
This program generates a listing of all setuid programs, and tries
to associate them with a package.
*****/
#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include "magpie.h"

#define	OUTPUT_FILE	"setuids.html"

/*+
Recursively walk the directory tree looking for setuid files.
+*/
static int find (FILE *fp, const char *basename)
{
	DIR *dirp;
	struct dirent *dp;
	struct stat buf;
	char pathname[256];

	stat (basename, &buf);
	dirp = opendir (basename);
	if (dirp) {
		while ((dp = readdir (dirp)) != NULL) {
			if (strcmp (dp->d_name, ".") == 0)
				continue;
			if (strcmp (dp->d_name, "..") == 0)
				continue;

			sprintf (pathname, "%s/%s", basename, dp->d_name);
			if (stat (pathname, &buf) == -1)
				continue;
			if (S_ISDIR (buf.st_mode) && !S_ISLNK (buf.st_mode))
				find (fp, pathname);

			if ((buf.st_mode & S_ISUID) == S_ISUID) {
				fprintf (fp, "%s\n", pathname);
			}
		}
		closedir (dirp);
	}
	return 0;
}

/*+
(description)
Since this function takes a long time to finish, we fork() and run it
in the background.
+*/
static void dump_details (void)
{
	FILE *fp;

	if (fork() == 0)
		return;

	fp = fopen (OUTPUT_FILE, "w");
	mp_doc_open (fp, "List of all setuid files");

	mp_abstract (fp, "\
This page lists all setuid files");

	mp_literal_open (fp);
	fprintf (fp, "# find -perm +04000 -print\n");
	find (fp, "/");
	mp_literal_close (fp);

	mp_doc_close (fp);
	fclose (fp);

	gzip (OUTPUT_FILE);
}


/*+
List all setuid programs.
+*/
void list_all_setuids (FILE *fp0)
{
	mp_item_open (fp0);
	mp_url (fp0, "%s.gz", "List of SUID Programs", 
		OUTPUT_FILE);
	mp_item_close (fp0);

	dump_details ();
}
