/*
Magpie - reference librarian for Debian systems
Copyright (C) 2000  Bear Giles <bgiles@coyotesong.com>

This program is free software; you may redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the license, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

static const char rcsid[] = "$Id$";

/*****
This module lists all task packages.
*****/
#include <assert.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include "magpie.h"

extern int mkdir (const char *, mode_t);

#define OUTPUT_DIR	"tasks"
#define OUTPUT_FILE	"tasks/index.html"


/*+
Comparison function for sorting by package name, version (descending),
section, category.  It is used prior to creating the initial set of
HTML files.
+*/
static int cmp_package_name (const void *p, const void *q)
{
	struct package_info *pp = *((struct package_info **) p);
	struct package_info *qq = *((struct package_info **) q);
	int r;
	
	assert (pp->name);
	assert (qq->name);

	r = strcoll (pp->name, qq->name);
	if (r)
		return r;

	r = strcoll (pp->version, qq->version);
	if (r)
		return -r;

	r = pp->section - qq->section;
	if (r)
		return r;

	return pp->category - qq->category;
}


/*+
Print the "task-* packages.
+*/
static int tasks_init (void)
{
	int i;
	FILE *fp;
	struct package_info *p;

	if (mkdir (OUTPUT_DIR, 0755) == -1) {
		perror ("mkdir (tasks)");
		return -1;
	}

	qsort (cache, cachecnt, sizeof cache[0], cmp_package_name);

	fp = fopen (OUTPUT_FILE, "w");
	mp_doc_open (fp, "'Task' Packages");

	for (i = 0; i < cachecnt; i++) {
		p = cache[i];
		if (strncmp (p->name, "task-", 5) != 0)
			continue;

		mp_package (fp, p, 1, 0);
	}
	mp_doc_close (fp);
	fclose (fp);

	gzip (OUTPUT_FILE);
	return 0;
}


/*+
Print the *tasks* packages ordered by name.
+*/
static int tasks_misc (FILE *fp)
{
	mp_item_open (fp);
	mp_url (fp, "%1$s.gz", "All Packages: task packages", OUTPUT_FILE);
	mp_item_close (fp);

	return 0;
}


struct magpie_module mod_tasks = { 
	version           : MAGPIE_VERSION,
	description       : "list 'task' packages",
	init              : tasks_init,
	miscellaneous     : tasks_misc
};
