/*
 *  pbm2styl800.c
 *
 *  (C) 9/1995 Tilman Kuepper (tilman@tilli.tng.oche.de)
 *
 *  Eingabe: stdin, Ausgabe: stdout
 */

 
/* RCS-Infos */
static char RCSdat[]="$Date: 1995/09/07 01:27:58 $";
static char RCSrev[]="$Revision: 1.0 $"; 
static char RCSsta[]="$State: Released $";


/* (C)-Meldung */
#define COPYRIGHT "(C) 9/1995 Tilman Kuepper (tilman@tilli.tng.oche.de)"


#include <stdio.h> 
 

/*
 *  Daten von stdin einlesen und komplette Seite drucken 
 */
void drucken(int laenge)
{
    int i,j,k,l;
    char data[6480]; /* 30 Zeilen mal 7128 Pixel */
    char out_data[16848]; /* Druckerdaten */
    int out_pos; /* Aktuelle Position im Ausgabe-Array */
    int aktuell; /* aktuelle Zeile */
    int a[6]; /* 6 Bytes fuer 48 Duesen */
    int mask; /* Maske fuer Bit-Operationen */
    int null_count; /* Nullen am Zeilenende zaehlen */
    int free_cols,print_cols; /* Freie und gedruckte Spalten */
        
    aktuell=0; 
    
    while(aktuell<laenge) 
    {
        /* 
         *  Es werden immer 30 Zeilen am Stueck eingelesen und mit 48 Duesen
         *  ausgedruckt. Es findet also eine vertikale Skalierung statt!
         */
        for(j=0;j<30;j++) 
        {
            if(aktuell<laenge)
            {
                /* Eine Zeile von stdio einlesen */
                fread(&(data[j*216]),1,216,stdin);
            } 
            else
            {
                /* Es sind bereits alle Zeilen der Datei gelesen worden */
                for(i=0;i<216;i++)
                {
                    /* Zeile mit Nullen fuellen */
                    data[i+j*216]=0;
                }
            }
            aktuell++;
        }
                             
        /* Jetzt eine Zeile drucken */
        out_pos=0;
        null_count=0;
        
        for(i=0;i<216;i++) /* Alle Bytes einer Zeile durchlaufen */
        {
            for(j=7;j>(-1);j--) /* Alle Bits eines Bytes - von links */ 
            {
                mask=1<<j;
                for(k=0;k<6;k++) /* 48 Duesen entspr. 6 Bytes */
                {
                    l=i+k*1080;

                    /* aus 5 Bits wird ein Byte zusammengestellt */
                    a[k]=((data[l]&mask)>>j)*192
                        +((data[l+216]&mask)>>j)*48
                        +((data[l+432]&mask)>>j)*8
                        +((data[l+648]&mask)>>j)*6
                        +((data[l+864]&mask)>>j);

                    /* Spalte fuer Drucker merken */
                    if((out_data[out_pos++]=a[k])==0)
                    {
                        null_count++;
                    }
                    else
                    {
                        null_count=0;
                    }        
                } /* for k */
                
                /* Horizontale Skalierung... */
                switch(j)
                {
                    case 1:
                    case 2:                            
                    case 4:
                    case 6:
                    case 7:
                    {
                        /*
                         *  Spalten 1, 2, 4, 6 und 7 verdoppeln,
                         *  d. h. horiz. Skalierung durchfuehren.
                         */
                        for(k=0;k<6;k++)
                        {
                            /* Spalte fuer Drucker merken */
                            if((out_data[out_pos++]=a[k])==0)
                            {
                                null_count++;
                            }
                            else
                            {
                                null_count=0;
                            }        
                        }
                    } 
                } /* switch */
            } /* for j */ 
        } /* for i */
        
        /* Wenn was zum Drucken da ist, ausgeben! */
        if(null_count<16848)
        {
            /* 
             *  Zunaechst pruefen, ob am Ende der Zeile freier Raum
             *  vorhanden ist. Dieser wird nicht uebertragen!
             */
            free_cols=null_count/6; /* freie Spalten am Ende */
            print_cols=2808-free_cols; /* diese Spalten werden gedruckt */            

            /*
             *  DRUCKER-INIT: Esc * m n1 n2 
             *  m=73 fuer 360 dpi, n1+n2*256=Spaltenzahl
             */
            fprintf(stdout,"%c*%c%c%c",27,73,
                (char)(print_cols%256),(char)(print_cols/256));

            /*
             *  Jetzt die Druckdaten abschicken...
             */
            fwrite(out_data,1,print_cols*6,stdout);
        }
         
        /* Newline */
        fprintf(stdout,"\n");
    } /* while */
}


/* 
 *  Hauptprogramm 
 */
void main(int argc,char *argv[])
{   
    unsigned char buf[200]; /* Platz fuer fgets */
    unsigned int breite,laenge; /* Abmessungen des Bitmaps */

    /* Vielleicht moechte jemand die Version wissen? */
    if(argc==2)
    {
        if(strcmp(argv[1],"-v")==0)
        {
            /* RCS-Infos ausgeben */
            fprintf(stderr,"%s\n\n",COPYRIGHT);
            fprintf(stderr,"%s\n%s\n%s\n",RCSrev,RCSsta,RCSdat);
            exit(0);
        }
        else
        {
            /* Kurze Bedienungsanleitung... */
            fprintf(stderr,"Korrekter Aufruf: ");
            fprintf(stderr,"%s [-v]\n\n%s ",argv[0],argv[0]);
            fprintf(stderr,"liest eine PBM-Faxdatei von 'stdin' ein ");
            fprintf(stderr,"und schreibt die\nzugehoerige Druckerausgabe");
            fprintf(stderr,"datei (Epson Stylus 800) nach 'stdout'.\n");
            exit(255);
        }
    }
    
    /* Datei-Kopf lesen */
    fgets(buf,200,stdin);

    if(strcmp(buf,"P4\n")!=0) 
    {
        /* Falsches Dateiformat */
        fprintf(stderr,"Dateiformat ungueltig!\n%s ",argv[0]);
        fprintf(stderr,"bearbeitet nur PBM-Dateien im P4-Format.\n");
        exit(255);
    }    

    /* Laenge und Breite besorgen */
    fscanf(stdin,"%i %i",&breite,&laenge);
    fgets(buf,200,stdin);

    if(strlen(buf)!=1) 
    {
        /* Falsches Dateiformat */
        fprintf(stderr,"Dateiformat ungueltig!\n%s ",argv[0]);
        fprintf(stderr,"bearbeitet nur PBM-Dateien im P4-Format.\n");
        exit(255);
    }
    
    if(breite!=1728)
    {
        fprintf(stderr,"Breite != 1728 Pixel, Programmabbruch!\n");
        fflush(stderr);
        exit(255);
    }
    
    /* Drucker-Reset */
    fprintf(stdout,"%c%c",27,64);
    
    /* Zeilenabstand enger machen */
    fprintf(stdout,"%c+%c",27,48);
    
    /* Jetzt wird gedruckt! */
    drucken(laenge);

    /* Drucker-Reset zum Abschluss */
    fprintf(stdout,"%c%c%c",27,64,12);
    fflush(stdout);

    /* Fertig! */
    exit(0);
}
