/* NetLeds applet - Lights from a network device
 * Copyright (C) 1999 Michael Witrant
 *
 * Homepage: http://netleds.port5.com
 * Author: Michael Witrant
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
#ifndef DEFINES_H
#define DEFINES_H
 
#include <gnome.h>

/* maximum number of leds allowed */
#define NBLEDS_MAX 8

/* change in properties.c too! */
#define DEFAULT_DELAY 20
#define DEFAULT_SPACING 4
#define DEFAULT_BORDER 1
#define DEFAULT_NBLEDS 3
#define DEFAULT_ORIENT_STYLE orient_auto

/* a pixmap and its mask */
typedef struct {
	GdkPixmap *img, *mask;
} pixmask;

/* pixmap and mask for on and off state */
typedef struct {
	pixmask on, off;
} ledpix;

/* lcolor is a led image. It contains the xpm (pointer), the pixmaps and the 
   masks for the on and off states 
*/
typedef struct {
	/* color id */
	int cid;
	/* color name */
	char name[32];
	/* xpm */
	char **on, **off;
	/* used to store pixmaps created from on and off */
	ledpix pix;
} lcolor;
extern lcolor *lcolors;

/* procinfo is an information that a led must display.
   when *value > the old value, the light is lit. 
*/
typedef struct {
	/* info id */
	int iid;
	/* info name */
	char name[32];
	/* pointer to the variable containing the information */
	u_int64_t *value;
} procinfo;
extern procinfo *procinfos;

/* all informations about a led.
   values should not be modified in this struct. use the functions in
   led.h instead
*/
typedef struct _led {
	/* properties */
	/* information to be displayed (info id)*/
	int iid;
	/* color id */
	int cid;

	/* state */
	u_int64_t value;
	int lit;
	
	/* images */
	ledpix pix;
	GtkWidget *widget;
} led;

/* availiable orientations */
typedef enum {
	orient_auto       = 0,
	orient_invert     = 1,
	orient_vertical   = 2,
	orient_horizontal = 3,
} orient_style;


#endif
