/* NetLeds applet - Lights from a network device
 * Copyright (C) 1999 Michael Witrant
 *
 * Homepage: http://netleds.port5.com
 * Author: Michael Witrant
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gdk/gdk.h>
#include "defines.h"

/* applet properties */
extern int spacing;
extern int border;
extern int nb_leds;
extern orient_style ostyle;

/* update and redraw leds if necessary */
int draw();
/* update and redraw leds */
int draw_all();
/* called when orientation is changed (applet moved) */
void draw_orient_changed();

gint draw_init(GtkWidget *applet);

ledpix get_ledpix(int cid);
void set_spacing(int s);
void set_border(int b);
void set_nb_leds(int n);
void set_widget_tooltip(GtkWidget *widget, char *str);
void set_orient_style(orient_style ostyle);
