/****************************************************************************/
/* |\   ======   /| **               MCL                ** |\   ======   /| */
/* |__\========/__| **       Masar Class Libraries      ** |__\========/__| */
/* |\            /| ** -------------------------------- ** |\            /| */
/* |  \        /  | **  Maurizio Sartori (c) 1998-2000  ** |  \        /  | */
/* |    \    /    | ** -------------------------------- ** |    \    /    | */
/* |    /=\/=\    | **            Written  by           ** |    /=\/=\    | */
/* |  /========\  | **     Maurizio Sartori 'masar'     ** |  /========\  | */
/* |/   ======   \| **     e-mail:  masar@libero.it     ** |/   ======   \| */
/****************************************************************************/
/*              This program comes with ABSOLUTELY NO WARRANTY              */
/*            for details refer to the GNU General Public License           */
/****************************************************************************/
/*\F $Id: idreplace.cpp,v 1.6 2000/06/12 09:06:29 cvs Exp $
*****************************************************************************/

static char Psz_RCS [] =
   "$Id: idreplace.cpp,v 1.6 2000/06/12 09:06:29 cvs Exp $";

/****************************************************************************/

#include <fstream>
#include <mcl/util/strutil.hpp>

MCL_APIRET MclIdReplace (istream & isIStream, ostream & osOStream,
                         const MCL_HASH_MAP_STR_STR & hashMap,
                         INT &iFound, INT & iReplaced,
                         PCSZ pcszPrefix, PCSZ pcszSuffix,
                         CHAR chIncludeChar)
   {
   MCL_HASH_MAP_STR_STR::const_iterator itMap;
   size_t iSize;
   size_t iMaxKeySize;
   STRING strKey;
   ifstream ifStream;

   *Psz_RCS = *Psz_RCS;                 // To fake compiler warnings

   //
   // Find Max Id Size
   //*************************************************************************
   iMaxKeySize = 0;
   itMap = hashMap.begin ();
   while (itMap != hashMap.end ())
      {
      iSize = itMap->first.length ();
      if (iSize > iMaxKeySize)
         {
         iMaxKeySize = iSize;
         }
      ++itMap;
      }
   ++iMaxKeySize;

   //
   // Process
   //*************************************************************************
   iFound = 0;
   iReplaced = 0;
   while (MclStrSearchSkip (pcszPrefix, isIStream, osOStream))
      {
      if (MclStrSearchSkip (pcszSuffix, isIStream, strKey, iMaxKeySize))
         {
         ++iFound;
         if ((chIncludeChar != '\0') &&
             (strKey[0] == chIncludeChar))
            {
            //
            // Include external file
            //****************************************************************
            ifStream.open (strKey.c_str()+1, ios::in);
            if (ifStream.fail ())
               {
               cerr << "Error opening \"" << strKey.c_str()+1 << "\"" << endl;
               }
            else
               {
               osOStream << ifStream.rdbuf();
               ifStream.close ();
               ++iReplaced;
               }
            }
         else
            {
            //
            // Simple Substitution
            //****************************************************************
            itMap = hashMap.find (strKey);
            if (itMap != hashMap.end ())
               {
               osOStream.write (itMap->second.c_str (),
                                itMap->second.length ());
               ++iReplaced;
               }
            }
         }
      }

   return (MCL_OK);
   }

