
open Graph.Delaunay.Float

let random_point () = float (50 + Random.int 500), float (40 + Random.int 320)

let () = Random.self_init ()
let n = 1000

let print_points points =
  for i = 0 to n - 1 do
    let (x,y) = points.(i) in
    Printf.eprintf "%d: (%.0f, %.0f)\n" i x y
  done;
  flush stderr

(***
let () =
  let c = ref 0 in
  while true do
    incr c;
    let points = Array.init n (fun _ -> random_point ()) in
    try
      ignore (triangulate points)
    with Assert_failure _ ->  
      print_points points; 
      open_graph " 600x400";
      for i = 0 to n - 1 do
	let x,y = points.(i) in
	draw_circle (truncate x) (truncate y) 3
      done;
      while not (key_pressed ()) do () done; ignore (read_key ());
      close_graph ();
  done

      Printf.eprintf "nb = %d\n" !c;
      print_points points; exit 1
  done
***)

let points = Array.init n (fun _ -> random_point ())

(*
let points = [| 
(289., 149.);
(241., 57.);
(410., 236.);
(538., 322.);
(279., 359.);
|]
*)

let t = triangulate points


(**
let points = [| (150., 226.);
		(544., 288.);
		(408., 217.);
		(315., 103.);
		(199., 85.) |]
**)

open Graphics
let () = open_graph " 600x400"

let () = 
  set_color red;
  for i = 0 to n - 1 do
    let x,y = points.(i) in
    draw_circle (truncate x) (truncate y) 3
  done

let () = 
  set_color black;
  iter (fun (xu,yu) (xv,yv) -> 
	  moveto (truncate xu) (truncate yu);
	  lineto (truncate xv) (truncate yv)) t

let _ = ignore (Graphics.wait_next_event [ Graphics.Key_pressed ])
let () = close_graph ()


(***
open Unix
  
let utime f x =                                                   
  let u = (times()).tms_utime in                                  
  let y = f x in
  let ut = (times()).tms_utime -. u in
  (y,ut)

let print_utime f x = 
  let (y,ut) = utime f x in
  Printf.printf "user time: %2.2f\n" ut; flush Pervasives.stdout;
  y

open Graph.Pack.Digraph

let g = print_utime (fun e -> Rand.random ~v:200000 ~e) 500000

let () = print_utime (Dfs.iter ~pre:(fun _ -> ())) g

let () = print_utime (Dfs.prefix (fun _ -> ())) g

let () = print_utime Marking.dfs g
***)
