// $Id: RomMSXAudio.hh,v 1.8 2005/01/13 18:25:41 m9710797 Exp $

#ifndef __ROMMSXAUDIO_HH__
#define __ROMMSXAUDIO_HH__

#include "MSXRom.hh"

namespace openmsx {

class Ram;

class RomMSXAudio : public MSXRom
{
public:
	RomMSXAudio(const XMLElement& config, const EmuTime& time,
	            std::auto_ptr<Rom> rom);
	virtual ~RomMSXAudio();

	virtual void reset(const EmuTime& time);
	virtual byte readMem(word address, const EmuTime& time);
	virtual const byte* getReadCacheLine(word start) const;
	virtual void writeMem(word address, byte value, const EmuTime& time);
	virtual byte* getWriteCacheLine(word address) const;

protected:
	const std::auto_ptr<Ram> ram;
	byte bankSelect;
};

} // namespace openmsx

#endif
