// $Id: MidiOutNative.cc,v 1.9 2005/11/11 20:53:06 m9710797 Exp $

#if defined(_WIN32)

#include "Midi_w32.hh"
#include "MidiOutNative.hh"
#include "PluggingController.hh"

using std::string;

namespace openmsx {

void MidiOutNative::registerAll(PluggingController& controller)
{
	w32_midiOutInit();
	unsigned devnum = w32_midiOutGetVFNsNum();
	for (unsigned i = 0; i < devnum; ++i) {
		controller.registerPluggable(new MidiOutNative(i));
	}
}


MidiOutNative::MidiOutNative(unsigned num)
{
	name = w32_midiOutGetVFN(num);
	desc = w32_midiOutGetRDN(num);
}

MidiOutNative::~MidiOutNative()
{
	//w32_midiOutClean(); // TODO
}

void MidiOutNative::plugHelper(Connector& connector, const EmuTime& time)
{
	devidx = w32_midiOutOpen(name.c_str());
	if (devidx == (unsigned)-1) {
		throw PlugException("Failed to open " + name);
	}
}

void MidiOutNative::unplugHelper(const EmuTime& time)
{
	w32_midiOutClose(devidx);
}

const string& MidiOutNative::getName() const
{
	return name;
}

const string& MidiOutNative::getDescription() const
{
	return desc;
}

void MidiOutNative::recvByte(byte value, const EmuTime& time)
{
	w32_midiOutPut(value, devidx);
}

} // namespace openmsx

#endif // defined(_WIN32)
