// $Id: AudioInputConnector.hh,v 1.10 2005/06/16 20:51:53 m9710797 Exp $

#ifndef AUDIOINPUTCONNECTOR_HH
#define AUDIOINPUTCONNECTOR_HH

#include "Connector.hh"
#include "AudioInputDevice.hh"

namespace openmsx {

class PluggingController;

class AudioInputConnector : public Connector
{
public:
	AudioInputConnector(PluggingController& pluggingController,
	                    const std::string& name);
	virtual ~AudioInputConnector();

	// Connector
	virtual const std::string& getDescription() const;
	virtual const std::string& getClass() const;
	virtual AudioInputDevice& getPlugged() const;

	short readSample(const EmuTime& time) const;

private:
	PluggingController& pluggingController;
};

} // namespace openmsx

#endif
