//=======================================================================
// pkgwindow.cc
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#include "config.h"
#include "pkgwindow.h"
#include "filestab.h"
#include "infotab.h"
#include "removetab.h"
#include "packagetab.h"
#include "pkg.h"
#include <gtkmm/stock.h>
#include <gtkmm/notebook.h>

using Glib::ustring;
using namespace Gpaco;


PkgWindow::PkgWindow(Pkg& pkg)
:
	Gtk::Window(),
	mPkg(pkg),
	mpFilesTab(new FilesTab(pkg)),
	mpInfoTab(new InfoTab(pkg)),
	mpRemoveTab(new RemoveTab(pkg)),
	mpPackageTab(new PackageTab(pkg)),
	mNotebook()
{
	set_title(pkg.name());
	set_default_size(1, 400);
	try { set_icon_from_file(DATADIR "/pixmaps/gpaco.png"); }
	catch (...) { }

	add(mNotebook);

	mNotebook.append_page(*mpFilesTab, 
		*(Gtk::manage(new TabLabel("Files", Gtk::Stock::DIRECTORY))));
	mNotebook.append_page(*mpInfoTab, 
		*(Gtk::manage(new TabLabel("Properties", Gtk::Stock::PROPERTIES))));
	mNotebook.append_page(*mpRemoveTab, 
		*(Gtk::manage(new TabLabel("Remove", Gtk::Stock::DELETE))));
	mNotebook.append_page(*mpPackageTab, *(Gtk::manage
		(new TabLabel("Package", DATADIR "/pixmaps/gpaco-package.png"))));
	
	mNotebook.show();
	show();
}


PkgWindow::~PkgWindow()
{
	mPkg.changed(true);
	delete mpFilesTab;
	delete mpInfoTab;
	delete mpRemoveTab;
	delete mpPackageTab;
}


void PkgWindow::presentTab(int const& tab)
{
	mNotebook.set_current_page(tab);
	present();
}


// [virtual]
bool PkgWindow::on_delete_event(GdkEventAny*)
{
	g_usleep(1000);
	mPkg.deleteWindow();
	return true;
}


//---------------------//
// PkgWindow::TabLabel //
//---------------------//


PkgWindow::TabLabel::TabLabel(ustring const& title, ustring const& file)
:
	Gtk::HBox(false, 5)
{
	try {
		pack_start(*(Gtk::manage(new Gtk::Image(file))));
	}
	catch (...) { }
	pack_start(*(Gtk::manage(new Gtk::Label(title))));
	show_all_children();
}


PkgWindow::TabLabel::TabLabel(ustring const& title, Gtk::StockID id)
:
	Gtk::HBox(false, 5)
{
	pack_start(*(Gtk::manage(new Gtk::Image(id, Gtk::ICON_SIZE_MENU))));
	pack_start(*(Gtk::manage(new Gtk::Label(title))));
	show_all_children();
}


PkgWindow::TabLabel::~TabLabel()
{ }

