#include "pk_crypt.h"

int pk_hmac(u_char *hash, u_char *key, u_char *message, int size)
{
   int idx, i;
   hmac_state hmac;

  /* register SHA-1 */
   if (register_hash(&sha1_desc) == -1) {
      printf("Error registering SHA1: %s\n", crypt_error);
      exit(1);
   }     
   /* get index of SHA1 in hash descriptor table */
   idx = find_hash("sha1");

   /* start the HMAC */
   if (hmac_init(&hmac, idx, key, sizeof(key)) == CRYPT_ERROR) {
      printf("Error setting up hmac: %s\n", crypt_error);
      exit(1);
   }

   hmac_process(&hmac, message, size);

   hmac_done(&hmac, hash);

   /*libnet_hex_dump(message, size, 1, stderr);
   libnet_hex_dump(key, 20, 1, stderr);
   libnet_hex_dump(hash, 20, 1, stderr);*/

   return(0);
}

int pk_sha1(u_char *hash, u_char *message, int size)
{
   int i;
   hash_state hs;
 
   sha1_init(&hs);
   sha1_process(&hs, message, size);
   sha1_done(&hs, hash);

   /*libnet_hex_dump(hash, 20, 0, stderr);
   libnet_hex_dump(message, size, 0, stderr);*/

   return(20);
}

int pk_initrng(prng_state *prng)
{
   int i;
   long li;
   
   /* The following is an absolutely horrifying way of seeding a RNG.
      If it wasn't for the even more horrifying crypto it was replacing,
      I wouldn't put my name on it.  Oh well. */

   /* register yarrow */
   if (register_prng(&yarrow_desc) == -1) {
      printf("Error registering Yarrow: %s\n", crypt_error);
      return -1;
   }

   /* setup the PRNG */
   if (yarrow_start(prng) == CRYPT_ERROR) {
      printf("Start error: %s\n", crypt_error);
   }
   /* add entropy */
   libnet_seed_prand();
   for(i=0,li=libnet_get_prand(PRu32);i<libnet_get_prand(PR8);i++)
   {
       libnet_seed_prand(); 
       if (yarrow_add_entropy((char *)&li, 4, prng) == CRYPT_ERROR) {
          printf("Add_entropy error: %s\n", crypt_error);
       }
   }
   /* ready and read */
   if (yarrow_ready(prng) == CRYPT_ERROR) {
      printf("Ready error: %s\n", crypt_error);
   }
}
