#include "mycrypt.h"

#ifdef GZIP

int pack_buffer(const unsigned char *in,  unsigned long inlen,
                      unsigned char *out, unsigned long *outlen)
{
   return (compress2(out, outlen, (unsigned char *)in, inlen, 9) == Z_OK) ? CRYPT_OK : CRYPT_ERROR;
}

int unpack_buffer(const unsigned char *in,  unsigned long inlen,
                        unsigned char *out, unsigned long *outlen)
{
   return (uncompress(out, outlen, (unsigned char *)in, inlen) == Z_OK) ? CRYPT_OK : CRYPT_ERROR;
}

#endif

static const char *ID_TAG = "pack.c"; 
 
