/*  Pensnap2, based on Version 0.21 of stand alone pensnap,  January 15, 2002
 *
 * author: Kevin Sisson <kjsisson@bellsouth.net>
 *
 * pensnap - a program to automatically take a picture and download 
 * it to disk.  Based on pencam, originally by
 * 	    (C) Copyright 2001 by Bart Hartgers
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <usb.h>
#include <stdlib.h>
#include <term.h>
#include <string.h>
#include <malloc.h>
#include <ctype.h>
#include <math.h>
#include <termios.h>

#include <pthread.h>

#include "pencam2.h"
#include "unsharp.h"
#include "font_6x11.h"

extern struct termios kborig, kbnew;
extern int peek;


int get_snapshot( usb_dev_handle *pc, usb_stv *stv680)
{
	char  choice = ' ', ch = ' ';
        int   k, j, count = 0;


	if (stv680->currentMode != stv680->ssMode) {
		k = pencam_set_mode (pc, stv680, stv680->ssMode);
		if (k < 0)
			fprintf (stderr, "\a\a\n Error setting snapshot mode in get_snapshot!\n");
	}

	tcsetattr (0, TCSANOW, &kbnew);		

    	while ( choice != 'x') {

		stv680->pic_no = count+1;

		k = pensnap_get_picture (pc, stv680, stv680->pic_no);
		j=0;
		
		while (k < 0) {
		        k = pensnap_get_picture (pc, stv680, stv680->pic_no); 
			j++;
			if (j >= 3) {
				fprintf (stderr, "\a\a Couldn't get picture after 3 tries, giving up!\n");
				break;
			}
			sleep(1);
    			if (kbhit()) 
    				ch = (char) readch();
			if (ch == 'x')  
				goto gsexit;
		}  /* while k */
		
		count++;
		if (count > 999)
		        count = 0;
		if (stv680->time_delay > 5) {
			for (j=0; j<stv680->time_delay; j+=5) {
				sleep (5);
    				if (kbhit ()) 
    					choice = (char) readch ();
				if (choice == 'x')  
					break;
			}   /*  for  */
		} else {
			sleep (stv680->time_delay);
    				if (kbhit ()) 
    					choice = (char) readch ();
				if (choice == 'x')  
					break;
		}  /*  if - else  */   
	}  /* while != x */

gsexit:
	tcsetattr (0,TCSANOW, &kborig);
	return 0;

}  /*  get_snapshot  */


int pensnap_get_picture( usb_dev_handle *pc, usb_stv *stv680, int pic_no)
{
	unsigned char  buffer[16];
	unsigned char  *raw, *pic;
	unsigned int   width, height;
	unsigned long int sofar;
        int    s, pic_index = 0, j;

	
        if (pencam_vendor (0, pc, 0x86, 0x10, 0, buffer) != 0x10) {
		fprintf (stderr, "\a\a Couldn't get image info\n");
		return -1;
        } else {
		pic_index = ((buffer[2]<<8) + buffer[3]) - 1;
	}

        /* grab image, wait till done; use last (max) location */
	/* use 2000 for beep, 6000 for no beep */
        if (stv680->beep_yes == 1)
		pencam_vendor (3, pc, 0x05, 0, 0x2000, buffer);
        else
		pencam_vendor (3, pc, 0x05, 0, 0x6000, buffer);
	
        sleep (1);
	pencam_vendor (0, pc, 0x80, 0x02, 0, buffer);
        j=0;
	while (buffer[0] != 0) {
		pencam_vendor (0, pc, 0x80, 0x02, 0, buffer);
		sleep(1);	j++;
		if (j >= 5)
		        break;
	}

        /* get image header */
	if (pencam_vendor (0, pc, 0x8f, 0x10, pic_index, buffer) != 0x10) {
		fprintf (stderr, "\a\a Couldn't get image header\n");
		return -1;
        } else {
	        stv680->rawbufsize = (buffer[0]<<24) | (buffer[1]<<16) |
				     (buffer[2]<<8)  | (buffer[3]);
		width = (buffer[4]<<8)|(buffer[5]); 	stv680->cwidth = width;
		height = (buffer[6]<<8)|(buffer[7]); 	stv680->cheight = height;
		stv680->FineExp = (buffer[8]<<8)|(buffer[9]);
		stv680->CoarseExp = (buffer[10]<<8)|(buffer[11]);
		stv680->origGain = buffer[12];
		stv680->CLKDIV = buffer[13];
		stv680->AvgPixVal = buffer[14];
	}

        if ((stv680->ssMode == 3) && (width >= 318) && (width <= 324))  { /* QVGA */
		stv680->vwidth = 320;	stv680->vheight = 240;
        }	
	else if ((stv680->ssMode == 1) && (width >= 638) && (width <= 646)) { /* VGA */
		stv680->vwidth = 640;	stv680->vheight = 480;
	}	
	else if ((stv680->ssMode == 0) && (width >= 350) && (width <= 356)) { /* CIF */
		stv680->vwidth = 352;	stv680->vheight = 288;
	}	
	else if ((stv680->ssMode == 2) && (width >= 172) && (width <= 180)) { /* QCIF */
	        stv680->vwidth = 176;	stv680->vheight = 144;
        }	
	else {
	        fprintf (stderr, "\a\a Picture dimensions not valid!\n");
		return -1;
	}

        raw = malloc (stv680->rawbufsize);
	if (raw == NULL) return -1;
        pic = malloc (3*stv680->rawbufsize);
	if (pic == NULL) {
		free (raw);
		return -1;
	}

        /*  set up bulk channel */
	if (pencam_vendor (0, pc, 0x83, 0x10, pic_index, buffer) != 0x10) {
		fprintf (stderr, "\a\a Couldn't set up for bulk transfer\n");
		free (raw);
		free (pic);
		return -1;
	}
        sofar = 0;  /*  get picture  */
	s = usb_bulk_read (pc, 0x82, (raw + sofar), (stv680->rawbufsize - sofar), PENCAM_TIMEOUT);  
        if (s <=0) {
	        fprintf (stderr, "\a\a usb_bulk_read error\n");

		/* cancel transaction */
		pencam_vendor (0, pc, 0x04, 0x0, 0x0, buffer);
		fprintf (stdout, " Re-initializing camera\n");
    		free (raw);
    		free (pic);
    		return -1;
        } 

	/* do image processing and save to disk */
	common_image_process (pc, stv680, raw, pic, "PENSNAP");

    	if (stv680->overwrite == 1) 
		j = common_save_image (stv680, 1, pic, "PENSNAP");
    	else 
		j = common_save_image (stv680, stv680->pic_no, pic, "PENSNAP");

	if (j < 0)
		fprintf (stderr, "\a\a Error saving snapshot %i!\n", stv680->pic_no);

        free (raw);
	free (pic);

        return 0;
}  /*  pensnap_get_picture  */


void pensnap_do_function (usb_dev_handle *pc, usb_stv *stv680, char choice)
{
        int    tmp;
	char   tempname[170];
	double r;


	common_do_function (pc, stv680, "PENSNAP", choice);

	switch (choice) {

		case 'c':
			tmp = 0;
			if (stv680->SupportedModes == 5) {     /* CIF, QCIF */
				stv680->currentMode += 2;
				if (stv680->currentMode > 2)
					stv680->currentMode = 0;
			}
			if (stv680->SupportedModes == 10) {     /* VGA, QVGA */
				stv680->currentMode += 2;
				if (stv680->currentMode > 3)
					stv680->currentMode = 1;
			}
			if ((stv680->SupportedModes != 10) && (stv680->SupportedModes != 5))
				tmp = -1;
			if (tmp == -1) {
				fprintf (stderr, "\a\a Attempting to set invalid mode! (%i)\n",
					 stv680->currentMode);
				break;
			} else	if (pencam_set_mode (pc, stv680, stv680->currentMode) < 0)
				fprintf (stderr, "\a\a Mode not set!");
			stv680->ssMode = stv680->currentMode;
			break;

		case 'd':
			fprintf (stdout, " Enter time between snapshots, in seconds ");
			scanf ("%lf", &r);
			if ((r < 0) || (r > 7200)) 
				break;
			stv680->time_delay = (int) r;
			break;		

		case 'u':
			stv680->beep_yes = -stv680->beep_yes;    
			break;		

		case 'v':
			stv680->overwrite = -stv680->overwrite;
			break;

		case 'o':
			stv680->annotate_ps = -stv680->annotate_ps;    
			break;		

	        case 'k':
			if (stv680->annotate_ps == -1)
				break;
			fprintf (stdout, "\n Enter message (20 chars max) ");
			fgets (tempname, 21, stdin);
			strcpy (stv680->picmsg_ps, " ");
			strncat (stv680->picmsg_ps, tempname, (strlen(tempname) - 1));
			break;		

		case 'x':
			fprintf (stdout, "\n");
			get_snapshot (pc, stv680);
			break;		

		case 'z':
			if (stv680->currentMode != stv680->origMode) {
		    		pencam_set_mode (pc, stv680, stv680->origMode);
				fprintf (stdout, " resetting original mode and exiting\n");
			} else
				fprintf (stdout, " exiting\n");
			break;

		default:
			fprintf (stdout, "\n");
			break;
	}  // switch

	fprintf(stdout, "\n");

    return;
}


/**********************************************************************
*
* The add_text routine and font_6x11.h file are taken from the (GPLed) 
* webcam.c file, part of xawtv,   (c) 1998-2002 Gerd Knorr.
* add_text was slightly modified for this program.
*
*********************************************************************/

#define MSG_MAXLEN   45
#define CHAR_HEIGHT  11
#define CHAR_WIDTH   6
#define CHAR_START   4

void add_text(unsigned char *image, int width, int height, char *txt)
{
	time_t      t;
        struct tm  *tm;
	char        line[MSG_MAXLEN+1], *ptr;
        int         i, x, y, f, len;
	char        fmtstring[25] = " %Y-%m-%d %H:%M:%S";
        char        fmttxt[46];
	
        time(&t);
	tm = localtime(&t);
	if ( strlen (txt) > (MSG_MAXLEN - 23))
		strncpy (fmttxt, txt, (MSG_MAXLEN - 23));
	else
		strcpy (fmttxt, txt);
	strcat (fmttxt, fmtstring);
	
	len = strftime (line, MSG_MAXLEN, fmttxt, tm);

        for (y=0; y<CHAR_HEIGHT; y++) {
		ptr = image + 3 * width * (height-CHAR_HEIGHT-2+y) + 12;
		
		for (x=0; x<len; x++) {
			f = fontdata[line[x] * CHAR_HEIGHT + y];
			for (i=CHAR_WIDTH-1; i>=0; i--) {
				if (f & (CHAR_START << i)) {
					ptr[0] = 255;
					ptr[1] = 255;
					ptr[2] = 255;
				}
				ptr += 3;
			}  /* for i */
		}  /* for x */
	}  /* for y */
}  /*  add_text  */
