#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>

#include "npfile.h"

int NP_File::opena( const char *fn )
{
   if ( is_open )
   {
      snprintf( error_message, sizeof error_message,
                "NP_File: opena(): "
                "File %s is still open for this object", filename );
      return 1;
   }
   
   if ( lock( 1 ))
   {
      close();
      return 2;
   }

   if (( stream = fopen( fn, "a" )) == NULL )
   {
      if ( errno == ENOENT )
         snprintf( error_message, sizeof error_message,
                   "NP_File: opena(): File %s does not exist", filename );
      else
         snprintf( error_message, sizeof error_message,
                   "NP_File: opena(): fopen() returned error: %s",
                   strerror( errno ));
      return 1;
   }

   if (( filename = strdup( fn )) == NULL )
   {
      perror( "strdup" );
      exit( 1 );
   }
   
   is_open = 1;
   is_writable = 1;
   is_readable = 0;
   
   return 0;
}
