#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>

#include <gtk/gtk.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"
#include "npcollections.h"

extern void *collections_p;

void feedback_callback( gpointer data, gint fd, GdkInputCondition condition )
{
   NP_Collections *collections = ( NP_Collections *)collections_p;

   char server[ 1024 ], group[ 1024 ], change[ 4 ];

   if ( !collections->summary_pid )
      return;

 LOOP:
   if ( fgets( server, sizeof server, collections->feedback_file ) == NULL )
      return;

   if ( fgets( group, sizeof group, collections->feedback_file ) == NULL )
      return;

   if ( fgets( change, sizeof change, collections->feedback_file ) == NULL )
      return;

   strtok( server, "\n" );
   strtok( group, "\n" );
   
   int server_idx = collections->tree[ server ];
   int group_idx = collections->tree.get_group_index( server, group );

   if ( server_idx == -1 || group_idx == -1 )
      return;

   switch( *change )
   {
   case 'a':
      ++collections->total_messages;
      ++collections->tree_nodes[ server_idx ].total_messages;
      ++collections->tree_nodes[ server_idx ].messages[ group_idx ];
      break;

   case 'd':
      --collections->total_messages;
      --collections->tree_nodes[ server_idx ].total_messages;
      --collections->tree_nodes[ server_idx ].messages[ group_idx ];
      break;

   case 'h':
      --collections->total_headers;
      --collections->tree_nodes[ server_idx ].total_headers;
      --collections->tree_nodes[ server_idx ].headers[ group_idx ];
      break;

   case 'n':
      ++collections->total_unseen;
      ++collections->tree_nodes[ server_idx ].total_unseen;
      ++collections->tree_nodes[ server_idx ].unseen[ group_idx ];
      break;

   case 'r':
      ++collections->total_requested;
      ++collections->tree_nodes[ server_idx ].total_requested;
      ++collections->tree_nodes[ server_idx ].requested[ group_idx ];
      break;

   case 's':
      --collections->total_unseen;
      --collections->tree_nodes[ server_idx ].total_unseen;
      --collections->tree_nodes[ server_idx ].unseen[ group_idx ];
      break;

   case 'u':
      --collections->total_requested;
      --collections->tree_nodes[ server_idx ].total_requested;
      --collections->tree_nodes[ server_idx ].requested[ group_idx ];
      break;
   }

   char buffer[ 1024 ];
   char *pointer = server;
   for( int i = strlen( server ); i > 0; --i )
      *pointer++ = toupper( *pointer );

   snprintf( buffer, sizeof buffer, "\n%s:\n"
         "groups: %d\nunseen: %d\n"
         "total: %d\nrequested: %d\nheaders: %d\n",
         server,
         collections->tree_nodes[ server_idx ].total_groups,
         collections->tree_nodes[ server_idx ].total_unseen,
         collections->tree_nodes[ server_idx ].total_messages,
         collections->tree_nodes[ server_idx ].total_requested,
         collections->tree_nodes[ server_idx ].total_headers );

   gtk_label_set( GTK_LABEL( collections->tree_nodes[ server_idx ].label ),
                  buffer );

   char buffer2[ 128 ];

   if ( !strcmp( group, "FOLLOW-UPS" ) ||
        !strcmp( group, "POSTED" ) ||
        !strcmp( group, "OUTBOX" ) ||
        !strcmp( group, "SENT-MAIL" ))
      snprintf( buffer2, sizeof buffer2, "%d",
                collections->tree_nodes[ server_idx ].messages[ group_idx ] );
   else
      snprintf( buffer2, sizeof buffer2, "%d/%d",
                collections->tree_nodes[ server_idx ].unseen[ group_idx ],
                collections->tree_nodes[ server_idx ].messages[ group_idx ] );

   char buffer3[ 128 ];
   snprintf( buffer3, sizeof buffer3, ": %d/%d",
             collections->tree_nodes[ server_idx ].requested[ group_idx ],
             collections->tree_nodes[ server_idx ].headers[ group_idx ] );

   snprintf( buffer, sizeof buffer, "%s:  %s %s", group,
             ( collections->tree_nodes[ server_idx ].messages[ group_idx ] ?
               buffer2 : "" ),
             ( collections->tree_nodes[ server_idx ].headers[ group_idx ] ?
               buffer3 : "" ));

   gtk_label_set( GTK_LABEL(
         collections->tree_nodes[ server_idx ].group_labels[ group_idx ] ),
         buffer );

   GtkStyle *style = collections->empty_style;
   if ( collections->tree_nodes[ server_idx ].unseen[ group_idx ] )
      style = collections->unread_style;
   else if ( collections->tree_nodes[ server_idx ].messages[ group_idx ] )
      style = collections->read_style;

   gtk_widget_set_style( 
         collections->tree_nodes[ server_idx ].group_labels[ group_idx ],
         style );

   char c;
   if (( c = fgetc( collections->feedback_file )) != '.' )
   {
      ungetc( c, collections->feedback_file );       
      goto LOOP;
   }

   if ( collections->undelete_window != NULL )
   {
      /*
        If I don't wait here, before calling undelete refresh, the
        most recent write to ~/.peruser_spool/DELETED does not seem to
        complete, even with an fflush(). When undelete_refresh reads
        through the file, it gets EOF at the old end of file position.
        My development machine is a Pentium 200. I hope this value
        suffices for other machines.
      */

      struct timeval tval;
      tval.tv_sec = 0;
      tval.tv_usec = 250000;
      
      select( 0, NULL, NULL, NULL, &tval );
      undelete_refresh( collections );
   }

   return;
}
