#include <gtk/gtk.h>

#include "npconfig.h"
#include "ctype.h"

void NP_Config::create_server_frame( GtkWidget *outer_box, int i,
                                     const char *server )
{
   // inner frame
         
   char title[ 128 ];
   snprintf( title, sizeof title, "Server %d", i + 1 );
   GtkWidget *inner_frame = gtk_frame_new( title );
   gtk_widget_show( inner_frame );
   gtk_container_border_width( GTK_CONTAINER( inner_frame ), 10 );
   gtk_box_pack_start( GTK_BOX( outer_box ), inner_frame,
                       FALSE, FALSE, 0 );

   server_frames[ i ] = inner_frame;
   
   // vbox
         
   GtkWidget *vbox = gtk_vbox_new( FALSE, 5 );
   gtk_widget_show( vbox );
   gtk_container_border_width( GTK_CONTAINER( vbox ), 10 );
   gtk_container_add( GTK_CONTAINER( inner_frame ), vbox );
         
   // address label

   snprintf( title, sizeof title, "%s:", server );
   for( char *pointer = title; *pointer; ++pointer )
      *pointer = toupper( *pointer );

   GtkWidget *label = gtk_label_new( title );
   gtk_widget_show( label );
   gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, FALSE, 0 );

   // check button

   GtkWidget *button
      = gtk_check_button_new_with_label( "authenticating" );
   gtk_widget_show( button );
   gtk_box_pack_start( GTK_BOX( vbox ), button, FALSE, FALSE, 0 );
   gtk_object_set_data( GTK_OBJECT( button ), "container", inner_frame );
   gtk_signal_connect( GTK_OBJECT( button ), "toggled",
                       GTK_SIGNAL_FUNC( check_buttons_callback ),
                       NULL );

   // user label

   label = gtk_label_new( "user name:" );
   gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, FALSE, 0 );
         
   // user entry
         
   GtkWidget *user_entry = gtk_entry_new_with_max_length( 100 );
   gtk_box_pack_start( GTK_BOX( vbox ), user_entry, FALSE, TRUE, 0 );
   gtk_object_set_data( GTK_OBJECT( user_entry ),
                        "position", ( gpointer) i );
   gtk_object_set_data( GTK_OBJECT( user_entry ),
                        "label", ( gpointer )label );
   gtk_object_set_data( GTK_OBJECT( button ),
                        "user_entry", ( gpointer )user_entry );

   char *pointer = ( char *)subscription.get_user( i );

   if ( pointer == NULL ||  *pointer == '\0' )
      GTK_TOGGLE_BUTTON( button )->active = FALSE;
   else
   {
      GTK_TOGGLE_BUTTON( button )->active = TRUE;
      gtk_widget_show( label );
      gtk_widget_show( user_entry );
      gtk_entry_set_text( GTK_ENTRY( user_entry ), pointer );
   }
         
   gtk_signal_connect( GTK_OBJECT( user_entry ), "changed",
                       GTK_SIGNAL_FUNC( user_entries_callback ), this );

   // pass label

   label = gtk_label_new( "password:" );
   gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, FALSE, 0 );
         
   // pass entry

   GtkWidget *pass_entry = gtk_entry_new_with_max_length( 100 );
   gtk_object_set_data( GTK_OBJECT( pass_entry ),
                        "position", ( gpointer ) i );
   gtk_object_set_data( GTK_OBJECT( pass_entry ),
                        "label", ( gpointer ) label );
   gtk_object_set_data( GTK_OBJECT( button ),
                        "pass_entry", ( gpointer )pass_entry );
         
   pointer = ( char *)subscription.get_pass( i );

   if ( pointer != NULL && *pointer != '\0' )
   {
      gtk_widget_show( label );
      gtk_widget_show( pass_entry );
      gtk_entry_set_text( GTK_ENTRY( pass_entry ), pointer );
   }

   gtk_box_pack_start( GTK_BOX( vbox ), pass_entry, FALSE, FALSE, 0 );
   gtk_signal_connect( GTK_OBJECT( pass_entry ), "changed",
                       GTK_SIGNAL_FUNC( pass_entries_callback ), this );

   return;
}
