#include <stdlib.h>
#include <stdio.h>
#include <errno.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npauthentication.h"

int NP_Authentication::save()
{
   int existing;
   
   if ( config_file.openr( config_path ))
   {
      if ( errno != ENOENT )
      {
         snprintf( error_message, sizeof error_message, "NP_Authentication: "
                   "save(): %s", config_file.get_error() );
         return 1;
      }

      existing = 0;
   }
   else
      existing = 1;
   
   if ( temp_file.openw( temp_path ))
   {
      save_error( 0 );
      return 1;
   }

   char *line;

   if ( existing )
   {
      int x = 4;

      while( x-- )
      {
         if (( line = config_file.get_string()) == NULL )
         {
            save_error( 1 );
            return 1;
         }

         if ( temp_file.put_string( line ))
         {
            save_error( 0 );
            return 1;
         }
      }
   }
   else
   {
      int x = 4;
      while( x-- )
         if ( temp_file.put_string( "\n" ))
         {
            save_error( 0 );
            return 1;
         }
   }

   int total;
   if (( total = user_list.get_total() ) > 0 )
   {
      for( int i = 0; i < total; ++i )
      {
         if (( line = ( char *)user_list[ i ] ) == NULL )
         {
            save_error( 2 );
            return 1;
         }

         if ( line[ 0 ] == '\0' )
         {
            if ( temp_file.put_string( "0\n\n\n" ))
            {
               save_error( 0 );
               return 1;
            }

            continue;
         }

         if ( temp_file.put_string( "1\n" ))
         {
            save_error( 0 );
            return 1;
         }

         if ( temp_file.put_string( line ))
         {
            save_error( 0 );
            return 1;
         }

         if ( temp_file.put_string( "\n" ))
         {
            save_error( 0 );
            return 1;
         }

         if (( line = ( char *)pass_list[ i ] ) == NULL )
         {
            save_error( 3 );
            return 1;
         }

         if ( temp_file.put_string( line ))
         {
            save_error( 0 );
            return 1;
         }

         if ( temp_file.put_string( "\n" ))
         {
            save_error( 0 );
            return 1;
         }
      }
   }

   temp_file.close();
   config_file.close();

   rename( temp_path, config_path );

   return 0;
}
