#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <regex.h>

#include <gtk/gtk.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npserver.h"
#include "npsubscription.h"
#include "npgeneral.h"
#include "npfolders.h"

class NP_Config
{
   const char *home;

   char **argv_copy;
   
   NP_File list_file;
   NP_Server server;
   NP_Subscription subscription;
   NP_General general;
   NP_Folders folders_f;

   NP_Stringarray deleted, temp_deleted;
   
   void init_general( GtkWidget * );
   void init_servers( GtkWidget * );
   void init_newsgroups( GtkWidget * );
   void init_folders( GtkWidget * );

   void create_folder_frame( GtkWidget *, NP_Folders *, char *, char * );
   void remove_files( char * );
   
   void save_size();
   void set_size();

   GtkWidget *window, **server_frames, **server_buttons,
      *server_buttons_vbox, *first_button, *group_clist, *message_label,
      *message_window, *message_button, *lists_window, *list_clist,
      *sort_active_button, *sort_subscribed_button, *ok_button,
      *cancel_button, *search_button, *search_label, *search_entry,
      *update_button, *refresh_button, *edit_group_clist;
   
   int current_server, group_clist_lines, stop, folder_clist_line,
      active_clist_line, group_clist_id, list_clist_id, search_id, stop_id,
      active_groups, dirty;

   char search_text[ 101 ];
   regex_t regex;
   int regex_alloc;
   
 public:

   void create_server_frame( GtkWidget *, int, const char * );
   void create_server_list( GtkWidget * );
   void create_server_button( int, const char * );
   void update_server_frames( int );
   void update_server_buttons( int );
   
   friend void save_button_callback( GtkWidget *, gpointer );
   friend void reload_button_callback( GtkWidget *, gpointer );

   friend void email_entry_callback( GtkWidget *, gpointer );
   friend void editor_entry_callback( GtkWidget *, gpointer );
   friend void browser_entry_callback( GtkWidget *, gpointer );
   friend void adjustment_callback( GtkWidget *, gpointer );

   friend void add_button_callback( GtkWidget *, gpointer );
   friend void remove_button_callback( GtkWidget *, gpointer );

   friend void user_entries_callback( GtkWidget *, gpointer );
   friend void pass_entries_callback( GtkWidget *, gpointer );

   friend void dialog_add_callback( GtkWidget *, gpointer );
   friend void dialog_remove_callback( GtkWidget *, gpointer );
   friend void do_dialog( int, void * );

   friend void address_buttons_callback( GtkWidget *, gpointer );
   friend void edit_button_callback( GtkWidget *, gpointer );

   friend void lists_ok_callback( GtkWidget *, gpointer );
   friend void lists_cancel_callback( GtkWidget *, gpointer );
   friend void do_lists( int, GtkWidget *, gpointer );

   friend void clist_remove_callback( GtkWidget *, gint, gint, GdkEvent * );
   friend void clist_add_callback( GtkWidget *, gint, gint, GdkEvent *,
                                   gpointer );

   friend void refresh_active_callback( GtkWidget *, gpointer );
   friend void lists_update_callback( GtkWidget *, gpointer );
   friend int server_callback( void *, int, int );

   friend void search_entry_callback( GtkWidget *, gpointer );
   friend void search_button_callback( GtkWidget *, gpointer );
   friend void sort_button_callback( GtkWidget *, gpointer );

   friend void new_folder_callback( GtkWidget *, gpointer );
   friend void replace_folder_callback( GtkWidget *, gpointer );
   friend void remove_folder_callback( GtkWidget *, gpointer );
   friend void folder_clist_callback( GtkWidget *, gint, gint, GdkEvent *,
                                      gpointer );
   friend void sort_folders_callback( GtkWidget *, gpointer );
   
   friend void message_callback( GtkWidget *, gpointer );   
   friend void stop_button_callback( GtkWidget *, gpointer );
   friend void exit_button_callback( GtkWidget *, gpointer );
   
   void load_clist( GtkWidget * );
   void show_message( char *, int );
   void update_message( char * );
   void busy_cursor_and_block_signals( int );
   
   void run();

   NP_Config( int *, char *** );
   ~NP_Config();
};

void save_exit_button_callback( GtkWidget *, gpointer );
void check_buttons_callback( GtkWidget *, gpointer );

void SIGALRM_handler( int );
void SIGTERM_handler( int );
void SIGUSR2_handler( int );
void signal_handler( int );
