#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/time.h>
#include <signal.h>

#include "npserver.h"

int NP_Server::sort_file( char *filename, void ( *SIGALRM_handler )( int ))
{
   unsigned int i, count;

   char **array, buffer[ 1024 ], second_buffer[ 1024 ], third_buffer[ 1024],
      *home;
   FILE *file, *temp;


   snprintf( third_buffer, sizeof third_buffer, "%s/%s", 
             home = getenv( "HOME" ), filename );
   if (( file = fopen( third_buffer, "r" )) == NULL )
   {
      snprintf( error_message, sizeof error_message,
                "NP_Server: sort_file(): fopen() returned error: %s.",
                strerror( errno ));
      return 1;
   }

   snprintf( second_buffer, sizeof second_buffer, "%s.tmp", third_buffer );
   if (( temp = fopen( second_buffer, "w" )) == NULL )
   {
      fclose( file );
      snprintf( error_message, sizeof error_message,
                "NP_Server: sort_file(): fopen() returned error: %s.",
                strerror( errno ));
      return 1;
   }

   count = 0;
   while( fgets( buffer, sizeof buffer, file ) != NULL )
      ++count;

   if ( count > 5000 )
   {
      fclose( file );
      fclose( temp );

      snprintf( buffer, sizeof buffer, "sort %s >%s", third_buffer, 
                second_buffer );
      system( buffer );
   }
   else
   {
      if (( array = ( char **)calloc( count, sizeof *array )) == NULL )
      {
         perror( "calloc" );
         exit( 1 );
      }

      rewind( file );
      for( i = 0; i < count; ++i )
      {
         fgets( buffer, sizeof buffer, file );

         if (( array[ i ] = ( char *)malloc( sizeof( buffer ) + 1 )) == NULL )
         {
            perror( "malloc" );
            exit( 1 );
         }

         strcpy( array[ i ], buffer );
      }

      fclose( file );

      struct itimerval tval;
      if ( SIGALRM_handler != NULL )
      {
         tval.it_interval.tv_sec = 0;
         tval.it_interval.tv_usec = 250000;
         tval.it_value.tv_sec = 0;
         tval.it_value.tv_usec = 250000;

         setitimer( ITIMER_REAL, &tval, NULL );

         signal( SIGALRM, SIGALRM_handler );
      }

      qsort( array, count, sizeof *array, compare );

      if ( SIGALRM_handler != NULL )
      {
         tval.it_value.tv_sec = 0;
         tval.it_value.tv_usec = 0;

         setitimer( ITIMER_REAL, &tval, NULL );
      }

      for( i = 0; i < count; ++i )
      {
         fputs( array[ i ], temp );
         free( array [ i ] );
      }

      free( array );

      fclose( temp );
   }

   rename( second_buffer, third_buffer );

   return 0;
}
